<?php
  session_start();

  $CONFDIR="../../config";
  require $CONFDIR."/config.php";
  require "../functions/config_functions.php";
  require "../functions/ldap_functions.php";
  require "../functions/image_functions.php";
  require "../functions/sql_functions.php";
  require "../functions/network_functions.php";
  require "../functions/json_functions.php";
  require "../phpldap/ldap_class.php";
  require "../phpfile/file_class.php";
  $languageCode = getLanguage();
  require "../language/".$languageCode.".php";

  /*******************************************************************
  * Input parameters
  *******************************************************************/
  $environmentid = getFormValue("environmentid");
  $serverid      = getFormValue("serverid");
  $operation     = getFormValue("operation");

  // check that this is not called from somewhere else
  $sessionid = session_id();
  $USER_SESSION_ID = base64_decode(getFormValue("sid"));
  if($USER_SESSION_ID != $sessionid) {
    return;
  }
  // load necessary sql functions
  if(!dbConfigured()) {
    $data["operation"] = $operation;
    $data["error"] = "Database not available.";
    $data["operation_text"] = getTextByOperation($operation);
    echo __json_encode($data);
    return;
  }

  $serverString = "";
  if(!empty($serverid)) {
    $serverString = getServerName($serverid, $environmentid);
  }
  else {
    $servers = getServers($environmentid);
    $serverList = array();
    for($i = 0; $i < count($servers); $i++) {
      $serverList[count($serverList)] = $servers[$i][1];
    }
    $serverString = implode(";", $serverList);
  }

  $data = array();
  $values = array();
  $ticks = array();
  $graphdata = updateSummaryDatabaseGraphData($serverString, $operation);
  
  for($i = 0; $i < count($graphdata[2]); $i++) {
    $values[$i]["label"] = $graphdata[2][$i];
    $values[$i]["data"] = array();
    $currCounter = 0;
    for($j = 1; $j < count($graphdata[0][$i]); $j++) {
      if($graphdata[0][$i][$j] > 0) {
        $values[$i]["data"][$currCounter] = array(($j - 1), $graphdata[0][$i][$j]);
        $currCounter++;
      }
    }
  }
  
  // set month information
  for($i = 1; $i < count($graphdata[1]); $i++) {
    $ticks[count($ticks)] = array(($i - 1), $graphdata[1][$i]);
  }

  $data[0] = $values;  
  $data[1] = $ticks;
  $data["operation"] = $operation;
  $data["error"] = "";
  $data["operation_text"] = getTextByOperation($operation);
  echo __json_encode($data);
?>