<?php
  session_start();
  $CONFDIR="../../config";

  require "../functions/config_functions.php";
  require "../functions/sql_functions.php";
  require "../phpfile/file_class.php";
  require "../objects/monitorobject.php";
  require "../objects/snmpobject.php";
  require "../phpldap/ldap_class.php";
  require "../functions/image_functions.php";
  require "../functions/ldap_functions.php";
  require "../functions/network_functions.php";
  require "../functions/json_functions.php";
  require "../objects/querytimeobject.php";
  require "../objects/serverobject.php";
  $languageCode = getLanguage();
  require "../language/".$languageCode.".php";

  // get all properties
  $operation = getFormValue("operation");
  $changetype = getFormValue("changetype");
  $serverlist = getFormValue("serverlist");
  $monitorstart = getFormValue("monitorstart");
  $monitorend = getFormValue("monitorend");
  $monitorcombine = getFormValue("monitorcombine");
  $monitortime = getFormValue("monitortime");
  $monitorave = getFormValue("monitorave");
  $monitorcomp = getFormValue("monitorcomp");
  $monitortz = getFormValue("monitortz");
  $errorFound = "";
  $warningFound = "";

  // check that this is not called from somewhere else
  $sessionid = session_id();
  $USER_SESSION_ID = base64_decode(getFormValue("sid"));
  if($USER_SESSION_ID != $sessionid) {
    return;
  }

  /********************************************************************************
  * force settings
  ********************************************************************************/
  if($monitorcomp) {
    $monitorcombine = 1; // the result must be combined
    $monitorave = 0; // average line is not possible
  }
  
  /********************************************************************************
  * if live monitoring we need to sort out responding servers
  ********************************************************************************/
  if($monitortime == "live") {
    $aServerList = explode(";", $serverlist);
    $serverlist = "";
    for($i = 0; $i < count($aServerList); $i++) {
      $oServer = setServer($aServerList[$i]);
      if($oServer->isAvailable()) {
        if(strlen($serverlist) > 0) {
          $serverlist .= ";";
        }
        $serverlist .= $aServerList[$i];
      }
    }
  }

  /********************************************************************************
  * Set Flot Graph Data
  ********************************************************************************/
  function formatGraphData($serverlist, $monitorstart, $monitorend, $operation, 
                           $monitortime, $changetype, $monitorcombine, $monitorave, 
                           $monitorcomp, $monitortz) {  
    global $errorFound;
    global $warningFound;
    
    // Get timezone offset * 1000
    $tzOffset = get_timezone_offset($monitortz);
    // update start / end time to match timezone offset
    $monitorStartTime = (strtotime($monitorstart) - $tzOffset);
    $monitorEndTime = (strtotime($monitorend) - $tzOffset);
    $monitorstart = date("Y-m-d H:i:s", $monitorStartTime);
    $monitorend = date("Y-m-d H:i:s", $monitorEndTime);

    /*********************************************************************
    * If we should compare with first of all need to get compare dates 
    *********************************************************************/
    if($monitorcomp) {
      $monitorStartTime = strtotime($monitorstart);
      $monitorEndTime = strtotime($monitorend);
      $timeDiffSec = (($monitorEndTime - $monitorStartTime) + 1);
      $daysDiff = round(($timeDiffSec/86400), 0);
      if($daysDiff < 1) {
        $daysDiff = 1;
      }
      $timeDiff = (86400 * $daysDiff);
      $monitorCompStart = date("Y-m-d H:i:s", ($monitorStartTime - $timeDiff));
      $monitorCompEnd = date("Y-m-d H:i:s", ($monitorEndTime - $timeDiff));      
    }

    /*********************************************************************
    * Which type of monitoring Live or Historical 
    *********************************************************************/
    if($monitortime == "live") {
      $graphdata = updateLiveGraphData(explode(";", $serverlist), 
                                     $operation, $monitorcombine);
    }
    else {
      // for database we set the values now.
      $graphdata = updateDatabaseGraphData(explode(";", $serverlist), 
                                          $operation, $monitorstart, $monitorend, 
                                          $monitorcombine, true); 
      if($monitorcomp) {
        $graphdataComp = updateDatabaseGraphData(explode(";", $serverlist), 
                                                 $operation, $monitorCompStart, $monitorCompEnd, 
                                                 $monitorcombine, true); 
      }
      // if error exist
      if(!empty($graphdata[4][0])) {
        $errorFound = $graphdata[4][0];
        return array();
      }

      // if warning exist
      if(!empty($graphdata[4][1])) {
        $warningFound = $graphdata[4][1];
      }
    }
  
    /*********************************************************************
    * If Combine should be used
    *********************************************************************/
    if($monitorcombine) {
      $line = mergeResultSet($graphdata);
      $graphdata[0] = $line[0];
      
      // live monitoring set combined
      if($monitortime == "live") {
        $graphdata[2] = array('Combined');
      }
      else {
        $graphdata[2] = array($monitorstart." - ".$monitorend);
      }

      if($monitorcomp) {
        $line = mergeResultSet($graphdataComp);
        $graphdataComp[0] = $line[0];
        $graphdataComp[2] = array($monitorCompStart." - ".$monitorCompEnd);
      }
    }

    /*********************************************************************
    * Re-write values, by seconds and operation
    *********************************************************************/
    for($i = 0; $i < count($graphdata[0]); $i++) {
      $graphdata[0][$i] = rewriteValues($operation, $graphdata[0][$i], $changetype, $graphdata[1]);
    }
    if($monitorcomp) {
      for($i = 0; $i < count($graphdataComp[0]); $i++) {
        $graphdataComp[0][$i] = rewriteValues($operation, $graphdataComp[0][$i], $changetype, $graphdataComp[1]);
      }
    }

    /*********************************************************************
    * Add an everage line
    *********************************************************************/
    if($monitorave) {
      $averageValue = returnAverageValue($graphdata);
    }

    /*********************************************************************
    * Convert old data structure to new JSON/FLOT format
    *********************************************************************/
    $values = array();
    for($i = 0; $i < count($graphdata[2]); $i++) {
      $valueIndex = count($values);
      $values[$valueIndex]["label"] = $graphdata[2][$i];
      $values[$valueIndex]["data"] = array();
      for($j = 0; $j < count($graphdata[0][$i]); $j++) {
//          echo "W: ".((strtotime($graphdata[1][$j]) * 1000))."<br>\n";
//          echo "O: ".((strtotime($graphdata[1][$j]) * 1000) + $tzOffset)."<br>\n";
        $nTimeInclTZ = ((strtotime($graphdata[1][$j]) * 1000) + ($tzOffset * 1000));
        $values[$valueIndex]["data"][$j] = array($nTimeInclTZ, $graphdata[0][$i][$j]);
      }
      
      // if compare is enabled
      if($monitorcomp) {
        $values[$valueIndex]["xaxis"] = 2;
        $values[$valueIndex]["yaxis"] = 1;
      }
    }
    if($monitorcomp) {
      for($i = 0; $i < count($graphdataComp[2]); $i++) {
        $valueIndex = count($values);
        $values[$valueIndex]["label"] = $graphdataComp[2][$i];
        $values[$valueIndex]["data"] = array();
        for($j = 0; $j < count($graphdataComp[0][$i]); $j++) {
          $nTimeInclTZ = ((strtotime($graphdataComp[1][$j]) * 1000) + ($tzOffset * 1000));
          $values[$valueIndex]["data"][$j] = array($nTimeInclTZ, $graphdataComp[0][$i][$j]);
        }
      
        // if compare is enabled
        if($monitorcomp) {
          $values[$valueIndex]["xaxis"] = 1;
          $values[$valueIndex]["yaxis"] = 1;
        }
        $values[$valueIndex]["color"] = "#CCC";
      }
    }

  
    /*********************************************************************
    * Add an everage line part 2. Two line settings, start and end
    *********************************************************************/
    if($monitorave) {
      $serverCount = count($values);
      $values[$serverCount]["label"] = getLang("page.general.average");
      $values[$serverCount]["data"][0] = array($values[0]["data"][0][0], 
                                               $averageValue);
      $values[$serverCount]["data"][1] = array($values[0]["data"][(count($values[0]["data"]) - 1)][0], 
                                               $averageValue);
      $values[$serverCount]["color"] = "#CCC";
    }
    return $values;
  }
  
  /********************************************************************************
  * Return JSON format
  ********************************************************************************/
  $returnValues = array();

  // if historical collected data we should check database connection
  if($monitortime != "live") {
    if(!dbConfigured()) {
      $errorFound = "Unable to connect to database";
    }
  }
  if(empty($errorFound)) {
    $returnValues["data"] = formatGraphData($serverlist, $monitorstart, $monitorend, $operation, 
                                            $monitortime, $changetype, $monitorcombine, $monitorave, 
                                            $monitorcomp, $monitortz);
  }
  
  $returnValues["operation"]  = $operation;
  $returnValues["operation_text"] = getTextByOperation($operation);
  $returnValues["changetype"] = $changetype;
  $returnValues["monitortime"] = $monitortime;
  $returnValues["features"]["monitorcombine"] = $monitorcombine;
  $returnValues["features"]["monitorave"] = $monitorave;
  $returnValues["features"]["monitorcomp"] = $monitorcomp;
  $returnValues["error"] = $errorFound; 
  $returnValues["warning"] = $warningFound; 
  echo __json_encode($returnValues);
?>