<?php
  /**
  * @package file
  * @author Andreas Andersson
  * @version 1.0
  *
  *  080811 - Andreas Andersson
  *           Created
  */
  class File {

    /**
    * Constructor
    * @return void
    */
    function File() {
    }

    /**
    * Read file contents
    * @param string $sFile Path to file
    * @return string
    */
    function read($sFileName) {
      $sData = "";

      if(!file_exists($sFileName)) {
        return false;
      }

      return file_get_contents($sFileName);
    }

    /**
    * Read file contents to array
    * @param string $sFile Path to file
    * @return array
    */
    function readToArray($sFileName) {

      if(!file_exists($sFileName)) {
        return false;
      }

      return file($sFileName);
    }

    /**
    * Write to file
    * @param string $sFile Path to file
    * @param string $sData File contents
    * @return boolean
    */
    function write($sFileName, $sData = "") {
      return $this->write_impl($sFileName, $sData, "w");
    }

    /**
    * Append to file
    * @param string $sFile Path to file
    * @param string $sData File appending contents
    * @return boolean
    */
    function append($sFileName, $sData = "") {
      return $this->write_impl($sFileName, $sData, "a");
    }

    /**
    * Implementation method for write and append
    * @param string $sFile Path to file
    * @param string $sData File appending contents
    * @param string $sType Type of data
    * @return boolean
    */
    function write_impl($sFileName, $sData, $sType = "w") {
      $fp = fopen($sFileName, $sType);

      if(!$fp) {
        return false;
      }

      if (fwrite($fp, $sData) === FALSE) {
        return false;
      }

      fclose($fp);

      return true;
    }

  }
?>
