<?php
  if(!file_exists("../phpldap/ldap_class.php")) { header("Location: ../index.php"); }
  require "../phpldap/ldap_class.php";

  $dn = $_GET["dn"];
  $attribute = $_GET["attribute"];
  $servername = $_GET["servername"];
  if(empty($dn) || empty($attribute) || empty($servername)) {
    exit(1);
  }

  $ldap = new LDAP($servername);

  $hResult = $ldap->get_entry($dn);

  // user not found
  if(!$hResult) {
    $ldap->close();
    exit(2);
  }

  // get photo
  $hEntry = $ldap->get_first_entry($hResult);
  $binary = $ldap->get_value_binary($hEntry, $attribute);

  $ldap->free_result($hResult);
  $ldap->close();

  // display image
  header("Content-type: image/jpeg");
  echo $binary[0];
?>
