<?php
  if(!file_exists("./functions/sql_functions.php")) { header("Location: ../index.php"); }
  $CONFDIR="../config";
  require "./functions/image_functions.php";
  require "./functions/sql_functions.php";

  $environmentid = getFormValue("environmentid");
  $serverid = getFormValue("serverid");
  $environmentServers = getServers($environmentid);

  // build serverlist, server to be default active
  $serverlist = Array();
  if(!empty($serverid)) {
    $serverlist[0] = getConfigValue("name", $environmentid, $serverid);
  }
  else {
    for($i = 0; $i < count($environmentServers); $i++) {
      $serverlist[count($serverlist)] = $environmentServers[$i][1];
    }  
  }

  // default date values
  $databaseavailable = 0;
  $monitortime = "live";
  if(dbConfigured()) {
    $databaseavailable = 1;
    $monitortime = "database";
  }
  else {
    $databaseavailable = 0;
    $monitortime = "live";
  }

  $monitordatestarthour = "00";
  $monitordatestartminute = "00";
  $monitordatestartsecond = "00";

  $monitordateendhour = "23";
  $monitordateendminute = "59";
  $monitordateendsecond = "59";

  $monitordatestart = date("Y-m-d");
  $monitordateend = date("Y-m-d");

  // build timestamp
  $monitordaterunstart = $monitordatestart." ".
                         $monitordatestarthour.":".
                         $monitordatestartminute.":".
                         $monitordatestartsecond;
  $monitordaterunend   = $monitordateend." ".
                         $monitordateendhour.":".
                         $monitordateendminute.":".
                         $monitordateendsecond;

  $countervalue = getConfigValue("graphtime", $environmentid, $serverid);
  // if still empty we need to set a default value
  if(empty($countervalue)) {
    $countervalue = 10;
  }

  $changetype = getConfigValue("graphchangetype", $environmentid, $serverid);
  if(empty($changetype)) {
    $changetype = "seconds";
  }

  $graphdefaultview = getConfigValue("graphdefaultview", $environmentid, $serverid);
  if(empty($graphdefaultview)) {
    $graphdefaultview = "today";
  }

  $graphdefaulttz = getConfigValue("timezone", $environmentid, $serverid);
  if(empty($graphdefaulttz)) {
    $graphdefaulttz = "UTC";
  }

  // Set available operations based on detected vendor type
  $operations = setPerformanceCounterList($CNMONITOR_VENDOR);

  // remove temporary files on reload
  for($i = 0; $i < count($operations); $i++) {
    removeTempFileName($operations[$i]);
  }
?>

  <script language="javascript">
    
    var SELECTED_OPERATIONS = new Array();
    var SELECTED_URL = "";
    var SELECTED_MONITORING = "";
    var preloadImageStepBackward = new Image(32,32); 
    preloadImageStepBackward.src = "icons/left.png"; 
    var preloadImageStepForward = new Image(32,32); 
    preloadImageStepForward.src = "icons/right.png"; 
    var preloadImageIncIn = new Image(32,32); 
    preloadImageIncIn.src = "icons/expand_in.png"; 
    var preloadImageIncOut = new Image(32,32);
    preloadImageIncOut.src = "icons/expand_out.png"; 
    var preloadImageStatComp = new Image(32,32);
    preloadImageStatComp.src = "icons/statistics_compare.png"; 

    /*****************************************************************
    * Check if button is disabled (has an image named *_disabled)
    *****************************************************************/
    function exitIfButtonDisabled(buttonId) {
      if($("#" + buttonId).attr("src").indexOf("_disabled") != -1) {
        return true;
      }
      return false;
    }
  
    function getFormVal(name) {
      var obj = document.forms["servergraph"][name];
      if(obj.length > 1) {
        for(var i = 0; i < obj.length; i++) {
          if(obj[i].checked) {
            return obj[i].value;
          }
        }      
      }
      return obj.value;
    }
  
    function retrieveData(operation, recurring) {
    
      // if recurring result (live) skip result if not in live mode anymore
      if(recurring) {
        if(SELECTED_MONITORING != "live") {
          return;
        }
      }
    
      // disable buttons
      url = SELECTED_URL + "&operation=" + operation;
      $("#status_" + operation).attr("src", preloadImageLoadingContent.src);
      if(CNMONITOR_LOGLEVEL > 9) { alert(url); }
      $.getJSON(url, function(received) {

        $("#operation_text_" + received.operation).text(received.operation_text);
      
        if(received.error) {
          $("#operation_" + received.operation).text(received.error);
          $("#status_" + received.operation).attr("src", preloadImageDownError.src);
          return;
        }
      
        // set different options depending on result
        var optionSelection = null;
        if(received.monitortime == "live") {
        }
        else {
          optionSelection = 'x';
        }
        $.plot($("#operation_" + received.operation), received.data, {
          series: {
            lines: { show: true },
            points: { show: true }
          },
          xaxis: {
            mode: 'time'
          },
          grid: {
            hoverable: true
          },
          selection: { 
            mode: optionSelection 
          }
        });
        $("#operation_" + received.operation).bind("plothover", setFlotPieLineGraphHover);
        $("#operation_" + received.operation).bind("plotselected", function (event, ranges) {
          setDateBasedOnTimeStamp(ranges.xaxis.from.toFixed(0), ranges.xaxis.to.toFixed(0), true);
          initializeMonitoring();
        });
                
        if(received.monitortime == "live") {
          setTimeout(function() { retrieveData(received.operation, 1) }, (getFormVal("countervalue") * 1000));
        }
        
        if(received.warning) {
          $("#error_" + received.operation).text(received.warning);
        }
        
        if(!received.error) {
          $("#status_" + received.operation).attr("src", preloadImageDownOk.src);      
        }
        
      }).error(function() { 
        getServiceError(url);
        $("#status_" + received.operation).attr("src", preloadImageDownError.src);
      });
    }
  
    function cnmonitorMonitoring() {
      recurring = 0;
      if(SELECTED_MONITORING == "live") {
        recurring = 1;
      }
      for(var i = 0; i < SELECTED_OPERATIONS.length; i++) {
        retrieveData(SELECTED_OPERATIONS[i]);
      }
    }
    
    function addGraph() {      
      $('#monitorTable').empty();
      var graphWidth = ($(document).width() - 100); //70
      for(var i = 0; i < SELECTED_OPERATIONS.length; i++) {
        $("#monitorTable").last().append(
          "<tr class='tableHeader'><td>" + "<img id='status_" + SELECTED_OPERATIONS[i] + "' width='22' src='icons/alert_ok.png' style='vertical-align:middle;'>" +
          " <span id='operation_text_" + SELECTED_OPERATIONS[i] + "'>" + SELECTED_OPERATIONS[i] + "</span><span id='error_" + SELECTED_OPERATIONS[i] + "' style='float:right;'>&nbsp;</span></td></tr>" +
          "<tr><td><div id='operation_" + SELECTED_OPERATIONS[i] + "' style='width:" + 
          graphWidth + ";height:300;cursor:crosshair;'></div></td></tr>" +
          "<tr><td>&nbsp;</td></tr>");
          
          // to be sure that the checkbox is checked for these values
          var obj = document.forms["servergraph"]["monitoroperations"];
          for(var j = 0; j < obj.length; j++) {
            if(obj[j].value == SELECTED_OPERATIONS[i]) {
              obj[j].checked = true;
            }
          }
      }
    }
    
    function graphStepFwdOrBwdInit(direction) {
      if(exitIfButtonDisabled("step_" + direction)) {
        return;
      }
      var startDate = new XDate($('#monitordatestart').val()); 
      var endDate = new XDate($('#monitordateend').val()); 
      // get diff in days
      var diffDays = startDate.diffDays(endDate);
      if(diffDays < 1) {
        diffDays = 1;
      }
      // siff days depending on direction
      if(direction == "backward") {
        startDate.addDays(-diffDays);
        endDate.addDays(-diffDays);
      }
      else {
        startDate.addDays(diffDays);
        endDate.addDays(diffDays);
      }
      $('#monitordatestart').val(startDate.toString("yyyy-MM-dd"));
      $('#monitordateend').val(endDate.toString("yyyy-MM-dd"));
      initializeMonitoring();
    }

    function enableMonitorFeature(feature) {
      if(exitIfButtonDisabled("anc_" + feature)) {
        return;
      }
      var obj = document.forms["servergraph"][feature];
      // check exception for monitorcombine with monitorcomp
      if(feature == "monitorcombine") {
        var objMonitorComp = document.forms["servergraph"]["monitorcomp"];
        if(parseInt(objMonitorComp.value) == 1) {
          return;
        }
      }
    
      if(obj.value == 1) {
        obj.value = 0;
        $('#anc_' + feature).css({'border-color':'#fff', 'border-width':'0px', 'border-style':'solid'});
      }
      else {
        obj.value = 1;
        $('#anc_' + feature).css({'border-color':'#CCC', 'border-width':'1px', 'border-style':'solid'});
      }
      initializeMonitoring();
    }
  
    function enableMonitorFeatureComp() {
      if(exitIfButtonDisabled("anc_monitorcomp")) {
        return;
      }
      var obj = document.forms["servergraph"]["monitorcomp"];
      if(parseInt(obj.value) == 0) {
        obj.value = 1;
        $('#anc_monitorcomp').css({'border-color':'#CCC', 'border-width':'1px', 'border-style':'solid'});    
        var objCombine = document.forms["servergraph"]["monitorcombine"];
        objCombine.value = 1;
        $('#anc_monitorcombine').css({'border-color':'#CCC', 'border-width':'1px', 'border-style':'solid'});    
      }
      else {
        obj.value = 0;
        $('#anc_monitorcomp').css({'border-color':'#fff', 'border-width':'0px', 'border-style':'solid'});
      }
      initializeMonitoring();
    }
    
  function graphIncreaseDate(direction) {
    if(exitIfButtonDisabled("inc_" + direction)) {
      return;
    }

    var startDate = new XDate($('#monitordatestart').val()); 
    var endDate = new XDate($('#monitordateend').val()); 
    // get diff in days
    var diffDays = startDate.diffDays(endDate);
    if(diffDays < 1) {
      diffDays = 1;
    }
    // siff days depending on direction
    if(direction == "backward") {
      startDate.addDays(-diffDays);
    }
    else {
      endDate.addDays(diffDays);
    }
    $('#monitordatestart').val(startDate.toString("yyyy-MM-dd"));
    $('#monitordateend').val(endDate.toString("yyyy-MM-dd"));
    initializeMonitoring();
  }

  function reloadConfiguration() {
    $('#cnmonitorSettingsDiv').hide();
    initializeMonitoring();
  }
  
  function graphSetDateTime(timespan) {
    var startDate = new XDate(true); 
    var endDate = new XDate(true); 
    // we don't have to do anything for "today"
    if(timespan == "week") {
      startDate.addWeeks(-1);
    }
    else if(timespan == "month") {
      startDate.addMonths(-1);
    }
    $('#monitordatestart').val(startDate.toString("yyyy-MM-dd"));
    $('#monitordatestarthour').val("00");
    $('#monitordatestartminute').val("00");
    $('#monitordatestartsecond').val("00");
    $('#monitordateend').val(endDate.toString("yyyy-MM-dd"));
    $('#monitordateendhour').val("23");
    $('#monitordateendminute').val("59");        
    $('#monitordateendsecond').val("59");        
    // activate database search
    document.forms["servergraph"]["monitortime"][1].checked = true;
  }
  
  function graphSetDateTimeChange(timespan) {
    graphSetDateTime(timespan);
    initializeMonitoring();
  }
  
  function graphEnableLiveMonitoring() {
    document.forms["servergraph"]["monitortime"][0].checked = true;
    initializeMonitoring();
  }

  function initializeMonitoring() {
    var obj = document.forms["servergraph"]["monitoroperations"];
    var selected = new Array();
    for(var i = 0; i < obj.length; i++) {
      if(obj[i].checked == true) {
        selected.push(obj[i].value);
      }
    }
    if(selected.length > 0) {
      if(!jQuery.compareArray(SELECTED_OPERATIONS, selected)) {
        SELECTED_MONITORING = "";
      }
      SELECTED_OPERATIONS = selected;
    }
    else {
      SELECTED_OPERATIONS = cnmonitorDefaultMonitoring(CNMONITOR_VENDOR);
    }
  
    var monitortime = getFormVal("monitortime");
    // build URL
    SELECTED_URL = "services/flot_data.php?sid=" + usersessionid;
    SELECTED_URL = SELECTED_URL + "&changetype=" + getFormVal("changetype");
    SELECTED_URL = SELECTED_URL + "&monitortime=" + monitortime;
    SELECTED_URL = SELECTED_URL + "&monitorcombine=" + getFormVal("monitorcombine");
    SELECTED_URL = SELECTED_URL + "&monitorave=" + getFormVal("monitorave");
    SELECTED_URL = SELECTED_URL + "&monitortz=" + getFormVal("monitortz");
    SELECTED_URL = SELECTED_URL + "&monitorcomp=" + getFormVal("monitorcomp");
    if(monitortime == "database") {
      timeFrom = getFormVal("monitordatestart") +
                            " " + getFormVal("monitordatestarthour") +
                            ":" + getFormVal("monitordatestartminute") + 
                            ":" + getFormVal("monitordatestartsecond");
      timeTo = getFormVal("monitordateend") +
                            " " + getFormVal("monitordateendhour") +
                            ":" + getFormVal("monitordateendminute") + 
                            ":" + getFormVal("monitordateendsecond");
      SELECTED_URL = SELECTED_URL + "&monitorstart=" + escape(timeFrom);
      SELECTED_URL = SELECTED_URL + "&monitorend=" + escape(timeTo);
    }
    SELECTED_URL = SELECTED_URL + "&serverlist=" + getSelectedElementsInList("serverlist").join(";");
    if(monitortime == "live") {
      $("#spanDateTime").text("Live Monitoring");
    }
    else {
      $("#spanDateTime").text(timeFrom + " - " + timeTo);
    }

    if(SELECTED_MONITORING != monitortime) {
      // monitoring view has changed, re-create buttons
      if(monitortime == "live") {
        $("#step_backward").attr("src", "icons/left_disabled.png");
        $("#step_forward").attr("src", "icons/right_disabled.png");
        $("#inc_backward").attr("src", "icons/expand_disabled.png");
        $("#inc_forward").attr("src", "icons/expand_disabled.png");
        $("#anc_monitorcomp").attr("src", "icons/statistics_compare_disabled.png");
      }
      else {
        $("#step_backward").attr("src", preloadImageStepBackward.src);
        $("#step_forward").attr("src", preloadImageStepForward.src);
        $("#inc_backward").attr("src", preloadImageIncIn.src);
        $("#inc_forward").attr("src", preloadImageIncOut.src);
        $("#anc_monitorcomp").attr("src", preloadImageStatComp.src);
      } 
    }

    // reload everything for database only, live will fix itself
    if((SELECTED_MONITORING != "live") || (SELECTED_MONITORING != monitortime)) {
      addGraph();
      cnmonitorMonitoring();
    }
    SELECTED_MONITORING = monitortime;
  }

  $(function () {
    // set default timezone
    var defaultTZ = "<?php echo $graphdefaulttz; ?>";
    var currentTimezone = jstz.determine();
    var defaultTZChecked = "";
    if(defaultTZ == "UTC") {
      $("#monitortz").filter('[value="UTC"]').attr('checked', true);
    }
    else {
      defaultTZChecked = " checked";
    }

    $("#monitortz").after('UTC <br>' + 
                          '<input type="radio" name="monitortz" id="monitortz" value="' + defaultTZ  + '"' + defaultTZChecked + '> <?php echo getLang("page.servergraph.tzconfigured"); ?> ( ' + defaultTZ + ' )<br>' + 
                          '<input type="radio" name="monitortz" id="monitortz" value="' + currentTimezone.name() + '"> <?php echo getLang("page.servergraph.tzbrowser"); ?> ( ' + currentTimezone.name() + ' )<br>');


    graphSetDateTime('<?php echo $graphdefaultview; ?>');
    initializeMonitoring();

    // initiate date picker

   calendar.set("monitordatestart");
   calendar.set("monitordateend");
  });
  
  </script>  
  <!-- MONITOR GRAPH -->
  <div id="servergraph_monitor">
    <table width="100%" cellpadding="3" cellspacing="3">
    <tr>
      <td align="right">
        <div style="float:left;">
          <table cellpadding="3" border="0">
          <tr>
            <td rowspan="2" width="45">
              <img src="icons/config.png" onClick="$('#cnmonitorSettingsDiv').toggle();" style="cursor:pointer;">
            </td>
            <td>
              <big><b><span id="spanDateTime"></span></b></big>
            </td>
          </tr>
          <tr>
            <td>
              <form>
              <input type="button" id="button_today" class="buttongreen" value="<?php echo getLang("page.servergraph.viewtoday"); ?>" onClick="graphSetDateTimeChange('today')">
              &nbsp;&nbsp;&nbsp;
              <input type="button" id="button_day" class="buttongreen" value="<?php echo getLang("page.servergraph.viewsevendays"); ?>" onClick="graphSetDateTimeChange('week')">
              &nbsp;&nbsp;&nbsp;
              <input type="button" id="button_week" class="buttongreen" value="<?php echo getLang("page.servergraph.monitortimelive"); ?>" onClick="graphEnableLiveMonitoring()">
              </form>
            </td>
          </tr>
          </table>
        </div>
        <div id="divFeatureButtons" style="float:right;padding-top:20px;">
          <img id="step_backward" height='26' src='icons/left_disabled.png' onClick='graphStepFwdOrBwdInit("backward")' style='padding:3px;cursor:pointer;' class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.backintime"); ?>">&nbsp;&nbsp;
          <img id="inc_backward" height='26' src='icons/expand_disabled.png' onClick='graphIncreaseDate("backward")' style='padding:3px;cursor:pointer;' class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.increaseview"); ?>">&nbsp;&nbsp;
          <img id='anc_monitorcombine' height='26' src='icons/combinedresult.png' onClick='enableMonitorFeature("monitorcombine")' style='padding:3px;cursor:pointer;' class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.combineresult"); ?>">&nbsp;&nbsp;
          <img id='anc_monitorave' height='26' src='icons/statistics_ave.png' onClick='enableMonitorFeature("monitorave")' style='padding:3px;cursor:pointer;' class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.averageresult"); ?>">&nbsp;&nbsp;
          <img id='anc_monitorcomp' height='26' src='icons/statistics_compare_disabled.png' onClick='enableMonitorFeatureComp()' style='padding:3px;cursor:pointer;' class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.compareresult"); ?>">&nbsp;&nbsp;
          <img id="inc_forward" height='26' src='icons/expand_disabled.png' onClick='graphIncreaseDate("forward")' style='padding:3px;cursor:pointer;' class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.increaseview"); ?>">&nbsp;&nbsp;
          <img id="step_forward" height='26' src='icons/right_disabled.png' onClick='graphStepFwdOrBwdInit("forward")' style='padding:3px;cursor:pointer;' class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.forwardintime"); ?>">&nbsp;&nbsp;
        </div>
      </td>
    </tr>
    <tr>
      <td>
       <table id="monitorTable" width="100%" border="0" cellpadding="6" cellspacing="0">

        </table>
      </td>
    </tr>
    </table>
  </div>

  <!-- Floating dateselector div -->
  <div id="dateselector"></div>

  <div id="cnmonitorSettingsDiv" style="width:1100px;">
    <form method="post" onsubmit="return false;" name="servergraph">
    <input type="hidden" name="monitorcombine" value="0">
    <input type="hidden" name="monitorave" value="0">
    <input type="hidden" name="monitorcomp" value="0">
      <table border="0" cellpadding="5" cellspacing="5" width="100%">
      <tr class="tableHeader">
        <td class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.servers"); ?>">
          <?php echo getLang('page.servergraph.selectedservers'); ?>
        </td>
        <td class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.time"); ?>">
          <?php echo getLang('page.servergraph.monitortime'); ?>
        </td>
        <td class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.operations"); ?>">
          <?php echo getLang('page.general.operations'); ?>
        </td>
        <td class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.type"); ?>">
          <?php echo getLang('page.servergraph.graphtype'); ?>
        </td>
        <td align="center" onClick="$('#cnmonitorSettingsDiv').hide();" style="cursor:pointer;"><img width="22" src="icons/exit.png"></td>
      </tr>
      <tr>
        <td valign="top">
          <select name="serverlist" id="serverlist" multiple size="10">
<?php
            for($i = 0; $i < count($environmentServers); $i++) {
?>
            <option value="<?php echo $environmentServers[$i][1]; ?>"<?php
              if(in_array($environmentServers[$i][1], $serverlist)) {
                echo " selected"; 
              } ?>><?php echo $environmentServers[$i][1]; ?></option>
<?php
            }
?>
          </select>
        </td>
        <td valign="top">
          <table border="0" cellpadding="3" cellspacing="3">
          <tr>
            <td>
              <input type="radio" name="monitortime" value="live"<?php
                if($monitortime == "live") {
                  echo " checked";
                } ?>>
            </td>
            <td colspan="4" valign="middle">
              <b><?php echo getLang('page.servergraph.monitortimelive'); ?></b>
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="4">
              <?php echo getLang('page.general.updateinterval'); ?><br>
              <input type="text" name="countervalue" size="3" value="<?php echo $countervalue; ?>">
            </td>
          </tr>
          <tr>
            <td>
              <input type="radio" name="monitortime" value="database"<?php
                if(!$databaseavailable) {
                  echo " disabled='disabled'";
                }
                if($monitortime == "database") {
                  echo " checked";
                } ?>>
            </td>
            <td colspan="4" valign="middle">
              <b><?php echo getLang('page.servergraph.monitortimehistory'); ?></b>
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td><?php echo getLang('page.general.date'); ?></td>
            <td><?php echo getLang('page.general.hour'); ?></td>
            <td><?php echo getLang('page.general.minute'); ?></td>
            <td><?php echo getLang('page.general.second'); ?></td>
          </tr>
          <tr>
            <td align="right">
              <?php echo getLang('page.general.from'); ?>:
            </td>
            <td>
              <input type="text" id="monitordatestart" name="monitordatestart" value="<?php echo $monitordatestart; ?>" size="10"<?php
                if(!$databaseavailable) {
                  echo " disabled='disabled'";
                } ?>> 
            </td>
            <td>
              <?php getSelectHour("monitordatestart", $monitordatestarthour, $databaseavailable); ?>
            </td>
            <td>
              <?php getSelectMinute("monitordatestart", $monitordatestartminute, $databaseavailable); ?>
            </td>
            <td>
              <?php getSelectSecond("monitordatestart", $monitordatestartsecond, $databaseavailable); ?>
            </td>
          </tr>
          <tr>
            <td align="right">
              <?php echo getLang('page.general.to'); ?>:
            </td>
            <td>
              <input type="text" id="monitordateend" name="monitordateend" value="<?php echo $monitordateend; ?>" size="10"<?php
                if(!$databaseavailable) {
                  echo " disabled='disabled'";
                } ?>> 
            </td>
            <td>
              <?php getSelectHour("monitordateend", $monitordateendhour, $databaseavailable); ?>
            </td>
            <td>
              <?php getSelectMinute("monitordateend", $monitordateendminute, $databaseavailable); ?>
            </td>
            <td>
              <?php getSelectSecond("monitordateend", $monitordateendsecond, $databaseavailable); ?>
            </td>
          </tr>
          <tr>
            <td align="right" valign="top">
              <?php echo getLang('page.servergraph.zone'); ?>
            </td>
            <td colspan="4">
              <input type="radio" id="monitortz" value="UTC" name="monitortz">
            </td>
          </tr>            
          </table>
        </td>
        <td valign="top">
          <?php for($i = 0; $i < count($operations); $i++) { ?>
          <input type="checkbox" name="monitoroperations" value="<?php echo $operations[$i]; ?>"> <?php echo getTextByOperation($operations[$i]); ?><br>
          <?php } ?>
        </td>
        <td valign="top">
          <input type="radio" name="changetype" value="changes"<?php
            if($changetype == "changes") {
              echo " checked";
            } ?>> <?php echo getLang('page.servergraph.graphtypechanges'); ?>
            <br>
          <input type="radio" name="changetype" value="seconds"<?php
            if($changetype == "seconds") {
              echo " checked";
            } ?>> <?php echo getLang('page.servergraph.graphtypesecond'); ?>            
        </td>
        <td valign="top">
          <input type="button" id="button_reload" class="buttongreen" value="<?php echo getLang('page.servergraph.save'); ?>" onClick="reloadConfiguration()">
        </td>
      </tr>
      </table>
      </form>
  </div>
  
