<?php
  if(!file_exists("./objects/vendorinfoobject.php")) { header("Location: ../index.php"); }
  $CONFDIR="../config";
  require "./objects/vendorinfoobject.php";
  require "./objects/rootdnobject.php";
  require "./functions/image_functions.php";
  require "./functions/sql_functions.php";
  require "./functions/oid_functions.php";

  $serverid = getFormValue("serverid");
  $servername = getServerName($serverid, $CNMONITOR_ENVIRONMENTID);
  $respondingServer = "";

  $oServer = setServer($servername);

  if($oServer->isAvailable()) {
    $vendorInfo = setVendorInfo($servername);
    $rootdn = setRootDN($servername);
    $serverDescription = getConfigValue("description", $CNMONITOR_ENVIRONMENTID, $serverid);
    $serverURL = getConfigValue("url", $CNMONITOR_ENVIRONMENTID, $serverid);
    $respondingServer = $servername;
  }
?>
<script language="javascript">

  var preloadImageTopRight = new Image(24,24); 
  preloadImageTopRight.src = "icons/topright.png"; 

  var preloadImageDownRight = new Image(24,24); 
  preloadImageDownRight.src = "icons/downright.png"; 

  var preloadImageMiddleRight = new Image(24,24); 
  preloadImageMiddleRight.src = "icons/right_yellow.png";

  // check if initial page content is loaded
  // variable used to avoid reloading of monitoring summary
  var cnmonitorInitLoaded = false;

  /*************************************************
  * Create Flot pie graph
  * divId = Div ID
  * data = plot data
  *************************************************/
  function setFlotPieLineGraph(divId, data) {
    var graphOptions = null;
    // if we should show a line graph
    if(data[0]["data"].length > 1) {
      graphOptions = {
          series: {
            lines: { show: true },
            points: { show: true }
          },
          xaxis: { 
            mode: 'time', 
            minTickSize: [2, "minute"]
          },
          grid: { hoverable: true },
          legend: { show: false }
       };
     }
     else {
      // show pie graph
      graphOptions = {
        series: {
          pie: { show: true }
        },
        grid: { hoverable: true }
      };
    }
  
    $.plot($("#" + divId), data, graphOptions);
    $("#" + divId).bind("plothover", setFlotPieLineGraphHover);
  }

  /*************************************************
  * Flot Pie Graph Hover Function
  *************************************************/  
  function setFlotGraphHover(event, pos, obj) {
    if (!obj) {
      $("#cnmonitorTooltip").remove();
      cnmonitorPreviousPoint = null;
      return;
    }
    x = parseInt(obj.datapoint[0].toFixed(2)),
    value = obj.datapoint[1].toFixed(2);
    if(cnmonitorPreviousPoint != value) {
      cnmonitorPreviousPoint = value;
      $("#cnmonitorTooltip").remove();
      // Compare with previous month, we can only do this for the same year
      prevValue = 0;
      if((x > 0) && (obj.series.data[(obj.dataIndex - 1)])) {
        prevValue = obj.series.data[(obj.dataIndex - 1)][1];
        showTooltip(pos.pageX, pos.pageY, "", value, prevValue);
      }
      else {
        showTooltip(pos.pageX, pos.pageY, value, value, 0);
      }
    }   
  }

  /*************************************************
  * set Environment Pie Graph
  * creates pie graph header and calls setFlotPieGraph
  * divId = Key for graph, also used to fetch data
  * pieHeader = Header text for this graph
  *************************************************/  
  function setEnvironmentPieLineGraph(divId, pieHeader) {
    // create header & graph if not exist
    if($("#" + divId).length == 0) {

      var spaceHeight = 10;
      if(isIE()) {
        spaceHeight = 60;
      }

      $("#pieTable").last().append(
        "<tr class='tableHeader'><td>" + pieHeader + "</td></tr>" +
        "<tr><td><div id='" + divId + "' class='flot_default_class'></div></td></tr>" +
        "<tr style='height:" + spaceHeight + "px;'><td>&nbsp;</td></tr>");
    }
    setFlotPieLineGraph(divId, collectedMonitoringData[divId]);
  }

  function cnmonitorEnvironmentStatus(received) {
    var operationsExist = false;
    var bindsExists = false;
    var txtURL = "";
    
    // skip reload functionality if server stops responding
    // reload page instead
    if(!received.server.respondLDAP) {
      window.location.reload();
    }
    
    if(parseFloat(received.snmp.searchops) > 0) {
      operationsExist = true;
      setCollectedMonitoringData("graphOperations", 0, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('search'); ?>\", \"search\")' class='compareValue'>" + 
                                 "<?php echo getTextByOperation('search'); ?>" + "</a>", received.snmp.searchops);
      setCollectedMonitoringData("graphOperations", 1, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('add'); ?>\", \"add\")' class='compareValue'>" + 
                                 "<?php echo getTextByOperation('add'); ?>" + "</a>", received.snmp.addentryops);
      setCollectedMonitoringData("graphOperations", 2, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('modify'); ?>\", \"modify\")' class='compareValue'>" + 
                                 "<?php echo getTextByOperation('modify'); ?>" + "</a>", received.snmp.modifyentryops);
      setCollectedMonitoringData("graphOperations", 3, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('modifyrdn'); ?>\", \"modifyrdn\")' class='compareValue'>" + 
                                 "<?php echo getTextByOperation('modifyrdn'); ?>" + "</a>", received.snmp.modifyrdnops);
      setCollectedMonitoringData("graphOperations", 4, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('remove'); ?>\", \"remove\")' class='compareValue'>" + 
                                 "<?php echo getTextByOperation('remove'); ?>" + "</a>", received.snmp.removeentryops);
    }
    if(parseFloat(received.snmp.simpleauthbinds) > 0) {
      bindsExists = true;
      setCollectedMonitoringData("graphBinds", 0, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('anon_bind'); ?>\", \"anon_bind\")' class='compareValue'>" + 
                                 "<?php echo getTextByOperation('anon_bind'); ?>" + "</a>", received.snmp.anonymousbinds);
      setCollectedMonitoringData("graphBinds", 1, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('unauth_bind'); ?>\", \"unauth_bind\")' class='compareValue'>" +
                                 "<?php echo getTextByOperation('unauth_bind'); ?>" + "</a>", received.snmp.unauthbinds);
      setCollectedMonitoringData("graphBinds", 2, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('simple_bind'); ?>\", \"simple_bind\")' class='compareValue'>" +
                                 "<?php echo getTextByOperation('simple_bind'); ?>" + "</a>", received.snmp.simpleauthbinds);
      setCollectedMonitoringData("graphBinds", 3, "<a href='#' onClick='compareValueWindow(\"<?php echo getTextByOperation('strong_bind'); ?>\", \"strong_bind\")' class='compareValue'>" +
                                                  "<?php echo getTextByOperation('strong_bind'); ?>" + "</a>", received.snmp.strongauthbinds);          
    }
    if(received.monitor.starttime) {
      $("#starttime").attr("class", "black");
      txtURL = "<a href='#' onClick='compareValueWindow(\"<?php echo getLang('page.general.serverstarted'); ?>\", \"server_start\")' class='compareValue'>" +
               received.monitor.starttime + "</a>";
      $("#starttime").html(txtURL);
      $("#uptime").attr("class", "black");
      $("#uptime").html(received.monitor.uptimeday + " <?php echo getLang('page.general.uptime.days'); ?><br>" +
                        received.monitor.uptimehour + " <?php echo getLang('page.general.uptime.hours'); ?><br>" +
                        received.monitor.uptimeminute + " <?php echo getLang('page.general.uptime.minutes'); ?>");
    }
    if(received.monitor.currentConnections) {
      $("#currconnections").attr("class", "black");
      txtURL = "<a href='#' onClick='compareValueWindow(\"<?php echo getLang('page.general.currentconnections'); ?>\", \"curr_con\")' class='compareValue'>" +
               received.monitor.currentConnections + "</a>";
      $("#currconnections").html(txtURL);
    }
    if(received.monitor.totalConnections) {
      $("#totconnections").attr("class", "black");
      txtURL = "<a href='#' onClick='compareValueWindow(\"<?php echo getLang('page.general.totalconnections'); ?>\", \"tot_con\")' class='compareValue'>" +
               received.monitor.totalConnections + "</a>";
      $("#totconnections").html(txtURL);
    }
    if(received.monitor.threads) {
      $("#maxthreads").attr("class", "black");
      txtURL = "<a href='#' onClick='compareValueWindow(\"<?php echo getLang('page.general.maxthreads'); ?>\", \"threads\")' class='compareValue'>" +
               received.monitor.threads + "</a>";
      $("#maxthreads").html(txtURL);
    }
    if(received.monitor.connectionPeak) {
      $("#peakconnections").attr("class", "black");
      txtURL = "<a href='#' onClick='compareValueWindow(\"<?php echo getLang('page.general.peakconnections'); ?>\", \"con_peak\")' class='compareValue'>" +
               received.monitor.connectionPeak + "</a>";
      $("#peakconnections").html(txtURL);
    }

    if(received.server.message) {
      $("#serverInformation").last().append(
        "<tr><td><div class='warningMessage'><b><span style='color:#000;'>" + 
          received.server.message + 
        "</b></div></td></tr>");
    }

    // create pie graphs
    if(operationsExist) {
      setEnvironmentPieLineGraph("graphOperations", "<?php echo getLang('page.server.general.operationsgraph'); ?>");
    }
    if(bindsExists) {
      setEnvironmentPieLineGraph("graphBinds", "<?php echo getLang('page.server.general.bindsgraph'); ?>");
    }
        
    $("#serverIcon").attr("src", preloadImageDownOk.src);

    // now get and set historical events
    if(!cnmonitorInitLoaded) {
      cnmonitorHistoricalEvents(cnmonitorDefaultMonitoring(CNMONITOR_VENDOR));
      cnmonitorInitLoaded = true;
    }

  }

  function cnmonitorHistoricalEvents(selectedOperation) {
    $("#summaryStatus").attr("src", preloadImageLoadingContent.src);
    $('#historySummaryTable').empty();
    
    var graphWidth = ($(document).width() - 260);

    for(var i = 0; i < selectedOperation.length; i++) {
      var url = "services/flot_history_data.php?sid=" + usersessionid + "&environmentid=" + CNMONITOR_ENVIRONMENTID + 
                "&serverid=" + CNMONITOR_SERVERID + "&operation=" + selectedOperation[i];
      $.getJSON(url, function(received) {

        if(received.error) {
          $("#summaryStatus").attr("src", preloadImageDownWarning.src);
          $("#historySummaryTable").last().append(
            "<tr class='tableHeader'><td>" + received.operation_text + "</td></tr>" +
            "<tr><td>" + received.error + "</td></tr>" + 
            "<tr><td>&nbsp;</td></tr>");
          return;
        }

        $("#historySummaryTable").last().append(
          "<tr class='tableHeader'><td>" + received.operation_text + "</td></tr>" +
          "<tr><td><div id='operation_" + received.operation + "' style='width:" + graphWidth + ";height:300;'></div></td></tr>" +
          "<tr><td>&nbsp;</td></tr>");

        collectedMonitoringData["server_statistics"][collectedMonitoringData["server_statistics"].length] = 
        $.plot($("#operation_" + received.operation), received[0], {
          series: {
            lines: { show: true },
            points: { show: true }
          },
          xaxis: {
            ticks: received[1]
          },
          grid: {
            hoverable: true,
            backgroundColor: { colors: ["#fff", "#eee"] }
          }
        });
        $("#operation_" + received.operation).bind("plothover", setFlotGraphHover);
      }).error(function() { 
        $("#summaryStatus").attr("src", preloadImageDownError.src);
        getServiceError(url);
      });
    } // for
    $("#summaryStatus").attr("src", preloadImageDownOk.src);
    
    // Set selected values
    selectElementsInList("selectedoperations", selectedOperation);
  }

  // open compare value window (text string and compare key)
  function compareValueWindow(compareText, compareKey) {
    $("#compareResult").empty();
    $("#cnmonitorSettingsDiv").height(200);
    $("#comparetext").text(compareText);
    document.forms["comparevalueform"]["comparekey"].value = compareKey;
    $("#cnmonitorSettingsDiv").toggle();
  }
  
  // run compare value
  function compareValue() {
    var comparekey = document.forms["comparevalueform"]["comparekey"].value;
    var url = getServiceURL() + "&service=comparevalue&q=" + comparekey + "," +
        getSelectedElementsInList("serverlist").join(";");
    $("#compareResult").empty();
    $("#comparestatus").attr("src", preloadImageLoadingContent.src);
    $.getJSON(url, function(received) {

      $("#cnmonitorSettingsDiv").animate({ height: (300 + (received.compare.length * 32)) }, 750);
      $("#compareResult").last().append(
        "<tr class='tableHeader'><td colspan='2'><?php echo getLang('page.general.viewresult'); ?></td></tr>");

      var style = "#111";
      for(var i = 0; i < received.compare.length; i++) {
        if(style == "#111") {
          style = "#000";
        }
        else {
          style = "#111";
        }
        $("#compareResult").last().append(
          "<tr style='background:" + style + "'><td width='250'>" + received.compare[i][0] + "</td>" + 
               "<td width='350'>" + received.compare[i][1] + "</td>" + 
               "</tr>");
      
      }

      // if we should summarize result      
      if(received.options.summary) {
        $("#compareResult").last().append(
          "<tr><td colspan='2'><hr width='100%'></td></tr>" +
          "<tr><td width='250'>&nbsp;</td><td width='350'>" + received.options.summary + "</td></tr>");
      }
      
      $("#comparestatus").attr("src", "icons/alert_ok.png");
    });

  }
</script>

<div id="server_availability">
  
<?php
  if(!$oServer->isAvailable()) {
    // build error message
    $sMessage = getLang('page.general.answeringonport').": ";
    $sMessage .= ($oServer->getRespondPort()) ? getLang('page.general.yes') : getLang('page.general.no');
    $sMessage .= "\n\n";
    $sMessage .= getLang('page.general.answeringonping').": ";
    $sMessage .= (pingLdapServer($servername) == 0) ? getLang('page.general.yes') : getLang('page.general.no');
    showErrorMessage(getLang('page.general.servernotavailable'), $sMessage);
  }
  else {
    // server is available
    $ip = getServerIP($servername);
?>
  <table cellpadding="3" width="100%" cellspacing="3" border="0">
  <tr>
    <td width="300" valign="top">
      <table width="100%" id="serverInformation" cellpadding="6" cellspacing="0" border="0">
      <tr class="tableHeader">
        <td>
          <img src="icons/alert_ok.png" id="serverIcon" width="16" style="vertical-align:middle;"> <?php echo $servername; ?>
        </td>
      </tr>
      <tr>
        <td>
          <a href='#' onClick="compareValueWindow('<?php echo getLang('page.general.hostip'); ?>', 'ipaddress')" class="compareValue"><?php echo $ip; ?></a>
        </td>
      </tr>
<?php
  if(!empty($serverDescription)) {
?>
      <tr>
        <td>
          <?php echo $serverDescription; ?>
        </td>
      </tr>
<?php
  }
  if(!empty($serverURL)) {
?>
      <tr>
        <td>
          <a href='<?php echo $serverURL; ?>' target='_blank'><?php echo $serverURL; ?></a>
        </td>
      </tr>
<?php
  }
?>
      </table>
    </td>
    <td width="400" valign="top">
      <table width="100%" cellpadding="6" cellspacing="0" border="0">
      <tr class="tableHeader">
        <td>
          <?php echo getLang("page.general.version"); ?>
        </td>
      </tr>
      <tr>
        <td>
          <a href='#' onClick="compareValueWindow('<?php echo getLang('page.general.vendor'); ?>', 'vendor')" class="compareValue"><?php echo $vendorInfo->getVendor(); ?></a>
        </td>
      </tr>
      <tr>
        <td>
          <a href='#' onClick="compareValueWindow('<?php echo getLang('page.general.version'); ?>', 'version')" class="compareValue"><?php echo $vendorInfo->getVersion(); ?></a>
        </td>
      </tr>
      </table>
    </td>
    <td valign="top" rowspan="3">
      <table width="100%" cellpadding="6" cellspacing="0" border="0">
<?php
      if(dbConfigured()) {
        $sql = "SELECT col_srvmsg_date, col_srvmsg_key, col_srvmsg_value FROM servermessage WHERE ";
        $sql .= " col_srvmsg_host = '".$servername."' ORDER BY col_srvmsg_date DESC LIMIT 15";
  
        $dbh = dbConnect();
        $result = dbQuery($sql, $dbh);
?>
        <tr class="tableHeader">
          <td valign='top'><?php echo getLang("page.general.messagestime"); ?></td>
          <td valign='top'><?php echo getLang("page.general.messagestype"); ?></td>
          <td valign='top'><?php echo getLang("page.general.messagesvalue"); ?></td>
        </tr>
<?php
        while($row = dbGetRow($result)) {
          $typetext = getLang("page.general.unknown");
          echo "<tr>\n";
          echo "<td valign='top'>".$row[0]."</td>\n";
            $typetext = getTextByServerMessageKey($row[1]);
          echo "<td valign='top'>".$typetext."</td>\n";
          echo "<td valign='top'>".$row[2]."</td>\n";
          echo "</tr>\n";
        }
        dbClose($dbh);
      }
      else {
        showWarningMessage(getLang("page.general.notconfigured"), "Database not available.");
      }
?>
      </table>
    </td>
  </tr>
  <tr>
    <td colspan="2">
      <hr width="100%">
    </td>
  </tr>
  <tr>
    <td width="300" align="left" valign="top">
      <table border="0" width="100%" cellpadding="6" cellspacing="0">
      <tr class="tableHeader">
        <td colspan="2" valign="top">
          <?php echo getLang('page.server.general.serverstatus'); ?>
        </td>
      </tr>
      <tr>
        <td>
          <b><?php echo getLang('page.general.serverstarted'); ?>:</b>
        </td>
        <td>
          <span id="starttime" class="gray">-</span>
        </td>
      </tr>
      <tr>
        <td valign="top">
          <b><?php echo getLang('page.general.uptime'); ?>:</b>
        </td>
        <td valign="top">
          <span id="uptime" class="gray">-</span>
        </td>
      </tr>
      <tr>
        <td valign="top">
          <b><?php echo getLang('page.general.currentconnections'); ?>:</b>
        </td>
        <td valign="top">
          <span id="currconnections" class="gray">-</span>
        </td>
      </tr>      
      <tr>
        <td valign="top">
          <b><?php echo getLang('page.general.totalconnections'); ?>:</b>
        </td>
        <td valign="top">
          <span id="totconnections" class="gray">-</span>
        </td>
      </tr>
      <tr>
        <td valign="top">
          <b><?php echo getLang('page.general.maxthreads'); ?>:</b>
        </td>
        <td valign="top">
          <span id="maxthreads" class="gray">-</span>
        </td>
      </tr>
      <tr>
        <td valign="top">
          <b><?php echo getLang('page.general.peakconnections'); ?>:</b>
        </td>
        <td valign="top">
          <span id="peakconnections" class="gray">-</span>
        </td>
      </tr>      
      </table>
      <br>
      <br>
      <br>
      <br>
      <br>
      <br>
      <br>
      <br>
	</td>
    <td width="400" valign="top">
      <table id="pieTable" cellpadding="6" cellspacing="0" width="100%">
      </table>
    </td>
  </tr>
  </table>
<?php
  }
?>
</div>

<?php
if($oServer->isAvailable()) {
?>
<script language="javascript">
  $(function () {
    collectedMonitoringData["server_availability"] = new Array();
    collectedMonitoringData["server_statistics"] = new Array();
    initReloadPage(CNMONITOR_ENVIRONMENTID, CNMONITOR_SERVERID, "server.php");
  });
</script>
<?php
}
?>

<!-- STATISTICS -->
<div id="server_statistics">
<?php
  if(!$oServer->isAvailable()) {
    showErrorMessage(getLang('page.server.about'), getLang('page.general.servernotavailable'), "");
  }
  else {
?>
<table width="100%" border="0" cellpadding="3" cellspacing="3">
<tr>
  <td colspan="2">
    <table width="100%" cellpadding="3" cellspacing="3">
    <tr>
      <td width="30"><img src="icons/alert_ok.png" id="summaryStatus" width="30"></td>
      <td><big><b><?php echo getLang("page.general.trendsdifference"); ?></b></big></td>
    </tr>
    </table>
  </td>
</tr>
<tr>
  <td valign="top">
    <table id="historySummaryTable" width="100%" border="0" cellpadding="6" cellspacing="0">

    </table>
  </td>
  <td width="200" valign="top">
    <table width="100%" border="0" cellpadding="6" cellspacing="0">
    <tr class="tableHeader">
      <td>
        <?php echo getLang('page.general.operations'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <select name="selectedoperations[]" id="selectedoperations" multiple size="15" style="width:180px;">
<?php
        // Set available operations based on detected vendor type
        $operations = setPerformanceCounterList($CNMONITOR_VENDOR);
        for($i = 0; $i < count($operations); $i++) {
?>
          <option value="<?php echo $operations[$i]; ?>">
            <?php echo getTextByOperation($operations[$i]); ?>
          </option>
<?php
        } // available operations
?>
        </select>
        <br><br>
        <input type="button" class="buttongreen" value="<?php echo getLang('page.general.update'); ?>" onClick="cnmonitorHistoricalEvents(getSelectedElementsInList('selectedoperations'))">
      </td>
    </tr>
    </table>
  </td>
</tr>
</table>
<br>
<br>
<br>
<br>
<?php
  }
?>
</div>
<!-- About -->
<div id="server_about">
<?php
  if(!$oServer->isAvailable()) {
    showErrorMessage(getLang('page.server.about'), getLang('page.general.servernotavailable'), "");
  }
  else {
?>
<table border="0" width="100%">
<tr>
  <td valign="top" width="50%">
  <table border="0" cellpadding="6" cellspacing="0" width="100%">
  <tr class="tableHeader">
    <td colspan="2">
      <?php echo getLang('page.server.about'); ?>
    </td>
  </tr>
  <tr>
    <td width="200">
      <?php echo getLang('page.general.vendorrecognized'); ?>:
    </td>
    <td>
      <?php echo $oServer->getVendorName(); ?>
    </td>
  </tr>
  <tr<?php echo $serverDescription ? "" : " class='gray'"; ?>>
    <td width="200">
      <?php echo getLang('page.general.description'); ?>:
    </td>
    <td>
      <?php  
        echo (empty($serverDescription)) ? "-" : $serverDescription;
      ?>
    </td>
  </tr>
  <tr<?php echo $serverURL ? "" : " class='gray'"; ?>>
    <td width="200">
      <?php echo getLang('page.general.url'); ?>:
    </td>
    <td>
      <?php  
        echo (empty($serverURL)) ? "-" : "<a href='".$serverURL."' target='_blank'>".$serverURL."</a>";
      ?>
    </td>
  </tr>
<?php
  $namingContexts = $rootdn->getNamingContexts();
?>
  <tr<?php echo $namingContexts ? "" : " class='gray'"; ?>>
    <td width="200" valign="top">
      <?php echo getLang('page.server.about.namingcontext'); ?>:
    </td>
    <td valign="top">
      <?php
        if(empty($namingContexts)) {
          echo "-";
        }
        else {
          for($i = 0; $i < count($namingContexts); $i++) {
            echo "<a href='index.php?page=query.php&settab=query_query&environmentid=".$CNMONITOR_ENVIRONMENTID."&serverid=".$serverid."&querysuffix=".urlencode($namingContexts[$i])."'>".$namingContexts[$i]."</a><br>";
          }
        }
      ?>
    </td>
  </tr>
  <tr>
    <td colspan="2">&nbsp;</td>
  </tr>
  <tr class="tableHeader">
    <td colspan="2">
      <?php echo getLang('page.server.about.network'); ?>
    </td>
  </tr>
<?php
  // get server ip and dns
  $ip = getServerIP($servername);
  $dns = getServerDNS($ip);
?>
  <tr<?php echo empty($dns) ? " class='gray'" : ""; ?>>
    <td width="200">
      <?php echo getLang('page.server.about.hostdns'); ?>:
    </td>
    <td>
      <?php echo empty($dns) ? "-" : $dns; ?>
    </td>
  </tr>
  <tr<?php echo empty($ip) ? " class='gray'" : ""; ?>>
    <td width="200">
      <?php echo getLang('page.general.hostip'); ?>:
    </td>
    <td>
      <?php echo empty($ip) ? "-" : "<a href='#' onClick='compareValueWindow(\"".getLang('page.general.hostip')."\", \"ipaddress\")' class='compareValue'>".$ip."</a>"; ?>
    </td>
  </tr>
  <tr>
    <td width="200">
      <?php echo getLang('page.server.about.ldapport'); ?>:
    </td>
    <td>
      <?php echo getPort($servername); ?>
    </td>
  </tr>
  <tr>
    <td width="200">
      <?php echo getLang('page.server.about.secureport'); ?>:
    </td>
    <td>
      <?php echo getSecurePort($servername); ?>
    </td>
  </tr>
  <tr>
    <td colspan="2">&nbsp;</td>
  </tr>
  <tr class="tableHeader">
    <td colspan="2">
      <?php echo getLang('page.general.vendor'); ?>
    </td>
  </tr>
  <tr<?php echo $vendorInfo->getVendor() ? "" : " class='gray'"; ?>>
    <td width="200">
      <?php echo getLang('page.general.vendor'); ?>:
    </td>
    <td>
      <?php echo $vendorInfo->getVendor() ? "<a href='#' onClick='compareValueWindow(\"".getLang('page.general.vendor')."\", \"vendor\")' class='compareValue'>".$vendorInfo->getVendor()."</a>" : "-"; ?>
    </td>
  </tr>
  <tr<?php echo $vendorInfo->getVersion() ? "" : " class='gray'"; ?>>
    <td width="200">
      <?php echo getLang('page.general.version'); ?>:
    </td>
    <td>
      <?php echo $vendorInfo->getVersion() ? "<a href='#' onClick='compareValueWindow(\"".getLang('page.general.version')."\", \"vendor\")' class='compareValue'>".$vendorInfo->getVersion()."</a>" : "-"; ?>
    </td>
  </tr>
  <tr<?php echo $rootdn->getSupportedLDAPVersion() ? "" : " class='gray'"; ?>>
    <td width="200" valign="top">
      <?php echo getLang('page.server.about.supportedldapversion'); ?>:
    </td>
    <td valign="top">
      <?php
        $ldapversion = $rootdn->getSupportedLDAPVersion();
        for($i = 0; $i < count($ldapversion); $i++) {
          echo $ldapversion[$i]."<br>\n";
        }
      ?>
    </td>
  </tr>
  <tr<?php echo $rootdn->getSupportedSASLMechanisms() ? "" : " class='gray'"; ?>>
    <td width="200" valign="top">
      <?php echo getLang('page.server.about.supportedldapmechanisms'); ?>:
    </td>
    <td valign="top">
      <?php
        $sasl = $rootdn->getSupportedSASLMechanisms();
        for($i = 0; $i < count($sasl); $i++) {
          echo $sasl[$i]."<br>\n";
        }
      ?>
    </td>
  </tr>
  </table>
  </td>
  <td valign="top" width="50%">
  <table border="0" cellpadding="6" cellspacing="0" width="100%">
  <tr class="tableHeader">
    <td colspan="2">
      <?php echo getLang('page.server.about.supportedextensions'); ?>
    </td>
  </tr>
  <tr>
    <td>
<?php
      $supportedExtension = $rootdn->getSupportedExtension();
      for($i = 0; $i < count($supportedExtension); $i++) {
        $oidLink = getLinkForOID($supportedExtension[$i]);
        if(!empty($oidLink)) {
          echo "<a href='".$oidLink."' target='_blank'>";
        }
        echo getTextForOID($supportedExtension[$i]);
        if(!empty($oidLink)) {
          echo "</a>";
        }
        echo "<br>\n";
      }
?>
    </td>
  </tr>
  <tr class="tableHeader">
    <td colspan="2">
      <?php echo getLang('page.server.about.supportedcontrol'); ?>
    </td>
  </tr>
  <tr>
    <td>
<?php
      $supportedControl = $rootdn->getSupportedControl();
      for($i = 0; $i < count($supportedControl); $i++) {
        $oidLink = getLinkForOID($supportedControl[$i]);
        if(!empty($oidLink)) {
          echo "<a href='".$oidLink."' target='_blank'>";
        }
        echo getTextForOID($supportedControl[$i]);
        if(!empty($oidLink)) {
          echo "</a>";
        }
        echo "<br>\n";
      }
?>
    </td>
  </tr>
  <tr class="tableHeader">
    <td colspan="2">
      <?php echo getLang('page.server.about.supportedfeatures'); ?>
    </td>
  </tr>
  <tr>
    <td>
<?php
      $supportedFeatures = $rootdn->getSupportedFeatures();
      for($i = 0; $i < count($supportedFeatures); $i++) {
        $oidLink = getLinkForOID($supportedFeatures[$i]);
        if(!empty($oidLink)) {
          echo "<a href='".$oidLink."' target='_blank'>";
        }
        echo getTextForOID($supportedFeatures[$i]);
        if(!empty($oidLink)) {
          echo "</a>";
        }
        echo "<br>\n";
      }
?>
    </td>
  </tr>
  </table>
  </td>
</tr>
</table>
<?php
  }
?>
</div>

<div id="cnmonitorSettingsDiv" style="width:700px;">
  <form method="post" onsubmit="return false;" name="comparevalueform">
    <input type="hidden" name='comparekey' value=''>
    <table border="0" cellpadding="5" cellspacing="5" width="100%">
    <tr class="tableHeader">
      <td><img id="comparestatus" src="icons/refresh.png" width="24"></td>
      <td width='250'><?php echo getLang("page.general.selectservers"); ?></td>
      <td width='350'><?php echo getLang("page.general.messagesvalue"); ?></td>
      <td align="center" onClick="$('#cnmonitorSettingsDiv').hide();" style="cursor:pointer;"><img width="22" src="icons/exit.png"></td>
    </tr>
    <tr>
      <td width="24">
        &nbsp;
      </td>
      <td valign="top" width="250">
        <select id="serverlist" name="serverlist[]" multiple size="6">
<?php
  $servers =  getServers($CNMONITOR_ENVIRONMENTID);
  print_r($servers);
  for($i = 0; $i < count($servers); $i++) {
?>
          <option value="<?php echo $servers[$i][1]; ?>" selected><?php echo $servers[$i][1]; ?></option>
<?php
  }
?>
        </select>
      </td>
      <td valign="top" width="350">
        <b><span id='comparetext'></span></b>
      </td>
      <td valign="top">
        <input type="button" id="button_reload" class="buttongreen" value="<?php echo getLang("page.general.run"); ?>" onClick="compareValue()">
      </td>
    </tr>
    <tr>
      <td width='24'>
        &nbsp;
      </td>
      <td colspan="2">
        <table id="compareResult" border="0" cellpadding="5" cellspacing="5" width="100%">
        </table>
      </td>
      <td>
        &nbsp;
      </td>
    </tr>
    </table>
  </form>
</div>


<script language="javascript">
  function cnmonitorTabSwitch(tabId) {
    // repaint graph when switching to monitor history
    if(collectedMonitoringData) {
      if(collectedMonitoringData[tabId]) {
        for(var i = 0; i < collectedMonitoringData[tabId].length; i++) {
          graphRef = collectedMonitoringData[tabId][i];
          graphRef.resize();
          graphRef.setupGrid();
          graphRef.draw();
        }
      }
    }
  }
</script>