<?php
  if(!file_exists("./objects/schemaobject.php")) { header("Location: ../index.php"); }
  require "./objects/schemaobject.php";

  // if page is disabled
  if(!functionIsEnabled("schema") || !functionIsEnabled("configuration")) {
    echo "Page is supposed to be disabled. Please report this as a bug if this is not the case.";
    exit(0);
  }  

  $environmentid = getFormValue("environmentid");
  $serverid = getFormValue("serverid");
  $serverlist = getFormValue("serverlist");
  $schemaserver = getFormValue("schemaserver");
  $page = getFormValue("page");
  $reloadschema = getFormValue("reloadschema");

  // if query a server for schema
  if(!empty($schemaserver)) {
    $servername = $schemaserver;
  }
  
  if(empty($reloadschema)) {
    $reloadschema = false;
  }
  
  if(empty($servername)) {
    if(empty($serverid)) {
      $respondingServer = getFirstRespondingServerInEnvironment($environmentid, $serverid);
      if(!empty($respondingServer)) {
        $servername = $respondingServer;    
      }
    }
    else {
      $servername = getServerName($serverid, $environmentid);  
    }
  }
?>
<form method="post" action="index.php">
<input type="hidden" name="page" value="<?php echo getFormValue('page'); ?>">
<input type="hidden" name="serverid" value="<?php echo $serverid; ?>">
<input type="hidden" name="settab" value="schema_result">
<input type="hidden" name="environmentid" value="<?php echo $environmentid; ?>">
<input type="hidden" name="reloadschema" value="true">

<!-- Schema result -->
<div id="schema_query">
  <table border="0" cellpadding="5" cellspacing="5" width="400">
  <tr class="tableHeader">
    <td>
      <b><?php echo getLang("page.general.selectservers"); ?></b>
    </td>
    <td width="70">
      <b><?php echo getLang('page.general.queryrun'); ?></b>
    </td>
  </tr>
  <tr>
    <td valign="top">
      <select name="schemaserver">
<?php
  $servers = getServers($environmentid);
  // as the same servers can be added to different environments
  // for each server
  for($i = 0; $i < count($servers); $i++) {
?>
        <option value="<?php echo $servers[$i][1]; ?>"<?php
          if($servers[$i][1] == $servername) {
            echo " selected";
          }
          ?>><?php echo $servers[$i][1]; ?></option>
<?php  
  } // list all servers
?>
        </select>  
    </td>
    <td valign="top">
      <input type="submit" value="<?php echo getLang('page.general.queryrun'); ?>">
    </td>
  </tr>
  </table>
</div>
<!-- Schema result -->
<div id="schema_result">
<?php
  $oServer = setServer($servername);

  if($oServer->isAvailable()) {
    $schema = setSchema($oServer->getHostName(), $reloadschema);
    if($schema->getExitCode() != 0) {
      showWarningMessage(getLang('page.schema.objectclasses'),
                     $schema->getMessage());
    }
  }
  else {
    $schema = setSchema("");
    showWarningMessage(getLang('page.schema.objectclasses'),
                     getLang('page.general.servernotavailable'));
  }
  
  function colorSyntax($str) {
    $str = str_replace("(", "<span style='color:red;'>(</span>", $str);
    $str = str_replace(")", "<span style='color:red;'>)</span>", $str);
    $str = str_replace("$", "<span style='color:gray;'>$</span>", $str);
    $str = str_replace("STRUCTURAL", "<span style='color:green;'>STRUCTURAL</span>", $str);
    $str = str_replace("MUST", "<span style='color:green;'>MUST</span>", $str);
    $str = str_replace("SUP", "<span style='color:green;'>SUP</span>", $str);
    $str = str_replace("MAY", "<span style='color:green;'>MAY</span>", $str);
    $str = str_replace("AUXILIARY", "<span style='color:green;'>AUXILIARY</span>", $str);
    $str = str_replace("ABSTRACT", "<span style='color:green;'>ABSTRACT</span>", $str);
    $str = str_replace("EQUALITY", "<span style='color:green;'>EQUALITY</span>", $str);
    $str = str_replace("SYNTAX", "<span style='color:green;'>SYNTAX</span>", $str);
    $str = str_replace("SINGLE-VALUE", "<span style='color:green;'>SINGLE-VALUE</span>", $str);
    $str = str_replace("USAGE", "<span style='color:green;'>USAGE</span>", $str);
    $str = str_replace("ORDERING", "<span style='color:green;'>ORDERING</span>", $str);
    $str = str_replace("SUBSTR", "<span style='color:green;'>SUBSTR</span>", $str);

    $str = str_replace("NAME", "<span style='color:blue;'>NAME</span>", $str);
    $str = str_replace("DESC", "<span style='color:blue;'>DESC</span>", $str);

    return $str;
  }
  
  $colorSchema = 0;
  
  
?>
  <h3><?php echo getLang('page.schema.objectclasses'); ?></h3>
  <?php
    $objectclass = $schema->getObjectclass();
  
    for($i = 0; $i < count($objectclass); $i++) {
      $str = htmlspecialchars($objectclass[$i])."<br>\n";
      if($colorSchema) {
        $str = colorSyntax($str);
      }
      echo $str;
    }
  ?>

  <h3><?php echo getLang('page.schema.attributes'); ?></h3>
  <?php
    $attributes = $schema->getAttributeType();
  
    for($i = 0; $i < count($attributes); $i++) {
      $str = htmlspecialchars($attributes[$i])."<br>\n";
      if($colorSchema) {
        $str = colorSyntax($str);
      }
      echo $str;
    }
  ?>
</div>
</form>
