<?php
  if(!file_exists("./objects/replicationagreementobject.php")) { header("Location: ../index.php"); }
  $CONFDIR="../config";
  require "./objects/replicationagreementobject.php";
  require "./objects/replicainfoobject.php";
  require "./objects/rootdnobject.php";
  require "./objects/monitorobject.php";
  require $CONFDIR."/replication.php";
  require "./functions/image_functions.php";

  // if page is disabled
  if(!functionIsEnabled("replication")) {
    echo "Page is supposed to be disabled. Please report this as a bug if this is not the case.";
    exit(0);
  }  

  $environmentid = getFormValue("environmentid");
  $serverid = getFormValue("serverid");
  $page = getFormValue("page");

  if(empty($serverid)) {
    $respondingServer = getFirstRespondingServerInEnvironment($environmentid);
    if(!empty($respondingServer)) {
      $servername = $respondingServer;
    }
  }
  else {
    $servername = getServerName($serverid, $environmentid);
  }

  $oServer = setServer($servername);
  
  // Functions for replication verification
  function getAgreement($agreements, $matchhost, $matchroot) {
    for($i = 0; $i < count($agreements); $i++) {
      $currentHost = $agreements[$i]->getHostName();
      $currentRoot = $agreements[$i]->getReplicaRoot();
      
      if(($currentHost == $matchhost) && ($currentRoot == $matchroot)) {
        return $agreements[$i];
      }    
    }
    // no replication agreement found. Returning new empty
    return new ReplicaAgreement();
  }

  function getStatusIcon($status, $scheduled_replication = "") {
    $filename = "./icons/server_";
    
    $scheduled = "";
    // if scheduled replication
    if((!empty($scheduled_replication)) && (strlen($scheduled_replication) > 1)) {
      $scheduled = "_schedule";
    }
    
    // should return an image in format server_<replica type>[_scheduled].png
    // such as server_master.png or server_consumer_scheduled.png
    $suggestion = $filename.$status.$scheduled.".png";
    if($suggestion && $status != "unknown") {
      return $suggestion;
    }
    else {
      // default image we know exists
      return "./icons/server.png";
    }
  }

  // get acceptable time
  function isAcceptableHours($aTime, $replicaroot) {
    global $serverid;
    global $environmentid;
    global $DEFAULT_ACCEPTABLE_DELAY;
    global $ACCEPTABLE_DELAY;
    if($aTime[0]."" == "----") {
      return false;
    }

    if(empty($ACCEPTABLE_DELAY[$replicaroot])) {
      $hours = $DEFAULT_ACCEPTABLE_DELAY;
    }
    else {
      $hours = $ACCEPTABLE_DELAY[$replicaroot];
    }

    if(intval($aTime[0]) > intval($hours)) {
      return false;
    }
    
    return true;
  }

  function generateReplicationTopologyTable($backenddb, $root, $style = "oddTD") {
    if($style == "oddTD") {
      $style = "evenTD";
    }
    else {
      $style = "oddTD";
    }
  
    echo "<table width='100%' cellspacing='3' cellpadding='3'>\n";
    echo "<tr>\n";
    // get root
    for($i = 0; $i < count($backenddb); $i++) {

      if(empty($root) && (strpos($backenddb[$i], ",") === FALSE)) {
        // root level
        echo "<td class='".$style."'>\n";
          echo $backenddb[$i]."\n";
          generateReplicationTopologyTable($backenddb, $backenddb[$i], $style);
        echo "</td>\n";
      }
      else if(empty($root) && (strpos($backenddb[$i], ",") !== FALSE)) {
        // verify if this root is part of another replica root
        // i.e. ou=clients,dc=example,dc=com part of dc=example,dc=com
        $rootOffset = (strpos($backenddb[$i], ',') + 1);
        $possibleSubRoot = substr($backenddb[$i], $rootOffset);
        if(in_array($possibleSubRoot, $backenddb)) {
          // part of another root set. Skip this one
          continue;
        }
        // root level, sublevels exist
        echo "<td class='".$style."'>\n";
          echo $backenddb[$i]."\n";
          generateReplicationTopologyTable($backenddb, $backenddb[$i], $style);
        echo "</td>\n";
      }
      else if(!empty($root) && strpos($backenddb[$i], ",".$root) !== FALSE) {
        // if levels and this is a sublevel
        // if root matches backend
        $backendcurrent = explode(",".$root, $backenddb[$i]);
        // if current backend only is one level
        if(strpos($backendcurrent[0], ",") === FALSE) {
          echo "<td class='".$style."'>\n";
            echo $backendcurrent[0];
            // create new root
            $newroot = $backendcurrent[0].",".$root;
            generateReplicationTopologyTable($backenddb, $newroot, $style);        
          echo "</td>\n";
        } // backend matches root and only one level
      } // else if root is set
    } // for each backend
    echo "</tr>\n";
    echo "</table>\n";
  }
?>

<!-- Replication Overview -->
<div id="replication_overview">
<?php
  if(!$oServer->isAvailable()) {
    $replication = setReplicationAgreement("");
  }
  else {
    // check replication, including CSN back check by default (can be configured)
    // For OpenLDAP this is mandatory
    $replication = setReplicationAgreement($servername, true);
  }

  $message = $replication->getMessage();
  if(!empty($message)) {
    showErrorMessage(getLang('page.replication.server.topology'),
                             $message);
  }
  else {
    // replication agreements
    $agreements = $replication->getAgreements();
    // get backend databases
    $backenddb = $replication->getBackendDb();
    // get replication serverlist
    $serverlist = $replication->getServerlist();

    // to get current time stamp
    $monitor = setMonitor($servername, array("cur_time"));
    // get information about this replica
    $replicainfo = setReplicaInfo($servername, $servername);
    $replicabackenddb = $replicainfo->getReplicaRoot();
    
?>
<table width="100%" border="0">
<tr>
  <td colspan="2" valign="top">
    <table border="0" cellpadding="6" cellspacing="0" width="100%">
    <tr>
      <td valign="top" align="left" width="500">
        <h3><?php echo getLang('page.replication.server.topology'); ?></h3>
        <table class="elementBorder" cellpadding='3' cellspacing="3" width="100%">
        <tr class="tableHeader">
          <td width="200">
            <b><?php echo $servername; ?></b><br>
          </td>
          <td width="300">
            <b><?php echo getLang("page.general.database"); ?>,
               <?php echo getLang("page.replication.nrofchanges"); ?></b><br>
          </td>
        </tr>
        <tr>
          <td width="200">
            <img src="<?php echo getStatusIcon($replicainfo->getReplicaType(), ''); ?>"><br>
          </td>
          <td valign="top" width="300">
          <?php
            $chartBackenddb = implode("*", $replicabackenddb);
            
            $emptyValue = "";
            $coverupValue = "";
            $chartValue = "";
            for($i = 0; $i < count($replicabackenddb); $i++) {
              if($i > 0) {
                $emptyValue .= "*";
                $chartValue .= "*";
                $coverupValue .= "*";
              }
              $emptyValue .= "0";
              $coverupValue .= "1";
              $chartValue .= $replicainfo->getNrOfChanges($replicabackenddb[$i]);
            }
            
            if($emptyValue == $chartValue) {
              if(empty($chartBackenddb)) {
                $chartValue = 1;
                $chartBackenddb = "Root";
              }
              else {
                $chartValue = $coverupValue;
              }
            }            
            ?>
            <div id="divReplication" class="flot_default_class" style="height:100px;width:300px;"></div>
          </td>
        </tr>
        </table>
      </td>
      <td valign="top">
        <h3><?php echo getLang('page.replication.database.topology'); ?></h3>
      <?php 
        if(count($replicabackenddb) > 0) {
         echo "<table width='100%' cellpadding='2' cellspacing='2' class='elementBorder'>\n";
         echo "<tr>\n";
         echo "<td height='100%'>\n";
           generateReplicationTopologyTable($replicabackenddb, "");
         echo "</td>\n";
         echo "</tr>\n";
         echo "</table>\n";
        }
        else {
          echo "<span class='gray'>-</span>";
        }
      ?>
      </td>
    </tr>
    </table>
   </td>
</tr>
<?php
  // if replica holds replication agreements
  if(count($backenddb) > 0) {
?>
<tr>
  <td align="center" width="100">
    <img src="icons/down.png">
  </td>
  <td>
    &nbsp;
  </td>
</tr>
<tr>
  <td colspan="2">
    <table width="100%" border="0" cellpadding="3" cellspacing="3" class="elementBorder">
    <tr class="tableHeader">
      <td width="50">&nbsp;</td>
      <td><b><?php echo getLang('page.general.server'); ?></b></td>
    <?php
      for($i = 0; $i < count($backenddb); $i++) {
        echo "<td>";
        echo "<b>".htmlspecialchars($backenddb[$i])."</b>";
        echo "<small> ( ".$replicainfo->getReplicaId($backenddb[$i])." )</small>";
        echo "</td>";
      }
    ?>
      <td><b><?php echo getLang('page.general.vendor'); ?></b></td>
    </tr>
<?php
  $style = "evenRow";
  for($i = 0; $i < count($serverlist); $i++) {

    if($style == "evenRow") {
      $style = "oddRow";
    }
    else {
      $style = "evenRow";
    }
    // get server id and properties
    // also check if this is an alias
    $verifiedHost = verifyReturnedHost($serverlist[$i]);
    $aEnvironment = getEnvironmentId($verifiedHost);

    // get current replication info
    $currentreplicainfo = setReplicaInfo($verifiedHost, $servername);
    // get first agreement to verify if its scheduled
    $currentAgreement = getAgreement($agreements, $serverlist[$i], $backenddb[0]);
    $currentServer = setServer($verifiedHost);
?>
    <tr class=<?php echo $style; ?>>
      <td>
        <img src="<?php echo getStatusIcon($currentreplicainfo->getReplicaType(), $currentAgreement->getUpdateSchedule()); ?>">
      </td>
      <td>
        <?php
          if(!empty($aEnvironment)) {
            echo "<a href='index.php?page=replication.php&environmentid=".$aEnvironment[0]."&serverid=".$aEnvironment[1]."&settab=replication_overview'>";
          }
          echo $serverlist[$i]; 
          if(!empty($aEnvironment)) {
            echo "</a>";
          }
        ?>
      </td>
    <?php
      for($j = 0; $j < count($backenddb); $j++) {
        $status = "gray";
        $currentAgreementMessage = "";
        $currentAgreement = getAgreement($agreements, $serverlist[$i], $backenddb[$j]);
        $currentAgreementHostname = $currentAgreement->getHostName();

        // if agreement exists
        if(!empty($currentAgreementHostname)) {
          $aTime = $currentAgreement->getEndTimeDiff($monitor->getCurrentTime(), $replication->getMasterCSN($backenddb[$j]));

          if(isAcceptableHours($aTime, $backenddb[$j])) {
            $status = "green";
          }
          else {
            $currentAgreementMessage = getLang("page.replication.noreplication");
          }

          $replicationStatusIcon = "plus.png";
          $replicationStatus = "";
          if($currentAgreement->isDisabledReplication()) {
            $replicationStatusIcon = "alert_warning.png";
            $replicationStatus = "warning";
            $status = "orange";
          }
          if($currentAgreement->getReplicationError()) {
            $replicationStatusIcon = "alert_error.png";
            $replicationStatus = "error";
            $status = "red";
          }
    ?>
      <td class="<?php echo $status; ?>">
        <a href="#<?php echo $i."_".$j; ?>" onClick="showHideRow('<?php echo $i."_".$j; ?>', '<?php echo $replicationStatus; ?>')", this><img id="moreinfo_image_<?php echo $i."_".$j; ?>" src="icons/<?php echo $replicationStatusIcon; ?>" width="16" alt="" /></a>
        <a href="#<?php echo $i."_".$j; ?>"></a>
        &nbsp;
        <?php
            echo $aTime[0]."h ".$aTime[1]."m ".$aTime[2]."s";
        ?>
      </td>
    <?php
        }// agreement exists
        else {
          echo "<td class='gray'>-</td>\n";
        }
      } // for each backend
    ?>
      <td>
        <?php echo $currentServer->getVendorName(); ?>
      </td>
    </tr>
    <?php
      for($j = 0; $j < count($backenddb); $j++) {
        $currentAgreementMessage = "";
        $currentAgreement = getAgreement($agreements, $serverlist[$i], $backenddb[$j]);
        if(!empty($currentAgreement)) {

          $aTime = $currentAgreement->getEndTimeDiff($monitor->getCurrentTime(), $replication->getMasterCSN($backenddb[$j]));

          if(!isAcceptableHours($aTime, $backenddb[$j])) {
            $currentAgreementMessage = getLang("page.replication.noreplication");
          }
    ?>
    <tr class="<?php echo $style; ?>" id="moreinfo_<?php echo $i."_".$j; ?>" style="visibility:hidden;display:none;">
      <td colspan="<?php echo (count($backenddb) + 3); ?>">
        <table width="100%" border="0" cellpadding="2" cellspacing="1" class="moreinfo">
        <tr>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getReplicaRoot()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.general.database"); ?></b>
          </td>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getUpdateStart()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.replication.starttime"); ?></b>
          </td>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getUpdateEnd()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.replication.endtime"); ?></b>
          </td>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getCSN()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.replication.csntime"); ?></b>
          </td>
          <td valign="top" width="20%">
            <b><?php echo getLang("page.general.replicationstatus"); ?></b>
          </td>
        </tr>
        <tr>
          <td valign="top" width="20%">
            <?php echo $currentAgreement->getReplicaRoot(); ?>
          </td>
          <td valign="top" width="20%">
            <?php echo $currentAgreement->getUpdateStart(); ?>
          </td>
          <td valign="top" width="20%">
            <?php echo $currentAgreement->getUpdateEnd(); ?>
          </td>
          <td valign="top" width="20%">
            <?php echo $currentAgreement->getCSN(); ?>
          </td>
          <td valign="top" width="20%">
            <?php
              if($currentAgreement->getReplicationError()) {
                // replication error exist
                echo "<img src='icons/alert_error.png' width='14' height='14'> ";
                echo "<b><span class='red'>".$currentAgreement->getLastStatus()."</span></b>";
                echo "<br>";
              }
              else if($currentAgreement->isDisabledReplication()) {
                // replication has been disabled (Sun One DS feature). Send out a warning and text
                echo "<img src='icons/alert_warning.png' width='14' height='14'> <b><span class='red'>Disabled</span></b>";
                echo "<br>";
              }
              else {
                $currentstatus = $currentAgreement->getLastStatus();
                if(!empty($currentstatus)) {
                  echo nl2br($currentAgreement->getLastStatus());
                  echo "<br>";
                }
              }
              if(!empty($currentAgreementMessage)) {
                echo "<img src='icons/alert_warning.png' width='14' height='14'>";
                echo " <b><span class='gray'>".$currentAgreementMessage."</span></b>";
              }
            ?>
          </td>
        </tr>
        <tr>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getDescription()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.general.description"); ?></b>
          </td>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getUpdateSchedule()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.replication.schedule"); ?></b>
          </td>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getNrOfChanges()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.replication.nrofchanges"); ?></b>
          </td>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getMessage()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.general.message"); ?></b>
          </td>
          <td valign="top" width="20%"<?php
            echo ($currentAgreement->getInProgress()) ? "" : " class='gray'";
          ?>>
            <b><?php echo getLang("page.replication.inprogress"); ?></b>
          </td>
        </tr>
        <tr>
          <td valign="top" width="20%">
            <?php echo $currentAgreement->getDescription(); ?>
          </td>
          <td valign="top" width="20%">
            <?php
              echo $currentAgreement->getUpdateSchedule();
            ?>
          </td>
          <td valign="top" width="20%">
            <?php echo $currentAgreement->getNrOfChanges(); ?>
          </td>
          <td valign="top" width="20%">
            <?php echo $currentAgreement->getMessage(); ?>
          </td>
          <td valign="top" width="20%">
            <?php 
              echo $currentAgreement->getInProgress();
            ?>
          </td>
        </tr>
        </table>
      </td>
    </tr>
    
<?php
      } // agreement exists
    } // for each hidden more info
  } // for each replication host
?>
    </table>
    </div>
  </td>
</tr>
<?php
  }  // if agreements exists
?>
<tr>
  <td colspan="2">
    &nbsp;
  </td>
</tr>
<tr>
  <td colspan="2">
    <br>
    <?php
      // verify if we have a master CSN ID. If not display message
      if(count($replicabackenddb) > 0) {
        $masterCSN = $replication->getMasterCSN($replicabackenddb[0]);
        if(empty($masterCSN)) {
          showInfoMessage(getLang("page.replication.delays"), getLang("page.replication.delayscsn"));
        }
        else {
          showInfoMessage("Replication Delays", getLang("page.replication.delayscurrenttime"));
        }
      }
    ?>
  </td>
</tr>
</table>
<?php
} // if server matching replica and operational
?>

</div>

<script language="javascript">
  function initCreateReplicationGraph(backends, chartvalue) {
    // show pie graph
    graphOptions = {
      series: {
        pie: { show: true }
      },
      grid: { hoverable: true }
    };

    var aBackEnds = backends.split("*");
    var aChartValue = chartvalue.split("*");
    var data = new Array();
    for(var i = 0; i < aBackEnds.length; i++) {
      setCollectedMonitoringData("replication", i, aBackEnds[i], aChartValue[i]);
    }
    
    $.plot($("#divReplication"), collectedMonitoringData["replication"], graphOptions);
    $("#divReplication").bind("plothover", setFlotPieLineGraphHover);

  }
  $(function () {
    initCreateReplicationGraph("<?php echo $chartBackenddb; ?>", "<?php echo $chartValue; ?>");
  });
</script>

<!-- Replication Overview -->
<div id="replication_details">
<h3><?php echo getLang('tab.replication.details'); ?></h3>
<?php
  $message = $replication->getMessage();
  if(!empty($message)) {
    showErrorMessage(getLang('tab.replication.details'),
                             $message);
  }
  else {
    $agreements = $replication->getAgreements();
    $backenddb = $replication->getBackendDb();
?>
<table width="100%" cellpadding="5" cellspacing="1">
<tr>
  <td colspan="9">
    <b><?php echo getLang("page.replication.selectedserver"); ?></b>
  </td>
</tr>
<tr class="tableHeader">
  <td width="30">
    &nbsp;
  </td>
  <td>
    <?php echo getLang("page.general.server"); ?>
  </td>
  <td>
    <?php echo getLang("page.general.database"); ?>
  </td>
  <td>
    &nbsp;
  </td>
  <td>
    &nbsp;
  </td>
  <td>
    <?php echo getLang("page.replication.csntime"); ?>
  </td>
  <td>
    &nbsp;
  </td>
  <td>
    &nbsp;
  </td>
  <td width='250'>
    &nbsp;
  </td>
</tr>
<?php
  $style = "evenRow";
  for($i = 0; $i < count($backenddb); $i++) {

    if($style == "evenRow") {
      $style = "oddRow";
    }
    else {
      $style = "evenRow";
    }
?>
<tr class="<?php echo $style; ?>">
  <td width="30">
    &nbsp;
  </td>
  <td>
   <?php echo $servername; ?>
  </td>
  <td>
   <?php echo $backenddb[$i]; ?>
  </td>
  <td>
    &nbsp;
  </td>
  <td>
    &nbsp;
  </td>
  <td>
    <?php echo $replication->getMasterCSN($backenddb[$i]); ?>
  </td>
  <td>
    &nbsp;
  </td>
  <td>
    &nbsp;
  </td>
  <td width='300'>
    &nbsp;
  </td>
</tr>
<?php
  }
?>
<tr>
  <td colspan="9">
    &nbsp;
  </td>
</tr>
<tr>
  <td colspan="9">
    <b><?php echo getLang("page.replication.agreements"); ?></b>
  </td>
</tr>
<tr class="tableHeader">
  <td width="30">
    &nbsp;
  </td>
  <td>
    <?php echo getLang("page.general.server"); ?>
  </td>
  <td>
    <?php echo getLang("page.general.database"); ?>
  </td>
  <td>
    <?php echo getLang("page.replication.starttime"); ?>
  </td>
  <td>
    <?php echo getLang("page.replication.endtime"); ?>
  </td>
  <td>
    <?php echo getLang("page.replication.csntime"); ?>
  </td>
  <td>
    <?php echo getLang("page.general.port"); ?>
  </td>
  <td>
    <?php echo getLang("page.replication.inprogress"); ?>
  </td>
  <td width='300'>
    <?php echo getLang("page.general.replicationstatus"); ?>
  </td>
</tr>
<?php
  $style = "evenRow";
  for($i = 0; $i < count($agreements); $i++) {
    $currentAgreementMessage = "";
    if($style == "evenRow") {
      $style = "oddRow";
    }
    else {
      $style = "evenRow";
    }

    $statusImage = "ok";
    $rowStyle = "";
    if(!isAcceptableHours($agreements[$i]->getEndTimeDiff($monitor->getCurrentTime(), $replication->getMasterCSN($agreements[$i]->getReplicaRoot())), 
                          $agreements[$i]->getReplicaRoot())) {
      $currentAgreementMessage = getLang("page.replication.noreplication");
    }

    if($agreements[$i]->isDisabledReplication()) {
      $rowStyle = "orange";
      $statusImage = "warning";
    }
    if($agreements[$i]->getReplicationError()) {
      $rowStyle = "red";
      $statusImage = "error";
    }
?>
<tr class="<?php echo $style; ?>">
  <td width="30" valign="top"><img height="30" src="icons/alert_<?php echo $statusImage; ?>.png"></td>
  <td valign="top" class="<?php echo $rowStyle; ?>"><?php echo $agreements[$i]->getHostName(); ?></td>
  <td valign="top" class="<?php echo $rowStyle; ?>"><?php echo $agreements[$i]->getReplicaRoot(); ?></td>
  <td valign="top" class="<?php echo $rowStyle; ?>"><?php echo $agreements[$i]->getUpdateStart(); ?></td>
  <td valign="top" class="<?php echo $rowStyle; ?>"><?php echo $agreements[$i]->getUpdateEnd(); ?></td>
  <td valign="top" class="<?php echo $rowStyle; ?>"><?php echo $agreements[$i]->getCSN(); ?></td>
  <td valign="top" class="<?php echo $rowStyle; ?>"><?php echo $agreements[$i]->getPort(); ?></td>
  <td valign="top" class="<?php echo $rowStyle; ?>"><?php echo $agreements[$i]->getInProgress(); ?></td>
  <td valign="top" width='300' class="<?php echo $rowStyle; ?>">
    <?php 
      echo $agreements[$i]->getLastStatus(); 
      if(!empty($currentAgreementMessage)) {
        echo "<br><b><span class='gray'>".$currentAgreementMessage."</span></b>";
      }
    ?>
  </td>
</tr>
<?php
  }
?>
</table>


<?php 
  }
?>
</div>
