<?php
  if(!file_exists("./objects/schemaobject.php")) { header("Location: ../index.php"); }
  $CONFDIR="../config";
  require "./objects/schemaobject.php";
  require "./objects/queryobject.php";
  require "./objects/rootdnobject.php";
  require $CONFDIR."/query.php";

  // if page is disabled
  if(!functionIsEnabled("query")) {
    echo "Page is supposed to be disabled. Please report this as a bug if this is not the case.";
    exit(0);
  }  

  // set new csv and remove the old one
  $csvFileName = getTempFileName("queryexport");
  removeTempFileName("queryexport");
  $delim = $QUERY_CSV_DELIMITER;
  $delimvalue = $QUERY_CSV_DELIMITER_VALUE;

  $FILE = new File();
  $environmentid = getFormValue("environmentid");
  if(empty($environmentid)) {
    $environmentid = 0;
  }
  $serverid = getFormValue("serverid");

  $queryfilter = trim(getFormValue('queryfilter'));
  $queryattribute = trim(getFormValue('queryattribute'));
  $querysuffix = trim(getFormValue('querysuffix'));
  $serverlist = getFormValue('serverlist');
  $queryvalue = trim(getFormValue('queryvalue'));
  $queryreturn = getFormValue('queryreturn');
  $querydo = getFormValue('querydo');
  $entrydn = trim(getFormValue('entrydn'));
  $entrybasedn = trim(getFormValue('entrybasedn'));
  $entryserver = getFormValue('entryserver');
  $compareserver = getFormValue('compareserver');

  if(empty($serverid) && empty($serverlist)) {
    $serverlist = getServersUnique($environmentid);
    // get rootDN from first server in list
    $servername = $serverlist[0];
  }
  else {
    $servername = getServerName($serverid, $environmentid);
  }

  // if serverlist doesn't exist
  if(empty($serverlist)) {
    $serverlist[0] = $servername;
  }

  // build query suffix list
  $querysuffixlist = Array();
  $querysuffixlistrootdn = Array();

  // if server is selected it must respond
  // otherwise go for first responding in environment
  if(!empty($serverid)) {
    $respondingServer = getFirstRespondingServerInEnvironment($environmentid, $serverid);
  }
  else {
    $respondingServer = getFirstRespondingServerInEnvironment($environmentid);
  }

  if(!empty($respondingServer)) {
    $rootdn = setRootDN($respondingServer, array("namingcontexts"));
    $querysuffixlistrootdn = $rootdn->getNamingContexts();
  }

  // set schema from first responding server
  if(!empty($respondingServer)) {
    setSchema($respondingServer);
  }

  // we need to set this variable even if it is empty
  if(empty($QUERY_DISABLE_ATTRIBUTES)) {
    $QUERY_DISABLE_ATTRIBUTES = Array();
  }


  // merge found naming contexts and default suffixes
  // there can be duplicates but we have to live with that for now
  $querysuffixlist = array_merge($querysuffixlistrootdn, 
                                 $QUERY_DEFAULT_BASESUFFIX);

  // base suffix from default configured value
  if(empty($querysuffix)) {
    $querysuffix = getConfigValue("querysuffix", $environmentid, $serverid);
  }

  // if query suffix not in querysuffixlist, add it
  if(!empty($querysuffix)) {
    if(!in_array($querysuffix, $querysuffixlist)) {
      $querysuffixlist[count($querysuffixlist)] = $querysuffix;
    }
  }
  
  // finally. If querysuffix is still empty. Set first suffix in suffix list
  if(empty($querysuffix)) {
    $querysuffix = $querysuffixlist[0];
  }

  // query return
  if(empty($queryreturn) && empty($querydo)) {
    $squeryreturn = getConfigValue("queryreturn", $environmentid, $serverid);
    if(!empty($squeryreturn)) {
      $queryreturn = explode(",", $squeryreturn);
    }
    else {
      $queryreturn = explode(",", $QUERY_DEFAULT_RETURN_ATTRIBUTES);
    }
  }

  if(empty($querydo)) {
    $serverlist[0] = $servername;
  }

  // query attribute
  if(empty($queryattribute) && empty($querydo)) {
    $queryattribute = getConfigValue("queryattribute", $environmentid, $serverid);
    if(empty($queryattribute)) {
      $queryattribute = $QUERY_DEFAULT_ATTRIBUTES[0];
    }
  }

  // query filter
  if(empty($queryfilter) && empty($querydo)) {
    $queryfilter = getConfigValue("queryfilter", $environmentid, $serverid);
    if(empty($queryfilter)) {
      $queryfilter = $QUERY_DEFAULT_FILTER;
    }
  }

  // compare function for strings and arrays
  function compareValues($inEntry, $inCompare) {
    if(is_array($inEntry) && is_array($inCompare)) {
      if((count($inEntry) == 1) && (count($inCompare) == 1)) {
        if(strcasecmp($inEntry[0], $inCompare[0]) != 0) {
          if(empty($inCompare)) {
            echo "<span class='red'>N / A</span><br>\n";
          }
          else {
            echo "<span class='blue'>".$inCompare[0]."</span><br>\n";
          }
        }
        else {
          echo $inEntry[0]."<br>\n";
        }
      } // single value
      else {
        // multivalue
        for($i = 0; $i < count($inEntry); $i++) {
          if(!in_array($inEntry[$i], $inCompare)) {
            echo "<span class='red'>N / A</span><br>\n";
          }
          else {
            echo $inEntry[$i]."<br>\n";
          }
        }
        for($i = 0; $i < count($inCompare); $i++) {
          if(!in_array($inCompare[$i], $inEntry)) {
            echo "<span class='blue'>".$inCompare[$i]."</span><br>\n";
          }
        }
      } // multivalue
    } // array
    else {
      if(strcasecmp($inEntry, $inCompare) != 0) {
        if(empty($inCompare)) {
          echo "<span class='red'>N / A</span><br>\n";
        }
        else {
          echo "<span class='blue'>".$inCompare."</span><br>\n";
        }
      }
    } // string value
  }
?>
<script language="javascript">

function doQuery(oForm, querytype, dn) {

  oForm.entrybasedn.value = dn;
  
  if(querytype == "entry") {
    oForm.settab.value = "query_entry";
  }
  else if(querytype == "basedn") {
    oForm.settab.value = "query_result";
    queryEntryAttributes(oForm);
  }
  else {
    oForm.settab.value = "query_result";
  }


  // we need to select all query return attributes
  returnAttributesLength = oForm.queryreturn.options.length;
  for(var i = 0; i < returnAttributesLength; i++) {
    oForm.queryreturn.options[i].selected = 1;
  }

  oForm.submit();
  return false;
}

function viewSingleEntry(servername, dn) {
  var oForm = document.forms["queryform"];
  oForm.entryserver.value = servername;
  doQuery(oForm, "entry", dn);
}

// compare single entry with compareserver
function compareSingleEntry(servername, dn, compareserver) {
  if(!compareserver.value) {
    return;
  }
  var oForm = document.forms["queryform"];
  oForm.compareserver.value = compareserver.value;
  viewSingleEntry(servername, dn);
}

</script>

  <!-- Query One or more LDAP servers -->
  <form name="queryform" action="index.php" onSubmit="return false;" method="post">
  <input type="hidden" name="environmentid" value="<?php echo $environmentid; ?>">
  <input type="hidden" name="entrybasedn" value="<?php echo $entrybasedn; ?>">
  <input type="hidden" name="serverid" value="<?php echo $serverid; ?>">
  <input type="hidden" name="page" value="<?php echo getFormValue('page'); ?>">
  <input type="hidden" name="settab" value="query_result">
  <input type="hidden" name="compareserver" value="">
  <input type="hidden" name="querydo" value="1">
  <div id="query_query">

<?php
  if(empty($respondingServer)) {
    showErrorMessage(getLang('page.query.queryservers'),
                     getLang('page.general.servernotavailable'));
  }
  else {
?>

    <h2>
      <?php echo getLang('page.query.queryservers'); ?>
    </h2>
    <table border="0" cellpadding="5" cellspacing="5" width="1000">
    <tr class="tableHeader">
      <td>
        <b><?php echo getLang('page.general.selectservers'); ?></b>
      </td>
      <td colspan="2">
        <b><?php echo getLang('page.query.queryfield'); ?></b>
      </td>
      <td>
        <b><?php echo getLang('page.query.queryreturn'); ?></b>
      </td>
      <td width="100">
        <b><?php echo getLang('page.general.queryrun'); ?></b>
      </td>
    </tr>
    <tr>
<!-- SERVERS -->
      <td valign="top" rowspan="4">
<?php
  $servers = getServers($environmentid);
?>
        <select name="serverlist[]" multiple size="10">
<?php
  // as the same servers can be added to different environments
  // for each server
  for($i = 0; $i < count($servers); $i++) {
?>
          <option value="<?php echo $servers[$i][1]; ?>"<?php
            if(in_array($servers[$i][1], $serverlist)) {
              echo " selected";
            }
          ?>><?php echo $servers[$i][1]; ?></option>
<?php  
  } // list all servers
?>
        </select>
      </td>
<!-- Query Attribute -->
      <td width="200" valign="top">
        <b><?php echo getLang("page.query.queryattribute"); ?></b><br>
        <input class="inputattribute" type="text" autocomplete="off" value="<?php echo $queryattribute; ?>" name="queryattribute" id="queryattribute">
        <script language="javascript" type="text/javascript">
          $(function () {
            $("#queryattribute").coolautosuggest({
              url:getServiceURL() + "&service=schemaquery&servername=<?php echo $respondingServer; ?>&q=",
              minChars:3
            });
          });
        </script>
        <br><br>
<!-- Query Base Suffix -->
        <b><?php echo getLang('page.query.basesuffix'); ?></b><br>
        <select class="inputattribute" id="querysuffix" name="querysuffix" size="6">
        <?php
          for($i = 0; $i < count($querysuffixlist); $i++) {
            echo "<option value='".$querysuffixlist[$i]."'";
              if($querysuffix == $querysuffixlist[$i]) {
                echo " selected";
              }
            echo ">".$querysuffixlist[$i]."</option>\n";
          }
          ?>
        </select>

      </td>
<!-- Query Value -->
      <td>
        <b><?php echo getLang("page.query.queryvalue"); ?></b><br>
        <textarea rows="15" name="queryvalue" style="width:200px"><?php echo htmlspecialchars($queryvalue); ?></textarea>
      </td>
<!-- Query Return Attributes -->
      <td valign="top" rowspan="2">
        <table border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td colspan="2">
            <b><?php echo getLang('page.query.queryattribute'); ?></b><br>
          </td>
        </tr>
        <tr>
          <td>
            <input class="inputattribute" type="text" autocomplete="off" name="queryreturntext" id="queryreturntext">
            <script language="javascript" type="text/javascript">
              $(function () {
                $("#queryreturntext").coolautosuggest({
                  url:getServiceURL() + "&service=schemaquery&servername=<?php echo $respondingServer; ?>&q=",
                  minChars:3
                });
              });
            </script>
          </td>
          <td valign="top">
            <a href="#" onClick="cnmonitorAddValueToList('queryreturntext', 'queryreturn');" border="0"><img src="icons/down.png" width="14"></a>
          </td>
        </tr>
        <tr>
          <td colspan="2">
            &nbsp;
          </td>
        </tr>
        <tr>
          <td>
            <select class="inputattribute" id="queryreturn" name="queryreturn[]" multiple size="10">
<?php
  for($i = 0; $i < count($queryreturn); $i++) {
?>
              <option value="<?php echo $queryreturn[$i]; ?>"><?php echo $queryreturn[$i]; ?></option>
<?php
  }
?>
            </select>
          </td>
          <td valign="top">
            <a href="#" onClick="removeElementFromList(document.getElementById('queryreturn'))">
              <img src="icons/delete.png" width="16" border="0">
            </a>
          </td>
        </tr>
        <tr>
          <td colspan="2">
            &nbsp;&nbsp;&nbsp;
          </td>
        </tr>
        <tr>
          <td colspan="2">
            <b><?php echo getLang('page.query.queryprotectedattribute'); ?></b><br>
          </td>
        </tr>
        <tr>
          <td colspan="2">
<?php
  if(!empty($QUERY_DISABLE_ATTRIBUTES)) {
    if(is_array($QUERY_DISABLE_ATTRIBUTES)) {
      for($i = 0; $i < count($QUERY_DISABLE_ATTRIBUTES); $i++) {
        echo $QUERY_DISABLE_ATTRIBUTES[$i]."<br>\n";
      }
    } // is array
  } // protected attributes list not empty
  else {
    echo "<span class='gray'>-</span>";
  }
?>
          </td>
        </tr>
        </table>
      </td>
<!-- Query Search Button -->
      <td valign="top" rowspan="2" width="100">
        <input type="button" onclick="doQuery(document.forms['queryform'], '', '')" value="<?php echo getLang('page.query.querybutton'); ?>" style="width:100px;">
      </td>
    </tr>
    <tr>
      <td valign="top" colspan="2">
        <b><?php echo getLang('page.query.queryfilter'); ?></b>
        <br>
        <textarea rows="3" name="queryfilter" style="width:100%"><?php echo htmlspecialchars($queryfilter); ?></textarea>
      </td>
    </tr>
    </table>
<?php
  } // at least one server is available
?>
  </div>

  <!-- Query Result -->
  <div id="query_result">
<?php
  // if we have queried the directory/ies
  if(!empty($querydo)) {
?>
  <input type="hidden" name="entryserver" value="<?php echo $entryserver; ?>">
  <input type="hidden" name="entrydn" value="<?php echo $entrydn; ?>">

  <table width="100%" cellpadding="1" cellspacing="1">
  <tr>
    <td colspan="2">
      <h2>
        <?php echo getLang('page.general.viewresult'); ?>
      </h2>
    </td>
  </tr>
  <tr>
    <td>
      <i><?php echo getLang('page.query.querylimitation'); ?><?php echo $QUERY_LIMITED_TO; ?>
    </td>
    <td align="right" valign="top">
      <input type="button" onClick="window.location='index.php?page=exportfile.php&exportfile=queryexport'" value= "<?php echo getLang('page.general.exportcsvfile'); ?>">
      &nbsp;&nbsp;&nbsp;
      <input type="button" onclick="doQuery(document.forms['queryform'], '', '')" value="<?php echo getLang('page.query.querybutton'); ?>">
    </td>
  </tr>
  </table>
<?php
    // list of query filters to run
    $aqueryfilter = Array();
  
    // clean query filter
    $queryfilter = stripslashes($queryfilter);
    $queryfilter = str_replace(array("\r\n", "\n", "\r", " "), "", $queryfilter);
    $queryfilter = trim(str_replace("\t", "", $queryfilter));

    // if query value exists. Build query filter(s)
    if(!empty($queryvalue)) {
      // set query value
      $queryvalue = stripslashes($queryvalue);
      $queryvalue = str_replace(array("\r\n", "\r"), "\n", $queryvalue);
      $aqueryvalue = explode("\n", $queryvalue);

      // build query filter array
      for($i = 0; $i < count($aqueryvalue); $i++) {
        $currentValue = trim($aqueryvalue[$i]);
        if(!empty($currentValue)) {
          $aqueryfilter[count($aqueryfilter)] = "(&".$queryfilter."($queryattribute=".$currentValue."))";
        }
      }
    }
    else {
      // query filter does not exist. Ok to use existing filter
      $aqueryfilter[0] = $queryfilter;
    }
    
?>
  <table border="0" width="100%" cellpadding="3" cellspacing="3">
  <tr class="tableHeader">
    <td>
      <?php echo getLang('page.general.server'); ?>
    </td>
    <td width="10" valign="top">&nbsp;</td>
<?php
    $csvFileResult = getLang('page.general.server').$delim.$delim;
    for($i = 0; $i < count($queryreturn); $i++) {
      // csv file header
      $csvFileResult .= $queryreturn[$i].$delim;
      echo "<td>\n";
        echo $queryreturn[$i];
      echo "</td>\n";
    } // return attributes
    echo "<td>&nbsp;</td>";
    echo "</tr>\n";

    // add header attributes to file
    $FILE->write($csvFileName, $csvFileResult."\n");

  // query each filter
  for($filtercounter = 0; $filtercounter < count($aqueryfilter); $filtercounter++) {


    // for each server to query
    for($i = 0; $i < count($serverlist); $i++) {
      $currentserver = trim($serverlist[$i]);

      // if empty string next
      if(empty($currentserver)) {
        continue;
      }

      // Verify server status
      $oServer = setServer($currentserver);

      $csvFileResult = "";
      
      if($oServer->isAvailable()) {
        $result = queryServer($currentserver, $querysuffix, $aqueryfilter[$filtercounter], $queryreturn, $QUERY_LIMITED_TO);

        for($j = 0; $j < count($result); $j++) {
          $Query = $result[$j];
          $message = $Query->getMessage();


          echo "<tr>\n";
          echo "<td valign='top'>";
          // only display server name on the first row
          if($j == 0) {
            echo "<b>".$currentserver."</b>";
          }
          echo "&nbsp;</td>\n";

          if(!empty($message)) {
            echo "<td>&nbsp;</td>";
            echo "<td colspan='".count($queryreturn)."'>";
              // display warning message
              showWarningMessage($message." : ".htmlspecialchars($aqueryfilter[$filtercounter]));
            echo "</td>\n";
            echo "<td valign='top' align='right'><img src='icons/computer_alert.png' width='24'>&nbsp;&nbsp;</td>";
            $csvFileResult .= $currentserver.$delim.
                              " ".$delim.$message." : ".
                              str_replace(array($delim, $delimvalue), "", $aqueryfilter[$filtercounter]).$delim;
          }
          else {
            $csvFileResult .= $currentserver.$delim;
            $csvFileResult .= ($filtercounter + 1).".".($j+1).$delim;
            echo "<td valign='top'>".($filtercounter + 1).".".($j+1)."</td>";
            for($k = 0; $k < count($queryreturn); $k++) {
              echo "<td valign='top'>\n";
              $currentvalue = "";
              // most likely a string value
              if(!in_array($queryreturn[$k], $QUERY_DISABLE_ATTRIBUTES)) {
                $currentvalue = $Query->getValue(strtolower($queryreturn[$k]));
              } // if not protected value

              if(empty($currentvalue)) {
                echo "-";
                $csvFileResult .= $delim;
              }
              else {
                // jpeg photo
                if(($queryreturn[$k] == "photo") || ($queryreturn[$k] == "jpegPhoto")) {
                  echo "<img src='pages/showphoto.php?dn=".$Query->getDN()."&attribute=".$queryreturn[$k]."&servername=".$currentserver."'>";
                  $csvFileResult .= "<image>";
                }
                else {
                  // for each value in multi value
                  for($l = 0; $l < count($currentvalue); $l++) {
                    // add value delim if not first value
                    if($l > 0) {
                      $csvFileResult .= $delimvalue;
                    }  // not first value
                    echo $currentvalue[$l]."<br>";
                    // set csv result. Replace delim and delimvalue to nothing
                    $csvFileResult .= str_replace(array($delim, $delimvalue), 
                                                  "", $currentvalue[$l]);
                  } // for each value
                } // value exists
                $csvFileResult .= $delim;
              } // server is operational
              echo "</td>\n";
            } // for entry
            
            
            echo "<td valign='top' align='right'>\n";
            echo "  <a href='#".$filtercounter."_".$i."_".$j."' onClick='showHideRow(\"".$filtercounter."_".$i."_".$j."\", \"\")', this><img id='moreinfo_image_".$filtercounter."_".$i."_".$j."' src='icons/plus.png' width='24' alt='' /></a>\n";
            echo "&nbsp;&nbsp;";
            echo "<a name='".$filtercounter."_".$i."_".$j."'></a>";
            echo "</td>\n";
            echo "</tr>\n";

            // more info
            echo "<tr id='moreinfo_".$filtercounter."_".$i."_".$j."' style='visibility:hidden;display:none;'>\n";
            echo "<td valign='top' colspan='".(count($queryreturn) + 3)."'>\n";
?>           
              <table width="100%" border="0" cellpadding="3" cellspacing="3" class="moreinfo">
              <tr>
                <td colspan="3"><b>Distinguished Name (DN)</b></td>
                <td align="right" rowspan="2">
                  <a href="#" onClick="viewSingleEntry('<?php echo $currentserver; ?>', '<?php echo $Query->getDN(); ?>')"><img src="icons/document.png" width="32" alt=""></a>
                </td>
              </tr>
              <tr>
                <td colspan="4">
                  <big>
                    <a href="#" onClick="viewSingleEntry('<?php echo $currentserver; ?>', '<?php echo $Query->getDN(); ?>')"><?php echo $Query->getDN(); ?></a>
                  </big>
                </td>
              </tr>
              <tr>
                <td width="25%"><b><?php echo getLang("page.query.createdby"); ?></b></td>
                <td width="25%"><b><?php echo getLang("page.query.createdtimestamp"); ?></b></td>
                <td width="25%"><b><?php echo getLang("page.query.updatedby"); ?></b></td>
                <td width="25%"><b><?php echo getLang("page.query.updatedtimestamp"); ?></b></td>
              </tr>
              <tr>
                <td width="25%">
                  <?php echo $Query->getCreatorsName(); ?>
                </td>
                <td width="25%">
                  <?php echo $Query->getCreateTimeStamp(); ?>
                </td>
                <td width="25%">
                  <?php echo $Query->getModifiersName(); ?>
                </td>
                <td width="25%">
                  <?php echo $Query->getModifyTimestamp(); ?>
                </td>
              </tr>
              </table>
<?php
            echo "</td>\n";
            echo "</tr>\n";
          }  // result row
          $csvFileResult .= "\n";
        } // each exists
      } // if socket responding
      else {
        echo "<td valign='top' class='red'><b>".$currentserver."</b></td>\n";
        echo "<td valign='top'>&nbsp;</td>\n";
        echo "<td valign='top' colspan='".count($queryreturn)."'>";
        // display error message
         showErrorMessage($currentserver, 
                          getLang('page.general.notansweringonport'));
        echo "&nbsp;</td>\n";
        echo "<td align='right' valign='top'><img src='icons/alert_error.png' width='24'>&nbsp;&nbsp;</td>";
        echo "</tr>\n";
        $csvFileResult .= $currentserver.$delim." ".$delim.getLang('page.general.notansweringonport').$delim;
      }
      
      echo "<tr>\n";
        echo "<td colspan='".(count($queryreturn) + 3)."'>";
        echo "<hr width='100%'></td>\n";
      echo "</tr>\n";
?>
  </tr>
<?php
       $FILE->append($csvFileName, $csvFileResult);
     } // for each server
     // save data to file
   } // for filter to query
   echo "</table>\n";
   echo "<br><br>\n";
   echo "<span class='gray'>";
   for($i = 0; $i < count($aqueryfilter); $i++) {
     echo getLang('page.query.queryfilter')." ".($i + 1).": ".$aqueryfilter[$i]."<br>";
   }
     echo getLang('page.query.queryreturn').": ";
     for($i=0; $i < count($queryreturn); $i++) {
       echo $queryreturn[$i].",";
     }
     echo "<br>";
     echo getLang('page.query.queryfield').": ".$queryattribute."<br>";
     echo getLang('page.query.basesuffix').": ".$querysuffix."<br>";
   echo "</span>\n";
 } // if do query
?>
  </div>

  <!-- Query Result -->
  <div id="query_entry">

  <script language="javascript">
  
    function queryEntryAttributes(oForm) {
      var currentValue = "";
      var oList = oForm.queryreturn;
      removeAllElementsInList(oList);
      if(oForm.entryattributes) {
        for(var i = 0; i < oForm.entryattributes.length; i++) {
          if(oForm.entryattributes[i].checked) {
            currentValue = oForm.entryattributes[i].value;
            addElementToList(oList, currentValue, currentValue, "");
          }
        }
      }
    }
  
  </script>
<?php 
  if(!empty($entryserver) && !empty($entrybasedn)) {
  // Get Entry
  // Verify server status
  $oServerEntry = setServer($entryserver);
  if($oServerEntry->isAvailable()) {

    // get query object
    $QueryEntry = getEntry($entryserver, $entrybasedn);
    $attributes = $QueryEntry->getAttributes();
  } // is available

  // Compare server  
  $compareAvailable = false;
  $attributesCompare = Array();
  $resultAttributeCompare = Array();
  if(!empty($compareserver)) {
    // Verify server status
    $oServerCompare = setServer($compareserver);
    if($oServerCompare->isAvailable()) {
      // get query object
      $QueryCompare = getEntry($compareserver, $entrybasedn);
      $attributesCompare = $QueryCompare->getAttributes();
      if(!empty($attributesCompare)) {
        $compareAvailable = true;
      } // attributes do exists (entry exists)
    } // is available
  } // compare server
?>
  <table border="0" cellpadding="3" cellspacing="3">
  <tr>
    <td colspan="4">
      <h2>
        <?php echo $entrybasedn; ?>
      </h2>
    </td>
  </tr>
  <tr>
    <td colspan="2">&nbsp;</td>
    <td>
      <input type="button" onclick="doQuery(document.forms['queryform'], 'basedn', '')" value="<?php echo getLang('page.query.querybutton'); ?>">
    </td>
    <td>
      <select name="compareservername" onChange="compareSingleEntry('<?php echo $currentserver; ?>', '<?php echo $entrybasedn; ?>', this)">
        <option value=""><?php echo getLang("page.query.compare"); ?>:</option>
<?php
    $compareServer = getServersUnique();
    for($i = 0; $i < count($compareServer); $i++) {
      if(strcasecmp($compareServer[$i], $entryserver) == 0) {
        continue;
      }
?>
        <option value="<?php echo $compareServer[$i]; ?>"<?php
          if($compareserver == $compareServer[$i]) {
            echo " selected";
          } ?>><?php echo $compareServer[$i]; ?></option>
<?php
   }
?>
      </select>
<?php
  if(!empty($compareserver)) {
    if(!$oServerCompare->isAvailable()) {
      echo "&nbsp;<span class='red'>".getLang("page.general.servernotavailable")."</span>";
    }
    else {
      $errorMessage = $QueryCompare->getMessage();
      if(!empty($errorMessage)) {
        echo "&nbsp;<span class='red'>".$errorMessage."</span>";
      }
    }
  }
?>
    </td>
  </tr>
<?php
  $class = "evenRow";
  for($i = 0; $i < count($attributes); $i++) {
    if($class == "oddRow") {
      $class = "evenRow";
    }
    else {
      $class = "oddRow";
    }
    
    if(in_array($attributes[$i], $QUERY_DISABLE_ATTRIBUTES)) {
      continue;
    }

?>
  <tr class="<?php echo $class; ?>">
    <td width="10" valign="top">
      <input type="checkbox" name="entryattributes" value="<?php echo $attributes[$i]; ?>"<?php
        if(in_array($attributes[$i], $queryreturn)) {
          echo " checked";
        }
      ?>>
    </td>
    <td valign="top" width="200">
      <big><?php echo $attributes[$i]; ?></big>
    </td>
    <td valign="top">
      <?php
        $values = $QueryEntry->getValue(strtolower($attributes[$i]));
        for($j = 0; $j < count($values); $j++) {
          if(($attributes[$i] == "photo") || ($attributes[$i] == "jpegPhoto")) {
            echo "<img src='pages/showphoto.php?dn=".$entrybasedn."&attribute=".$attributes[$i]."&servername=".$entryserver."'>";
          }
          else {
            echo $values[$j]."<br>\n";           
          }
        }
      ?>
    </td>
    <td valign="top">
      <?php
        if($compareAvailable) {
          $valuesCompare = $QueryCompare->getValue(strtolower($attributes[$i]));
          if(($attributes[$i] == "photo") || ($attributes[$i] == "jpegPhoto")) {
            echo "<img src='pages/showphoto.php?dn=".$entrybasedn."&attribute=".$attributes[$i]."&servername=".$compareserver."'>";
          }
          else {
            compareValues($values, $valuesCompare);
          }
        } // compare available
      ?>
    </td>
  </tr>
<?php
  }
  
  for($i = 0; $i < count($attributesCompare); $i++) {

    if(in_array($attributesCompare[$i], $QUERY_DISABLE_ATTRIBUTES)) {
      continue;
    }

    if(!in_array($attributesCompare[$i], $attributes)) {
      $resultAttributeCompare[count($resultAttributeCompare)] = $attributesCompare[$i];
    }
  }
  $class = "evenRow";
  for($i = 0; $i < count($resultAttributeCompare); $i++) {
    if($class == "oddRow") {
      $class = "evenRow";
    }
    else {
      $class = "oddRow";
    }
?>
  <tr class="<?php echo $class; ?>">
    <td width="10">
      &nbsp;
    </td>
    <td>
      <big><?php echo $resultAttributeCompare[$i]; ?></big>
    </td>
    <td class="red">N / A</td>
    <td valign="top">
      <?php
        if($compareAvailable) {
          $valuesCompare = $QueryCompare->getValue(strtolower($resultAttributeCompare[$i]));
          $values = $QueryEntry->getValue(strtolower($resultAttributeCompare[$i]));
 
          if(($resultAttributeCompare[$i] == "photo") || ($resultAttributeCompare[$i] == "jpegPhoto")) {
            echo "<img src='pages/showphoto.php?dn=".$entrybasedn."&attribute=".$resultAttributeCompare[$i]."&servername=".$compareserver."'>";
          }
          else {
            compareValues($values, $valuesCompare);
          }

        } // compare available
      ?>
    </td>
  </tr>
<?php
  }
?>
  <tr>
    <td colspan="4">&nbsp;</td>
  </tr>
  <tr>
    <td colspan="4">
      <h3><?php echo getLang("page.query.operationalattributes"); ?></h3>
    </td>
  </tr>
  <tr>
    <td width="10">
      &nbsp;
    </td>
    <td>
      <?php echo getLang("page.query.createdby"); ?>:
    </td>
    <td>
      <?php
        echo "<a href='#' onClick='viewSingleEntry(\"".$entryserver."\", \"".$QueryEntry->getCreatorsName()."\")'>";
        echo $QueryEntry->getCreatorsName();
        echo "</a>\n";
      ?>
    </td>
    <td>
<?php
  if($compareAvailable) {
    compareValues($QueryEntry->getCreatorsName(), $QueryCompare->getCreatorsName());
  }
?>
    </td>
  </tr>
  <tr>
    <td width="10">
      &nbsp;
    </td>
    <td>
      <?php echo getLang("page.query.createtime"); ?>:
    </td>
    <td>
      <?php echo $QueryEntry->getCreateTimeStamp(); ?>
    </td>
    <td class="red">
<?php
  if($compareAvailable) {
    compareValues($QueryEntry->getCreateTimeStamp(), $QueryCompare->getCreateTimeStamp());
  }
?>
    </td>
  </tr>
  <tr>
    <td width="10">
      &nbsp;
    </td>
    <td>
      <?php echo getLang("page.query.modifiedby"); ?>:
    </td>
    <td>
      <?php
        echo "<a href='#' onClick='viewSingleEntry(\"".$entryserver."\", \"".$QueryEntry->getModifiersName()."\")'>";
        echo $QueryEntry->getModifiersName();
        echo "</a>\n";
      ?>
    </td>
    <td class="red">
<?php
  if($compareAvailable) {
    compareValues($QueryEntry->getModifiersName(), $QueryCompare->getModifiersName());
  }
?>
    </td>
  </tr>
  <tr>
    <td width="10">
      &nbsp;
    </td>
    <td>
      <?php echo getLang("page.query.modifiedtime"); ?>:
    </td>
    <td>
      <?php echo $QueryEntry->getModifyTimestamp(); ?>
    </td>
    <td>
<?php
  if($compareAvailable) {
    compareValues($QueryEntry->getModifyTimestamp(), $QueryCompare->getModifyTimestamp());
  }
?>
    </td>
  </tr>
  <tr>
    <td colspan="2">&nbsp;</td>
    <td>
      <input type="button" onclick="doQuery(document.forms['queryform'], 'basedn', '')" value="<?php echo getLang('page.query.querybutton'); ?>">
    </td>
    <td>&nbsp;</td>
  </tr>
  </table>
<?php } ?>
  </div>

  </form>
