<?php
  if(!file_exists("./objects/monitorobject.php")) { header("Location: ../index.php"); }
?>
<h3><?php echo getLang("page.environments.header"); ?></h3>
<?php
  $environments = getEnvironments();

  for($i = 0; $i < count($environments); $i++) {

    // get all servers
    $servers =  getServers($environments[$i][0]);
    $portRespond = 0;
    $ldapRespond = 0;

    for($j = 0; $j < count($servers); $j++) {
      $oServer = setServer($servers[$j][1]);
      // count port respond
      if($oServer->getRespondPort()) {
        $portRespond++;
      }
      if($oServer->getRespondLDAP()) {
        $ldapRespond++;
      }      
    }

    // check errors
    $statusIcon = "computer_ok.png";
    $mobileStatus = "mobileOk";
    if($ldapRespond != count($servers)) {
      $statusIcon = "alert_error.png";
      $mobileStatus = "mobileAlert";
    }
    
    // last thing, check load balancer
    $loadbalancer = getConfigValue("loadbalancer", $environments[$i][0], 0);
    if(!empty($loadbalancer)) {
      $oLoadBalancer = setServer($loadbalancer);
      if(!$oLoadBalancer->getRespondLDAP()) {
        $statusIcon = "alert_error.png";
      }
    }
    
?>
<table width="100%" class="<?php echo $mobileStatus; ?>">
<tr>
  <td width="36">
    <img width="32" src="icons/<?php echo $statusIcon; ?>">
  </td>
  <td>
    <a href="index.php?page=environment.php&environmentid=<?php echo $environments[$i][0]; ?>"><?php echo $environments[$i][1]; ?></a>
  </td>
  <td align="right" width="50" class="<?php echo ($ldapRespond == count($servers)) ? "green" : "red"; ?>">
    <?php echo $ldapRespond; ?> / <?php echo count($servers); ?>
    &nbsp;
  </td>
</tr>
</table>
<br>
<?php
  }
?>
