<?php
  if(!file_exists("./objects/monitorobject.php")) { header("Location: ../index.php"); }
  $CONFDIR="../config";
  require "./objects/monitorobject.php";
  require "./objects/rootdnobject.php";
  require "./objects/snmpobject.php";
  require "./objects/replicationagreementobject.php";
  require "./objects/replicainfoobject.php";
  $environmentId = getFormValue("environmentid");
  $environmentName = getEnvironmentName($environmentId);
  $servers =  getServers($environmentId);
?>
<h3>
  <?php echo $environmentName; ?>
</h3>
<?php
  // if we have a loadbalancer interface
  $loadbalancer = getConfigValue("loadbalancer", $environmentId, 0);
  if(!empty($loadbalancer)) {
    $oLoadBalancer = setServer($loadbalancer);
    $lbStatusIcon = "computer_ok.png";
    $mobileStatus = "mobileOk";
    if(!$oLoadBalancer->getRespondLDAP()) {
      $lbStatusIcon = "alert_error.png";
      $mobileStatus = "mobileAlert";
    }
?>

<table width="100%" class="<?php echo $mobileStatus; ?>">
<tr>
  <td width="36" rowspan="2">
    <img width="32" src="icons/<?php echo $lbStatusIcon; ?>">
  </td>
  <td>
    <b><?php echo $loadbalancer; ?></b>
  </td>
</tr>
<tr>
  <td>
    <span class="mobileInfo">
      <?php echo getLang("page.environment.about.loadbalancer"); ?>
    </span>
  </td>
</tr>
</table>
<br>
<?php
  }

  for($i = 0; $i < count($servers); $i++) {
    $mobileStatus = "mobileOk";
    $statusIcon = "computer_ok.png";
    $sServerName = $servers[$i][1];
    $nResponsePort = 0;
    $nResponseLDAP = 0;
    $sServerStartTime = "";
    $nExecutionTime = 0;
    $nCurrentConnections = 0;
    $nSearchOperations = 0;
    $replicaInfoType = "";
    
    // set server with verification of port, secureport and ldap availability
    $oServer = setServer($sServerName);

    if($oServer->getRespondPort()) {
      $nResponsePort = 1;

      // check ldap connection port 389
      if($oServer->getRespondLDAP()) {
        $nResponseLDAP = 1;
      }
      else {
        $statusIcon = "alert_error.png";
        $mobileStatus = "mobileAlert";
      }

      $monitor = setMonitor($sServerName, array("start_time", "cur_con"));
      $sServerStartTime = $monitor->getStartTime();
      $nCurrentConnections = $monitor->getCurrentConnections();

      $snmpObject = setSnmp($sServerName, array("search"));
      $nSearchOperations = $snmpObject->getSearchOps();

      $nExecutionTime = $oServer->getExecutionTime();
      
      $replicaInfo = setReplicaInfo($sServerName, $sServerName, true);
      $replicaInfoType = $replicaInfo->getReplicaType();
      // if master or hub, get replication agreements and check status
      if(in_array($replicaInfoType, array("master", "hub"))) {
        $replicationInfo = setReplicationAgreement($sServerName);
        $replicationStatus = true;
        if($replicationInfo->getAgreementsOk() != $replicationInfo->getNrOfAgreements()) {
          $replicationStatus = false;
          $statusIcon = "alert_warning.png";
          $mobileStatus = "mobileAlert";          
        } // if replication status not ok
        unset($replicationInfo);
      } // if master or hub
      unset($replicaInfo);
    }
    else {
      $statusIcon = "alert_error.png";
      $mobileStatus = "mobileAlert";
    }
?>
<table width="100%" class="<?php echo $mobileStatus; ?>">
<tr>
  <td width="36">
    <img width="32" src="icons/<?php echo $statusIcon; ?>">
  </td>
  <td colspan="2">
    <?php echo $sServerName; ?><br>
  </td>
</tr>
<tr>
  <td>
    &nbsp;
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo getLang('page.environments.answeringonport'); ?>:
    </span>
  </td>
  <td>
    <span class="mobileInfo">
      <span  class="<?php echo ($nResponsePort == 1) ? 'green' : 'red'; ?>">
        <b>
          <?php echo ($nResponsePort == 1) ? getLang('page.general.yes') : getLang('page.general.no'); ?>
        </b>
      </span>
    </span>
  </td>
</tr>
<tr>
  <td>
    &nbsp;
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo getLang('page.environments.answeringonldap'); ?>:
    </span>
  </td>
  <td>
    <span class="mobileInfo">
      <span  class="<?php echo ($nResponseLDAP == 1) ? 'green' : 'red'; ?>">
        <b>
          <?php echo ($nResponseLDAP == 1) ? getLang('page.general.yes') : getLang('page.general.no'); ?>
        </b>
      </span>
    </span>
  </td>
</tr>
<tr>
  <td>
    &nbsp;
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo getLang('page.general.serverstarted'); ?>:
    </span>
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo $sServerStartTime ? $sServerStartTime : "-"; ?>
    </span>
  </td>
</tr>
<tr>
  <td>
    &nbsp;
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo getLang('page.general.querytime'); ?>:
    </span>
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo $nExecutionTime ? $nExecutionTime : "-"; ?>
    </span>
  </td>
</tr>
<tr>
  <td>
    &nbsp;
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo getLang('page.general.currentconnections'); ?>:
    </span>
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo $nCurrentConnections ? $nCurrentConnections : "-"; ?>
    </span>
  </td>
</tr>
<tr>
  <td>
    &nbsp;
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo getLang('page.general.searchoperations'); ?>:
    </span>
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo $nSearchOperations ? $nSearchOperations : "-"; ?>
    </span>
  </td>
</tr>
<tr>
  <td>
    &nbsp;
  </td>
  <td>
    <span class="mobileInfo">
      <?php echo getLang('page.general.replicationstatus'); ?>:
    </span>
  </td>
  <td>
    <span class="mobileInfo">
<?php
  // if replication status available
  if(($replicaInfoType == "master") || ($replicaInfoType == "hub")) {
?>
      <span  class="<?php echo ($replicationStatus) ? 'green' : 'red'; ?>">
        <b>
          <?php echo $replicationStatus ? getLang('page.general.ok') : getLang('page.general.error'); ?>
        </b>
      </span>
<?php
  } // replication status available
  else {
      echo "<span class='gray'>-</span>";
  }
?>
    </span>
  </td>
</tr>
</table>
<br>
<?php
  }
?>
