<?php
  if(!file_exists("./objects/loadbalancerobject.php")) { header("Location: ../index.php"); }
  require "./objects/loadbalancerobject.php";
  require "./objects/rootdnobject.php";
  require "./objects/vendorinfoobject.php";
  require "./functions/image_functions.php";

  // if page is disabled
  if(!functionIsEnabled("loadbalancer")) {
    echo "Page is supposed to be disabled. Please report this as a bug if this is not the case.";
    exit(0);
  }  

  $environmentid = getFormValue("environmentid");

  // check if load balancer is configured  
  $loadbalancerAvailable = 0;
  $loadbalancer = getConfigValue("loadbalancer", $environmentid);
  if(empty($loadbalancer)) {
    $loadbalancerAvailable = 0;
  }
  else {
    $oServer = setServer($loadbalancer);
    if($oServer->isAvailable()) {
      $loadbalancerAvailable = 1;
    }  
  }

  // get ports
  $lb_port = getConfigValue("port", $environmentid);
  if(empty($lb_port)) {
    // this is to set default port
    $lb_port = getPort($loadbalancer);
  }
  $lb_secureport = getConfigValue("secureport", $environmentid);
  if(empty($lb_secureport)) {
    // this is to set default port
    $lb_secureport = getSecurePort($loadbalancer);
  }
  $lb_queryport = $lb_port;

  // you may want to set another vendor type for this lb
  $lb_vendor = getConfigValue("loadbalancervendor", $environmentid);
  if(empty($lb_vendor)) {
    if($loadbalancerAvailable) {
      $lb_vendor = $oServer->getVendor();
    }
  }

  $vendorFunctionName = vendorMapToFunction($CNMONITOR_VENDOR)."_getHostNameOfServer";
  $lb_type = getConfigValue("loadbalancertype", $environmentid);
  if(empty($lb_type)) {
    $lb_type = "host";
    if(!function_exists($vendorFunctionName)) {
      // if getHostNameOfServer function does not exist for this directory server
      // default will be dns verification
      $lb_type = "dns";
    }      
  }

  $lb_nrofqueries = getConfigValue("loadbalancerqueries", $environmentid);
  if(empty($lb_nrofqueries)) {
    $lb_nrofqueries = 10;
  }

?>

<script language="javascript">

  /*************************************************
  * Create Flot pie graph
  * divId = Div ID
  * data = plot data
  * graphType = line or pie
  *************************************************/
  function setFlotPieLineGraph(divId, data, graphType) {
    if(!data[0]) {
      return;
    }

    if(graphType == "line") {
      graphOptions = {
        series: {
          points: { 
            show: true,
            symbol: "diamond"
          }
        },
        xaxis: { 
          mode: 'time', 
          minTickSize: [1, "second"]
        },
        grid: { 
          hoverable: true,
          backgroundColor: { colors: ["#123", "#fff"] }
        },
        legend: { show: true }
      };
    }
    else {
      // show pie graph
      graphOptions = {
        series: {
          pie: { show: true }
        },
        grid: { hoverable: true }
      };
    }

    $.plot($("#" + divId), data, graphOptions);
    $("#" + divId).bind("plothover", setFlotPieLineGraphHover);  
  }

  function quickButtonLoadbalancer(nqueries) {
    var obj = document.forms["loadbalancer"]["lb_nrofqueries"];
    obj.value = nqueries;    
    runLoadbalancer();
  }

  function getFormVal(name) {
    var obj = document.forms["loadbalancer"][name];
    if(obj.length > 1) {
      for(var i = 0; i < obj.length; i++) {
        if(obj[i].checked) {
          return obj[i].value;
        }
      }      
    }
    return obj.value;
  }
  
  function runLoadbalancer() {  
    $("#cnmonitorSettingsDiv").hide();
    var lbqueries   = getFormVal("lb_nrofqueries");
    var lbtype      = getFormVal("lb_type");
    var lbqueryport = getFormVal("lb_queryport");

    disableButtons(["button_loadbalancer1", "button_loadbalancer2", "button_loadbalancer3", 
                    "button_loadbalancer4", "button_run"], true);
  
    $("#status_response").attr("src", preloadImageLoadingContent.src);
    $("#status_weight").attr("src", preloadImageLoadingContent.src);
    
    var url = "services/flot_loadbalancer.php?sid=" + usersessionid + "&lbqueries=" + lbqueries + 
              "&lbtype=" + lbtype + "&lbqueryport=" + lbqueryport + 
              "&environmentid=" + CNMONITOR_ENVIRONMENTID;

    $.getJSON(url, function(received) {
      if(received.message.length > 0) {
        $("#status_response").attr("src", preloadImageDownWarning.src);
        $("#status_weight").attr("src", preloadImageDownWarning.src);
        $("#loadbalancerGraph").html(received.message.replace("\n", "<br>"));
        $("#loadbalancerWeight").html(received.message.replace("\n", "<br>"));
      }
      else {
        setFlotPieLineGraph("loadbalancerGraph", received.querytime, "line");
        setFlotPieLineGraph("loadbalancerWeight", received.weight, "pie");
        $("#status_response").attr("src", preloadImageDownOk.src);
        $("#status_weight").attr("src", preloadImageDownOk.src);
      }
      disableButtons(["button_loadbalancer1", "button_loadbalancer2", "button_loadbalancer3", 
                      "button_loadbalancer4", "button_run"], false);
    }).error(function() { 
      getServiceError(url);
      $("#status_response").attr("src", preloadImageDownError.src);
      $("#status_weight").attr("src", preloadImageDownError.src);
    });
  }

  function initLoadbalancer() {
    $("#cnmonitorSettingsDiv").show();
    //adjust graph size
    var graphWidth = ($(document).width() - 500);
    if(graphWidth < 300) {
      graphWidth = 300;
    }
    $("#loadbalancerGraph").css("width", graphWidth);
  }

  function disableButtons(arrButton, disable) {
    for(var i = 0; i < arrButton.length; i++) {
      $("#" + arrButton[i]).attr("disabled", disable);
    }
  }
  
</script>

<!-- QUERY -->
<div id="loadbalancer_query">
    <table width="100%" border="0" cellpadding="3" cellspacing="3">
    <tr>
      <td align="right" colspan="2">
        <div style="float:left;">
          <table cellpadding="3" border="0">
          <tr>
            <td rowspan="2" width="45">
              <img src="icons/config.png" onClick="$('#cnmonitorSettingsDiv').toggle();" style="cursor:pointer;">
            </td>
            <td>
              <big><b><?php echo getLang('page.loadbalancer.verifyfor'); ?> <?php echo $loadbalancer; ?></b></big>
            </td>
          </tr>
          <tr>
            <td>
<?php
  // show buttons if loadbalancer is responding
  if($loadbalancerAvailable) {
?>
  
              <form>
              <input id="button_loadbalancer1" type="button" class="buttongreen" value="<?php printf(getLang("page.loadbalancer.runqueries"), 5); ?>" onClick="quickButtonLoadbalancer(5)">
              &nbsp;&nbsp;&nbsp;
              <input id="button_loadbalancer2" type="button" class="buttongreen" value="<?php printf(getLang("page.loadbalancer.runqueries"), 10); ?>" onClick="quickButtonLoadbalancer(10)">
              &nbsp;&nbsp;&nbsp;
              <input id="button_loadbalancer3" type="button" class="buttongreen" value="<?php printf(getLang("page.loadbalancer.runqueries"), 20); ?>" onClick="quickButtonLoadbalancer(20)">
              &nbsp;&nbsp;&nbsp;
              <input id="button_loadbalancer4" type="button" class="buttongreen" value="<?php printf(getLang("page.loadbalancer.runqueries"), 50); ?>" onClick="quickButtonLoadbalancer(50)">
              </form>
<?php
  }
?>
            </td>
          </tr>
          </table>
        </div>
        <div id="divFeatureButtons" style="float:right;padding-top:20px;">

        </div>
      </td>
    </tr>
    <tr>
      <td width="400">
        <table width="100%" cellpadding="6" cellspacing="0">
        <tr>
          <td class="tableheader" valign="top">
            <img id='status_weight' width='22' src='icons/alert_ok.png' style='vertical-align:middle;'>
            <?php echo getLang("page.general.weight"); ?>
          </td>
        </tr>
        <tr>
          <td><div id="loadbalancerWeight" style="width:400px;height:300px;"></div></td>
        </tr>
        </table>        
      </td>
      <td>
        <table width="100%" cellpadding="6" cellspacing="0">
        <tr>
          <td class="tableheader" valign="top">
            <img id='status_response' width='22' src='icons/alert_ok.png' style='vertical-align:middle;'>
            <?php echo getLang("page.general.result"); ?>
          </td>
        </tr>
        <tr>
          <td><div id="loadbalancerGraph" style="width:300px;height:300px;"></div></td>
        </tr>
        </table>        
      </td>
    </tr>
    </table>
</div>

<script language="javascript">
  $(function () {
    initLoadbalancer();
  });
</script>


<?php
  $noErrorExistStyle = "height:200px;";
  if(!$loadbalancerAvailable) {
    $noErrorExistStyle = "";
  }
?>
<div id="cnmonitorSettingsDiv" style="width:800px;<?php echo $noErrorExistStyle; ?>">
<?php
if(!$loadbalancerAvailable) {
  showErrorMessage(getLang('page.loadbalancer.verifyfor')." ".$loadbalancer,
                           "Load Balancer not configured or not available!\n" .
                           "Set load balancer by configuring <b>&lt;loadbalancer&gt;</b>cluster.domain.com<b>&lt;/loadbalancer&gt;</b> for this environment.");
}
else {
?>
<form method="get" onsubmit="return false;" name="loadbalancer">
<table border="0" cellpadding="5" cellspacing="5" width="100%">
<tr class="tableHeader">
  <td valign="top" class="ttPlugin" title="<?php echo getLang("tooltip.loadbalancer.vendor"); ?>">
    <?php echo getLang('page.general.vendorrecognized'); ?>
  </td>
  <td valign="top" class="ttPlugin" title="<?php echo getLang("tooltip.loadbalancer.queries"); ?>">
    <?php echo getLang('page.loadbalancer.numberofqueries'); ?>
  </td>
  <td valign="top" class="ttPlugin" title="<?php echo getLang("tooltip.loadbalancer.type"); ?>">
    <?php echo getLang('page.loadbalancer.balancertype'); ?>
  </td>
  <td valign="top" class="ttPlugin" title="<?php echo getLang("tooltip.loadbalancer.port"); ?>">
    <?php echo getLang('page.general.port'); ?>
  </td>
  <td align="center" onClick="$('#cnmonitorSettingsDiv').hide();" style="cursor:pointer;"><img width="22" src="icons/exit.png"></td>
</tr>
<tr>
  <td valign="top">
    <?php echo $lb_vendor; ?>
  </td>
  <td valign="top">
    <input type="text" size="4" maxlength="4" name="lb_nrofqueries" value="<?php echo $lb_nrofqueries; ?>">
  </td>
  <td valign="top">
    <input type="radio" name="lb_type" value="dns"<?php
      if("$lb_type" == "dns") { echo " checked"; } ?>>
      <?php echo getLang('page.general.dns'); ?><br>

    <input type="radio" name="lb_type" value="host"<?php
      if("$lb_type" == "host") { echo " checked"; } 
      if(!function_exists($vendorFunctionName)) {
        echo " disabled=disabled";
      }?>>
      <?php echo getLang('page.general.server'); ?><br>
  </td>
  <td valign="top">
    <input type="radio" name="lb_queryport" value="<?php echo $lb_port; ?>"<?php
      if("$lb_queryport" == "$lb_port") { echo " checked"; } ?>> <?php echo $lb_port; ?><br>

    <input type="radio" name="lb_queryport" value="<?php echo $lb_secureport; ?>"<?php
      if("$lb_queryport" == "$lb_secureport") { echo " checked"; } ?>> <?php echo $lb_secureport; ?><br>
  </td>
  <td valign="top">
    <input type="button" id="button_run" class="buttongreen" value="<?php echo getLang('page.general.run'); ?>" onClick="runLoadbalancer()">
  </td>
</tr>
</table>
</form>
<?php
  } // at least one server is responding
?>
</div>
