<?php
  if(!file_exists("./objects/indexesobject.php")) { header("Location: ../index.php"); }
  require "./objects/indexesobject.php";
  require "./objects/schemaobject.php";
  require "./functions/image_functions.php";

  // if page is disabled
  if(!functionIsEnabled("index") || !functionIsEnabled("configuration")) {
    echo "Page is supposed to be disabled. Please report this as a bug if this is not the case.";
    exit(0);
  }  

  $environmentid = getFormValue("environmentid");
  $serverid = getFormValue("serverid");
  $page = getFormValue("page");
  $backenddatabase = getFormValue("backenddatabase");
  $serverlist = getFormValue("serverlist");
  $queryindex = getFormValue("queryindex");
  $servername = "";
  if(!empty($serverid)) {
    $servername = getServerName($serverid, $environmentid);
  }

  /***
  * Don't think we need to translate the types
  * so we keep this translation here
  */
  function translateIndexType($indexType) {
    if($indexType == "pres") {
      return "Presence";
    }
    else if ($indexType == "sub") {
      return "Substring";
    }
    else if ($indexType == "subtree") {
      return "Subtree";
    }
    else if ($indexType == "eq") {
      return "Equality";
    }
    else if ($indexType == "approx") {
      return "Approximate";
    }
    else if ($indexType == "ord") {
      return "Ordering";
    }
  }

  // if serverlist missing
  // build one up based on serverid or environment list
  if(empty($serverlist)) {
    if(!empty($servername)) {
      $serverlist[0] = $servername;
    }
    else {
      $serversinenv = getServers($environmentid);
      for($i = 0; $i < count($serversinenv); $i++) {
        $serverlist[count($serverlist)] = $serversinenv[$i][1];
      }
    }
  }

  // if server is selected it must respond
  // otherwise go for first responding in environment
  if(!empty($serverid)) {
    $respondingServer = getFirstRespondingServerInEnvironment($environmentid, $serverid);
  }
  else {
    $respondingServer = getFirstRespondingServerInEnvironment($environmentid);
  }

  if(!empty($respondingServer)) {
    $backendDatabaseList = setBackEndDatabases($respondingServer);
  }
?>
<form method="post" action="index.php">
  <input type="hidden" name="page" value="<?php echo getFormValue('page'); ?>">
  <input type="hidden" name="serverid" value="<?php echo $serverid; ?>">
  <input type="hidden" name="settab" value="indexes_result">
  <input type="hidden" name="environmentid" value="<?php echo $environmentid; ?>">
<div id="indexes_query">
<?php
  if(empty($backendDatabaseList)) {
    echo "";
  }
  else {
?>
  <table border="0" cellpadding="5" cellspacing="5" width="600">
  <tr class="tableHeader">
    <td>
      <b><?php echo getLang("page.general.selectservers"); ?></b>
    </td>
    <td>
      <b><?php echo getLang('page.general.database'); ?></b>
    </td>
    <td width="70">
      <b><?php echo getLang('page.general.queryrun'); ?></b>
    </td>
  </tr>
  <tr>
    <td valign="top">
      <select name="serverlist[]" multiple size="10">
<?php
  $servers = getServers($environmentid);
  // as the same servers can be added to different environments
  // for each server
  for($i = 0; $i < count($servers); $i++) {
?>
        <option value="<?php echo $servers[$i][1]; ?>"<?php
          if(in_array($servers[$i][1], $serverlist)) {
            echo " selected";
          }
          ?>><?php echo $servers[$i][1]; ?></option>
<?php  
  } // list all servers
?>
        </select>  
    </td>
<?php
  for($i = 0; $i < count($backendDatabaseList); $i++) {
    // set default backend database, first found
    if(empty($backenddatabase)) {
      // we don't want to set o=netscaperoot (389 DS etc..)
      if(strcasecmp($backendDatabaseList[$i][1], "o=netscaperoot") != 0) {
        $backenddatabase = $backendDatabaseList[$i][0];
      }      
    }
  }
?>
    <td valign="top">
      <select name="backenddatabase">
<?php
  for($i = 0; $i < count($backendDatabaseList); $i++) {
?>
        <option value="<?php echo $backendDatabaseList[$i][0]; ?>"<?php
          if($backendDatabaseList[$i][0] == $backenddatabase) {
            echo " selected";
          }
        ?>><?php echo $backendDatabaseList[$i][1]; ?></option>
<?php
  }
?>
      </select>  
    </td>
    <td valign="top">
      <input type="submit" value="<?php echo getLang('page.general.queryrun'); ?>">
    </td>
  </tr>
  </table>
<?php
  }
?>
</div>

<div id="indexes_result">
<br>
<?php
if(empty($backenddatabase)) {
  // throw error
  showWarningMessage(getLang("page.indexes.result"), 
                   "Unable to get backend databases!");
}
else {
  $indexList = setIndexesList($respondingServer, $backenddatabase);
  $schemaObject = setSchema($respondingServer);

  // set default index if not selected
  if(empty($queryindex)) {
    if(!empty($indexList[0])) {
      $queryindex = $indexList[0];
    }
  }

?>
  <table border="0" cellpadding="6" cellspacing="0" width="1000">
  <tr class="tableHeader">
    <td>
      <b><?php echo getLang("page.indexes.index"); ?></b>
    </td>
    <td>
      <b><?php echo getLang("page.indexes.result"); ?></b>
    </td>
  </tr>
  <tr>
    <td valign="top" rowspan="2" width="200">
      <select name="queryindex" multiple size="23" onChange="showIndex(this.form, this.value)" style="width:200px;">
<?php
  for($i = 0; $i < count($indexList); $i++) {
?>
        <option value="<?php echo $indexList[$i]; ?>"<?php
          if($indexList[$i] == $queryindex) {
            echo " selected";
          }
        ?>><?php echo $indexList[$i]; ?></option>
<?php
  }
?>
      </select>
    </td>
    <td valign="top">
      <?php
        if(!empty($queryindex)) {
          $indexObject = setIndex($serverlist, $backenddatabase, $queryindex);
          $availableIndexes = $indexObject->getIndexType();
      ?>
      <table border="0" cellpadding="6" cellspacing="1" width="100%">
      <tr>
        <td width="200">
          <big><b><?php echo getLang('page.general.database'); ?></b></big>
        </td>
        <td colspan="<?php echo (count($availableIndexes) + 1); ?>">          
        <?php 
          for($i = 0; $i < count($backendDatabaseList); $i++) {
            if($backendDatabaseList[$i][0] == $backenddatabase) {
              echo "<big>".$backendDatabaseList[$i][1]."</big>";
            }
          }
        ?>
      </tr>
      <tr>
        <td width="200">
          <big><b><?php echo getLang('page.indexes.index'); ?></b></big>
        </td>
        <td colspan="<?php echo (count($availableIndexes) + 1); ?>">  
          <big><span class="green"><?php echo $queryindex; ?></span></big>
        </td>
      </tr>
      <tr>
        <td colspan="<?php echo (count($availableIndexes) + 2); ?>">
          &nbsp;
        </td>      
      </tr>
      <?php
        echo "<tr class='tableHeader'>";
        echo "<td width='200'>".getLang("page.general.selectservers")."</td>";
        for($i = 0; $i < count($availableIndexes); $i++) {
          echo "<th width='100'>".translateIndexType($availableIndexes[$i])."</th>";
        }
        echo "<th>&nbsp;</td>";
        echo "</tr>\n";

        $availableHosts = $indexObject->getHostNames();
        $styleClass = "evenRow";
        for($i = 0; $i < count($availableHosts); $i++) {
          $serverId = getEnvironmentId($availableHosts[$i]);
          if($styleClass == "evenRow") {
            $styleClass = "oddRow";
          }
          else {
            $styleClass = "evenRow";
          }
          $currentIndexes = $indexObject->getIndexTypeByHost($availableHosts[$i]);
          echo "<tr class='".$styleClass."'>";
          echo "<td width='200'>";
            echo "<a href='index.php?page=server.php&settab=server_availability&environmentid=".$serverId[0]."&serverid=".$serverId[1]."'>".$availableHosts[$i]."</a>";
          echo "</td>";
          for($j = 0; $j < count($availableIndexes); $j++) {
            echo "<td><center>";
            if(in_array($availableIndexes[$j], $currentIndexes)) {
              echo "<img src='icons/star.png'>";
            }
            echo "</center></td>";
          }
          echo "<td>";
          if(count($availableIndexes) != count($currentIndexes)) {
            echo "<img src='icons/alert_warning.png' height='24'>";
          }
          else {
            echo "<img src='icons/alert_ok.png' height='24'>";
          }
          echo "</td>";
          echo "</tr>\n";
        }
        
      ?>
      <tr>
        <td colspan="<?php echo (count($availableIndexes) + 2); ?>">
          &nbsp;
          <br>
          <hr width="100%">
          <br>
        </td>
      </tr>
      <?php 
        $schemaInfo = $schemaObject->getAttributeTypeFullString($queryindex, true);
      ?>
      <tr>
        <td valign="top"<?php
          if(empty($schemaInfo)) {
            echo " class='gray'";
          }
        ?>>
          <b><?php echo getLang("page.general.schema"); ?></b>
        </td>
        <td colspan="<?php echo (count($availableIndexes) + 1); ?>">
          <?php
            if(!empty($schemaInfo)) {
              echo $schemaInfo;
            }
            else {
              echo "-";
            }
          ?>
          &nbsp;
        </td>        
      </table>
      <?php
        }
      ?>
    </td>
  </tr>
  </table>
<?php
}
?>
</div>
<script language="javascript">

  function showIndex(oForm, indexValue) {
    oForm.submit();
  }

</script>
</form>


