<?php
  if(!file_exists("./functions/sql_functions.php")) { header("Location: ../index.php"); }
  require "./functions/sql_functions.php";
?>
<script language="javascript">

  /*************************************************
  * Handle received status for environments page
  * envid = Current Environment ID to process
  * received = received objects
  *************************************************/
  function cnmonitorEnvironmentsStatus(envid, received) {
    var replicationAgreements = 0;
    var respondPort = 0;
    var respondLDAP = 0;
    var totalServers = received.servers.length;
    var replicationAgreementsOk = 0;
    var errorExist = false;
      
    // start with check for load balancer
    if(received.loadbalancer) {
      if(received.loadbalancer.respondLDAP) {
        $("#lbIcon_" + envid).attr("src", preloadImageHostOk.src);        
      }
      else {
        errorExist = true;
        $("#lbIcon_" + envid).attr("src", preloadImageDownError.src);
      }
    }
      
    // check each server in environment
    if(received.servers) {
      // for each server
      for(i = 0; i < received.servers.length; i++) {          
        if(received.servers[i].respondPort) {
          respondPort++;
        }
        if(received.servers[i].respondLDAP) {
          $("#serverIcon_" + envid + "_" + i).attr("src", preloadImageHostOk.src);
          replicationAgreements   += received.servers[i].replicationAgreements;
          replicationAgreementsOk += received.servers[i].replicationAgreementsOk;
          respondLDAP++;
        }
        else {
          errorExist = true;
          $("#serverIcon_" + envid + "_" + i).attr("src", preloadImageDownError.src);
        }
      } // each server in environment      
    } // if received servers
    // set status flag
    if(errorExist) {
      $("#envIcon_" + envid).attr("src", preloadImageDownError.src);
    }
    else if(replicationAgreements != replicationAgreementsOk) {
      $("#envIcon_" + envid).attr("src", preloadImageDownWarning.src);
    }
    else {
      $("#envIcon_" + envid).attr("src", preloadImageHostOk.src);
    }
    // set port status
    $("#portStatus_" + envid).attr("class", (totalServers != respondPort) ? "red" : "green");
    $("#portStatus_" + envid).text(respondPort + " / " + totalServers);
    // set ldap status
    $("#ldapStatus_" + envid).attr("class", (totalServers != respondLDAP) ? "red" : "green");
    $("#ldapStatus_" + envid).text(respondLDAP + " / " + totalServers);
    
    if(replicationAgreements > 0) {
      // create if replication status id does not exist
      if($("#replicationStatus_" + envid).length == 0) {
        $("#envTable_" + envid).last().append(
          "<tr><td colspan='2'><?php echo getLang('page.general.replicationstatus'); ?></td>" +
          "<td width='40'><span id='replicationStatus_" + envid + "'>? / ?</span></td></tr>");
      } // add replication info
      if($("#replicationStatus_" + envid).length > 0) {
        $("#replicationStatus_" + envid).attr("class", (replicationAgreements != replicationAgreementsOk) ? "red" : "green");
        $("#replicationStatus_" + envid).text(replicationAgreementsOk + " / " + replicationAgreements);
      } // update status
    } // replication agreements exist
  }

</script>
<!-- List of configured environments -->
<div id="environments_availability">
<?php
  $environments = getEnvironments();

      for($i = 0; $i < count($environments); $i++) {
    
        // environment description and url
        $description = getConfigValue("description", $environments[$i][0], 0);
        $url = getConfigValue("url", $environments[$i][0], 0);
    
        // get all servers
        $servers     =  getServers($environments[$i][0]);
        // if load balancer exist
        $loadbalancer = getConfigValue("loadbalancer", $environments[$i][0], 0);
        // check if this is from session
        $isSession = getConfigValue("session", $environments[$i][0], 0);
        if($isSession) {
          $divHeaderStyle = "headerLightSession";
          $divMenuStyle = "serverMenuDivSession";
        }
        else {
          $divHeaderStyle = "headerLight";
          $divMenuStyle = "serverMenuDiv";
        }
?>
      <div class="environmentsBorder">
         <table width="100%" id="envTable_<?php echo $i; ?>" border="0" cellpadding="5" cellspacing="0">
         <tr class="<?php echo $divHeaderStyle; ?>">
           <td width="32">
             <img id="envIcon_<?php echo $i; ?>" src="icons/question.png" width="24">         
           </td>
           <td align="center">
             <a href="index.php?page=environment.php&environmentid=<?php echo $environments[$i][0]; ?>&settab=environment_availability">
               <?php 
                 echo $environments[$i][1];
                 // if load balancer config exists
                  if(!empty($loadbalancer)) {
                    echo "<br>\n";
                   echo "( ".$loadbalancer." )\n";
                  }
               ?>
               </a>
           </td>
           <td width="32" align="right">
             <a href="#" onClick="showHideServerMenu(<?php echo $i; ?>, ''); return false;", this><img width="20" id="moreinfo_image_<?php echo $i; ?>" src="icons/plus.png" width="32" alt="" /></a>
           </td>
         </tr>
         <tr>
           <td colspan="3" align="center">
             <a href="index.php?page=environment.php&environmentid=<?php echo $environments[$i][0]; ?>&settab=environment_availability">
             <img border="0" src="icons/environment.png">
             </a>
           </td>
         </tr>
<?php
  // description or url exists for this environment
  if(!empty($description) || !empty($url)) {
?>
         <tr>
           <td colspan="3">
           <?php
             if(!empty($description)) {
               echo nl2br(htmlspecialchars($description));
               echo "<br>\n";
             }
             if(!empty($url)) {
               echo "<a href='".$url."' target='_blank'>".$url."</a>";
             }
           ?>
         </td>
       </tr>
<?php
  }
?>
       <tr>
         <td colspan="2">
           <?php echo getLang('page.environments.answeringonport'); ?>:
         </td>
         <td width="40">
           <span id="portStatus_<?php echo $i; ?>" class="gray">
           ? / ?
           </span>
         </td>
       </tr>
       <tr>
         <td colspan="2">
           <?php echo getLang('page.environments.answeringonldap'); ?>:
         </td>
         <td width="40">
           <span id="ldapStatus_<?php echo $i; ?>" class="gray">
           ? / ?
           </span>
         </td>
       </tr>
       </table>
     </div>

        <!-- Menu div -->
        <div class="<?php echo $divMenuStyle; ?>" id="moreinfo_<?php echo $i; ?>">
          <table width="100%" border="0" cellpadding="3" cellspacing="3">
<?php
          if(!empty($loadbalancer)) {
?>
          <tr>
            <td width="16">
              <img id="lbIcon_<?php echo $i; ?>" width="16" src="icons/question.png">
            </td>
            <td colspan="2">
              <big><?php echo $loadbalancer; ?></big>
            </td>
          </tr>
<?php
          }

          for($j = 0; $j < count($servers); $j++) {
?>
          <tr>
            <td width="16">&nbsp;</td>
            <td width="16"><img id="serverIcon_<?php echo $i; ?>_<?php echo $j; ?>" width="16" src="icons/question.png"></td>
            <td>
              <a href="index.php?page=server.php&serverid=<?php echo ($j + 1); ?>&environmentid=<?php echo $i; ?>&settab=server_availability">
                <?php echo $servers[$j][1]; ?>
              </a>
            </td>
          </tr>
<?php
          }
?>
        </table>
      </div>
<?php
    } // environment
?>
<script language="javascript">
  $(function () {
    initReloadPage(null, null, "environments.php");
  });
</script>
</div>

<?php
  if(functionIsEnabled("addserver")) {
?>
<!-- Add a new environment and server -->
<div id="environments_add">
<script language="javascript">

  function environmentsAddServer(oForm) {
    var servername = oForm.addservername.value;
    var portnumber = oForm.addportnumber.value;
    reloadTimerActivated = false;

    if((servername == "") || (portnumber == "")) {
      return;
    }

    $("#alertAddServer").attr("src", preloadImageLoadingContent.src);
    $.post(getServiceURL(), { 
      "service": "addserver",
      "q": portnumber,
      "servername": servername },
      function(data){
        if(data.success) {
          var environmentid = data.environmentid;
          $("#alertAddServer").attr("src", preloadImageDownOk.src);

          // if environment does not exist, create it
          if(!data.exist) {
            $("#environments_availability").last().append(
              "<div class='environmentsBorder'><table width='100%' id='envTable_" + environmentid + "' border='0' cellpadding='5' cellspacing='0'>" +
              "<tr class='headerLightSession'>" +
              "<td width='32'>" +
              "  <img id='envIcon_" + environmentid + "' src='icons/question.png' width='24'>" +
              "</td>" +
             "<td align='center'>" +
             "  <a href='index.php?page=environment.php&environmentid=" + environmentid + "&settab=environment_availability'>" + data.name + "</a>" +
             "</td>" +
             "<td width='32' align='right'>" +
             "  <a href='#' onClick='showHideServerMenu(" + environmentid + ", \"\"); return false;', this><img width='20' id='moreinfo_image_" + environmentid + "' src='icons/plus.png' width='32' alt='' /></a>" +
             "</td>" +
             "</tr><tr>" +
             "<td colspan='3' align='center'>" +
             "  <a href='index.php?page=environment.php&environmentid=" + environmentid + "&settab=environment_availability'>" +
             "  <img border='0' src='icons/environment.png'>" +
             "  </a>" +
             "</td>" +
             "</tr><tr>" +
             "<td colspan='2'><?php echo getLang('page.environments.answeringonport'); ?>:</td>" +
             "<td width='40'><span id='portStatus_" + environmentid + "' class='gray'>? / ?</span></td>" +
             "</tr><tr>" +
             "<td colspan='2'><?php echo getLang('page.environments.answeringonldap'); ?>:</td>" +
             "<td width='40'><span id='ldapStatus_" + environmentid + "' class='gray'>? / ?</span></td>" +
             "</tr></table></div>");
           }
           
           var serverMenu = "<table width='100%' border='0' cellpadding='3' cellspacing='3'><tbody>";
           for(var i = 0; i < data.servers.length; i++) {
             serverMenu = serverMenu + "<tr>";
             serverMenu = serverMenu + "  <td width='16'>&nbsp;</td>";
             serverMenu = serverMenu + "  <td width='16'><img id='serverIcon_" + environmentid + "_" + i + "' width='16' src='icons/question.png'></td>";
             serverMenu = serverMenu + "  <td><a href='index.php?page=server.php&serverid=" + data.servers[i][0] + "&environmentid=" + environmentid + "&settab=server_availability'>";
             serverMenu = serverMenu + data.servers[i][1];
             serverMenu = serverMenu + "</a></td>";
             serverMenu = serverMenu + "</tr>";
           }
           serverMenu = serverMenu + "</tbody></table>";

           if(!data.exist) {
             // build the server menu
             $("<div class='serverMenuDivSession' id='moreinfo_" + environmentid +  "'>" + 
               serverMenu +
               "</div>").appendTo("body");
           }
           else {
             // replace menu information
             $("#moreinfo_" + environmentid).html(serverMenu);
           }
          showTab("environments_availability");
          initReloadPage(environmentid, null, "environments.php");
        }
        else {
          $("#alertAddServer").attr("src", preloadImageDownError.src);
        }
    }, "json");
  }

</script>

  <form method="post" action="index.php">
    <br>
    <table cellpadding="6" cellspacing="0" border="0" width="600">
    <tr>
      <td colspan="4">
        <h3><?php echo getLang("page.environments.addserver"); ?></h3>
        <?php echo getLang("page.environments.infotemp"); ?>.<br>
        <?php echo getLang("page.environments.infoperm"); ?>.<br>
      </td>
    </tr>
    <tr>
      <td colspan="4">
        &nbsp;
      </td>
    </tr>
    <tr class="tableHeader">
      <td>
        <?php echo getLang("page.general.environmentname"); ?>
      </td>
      <td>
        <?php echo getLang("page.general.server"); ?>
      </td>
      <td width="100">
        <?php echo getLang('page.general.port'); ?>
      </td>
      <td align="right">
        <img src="icons/alert_ok.png" width="24" id="alertAddServer">
      </td>
    </tr>
    <tr>
      <td>
        <?php echo getLang("page.environments.sessionenv"); ?>
      </td>
      <td>
        <input type="text" size="25" name="addservername">
      </td>
      <td>
        <input type="text" size="10" name="addportnumber" value="389">
      </td>
      <td align="right">
        <input type="button" onClick="environmentsAddServer(this.form)" value="<?php echo getLang("page.general.add"); ?>">
      </td>
    </tr>
    </table>
  </form>
</div>
<?php
  }
?>
<!-- Messages -->
<div id="environments_messages">
    <table width="100%" cellpadding="6" cellspacing="4">
    <tr>
      <td colspan="5">
        <big><?php echo getLang('page.general.messages'); ?></big>
      </td>
    </tr>
  <?php
    if(dbConfigured()) {

      $sql = "SELECT col_srvmsg_host, col_srvmsg_date, col_srvmsg_key, col_srvmsg_value FROM servermessage ";
      $sql .= " ORDER BY col_srvmsg_date DESC LIMIT 15";
      $dbh = dbConnect();
      $result = dbQuery($sql, $dbh);
  ?>
      <tr class="tableHeader">
        <td valign='top' width='16'></td>
        <td valign='top'><?php echo getLang("page.general.server"); ?></td>
        <td valign='top'><?php echo getLang("page.general.messagestime"); ?></td>
        <td valign='top'><?php echo getLang("page.general.messagestype"); ?></td>
        <td valign='top'><?php echo getLang("page.general.messagesvalue"); ?></td>
      </tr>
  <?php
      $class = "oddRow";
      while($row = dbGetRow($result)) {
        if($class == "evenRow") {
          $class = "oddRow";
        }
        else {
          $class = "evenRow";
        }
        $typetext = getLang("page.general.unknown");
        $configId = getEnvironmentId($row[0]);

        $alertImage = "alert_ok";
        if($row[2] == "port_unavailable") {
          $alertImage = "alert_error";
        }
        else if($row[2] == "ldap_unavailable") {
          $alertImage = "alert_error";
        }
        else if($row[2] == "collectservermessage") {
          $alertImage = "alert_error";
        }
        else if($row[2] == "collectdb") {
          $alertImage = "alert_error";
        }
        else if($row[2] == "collectsummary") {
          $alertImage = "alert_error";
        }
        else if($row[2] == "collectmailreport") {
          $alertImage = "alert_warning";
        }
        
        echo "<tr class='".$class."'>\n";
        echo "<td><img width='16' src='icons/".$alertImage.".png'></td>";
        echo "<td valign='top'>";
          if(!empty($configId)) {
            echo "<a href='index.php?page=server.php&serverid=".$configId[1];
            echo "&environmentid=".$configId[0]."&settab=server_availability'>";
          }
          echo $row[0];
          if(!empty($configId)) {
            echo "</a>";
          }
        echo "</td>\n";
        echo "<td valign='top'>".$row[1]."</td>\n";
          $typetext = getTextByServerMessageKey($row[2]);
        echo "<td valign='top'>".$typetext."</td>\n";
        echo "<td valign='top'>".$row[3]."</td>\n";
        echo "</tr>\n";
      }
      dbClose($dbh);
    }
    else {
  ?>
    <tr>
      <td colspan="5">
<?php 
        showWarningMessage(getLang("page.general.notconfigured"), "Database not available.");
?>
      </td>
    </tr>
  <?php
    }
  ?>
    </table>
</div>
