<?php
  if(!file_exists("./functions/sql_functions.php")) { header("Location: ../index.php"); }
  $CONFDIR="../config";
  require "./functions/sql_functions.php";
  require "./functions/image_functions.php";

//  $environmentId = getFormValue("environmentid");
  $environment = getEnvironmentName($CNMONITOR_ENVIRONMENTID);
  $servers =  getServers($CNMONITOR_ENVIRONMENTID);
?>
<script language="javascript">

  var preloadImageTopRight = new Image(24,24); 
  preloadImageTopRight.src = "icons/topright.png"; 

  var preloadImageDownRight = new Image(24,24); 
  preloadImageDownRight.src = "icons/downright.png"; 

  var preloadImageMiddleRight = new Image(24,24); 
  preloadImageMiddleRight.src = "icons/right_yellow.png";
  
  // check if initial page content is loaded
  // variable used to avoid reloading of monitoring summary
  var cnmonitorInitLoaded = false;
  
  /*************************************************
  * Create Flot pie graph
  * divId = Div ID
  * data = plot data
  *************************************************/
  function setFlotPieLineGraph(divId, data) {
    var graphOptions = null;
    if(!data[0]) {
      return;
    }
    // if we should show a line graph
    if(data[0]["data"].length > 1) {
      graphOptions = {
          series: {
            lines: { show: true },
            points: { show: true }
          },
          xaxis: { 
            mode: 'time', 
            minTickSize: [2, "minute"]
          },
          grid: { hoverable: true },
          legend: { show: false }
       };
     }
     else {
      // show pie graph
      graphOptions = {
        series: {
          pie: { show: true }
        },
        grid: { hoverable: true }
      };
    }

    $.plot($("#" + divId), data, graphOptions);
    $("#" + divId).bind("plothover", setFlotPieLineGraphHover);
  }

  /*************************************************
  * Flot Pie Graph Hover Function
  *************************************************/  
  function setFlotGraphHover(event, pos, obj) {
    if (!obj) {
      $("#cnmonitorTooltip").remove();
      cnmonitorPreviousPoint = null;
      return;
    }
    x = parseInt(obj.datapoint[0].toFixed(2)),
    value = obj.datapoint[1].toFixed(2);
    if(cnmonitorPreviousPoint != value) {
      cnmonitorPreviousPoint = value;
      $("#cnmonitorTooltip").remove();
      // Compare with previous month, we can only do this for the same year
      prevValue = 0;
      if((x > 0) && (obj.series.data[(obj.dataIndex - 1)])) {
        prevValue = obj.series.data[(obj.dataIndex - 1)][1];
        showTooltip(pos.pageX, pos.pageY, "", value, prevValue);
      }
      else {
        showTooltip(pos.pageX, pos.pageY, value, value, 0);
      }
    }   
  }

  /*************************************************
  * set Environment Pie Graph
  * creates pie graph header and calls setFlotPieGraph
  * divId = Key for graph, also used to fetch data
  * pieHeader = Header text for this graph
  *************************************************/  
  function setEnvironmentPieLineGraph(divId, pieHeader) {
    if(!collectedMonitoringData[divId][0]) {
      return;
    }

    var spaceHeight = 8;
    if(isIE()) {
      spaceHeight = 16;
    }
    if(collectedMonitoringData[divId].length > 3) {
      spaceHeight = (collectedMonitoringData[divId].length * spaceHeight);
    }
    else {
      spaceHeight = 10;
    }

    // create header & graph if not exist
    if($("#" + divId).length == 0) {
      $("#pieTable").last().append(
        "<tr class='tableHeader'><td>" + pieHeader + "</td></tr>" +
        "<tr><td><div id='" + divId + "' class='flot_default_class'></div></td></tr>" +
        "<tr style='height:" + spaceHeight + "px;'><td>&nbsp;</td></tr>");
    }
    setFlotPieLineGraph(divId, collectedMonitoringData[divId]);
  }
  
  /*************************************************
  * Handle received status for environments page
  * envid = Current Environment ID to process
  * received = received objects
  *************************************************/
  function cnmonitorEnvironmentStatus(envid, received) {
    var errorExist = false;
    var displayGraphCurrConn = true;
    var displayGraphExecTime = true;
      
    // start with check for load balancer
    if(received.loadbalancer) {
      if(!received.loadbalancer.respondLDAP) {
        errorExist = true;
      }
    }
    // check each server in environment
    if(received.servers) {
      // for each server
      for(i = 0; i < received.servers.length; i++) {  

        if(received.servers[i].respondLDAP) {
          // replica type
          if(received.servers[i].replicaType == "hub") {        
            $("#serverIcon_" + i).attr("src", preloadImageServerHub.src);
          }
          else if(received.servers[i].replicaType == "master") {        
            $("#serverIcon_" + i).attr("src", preloadImageServerMaster.src);
          }
          else {
            $("#serverIcon_" + i).attr("src", preloadImageServer.src);        
          }
          $("#serverPortLDAP_" + i).attr("class", "green");          
        }
        else {
          errorExist = true;
          $("#serverIcon_" + i).attr("src", preloadImageDownError.src);
          $("#serverPortLDAP_" + i).attr("class", "red");
        }
        if(received.servers[i].respondSecurePort) {
          $("#serverPortSecureLDAP_" + i).attr("class", "green");
        }
        else {
          $("#serverPortSecureLDAP_" + i).attr("class", "red");
        }
        if(received.monitor[i].starttime) {
          $("#serverStartTime_" + i).attr("class", "black");
          $("#serverStartTime_" + i).text(received.monitor[i].starttime);
          // set uptime
          $("#serverUptimeDay_" + i).attr("class", "black");
          $("#serverUptimeDay_" + i).text(received.monitor[i].uptimeday);
          $("#serverUptimeHour_" + i).attr("class", "black");
          $("#serverUptimeHour_" + i).text(received.monitor[i].uptimehour);
          $("#serverUptimeMinute_" + i).attr("class", "black");
          $("#serverUptimeMinute_" + i).text(received.monitor[i].uptimeminute);
        }
        if(parseFloat(received.servers[i].exectime) > 0) {
          $("#serverExecTime_" + i).attr("class", "black");
          $("#serverExecTime_" + i).text(received.servers[i].exectime);
          setCollectedMonitoringData("graphExecTime", i, received.servers[i].hostname, received.servers[i].exectime);
        }
        else {
          displayGraphExecTime = false;
        }
        if(received.servers[i].vendorName) {
          $("#serverVendor_" + i).attr("class", "black");
          $("#serverVendor_" + i).text(received.servers[i].vendorName);
        }
        if(parseFloat(received.monitor[i].currentConnections) > 0) {
          $("#serverCurrCon_" + i).attr("class", "black");
          $("#serverCurrCon_" + i).text(received.monitor[i].currentConnections);
          setCollectedMonitoringData("graphCurrConn", i, received.servers[i].hostname, parseInt(received.monitor[i].currentConnections));
        }
        else {
          displayGraphCurrConn = false;
        }

        if(received.servers[i].replicationAgreements) {
          if(received.servers[i].replicationAgreements > 0) {
            var errorText = "";
            if(received.servers[i].replicationAgreements != received.servers[i].replicationAgreementsOk) {
              errorText = '<?php echo getLang("page.general.error"); ?>: ';
              $("#serverReplication_" + i).attr("class", "red");
              $("#serverIcon_" + i).attr("src", preloadImageDownWarning.src);
              showHideRow(i, '');
            }
            else {
              $("#serverReplication_" + i).attr("class", "black");
            }
            $("#serverReplication_" + i).text(errorText + received.servers[i].replicationAgreementsOk + " / " + received.servers[i].replicationAgreements);
          } // if replication agreements more than 0
        } // if replication agreements property exist        
      } // each server in environment      

      // create pie graph if all servers are available
      if(collectedMonitoringData["graphExecTime"]) {
        if(displayGraphExecTime) {
          setEnvironmentPieLineGraph("graphExecTime", "<?php echo getLang('page.general.querytime'); ?>");
        } // if create pie
      }
      if(collectedMonitoringData["graphCurrConn"]) {
        if(displayGraphCurrConn) {
          setEnvironmentPieLineGraph("graphCurrConn", "<?php echo getLang('page.general.currentconnections'); ?>");
        } // if create pie
      }
    } // if received servers
    // set status flag
    if(errorExist) {
      $("#envIcon_" + envid).attr("src", preloadImageDownError.src);
    }
    else {
      $("#envIcon_" + envid).attr("src", preloadImageHostOk.src);
    }
    // now get and set historical events
    if(!cnmonitorInitLoaded) {
      cnmonitorHistoricalEvents(cnmonitorDefaultMonitoring(CNMONITOR_VENDOR));
      cnmonitorInitLoaded = true;
    }
  }

  function cnmonitorHistoricalEvents(selectedOperation) {
    $("#summaryStatus").attr("src", preloadImageLoadingContent.src);
    $('#historySummaryTable').empty();
    
    var graphWidth = ($(document).width() - 260);

    for(var i = 0; i < selectedOperation.length; i++) {
      var url = "services/flot_history_data.php?sid=" + usersessionid + "&environmentid=" + CNMONITOR_ENVIRONMENTID + "&operation=" + selectedOperation[i];
      $.getJSON(url, function(received) {
      
        if(received.error) {
          $("#summaryStatus").attr("src", preloadImageDownWarning.src);
          $("#historySummaryTable").last().append(
            "<tr class='tableHeader'><td>" + received.operation_text + "</td></tr>" +
            "<tr><td>" + received.error + "</td></tr>" + 
            "<tr><td>&nbsp;</td></tr>");
          return;
        }
      
        $("#historySummaryTable").last().append(
          "<tr class='tableHeader'><td>" + received.operation_text + "</td></tr>" +
          "<tr><td><div id='operation_" + received.operation + "' style='width:" + graphWidth + ";height:300;'></div></td></tr>" +
          "<tr><td>&nbsp;</td></tr>");

        collectedMonitoringData["environment_statistics"][collectedMonitoringData["environment_statistics"].length] = 
        $.plot($("#operation_" + received.operation), received[0], {
          series: {
            lines: { show: true },
            points: { show: true }
          },
          xaxis: {
            ticks: received[1]
          },
          grid: {
            hoverable: true,
            backgroundColor: { colors: ["#fff", "#eee"] }
          }
        });
        $("#operation_" + received.operation).bind("plothover", setFlotGraphHover);
      }).error(function() { 
        $("#summaryStatus").attr("src", preloadImageDownError.src);
        getServiceError(url);
      });
    } // for
    $("#summaryStatus").attr("src", preloadImageDownOk.src);
    
    // Set selected values
    selectElementsInList("selectedoperations", selectedOperation);
  }
  
</script>

<!-- Environment Availability -->
<div id="environment_availability">
<table width="100%" border="0" cellpadding="3" cellspacing="3">
<tr>
  <td valign="top">
    <table width="100%" border="0" cellpadding="6" cellspacing="0">
<?php
  $loadbalancer = getConfigValue("loadbalancer", $CNMONITOR_ENVIRONMENTID);
?>
    <!-- Load Balancer-->
    <tr>
       <td width="30">
         <img id="envIcon_<?php echo $CNMONITOR_ENVIRONMENTID; ?>" src="icons/question.png" width="30">
       </td>
       <td colspan="7">
         <big>
<?php 
           echo "<b>".$environment."</b>";
           if(!empty($loadbalancer)) {
             echo " <span class='gray'>( ".$loadbalancer." )</span>"; 
           }
?>
         </big>
       </td>
    </tr>
    <!-- List Servers -->
    <tr class="tableHeader">
       <td width="30">&nbsp;</td>
       <td>
         <?php echo getLang('page.general.server'); ?>
       </td>
       <td>
         <?php echo getLang('page.general.port'); ?>
       </td>
       <td>
         <?php echo getLang('page.server.about.secureport'); ?>
       </td>
       <td>
         <?php echo getLang('page.general.serverstarted'); ?>
       </td>
       <td>
         <?php echo getLang('page.general.querytime'); ?>
       </td>
       <td>
         <?php echo getLang('page.general.vendor'); ?>
       </td>
       <td>
         &nbsp;
       </td>
    </tr>
<?php
  $class = "evenRow";
  for($i = 0; $i < count($servers); $i++) {
    if($class == "oddRow") {
      $class = "evenRow";
    }
    else {
      $class = "oddRow";
    }

    $description = getConfigValue("description", $CNMONITOR_ENVIRONMENTID, $servers[$i][0]);
    $url = getConfigValue("url", $CNMONITOR_ENVIRONMENTID, $servers[$i][0]);
    $rowSpan = 1;
    if(!empty($description) || !empty($url)) {
      $rowSpan = 2;
    }
?>
     <tr class="<?php echo $class; ?>">
     <td width="30" valign="top" rowspan="<?php echo $rowSpan; ?>">
       <img id="serverIcon_<?php echo $i; ?>" src="icons/question.png" width="32" alt="">
     </td>
     <td>
       <big>
     <?php
       echo "<a href='index.php?page=server.php&serverid=".$servers[$i][0]."&environmentid=".$CNMONITOR_ENVIRONMENTID."&settab=server_availability'>";
       echo $servers[$i][1];
       echo "</a>";
     ?>
       </big>
     </td>
     <td>
       <span id="serverPortLDAP_<?php echo $i; ?>" class="gray"><?php echo getPort($servers[$i][1]); ?></span>
     </td>
     <td>
       <span id="serverPortSecureLDAP_<?php echo $i; ?>" class="gray"><?php echo getSecurePort($servers[$i][1]); ?></span>
     </td>
     <td>
       <span id="serverStartTime_<?php echo $i; ?>" class="gray">-</span>
     </td>
     <td>
       <span id="serverExecTime_<?php echo $i; ?>" class="gray">-</span>
     </td>
     <td>
       <span id="serverVendor_<?php echo $i; ?>" class="gray">-</span>
     </td>
     <td align="right" valign="top" rowspan="<?php echo $rowSpan; ?>">
       <a href="#" onClick="showHideRow(<?php echo $i; ?>, '')", this><img id="moreinfo_image_<?php echo $i; ?>" src="icons/plus.png" width="32" alt="" /></a>
     </td>
    </tr>
<?php
  if(!empty($description) || !empty($url)) {
?>
    <tr class="<?php echo $class; ?>">
      <td colspan="6" valign="top">
        <?php 
          if(!empty($description)) {
            echo nl2br($description)."\n<br>"; 
          }
          if(!empty($url)) {
            echo "<a href='".$url."' target='_blank'>".$url."</a>\n"; 
          }
        ?>
      </td>
    </tr>
<?php
  }
?>
    <tr>
    <tr class="<?php echo $class; ?>" id="moreinfo_<?php echo $i; ?>" style="visibility:hidden;display:none;">
      <td colspan="8">
       <table width="100%" border="0" cellpadding="2" cellspacing="1" class="moreinfo">
       <tr>
         <td valign="top">
           <b><?php echo getLang("page.general.replicationstatus"); ?></b>
         </td>
         <td valign="top" width="150">
           <b><?php echo getLang('page.general.currentconnections'); ?></b>
         </td>
         <td valign="top" width="250">
           <b><?php echo getLang("page.general.uptime"); ?></b>
         </td>
       </tr>
       <tr>
         <td valign="top">
           <span id="serverReplication_<?php echo $i; ?>" class="gray">-</span>
         </td>
         <td valign="top" width="150">
           <span id="serverCurrCon_<?php echo $i; ?>" class="gray">-</span>
         </td>
         <td valign="top" width="250">
           <span id="serverUptimeDay_<?php echo $i; ?>" class="gray">-</span> <?php echo getLang("page.general.uptime.days"); ?>&nbsp;&nbsp;&nbsp;
           <span id="serverUptimeHour_<?php echo $i; ?>" class="gray">-</span> <?php echo getLang("page.general.uptime.hours"); ?>&nbsp;&nbsp;&nbsp;
           <span id="serverUptimeMinute_<?php echo $i; ?>" class="gray">-</span> <?php echo getLang("page.general.uptime.minutes"); ?>
         </td>
       </tr>
       </table>
     </td>
    </tr>
<?php
  } // for
?>
    </table>
  </td>
  <td width="325" valign="top">
    <table id="pieTable" cellpadding="6" cellspacing="0" width="100%">
    <tr>
      <td height="42">&nbsp;</td>
    </tr>
    </table>
  </td>
</tr> 
</table>

<script language="javascript">
  $(function () {
    collectedMonitoringData["environment_availability"] = new Array();
    collectedMonitoringData["environment_statistics"] = new Array();
    initReloadPage(CNMONITOR_ENVIRONMENTID, null, "environment.php");
  });
</script>

</div>

<!-- STATISTICS -->
<div id="environment_statistics">
<table width="100%" border="0" cellpadding="3" cellspacing="3">
<tr>
  <td colspan="2">
    <table width="100%" cellpadding="3" cellspacing="3">
    <tr>
      <td width="30"><img src="icons/alert_ok.png" id="summaryStatus" width="30"></td>
      <td><big><b><?php echo getLang("page.general.trendsdifference"); ?></b></big></td>
    </tr>
    </table>
  </td>
</tr>
<tr>
  <td valign="top">
    <table id="historySummaryTable" width="100%" border="0" cellpadding="6" cellspacing="0">

    </table>
  </td>
  <td width="200" valign="top">
    <table width="100%" border="0" cellpadding="6" cellspacing="0">
    <tr class="tableHeader">
      <td>
        <?php echo getLang('page.general.operations'); ?>
      </td>
    </tr>
    <tr>
      <td>
        <select name="selectedoperations[]" id="selectedoperations" multiple size="15" style="width:180px;">
<?php
        // Set available operations based on detected vendor type
        $operations = setPerformanceCounterList($CNMONITOR_VENDOR, "mbyte_sent");
        for($i = 0; $i < count($operations); $i++) {
?>
          <option value="<?php echo $operations[$i]; ?>">
            <?php echo getTextByOperation($operations[$i]); ?>
          </option>
<?php
        } // available operations
?>
        </select>
        <br><br>
        <input type="button" class="buttongreen" value="<?php echo getLang('page.general.update'); ?>" onClick="cnmonitorHistoricalEvents(getSelectedElementsInList('selectedoperations'))">
      </td>
    </tr>
    </table>
  </td>
</tr>
</table>
<br>
<br>
<br>
<br>
 </div>

 <!-- ABOUT ENVIRONMENT -->
<div id="environment_about">
  <h2><?php echo getLang("page.environment.about"); ?></h2>

  <table width="900" cellpadding="3" cellspacing="3" border="0">
  <tr>
    <td valign="top" width="300">
      <b><?php echo getLang("page.environment.about.loadbalancer"); ?>:</b>
    </td>
    <td valign="top">
      <?php
        $loadbalancer = getConfigValue("loadbalancer", $CNMONITOR_ENVIRONMENTID);
        if(!empty($loadbalancer)) {
          echo "<a href='index.php?environmentid=".$CNMONITOR_ENVIRONMENTID."&page=loadbalancerenv.php&settab=loadbalancer_query'>".$loadbalancer."</a>";
        }
        else {
          echo "<span class='gray'>-</span>";
        }
      ?>
    </td>
  </tr>
<?php
if(!empty($loadbalancer)) {
  $envip = getServerIP($loadbalancer);
?>
  <tr>
    <td valign="top" width="300">
      <b><?php echo getLang("page.general.hostip"); ?></b>
    </td>
    <td valign="top">
      <?php
        echo $envip;
      ?>
    </td>
  </tr>
<?php
  }
?>
  <tr>
    <td valign="top" width="300">
      <b><?php echo getLang('page.general.messages'); ?>:</b>
    </td>
    <td valign="top">
<?php
      if(dbConfigured()) {

        // sql format all servers in environment
        $sqlServerList = "";
        for($i = 0; $i < count($servers); $i++) {
          if($i > 0) {
            $sqlServerList .= ",";
          }
          $sqlServerList .= "'";
          $sqlServerList .= $servers[$i][1];
          $sqlServerList .= "'";
        }

        $sql = "SELECT col_srvmsg_host, col_srvmsg_date, col_srvmsg_key, col_srvmsg_value FROM servermessage WHERE ";
        $sql .= " col_srvmsg_host IN (".$sqlServerList.") ORDER BY col_srvmsg_date DESC LIMIT 25";
        $dbh = dbConnect();
        $result = dbQuery($sql, $dbh);
?>
        <table width="100%" cellpadding="3" cellspacing="3">
        <tr class="tableHeader">
          <td valign='top'><?php echo getLang("page.general.server"); ?></td>
          <td valign='top'><?php echo getLang("page.general.messagestime"); ?></td>
          <td valign='top'><?php echo getLang("page.general.messagestype"); ?></td>
          <td valign='top'><?php echo getLang("page.general.messagesvalue"); ?></td>
        </tr>
<?php
        while($row = dbGetRow($result)) {
          $typetext = getLang("page.general.unknown");
          echo "<tr>\n";
          echo "<td valign='top'>".$row[0]."</td>\n";
          echo "<td valign='top'>".$row[1]."</td>\n";
            $typetext = getTextByServerMessageKey($row[2]);
          echo "<td valign='top'>".$typetext."</td>\n";
          echo "<td valign='top'>".$row[3]."</td>\n";
          echo "</tr>\n";
        }
        dbClose($dbh);
?>
      </table>
<?php
      }
      else {
        showWarningMessage(getLang("page.general.notconfigured"), "Database not available.");
      }
?>
    </td>
  </tr>
  </table>

</div>
<script language="javascript">
  function cnmonitorTabSwitch(tabId) {
    // repaint graph when switching to monitor history
    if(collectedMonitoringData) {
      if(collectedMonitoringData[tabId]) {
        for(var i = 0; i < collectedMonitoringData[tabId].length; i++) {
          graphRef = collectedMonitoringData[tabId][i];
          graphRef.resize();
          graphRef.setupGrid();
          graphRef.draw();
        }
      }
    }
  }  
</script>