<?php
  if(!file_exists("./objects/certobject.php")) { header("Location: ../index.php"); }
  require "./objects/certobject.php";
  require "./functions/image_functions.php";

  // if page is disabled
  if(!functionIsEnabled("certificate") || !functionIsEnabled("configuration")) {
    echo "Page is supposed to be disabled. Please report this as a bug if this is not the case.";
    exit(0);
  }  

  $environmentid = getFormValue("environmentid");
  $serverid = getFormValue("serverid");
  $page = getFormValue("page");

  $serverlist = getFormValue("serverlist");
  $queryCertificateKey = getFormValue("querycertificatekey");
  $queryReloadSchema = getFormValue("reloadschema");

  $servername = "";
  if(!empty($serverid)) {
    $servername = getServerName($serverid, $environmentid);
  }
  
  if(empty($queryReloadSchema)) {
    $queryReloadSchema = true;
  }

  // if serverlist missing
  // build one up based on serverid or environment list
  if(empty($serverlist)) {
    if(!empty($servername)) {
      $serverlist[0] = $servername;
    }
    else {
      $serversinenv = getServers($environmentid);
      for($i = 0; $i < count($serversinenv); $i++) {
        $serverlist[count($serverlist)] = $serversinenv[$i][1];
      }
    }
  }

  // if server is selected it must respond
  // otherwise go for first responding in environment
  if(!empty($serverid)) {
    $respondingServer = getFirstRespondingServerInEnvironment($environmentid, $serverid);
  }
  else {
    $respondingServer = getFirstRespondingServerInEnvironment($environmentid);
  }

  $exitCodeCertificate = -1;
  if(!empty($respondingServer)) {
    $oCertificate = setCertificate($respondingServer, $queryReloadSchema);
    $exitCodeCertificate = $oCertificate->getExitCode();
  }
  
  if(empty($queryCertificateKey)) {
    $queryCertificateKey = "subject";
  }

  function certificateValues($valueArray) {
    if(is_array($valueArray)) {
      for($i = 0; $i < count($valueArray); $i++) {
        if(is_array($valueArray[$i])) {
          certificateValues($valueArray[$i]);       
        }
        else {
          echo nl2br(htmlspecialchars($valueArray[$i]))."<br>";
        }
      }
    }
    else {
      echo nl2br(htmlspecialchars($valueArray))."<br>";
    }
  }

?>
<form method="post" action="index.php">
  <input type="hidden" name="page" value="<?php echo getFormValue('page'); ?>">
  <input type="hidden" name="serverid" value="<?php echo $serverid; ?>">
  <input type="hidden" name="settab" value="certificate_result">
  <input type="hidden" name="reloadschema" value="true">
  <input type="hidden" name="environmentid" value="<?php echo $environmentid; ?>">
<div id="certificate_query">
  <table border="0" cellpadding="5" cellspacing="5" width="400">
  <tr class="tableHeader">
    <td>
      <b><?php echo getLang("page.general.selectservers"); ?></b>
    </td>
    <td width="70">
      <b><?php echo getLang('page.general.queryrun'); ?></b>
    </td>
  </tr>
  <tr>
    <td valign="top">
      <select name="serverlist[]" multiple size="10">
<?php
  $servers = getServers($environmentid);
  // as the same servers can be added to different environments
  // for each server
  for($i = 0; $i < count($servers); $i++) {
?>
        <option value="<?php echo $servers[$i][1]; ?>"<?php
          if(in_array($servers[$i][1], $serverlist)) {
            echo " selected";
          }
          ?>><?php echo $servers[$i][1]; ?></option>
<?php  
  } // list all servers
?>
        </select>  
    </td>
    <td valign="top">
      <input type="submit" value="<?php echo getLang('page.general.queryrun'); ?>">
    </td>
  </tr>
  </table>
</div>

<div id="certificate_result">
<br>
<?php
  if($exitCodeCertificate != 0) {
    // throw error
    showWarningMessage(getLang("page.certificate.result"), 
                     "Unable to retrieve certificate information!");
  }
  else {
    $certificate = $oCertificate->getCertificate();
?>
  <!-- Display Certificate Info -->
  <table border="0" cellpadding="5" cellspacing="5" width="100%">
  <tr>
    <td class='tableHeader'>
      <b><?php echo getLang("page.certificate.key"); ?></b>
    </td>
    <td valign="top" rowspan="2">
<?php
  if(!empty($queryCertificateKey) && !empty($certificate[$queryCertificateKey])) {
    $certificatePortion = $certificate[$queryCertificateKey];

    // certificate portion can be either string or array of strings
    if(is_array($certificatePortion)) {
      $certificateKeys = array_keys($certificatePortion);
      $certificateKeysIsArray = true;      
    }
    else {
      $certificateKeys[0] = $queryCertificateKey;
      $certificateKeysIsArray = false;
    }

    // query all selected servers
    $oSelectedCertificate = Array();
    for($i = 0; $i < count($serverlist); $i++) {
      $oSelectedCertificate[$i] = setCertificate($serverlist[$i], $queryReloadSchema);
      $oSelectedCertificateValues[$i] = $oSelectedCertificate[$i]->getCertificate();
    }

    echo "<h2>";
      echo $queryCertificateKey;
    echo "</h2>\n";
    echo "<hr width='100%'>\n";
    echo "<table border='0' cellpadding='3' cellspacing='3' width='100%'>\n";

    $startColumn = 0;
    $maxColumn = 0;
    $maxKeysInColumn = 3;
    $roundsColumn = round((count($certificateKeys) / $maxKeysInColumn), 0, PHP_ROUND_HALF_UP);
    if($roundsColumn == 0) {
      $roundsColumn = 1;
    }
    for($k = 0; $k < $roundsColumn; $k++) {

      $maxColumn = (($k + 1) * $maxKeysInColumn);
      if($maxColumn > count($certificateKeys)) {
        $maxColumn = count($certificateKeys);
      }
      if($k > 0) {
        $startColumn = $k * $maxKeysInColumn;
      }

      // table header
      echo "<tr>\n";
        echo "<td>\n";
          echo "&nbsp;\n";
        echo "</td>\n";
        for($i = $startColumn; $i < $maxColumn; $i++) {
          echo "<td class='tableHeader'>\n";
            echo $certificateKeys[$i];
          echo "</td>\n";
        } // for
      echo "</tr>\n";

      // go through each server
      $style = "evenRow";
      for($i = 0; $i < count($serverlist); $i++) {
        if($style == "evenRow") {
          $style = "oddRow";
        }
        else {
          $style = "evenRow";
        }
        $currentCertificateValue = $oSelectedCertificateValues[$i];
        $serverId = getEnvironmentId($serverlist[$i]);
    
        echo "<tr class='".$style."'>\n";
          echo "<td width='200' valign='top'>";
            echo "<a href='index.php?page=server.php&settab=server_availability&environmentid=".$serverId[0]."&serverid=".$serverId[1]."'>".$serverlist[$i]."</a>";
          echo "</td>\n";
          if($certificateKeysIsArray) {
            for($j = $startColumn; $j < $maxColumn; $j++) {
              $currentKey = $certificateKeys[$j];
              echo "<td valign='top'><small>\n";
              if(!empty($currentCertificateValue[$queryCertificateKey][$currentKey])) {
                certificateValues($currentCertificateValue[$queryCertificateKey][$currentKey]);
              }
              echo "</small></td>\n";
            } // for
          }
          else {
            // only one key is present
            if(!empty($currentCertificateValue[$queryCertificateKey])) {
              echo "<td valign='top'><small>\n";
                echo nl2br(htmlspecialchars($currentCertificateValue[$queryCertificateKey]));
              echo "</small></td>\n";
            }
          }
        echo "</tr>\n";
      } // for each key
    } // for every 5th element
    echo "</table>\n";
  } // certkey is available
?>
    </td>
  </tr>
  <tr>
    <td valign="top" rowspan="2" width="200">
      <select name="querycertificatekey" multiple size="15" onChange="showCertificatePortion(this.form, this.value)" style="width:200px;">
        <?php
          $certificateKeys = array_keys($certificate);
          for($i = 0; $i < count($certificateKeys); $i++) {
            echo "<option value='".htmlspecialchars($certificateKeys[$i])."'";
            if(!empty($queryCertificateKey)) {
              if($certificateKeys[$i] == $queryCertificateKey) {
                echo " selected";
              }
            }
            echo ">".htmlspecialchars($certificateKeys[$i])."</option>\n";
          }
        ?>
      </select>
    </td>
  </tr>
  </table>
<?php
  }
?>
</div>
<script language="javascript">
  function showCertificatePortion(oForm, certKey) {
    oForm.reloadschema.value = "false";
    oForm.submit();
  }
</script>
</form>


