<?php
  if(!file_exists("./objects/cacheobject.php")) { header("Location: ../index.php"); }
  $environmentid = getFormValue("environmentid");
  $serverid = getFormValue("serverid");
  $page = getFormValue("page");
  $serverlist = array();

  // if page is disabled
  if(!functionIsEnabled("cache") || !functionIsEnabled("configuration")) {
    echo "Page is supposed to be disabled. Please report this as a bug if this is not the case.";
    exit(0);
  }  

  if(!empty($serverid)) {
    $servername = getServerName($serverid, $environmentid);
  }

  // all available back ends
  $backends = Array();

  // if serverlist missing
  // build one up based on serverid or environment list
  if(empty($serverlist)) {
    if(!empty($servername)) {
      $serverlist[0] = $servername;
    }
    else {
      $serversinenv = getServers($environmentid);
      for($i = 0; $i < count($serversinenv); $i++) {
        $serverlist[count($serverlist)] = $serversinenv[$i][1];
      }
    }
  }
?>
<script language="javascript">

  function addTDHeaderValue(sName, bIsSet, headerCSS) {
    row = "<td class='" + headerCSS + "'>";
    if(bIsSet) {
      row = row + sName;
    }
    else {
      row = row + "&nbsp;";
    }
    row = row + "</td>";
    return row;
  }

  function addTDValue(currentValue, bPercent, bReversed) {
    var str = "";
    if(bPercent) {
      if(bReversed) {
        if(currentValue > 90) {
          str = str + "<td class='headerGreen'>";
        }
        else if(currentValue > 50) {
          str = str + "<td class='headerWarning'>";
        }
        else {
          str = str + "<td class='headerError'>";
        }
      }
      else {
        if(currentValue > 90) {
          str = str + "<td class='headerError'>";
        }
        else if(currentValue > 70) {
          str = str + "<td class='headerWarning'>";
        }
        else {
          str = str + "<td class='headerGreen'>";
        }
      }
    }
    else {
      str = str + "<td>";
    }
    if(currentValue == "-1") {
      str = str + "<i>Unlimeted</i>";
    }
    else {
      str = str + currentValue;
    }
    if(bPercent) {
      str = str + " %";
    }
    str = str + "</td>";
    return str;
  }

  function showWarningMessage(sMessage, sInfo) {
    // show warning message
    cacheResult = "<tr><td><div class='warningMessage'><img src='icons/alert_warning.png' width='16'>";
    cacheResult = cacheResult + sMessage + "<br>";
    cacheResult = cacheResult + "<br>";
    cacheResult = cacheResult + sInfo + "</td></tr>";
    $("#cacheresult").last().append(cacheResult);
    $("#status").attr("src", preloadImageDownWarning.src);  
  }

  function initializeCache() {
    $("#cnmonitorSettingsDiv").hide();
    $("#status").attr("src", preloadImageLoadingContent.src);
    
    var url = "services/serverservice.php?sid=" + usersessionid + "&service=cachequery";
        url = url + "&environmentid=" + CNMONITOR_ENVIRONMENTID + "&q=" + getSelectedElementsInList("serverlist").join(";");
    if(CNMONITOR_LOGLEVEL > 9) { alert(url); }
    $.getJSON(url, function(received) {
      hitratioset = cachehitsset = currentcacheset = maxcacheset = freeentrycache =
                    entriesincacheset = maxentriescacheset = freedbcache = false;
      $('#cacheresult').empty();

      if(received.warning) {
        showWarningMessage("<?php echo getLang("page.cache.queryservers"); ?>", received.warning);
        return;
      }

      if(received.backenddb) {
        for(var i = 0; i < received.backenddb.length; i++) {
          currentbackend = received.backenddb[i];
          if(received.servers) {
            // for each server
            serverRowClass = "evenRow";
            serverResult = "";
            for(var j = 0; j < received.servers.length; j++) {
              if(serverRowClass == "evenRow") {
                serverRowClass = "oddRow";
              }
              else {
                serverRowClass = "evenRow";
              }
              serverResult = serverResult + "<tr class='" + serverRowClass + "'>";
              serverResult = serverResult + addTDValue(received.servers[j].hostname, false, false);

              // ENTRY CACHE
              if(received.servers[j]["maxentriescacheset"][currentbackend]) {
                serverResult = serverResult + addTDValue(received.servers[j]["maxentriescache"][currentbackend], false, false);
                maxentriescacheset = true;
              }
              else { serverResult = serverResult + "<td>&nbsp;</td>"; }

              if(received.servers[j]["entriesincacheset"][currentbackend]) {
                serverResult = serverResult + addTDValue(received.servers[j]["entriesincache"][currentbackend], false, false);
                entriesincacheset = true;
              }
              else { serverResult = serverResult + "<td>&nbsp;</td>"; }

              if(maxentriescacheset && entriesincacheset) {
                if(received.servers[j]["maxentriescache"][currentbackend] == -1) {
                  serverResult = serverResult + addTDValue(100, true, true);
                }
                else {
                  percent = (((received.servers[j]["maxentriescache"][currentbackend] - received.servers[j]["entriesincache"][currentbackend]) /
                              received.servers[j]["maxentriescache"][currentbackend]) * 100);
                  serverResult = serverResult + addTDValue(percent, true, true);
                }
                freeentrycache = true;
              }
              else { serverResult = serverResult + "<td>&nbsp;</td>"; }

              // DATABASE CACHE
              if(received.servers[j]["maxcacheset"][currentbackend]) {
                serverResult = serverResult + addTDValue(received.servers[j]["maxcache"][currentbackend] + " Mb", false, false);
                maxcacheset = true;
              }
              else { serverResult = serverResult + "<td>&nbsp;</td>"; }

              if(received.servers[j]["currentcacheset"][currentbackend]) {
                serverResult = serverResult + addTDValue(received.servers[j]["currentcache"][currentbackend] + " Mb", false, false);
                currentcacheset = true;
              }
              else { serverResult = serverResult + "<td>&nbsp;</td>"; }

              if(currentcacheset && maxcacheset) {
                if(received.servers[j]["maxcache"][currentbackend] == -1) {
                  serverResult = serverResult + addTDValue(100, true, true);
                }
                else {
                  percent = (((received.servers[j]["maxcache"][currentbackend] - received.servers[j]["currentcache"][currentbackend]) /
                              received.servers[j]["maxcache"][currentbackend]) * 100);
                  serverResult = serverResult + addTDValue(percent, true, true);
                }
                freedbcache = true;
              }
              else { serverResult = serverResult + "<td>&nbsp;</td>"; }

              // HITS
              if(received.servers[j]["cachehitsset"][currentbackend]) {
                serverResult = serverResult + addTDValue(received.servers[j]["cachehits"][currentbackend], false, false);
                cachehitsset = true;
              }
              else { serverResult = serverResult + "<td>&nbsp;</td>"; }

              // RATIO
              if(received.servers[j]["hitratioset"][currentbackend]) {
                serverResult = serverResult + addTDValue(received.servers[j]["hitratio"][currentbackend], true, true);
                hitratioset = true;
              }
              else { serverResult = serverResult + "<td>&nbsp;</td>"; }

            } // for each server
            serverResult = serverResult + "</tr>";
          } // servers
          cacheResult = "<tr><td colspan='8'><h3>" + currentbackend + "</h3></td></tr>";
          cacheResult = cacheResult + "<tr class='tableHeader'>" +
                                          "<td><?php echo getLang('page.general.server'); ?></td>";
          cacheResult = cacheResult + addTDHeaderValue("<?php echo getLang('page.cache.maxentriescache'); ?>", maxentriescacheset, "tableHeaderLight");
          cacheResult = cacheResult + addTDHeaderValue("<?php echo getLang('page.cache.entriesincache'); ?>", entriesincacheset, "tableHeaderLight");
          cacheResult = cacheResult + addTDHeaderValue("<?php echo getLang('page.cache.freeentrycache'); ?>", freeentrycache, "tableHeaderLight");
          cacheResult = cacheResult + addTDHeaderValue("<?php echo getLang('page.cache.max'); ?>", maxcacheset, "tableHeader");
          cacheResult = cacheResult + addTDHeaderValue("<?php echo getLang('page.cache.current'); ?>", currentcacheset, "tableHeader");
          cacheResult = cacheResult + addTDHeaderValue("<?php echo getLang('page.cache.free'); ?>", freedbcache, "tableHeader");
          cacheResult = cacheResult + addTDHeaderValue("<?php echo getLang('page.cache.hits'); ?>", cachehitsset, "tableHeaderLight");
          cacheResult = cacheResult + addTDHeaderValue("<?php echo getLang('page.cache.hitratio'); ?>", hitratioset, "tableHeaderLight");
          cacheResult = cacheResult + "</tr>";
          cacheResult = cacheResult + serverResult;
          cacheResult = cacheResult + "<tr><td colspan='8'>&nbsp;</td></tr>";
          $("#cacheresult").last().append(cacheResult);
          
        } // for each backend
      } // received backend
      $("#status").attr("src", preloadImageDownOk.src);
    });
  }

  $(function () {
    initializeCache();
  });

</script>

<div id="cache_result">

  <table width="100%" border="0" cellpadding="5" cellspacing="1">
  <tr>
    <td width="32"><img src="icons/config.png" width="24" onClick="$('#cnmonitorSettingsDiv').toggle();" style="cursor:pointer;"></td>
    <td><b><big><?php echo getLang('page.cache.detailedinfo'); ?></big></b></td>
    <td align="right">
      <img id="status" src="icons/alert_ok.png" width="24">
      &nbsp;&nbsp;&nbsp;
      <img id="status" src="icons/refresh.png" width="24" onClick="initializeCache()" style="cursor:pointer;">
    </td>
  </tr>
  <tr>
    <td colspan="3">
      <table id="cacheresult" width="100%" border="0" cellpadding="5" cellspacing="1">
      </table>
    </td>
  </tr>
  </table>
</div>
<div id="cnmonitorSettingsDiv" style="width:300px;">
<form method="get" onsubmit="return false;" name="cachequery">
<table border="0" cellpadding="5" cellspacing="5" width="100%">
<tr class="tableHeader">
  <td valign="top" class="ttPlugin" title="<?php echo getLang("tooltip.servergraph.servers"); ?>">
    <?php echo getLang('page.cache.queryservers'); ?>
  </td>
  <td align="center" onClick="$('#cnmonitorSettingsDiv').hide();" style="cursor:pointer;"><img width="22" src="icons/exit.png"></td>
</tr>
<tr>
  <td valign="top">
    <select id="serverlist" name="serverlist[]" multiple size="10">
<?php
    $servers = getServers($environmentid);
    // as the same servers can be added to different environments
    // for each server
    for($i = 0; $i < count($servers); $i++) {
?>
        <option value="<?php echo $servers[$i][1]; ?>"<?php
          if(in_array($servers[$i][1], $serverlist)) {
            echo " selected";
          }
          ?>><?php echo $servers[$i][1]; ?></option>
<?php
    } // list all servers
?>
        </select>  
  </td>
  <td valign="top">
    <input type="button" id="button_run" class="buttongreen" value="<?php echo getLang('page.general.run'); ?>" onClick="initializeCache()">
  </td>
</tr>
</table>
</form>
</div>