<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package vendorinfo
* @author Andreas Andersson
* @version 1.1
*
*  080812 - Andreas Andersson
*           Created
*/  
class VendorInfo {
  
  var $hostname;
  var $vendorversion;
  var $vendor;
  var $version;
  var $vendorkey;
  var $message;

  function VendorInfo($hostname) {
    $this->hostname = $hostname;    
  }

  // Hostname
  function setHostName($hostname) {
    $this->hostname = $hostname;    
  }
    
  function getHostName() {
    return $this->hostname;
  }

  // Full Vendor Version
  function setVendorVersion($vendorversion) {
    $this->vendorversion = $vendorversion;    
 
    if(strstr($vendorversion, "/")) {
      $avendor = explode("/", $vendorversion);
      $this->vendor = trim($avendor[0]);
      $this->version = trim($avendor[1]);
    }
    
    if(strstr($vendorversion, "(")) {
      $avendor = explode("(", $vendorversion);
      $this->vendor = trim($avendor[0]);
      $this->version = str_replace(")", "", trim($avendor[1]));
    }
  }
  
  function setVendor($vendor) {
    $this->vendor = $vendor;
  }

  function setVersion($version) {
    $this->version = $version;
  }
  
  function getVendorVersion() {
    if(!empty($this->vendorversion)) {
      return $this->vendorversion;  
    }
    else {
      return $this->version;
    }
  }

  function getVendor() {
    return $this->vendor;
  }

  function getVendorKey() {
    return $this->vendorkey;
  }

  function getVersion() {
    return $this->version;
  }

  // Hostname
  function setMessage($message) {
    $this->message = $message;    
  }
    
  function getMessage() {
    return $this->message;
  }

}

?>
