<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package cn=monitor
* @author Andreas Andersson
* @version 1.0
*
* 080811 - Andreas Andersson
*          Created
*/  

  class User {

    var $name = "Anonymous";
    var $dn = "";
    var $photo;
    var $uid = "n/a";
    var $isauthenticated = 0;
    var $roles = array();
    var $groups = array();
    var $accesslist = array();
    var $accesswildcardlist = array();
    var $accessglobal = false;

    // Constructor
    function User() {
      return;
    }

    // Get Control boolean. User is authenticated
    function isAuthenticated() {
      return $this->isauthenticated;
    }

    // Set Full Name (CN)
    function setName($_name) {
      $this->name = $_name;
    }

    // Get Full Name (CN)
    function getName() {
      return $this->name;
    }

    // Set LDAP Location (DN)
    function setDN($_dn) {
      $this->dn = $_dn;
      // we can also set that the user is authenticated at this point
      $this->isauthenticated = 1;
    }

    // Get LDAP Location (DN)
    function getDN() {
      return $this->dn;
    }

    // Set Small JPEG Photo (binary)
    function setPhoto($_photo) {
      $this->photo = $_photo;
    }

    // Get Small JPEG Photo (binary)
    function getPhoto() {
      return $this->photo;
    }
    
    // Set UID
    function setUID($_uid) {
      $this->uid = $_uid;
    }

    // Get UID
    function getUID() {
      return $this->uid;
    }

    // Set All Roles
    function setRoles($_roles) {

      $aRoles = array();

      for($i = 0; $i < count($_roles); $i++) {
        if(!empty($_roles[$i])) {
          $aRoles[count($aRoles)] = $_roles[$i];
        }
      }

      $this->roles = $aRoles;
    }

    // check if user has specific role
    function hasRole($_role) {
      return in_array($_role, $this->roles);
    }


    // return all roles
    function getRoles() {
      return $this->roles;
    }

    // Set All Groups
    function setGroups($_groups) {

      $aGroups = array();

      for($i = 0; $i < count($_groups); $i++) {
        if(!empty($_groups[$i])) {
          $aGroups[count($aGroups)] = $_groups[$i];
        }
      }

      $this->groups = $aGroups;
    }

    // Set Global Access
    function addGlobalAccess() {
      $this->accessglobal = true;
    }

    // Get Global Access
    function getGlobalAccess() {
      return $this->accessglobal;
    }

    // Set List of servers
    function addAccessList($_list) {
      $this->accesslist[count($this->accesslist)] = $_list;
    }

    // Get List of servers
    function getAccessList() {
      return $this->accesslist;
    }
 
    // Set Wildcard list of servers
    function addAccessWildcardList($_list) {
      $this->accesswildcardlist[count($this->accesswildcardlist)] = $_list;
    }

    // Get Wildcard List of servers
    function getAccessWildcardList() {
      return $this->accesswildcardlist;
    }
    
    // check if user has specific group
    function hasGroup($_group) {
      return in_array($_group, $this->groups);
    }


    // return all groups
    function getGroups() {
      return $this->groups;
    }

  }

?>
