<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package cn=monitor
* @author Andreas Andersson
* @version 1.2
*
*  100612 - Andreas Andersson
*           Added unauthenticated bind
*  090512 - Andreas Andersson
*           Created
*/  
class Snmp {
  
    var $hostname = "";
    var $currenttime = "";
    var $anonymousbinds = 0;
    var $unauthbinds = 0;
    var $simpleauthbinds = 0;
    var $strongauthbinds = 0;
    var $wholesubtreesearchops = 0;
    var $bindsecurityerrors = 0;
    // compare operations
    var $compareops = 0;
    // all errors
    var $errors = 0;

    // nr of operations forwarded to this server
    var $inops = 0;

    // nr of entry adds
    var $addentryops = 0;
    // nr of entry modifications
    var $modifyentryops = 0;
    // nr of dn modifications
    var $modifyrdnops = 0;
    // nr of removal operations
    var $removeentryops = 0;    
    // nr of search operations
    var $searchops = 0;
    // nr of security errors
    var $securityerrors = 0;
    // server starttime (actually not available from snmp)
    var $starttime = "";
    // messages
    var $message = "";

    function setHostName($sHostName) {
      $this->hostname = $sHostName;    
     }
    
    function getHostName() {
      return $this->hostname;
    }

    function setAnonymousBinds($sAnonymousBinds) {
      $this->anonymousbinds = $sAnonymousBinds;    
     }
    
    function getAnonymousBinds($nOffset = 0) {
      return returnValueOnOffset($this->anonymousbinds, $nOffset);
    }

    function setUnAuthenticatedBinds($sUnAuthenticatedBinds) {
      $this->unauthbinds = $sUnAuthenticatedBinds;    
     }
    
    function getUnAuthenticatedBinds($nOffset = 0) {
      return returnValueOnOffset($this->unauthbinds, $nOffset);
    }

    function setSimpleAuthBinds($sSimpleAuthBinds) {
      $this->simpleauthbinds = $sSimpleAuthBinds;    
     }
    
    function getSimpleAuthBinds($nOffset = 0) {
      return returnValueOnOffset($this->simpleauthbinds, $nOffset);
    }

    function setStrongAuthBinds($sStrongAuthBinds) {
      $this->strongauthbinds = $sStrongAuthBinds;    
     }
    
    function getStrongAuthBinds($nOffset = 0) {
      return returnValueOnOffset($this->strongauthbinds, $nOffset);
    }

    function setWholeSubtreeSearchOps($sWholeSubtreeSearchOps) {
      $this->wholesubtreesearchops = $sWholeSubtreeSearchOps;    
     }
    
    function getWholeSubtreeSearchOps($nOffset = 0) {
      return returnValueOnOffset($this->wholesubtreesearchops, $nOffset);
    }

    function setBindSecurityErrors($sBindSecurityErrors) {
      $this->bindsecurityerrors = $sBindSecurityErrors;    
     }
    
    function getBindSecurityErrors() {
      return $this->bindsecurityerrors;
    }

    function setCompareOps($sCompareOps) {
      $this->compareops = $sCompareOps;    
     }
    
    function getCompareOps() {
      return $this->compareops;
    }

    function setErrors($sErrors) {
      $this->errors = $sErrors;    
     }
    
    function getErrors($nOffset = 0) {
      return returnValueOnOffset($this->errors, $nOffset);
    }

    function setInOps($sInOps) {
      $this->inops = $sInOps;    
     }
    
    function getInOps() {
      return $this->inops;
    }

    function setAddEntryOps($sAddEntryOps) {
      $this->addentryops = $sAddEntryOps;
     }
    
    function getAddEntryOps($nOffset = 0) {
      return returnValueOnOffset($this->addentryops, $nOffset);
    }

    function setModifyEntryOps($sModifyEntryOps) {
      $this->modifyentryops = $sModifyEntryOps;
     }
    
    function getModifyEntryOps($nOffset = 0) {
      return returnValueOnOffset($this->modifyentryops, $nOffset);
    }

    function setModifyRdnOps($sModifyRdnOps) {
      $this->modifyrdnops = $sModifyRdnOps;
     }
    
    function getModifyRdnOps($nOffset = 0) {
      return returnValueOnOffset($this->modifyrdnops, $nOffset);
    }

    function setRemoveEntryOps($sRemoveEntryOps) {
      $this->removeentryops = $sRemoveEntryOps;
     }
    
    function getRemoveEntryOps($nOffset = 0) {
      return returnValueOnOffset($this->removeentryops, $nOffset);
    }

    function setSearchOps($sSearchOps) {
      $this->searchops = $sSearchOps;
     }
    
    function getSearchOps($nOffset = 0) {
      return returnValueOnOffset($this->searchops, $nOffset);
    }

    function setSecurityErrors($sSecurityErrors) {
      $this->securityerrors = $sSecurityErrors;
     }
    
    function getSecurityErrors() {
      return $this->securityerrors;
    }

    function setStartTime($sStartTime) {
      $this->starttime = $sStartTime;
    }

    function getStartTime() {
      return $this->starttime;
     }

    function setCurrentTimeFormated($sDate) {
      $this->currenttime = $sDate;
     }
    
    function getCurrentTime() {
      return $this->currenttime;
    }

    function setMessage($sMessage) {
      $this->message = $sMessage;
    }


    function getMessage() {
      return $this->message;
    }
  }

?>
