<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package schema
* @author Andreas Andersson
* @version 1.0
*
*  090424 - Andreas Andersson
*           Created
*  090425 - Andreas Andersson
*           Message method added
*/  
class Schema {
  
  var $hostname;
  var $message;
  var $attributetype = Array();
  var $objectclass = Array();
  var $matchingrule = Array();
  var $exitcode = 0;

  // Hostname
  function setHostName($hostname) {
    $this->hostname = $hostname;    
  }
    
  function getHostName() {
    return $this->hostname;
  }

  // Attribute Types
  function setAttributeType($attributetype) {
     $this->attributetype = $this->addToArray($attributetype);
  }
    
  function getAttributeType($searchstring = "") {
    if(empty($searchstring)) {
      return $this->attributetype;
    }
    $prioritizedArray = array();
    $returnArray = array();
    for($i = 0; $i < count($this->attributetype); $i++) {
      $currentValue = $this->attributetype[$i];
      if(stristr($currentValue, $searchstring) !== FALSE) {
//        echo $currentValue."<br>";
        $findname = preg_replace("/.*. NAME/", "", $currentValue);
        $findname = preg_replace("/DESC.*/", "", $findname);
        $findname = preg_replace("/EQUALITY.*/", "", $findname);
        $findname = preg_replace("/SUBSTR.*/", "", $findname);
        $findname = preg_replace("/SYNTAX.*/", "", $findname);
        // remove characters ' ( ) and trim
        $findname = trim(str_replace(array("(", ")", "'"), "", $findname));
//        echo "VALUE: ".$findname."<br><br>";
        // we can now have left <value> <value> so split this in to an array and add to list
        $afindname = explode(" ", $findname);
        for($j = 0; $j < count($afindname); $j++) {
          $afindname[$j] = trim($afindname[$j]);

          if(stripos($afindname[$j], $searchstring) !== false && stripos($afindname[$j], $searchstring) == 0) {
            $prioritizedArray[count($prioritizedArray)] = $afindname[$j];
          }
          else {
            $returnArray[count($returnArray)] = $afindname[$j];
          } // normal array
        } // for
      } // found in string
    }
    natcasesort($prioritizedArray);
    natcasesort($returnArray);
    return array_merge($prioritizedArray, $returnArray);
//    return $prioritizedArray;
  }
  
  function getAttributeTypeFullString($searchstring, $setColor = false) {
    for($i = 0; $i < count($this->attributetype); $i++) {
      $currentValue = $this->attributetype[$i];
      if(stristr($currentValue, "'".$searchstring."'") !== FALSE) {
        if($setColor) {
          return str_ireplace("'".$searchstring."'", "'<b>".$searchstring."</b>'", $currentValue);
        }
        else {
          return $currentValue;
        }
      }
    }
    return "";
  }

  function getListBasedOnKey($objectType, $keyName) {
    $returnMatches = Array();
    for($i = 0; $i < count($objectType); $i++) {
      $currentStr = $objectType[$i];
      $currentStartPosition = (strpos($currentStr, $keyName." '") + 6);
      if($currentStartPosition > 6) {
        $currentStr = substr($currentStr, $currentStartPosition);
        $returnMatches[count($returnMatches)] = $currentStr = substr($currentStr, 0, strpos($currentStr, "'"));
      }
    }
    sort($returnMatches);
    return $returnMatches;
  }

  // Objectclasses
  function setObjectClass($objectclass) {
     $this->objectclass = $this->addToArray($objectclass);
  }
    
  function getObjectClass() {
    return $this->objectclass;
  }

  // Matchingrules
  function setMatchingRule($matchingrule) {
     $this->matchingrule = $this->addToArray($matchingrule);
  }
    
  function getMatchingRule() {
    return $this->matchingrule;
  }

  // exit code
  function setExitCode($exitCode) {
    $this->exitcode = $exitCode;
  }
  
  function getExitCode() {
    return $this->exitcode;
  }
  
  // Message
  function setMessage($sMessage) {
    $this->message = $sMessage;
  }
  
  function getMessage() {
    return $this->message;
  }

  /**
  * addToArray
  * Helper method to clean incomming arrays
  *
  * @param array $aIn
  * @return array
  */
  function addToArray($aIn) {
    $aOut = Array();

    for($i = 0; $i < count($aIn); $i++) {
      if(!empty($aIn[$i])) {
        $aOut[count($aOut)] = $aIn[$i];
      }
    }

    return $aOut;
  }

}

?>
