<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package cn=monitor
* @author Andreas Andersson
* @version 1.0
*
*  090425 - Andreas Andersson
*           Created
*/
class RootDN {
  var $namingContexts = Array();
  var $supportedExtension = Array();
  var $supportedFeatures = Array();
  var $supportedControl = Array();
  var $supportedSASLMechanisms = Array();
  var $supportedLDAPVersion = Array();
  var $vendorName = "";
  var $vendorVersion = "";
  var $netscapemdsuffix = "";
  var $message = "";
  var $hostname = "";
  var $exitcode = 1;

  /**
  * Setters...
  */
  function setNamingContexts($aNamingContexts) {
    $this->namingContexts = $this->addToArray($aNamingContexts);
  }

  function setSupportedExtension($aSupportedExtension) {
    $this->supportedExtension = $this->addToArray($aSupportedExtension);
  }

  function setSupportedControl($aSupportedControl) {
    $this->supportedControl = $this->addToArray($aSupportedControl);
  }

  function setSupportedFeatures($aSupportedFeatures) {
    $this->supportedFeatures = $this->addToArray($aSupportedFeatures);
  }

  function setSupportedSASLMechanisms($aSupportedSASLMechanisms) {
    $this->supportedSASLMechanisms = $this->addToArray($aSupportedSASLMechanisms);
  }

  function setSupportedLDAPVersion($aSupportedLDAPVersion) {
    $this->supportedLDAPVersion = $this->addToArray($aSupportedLDAPVersion);
  }

  function setVendorName($sVendorName) {
    $this->vendorName = $sVendorName;
  }

  function setVendorVersion($sVendorVersion) {
    $this->vendorVersion = $sVendorVersion;
  }

  function setNetscapemdsuffix($sNetscapemdsuffix) {
    $this->netscapemdsuffix = $sNetscapemdsuffix;
  }

  function setMessage($sMessage) {
    $this->message = $sMessage;
  }

  function setHostName($sHostName) {
    $this->hostname = $sHostName;
  }

  function setExitCode($nExitCode) {
    $this->exitcode = $nExitCode;
  }

  /**
  * addToArray
  * Helper method to clean incomming arrays
  *
  * @param array $aIn
  * @return array
  */
  function addToArray($aIn) {
    $aOut = Array();

    for($i = 0; $i < count($aIn); $i++) {
      if(!empty($aIn[$i])) {
        $aOut[count($aOut)] = $aIn[$i];
      }
    }

    return $aOut;
  }


  /**
  * Getters...
  */

  // returns array
  function getNamingContexts() {
    return $this->namingContexts;
  }

  // returns array
  function getSupportedExtension() {
    return $this->supportedExtension;
  }

  // returns array
  function getSupportedControl() {
    return $this->supportedControl;
  }

  // returns array
  function getSupportedFeatures() {
    return $this->supportedFeatures;
  }

  // returns array
  function getSupportedSASLMechanisms() {
    return $this->supportedSASLMechanisms;
  }

  // returns array
  function getSupportedLDAPVersion() {
    return $this->supportedLDAPVersion;
  }

  // returns string
  function getVendorName() {
    return $this->vendorName;
  }

  // returns string
  function getVendorVersion() {
    return $this->vendorVersion;
  }

  // returns string
  function getNetscapemdsuffix() {
    return $this->netscapemdsuffix;
  }

  // returns string
  function getMessage() {
    return $this->message;
  }

  // returns int exit code 0 on success
  function getExitCode() {
    return $this->exitcode;
  }

  // returns string
  function getHostName() {
    return $this->hostname;
  }

}


?>
