<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package cn=replica agreement
* @author Andreas Andersson
* @version 1.1
* Holds an array of replication agreements
*
*  090625 - Andreas Andersson
*           Created
*/  
class ServerReplica {
  var $hostname;
  var $mastercsn = Array();
  var $message;
  var $exitcode = 0;
  var $agreementsok = 0;
  var $agreements = Array();
  var $serverlist = Array();
  var $backenddb = Array();

  // replica agreement name
  function setName($sName) {
    $this->name = $sName;    
  }
    
  function getName() {
    return $this->name;
  }

  // Hostname
  function setHostName($hostname) {
    $this->hostname = $hostname;    
  }
    
  function getHostName() {
    return $this->hostname;
  }

  // Hostname
  function setMessage($in_message) {
    $this->message = $in_message;    
  }
    
  function getMessage() {
    return $this->message;
  }

  // Serverlist
  function setServerlist($in_server) {
    if(!in_array($in_server, $this->serverlist)) {
      $this->serverlist[count($this->serverlist)] = $in_server;
    }
  }
  
  function getServerlist() {
    return $this->serverlist;
  }

  // Backend database
  function setBackendDb($in_backenddb) {
    $this->backenddb = $in_backenddb;
  }
  
  function getBackendDb() {
    return $this->backenddb;
  }

  // we want to have the highest CSN number to compare with
  // the value in should be in date format
  function setMasterCSN($in_backenddb, $in_mastercsn) {  
    if(!empty($this->mastercsn[$in_backenddb])) {
      $oldValue = strtotime($this->mastercsn[$in_backenddb]);
      $newValue = strtotime($in_mastercsn);
      if($newValue > $oldValue) {
        $this->mastercsn[$in_backenddb] = $in_mastercsn;  
      }
    }
    else {
      $this->mastercsn[$in_backenddb] = $in_mastercsn;
    }
  }

  function getMasterCSN($in_backenddb) {
    if(empty($this->mastercsn[$in_backenddb])) {
      return "";
    }
    else {
      return $this->mastercsn[$in_backenddb];
    }
  }
  
  // Agreement
  function setAgreement($in_agreement) {
    $this->agreements[count($this->agreements)] = $in_agreement;
  }
    
  function getAgreements() {
    return $this->agreements;
  }
  
  // exit code
  function setExitCode($in_exitcode) {
    $this->exitcode = $in_exitcode;
  }
  
  function getExitCode() {
    return $this->exitcode;
  }

  // set successfull agreement
  function setAgreementsOk($bStatus) {
    if($bStatus) {
      $this->agreementsok++;
    }
  }

  // returns number of successfull agreements
  function getAgreementsOk() {
    return $this->agreementsok;
  }

  // returns total number of agreements
  function getNrOfAgreements() {
    return count($this->agreements);
  }
}

/**
* @package cn=replica agreement
* @author Andreas Andersson
* @version 1.1
*
*  120208 - Andreas Andersson
*           Added UpdateStartRaw function
*  100613 - Andreas Andersson
*           Added disabled replication support
*  090424 - Andreas Andersson
*           Created
*/  
class ReplicaAgreement {
  
  var $hostname;
  var $message;
  var $port;
  var $bindmethod;
  var $binddn;
  var $replicaroot;
  var $description;
  var $csn;
  var $updateschedule;
  var $updatestart;
  var $updateend;
  var $nrofchanges;
  var $laststatus;
  var $inprogress;
  var $exitcode;
  var $scheduledReplication = 0;
  var $disabledReplication = false;
  var $replicationError = false;

  // Hostname
  function setHostName($hostname) {
    $this->hostname = $hostname;    
  }
    
  function getHostName() {
    return $this->hostname;
  }

  // In Progress
  function setInProgress($inprogress) {
    $this->inprogress = $inprogress;    
  }
    
  function getInProgress() {
    return $this->inprogress;
  }

  // Last Status
  function setLastStatus($laststatus) {

    // check starting number. If 0 success
    $nEndPos = strpos($laststatus, " ");    
    $nExitCode = substr($laststatus, 0, $nEndPos);
    $this->exitcode = $nExitCode;

    $this->laststatus = $laststatus;    
  }

  // Last Status
  function setLastStatusRaw($laststatus) {
    $this->laststatus = $laststatus;    
  }
    
  function getLastStatus() {
    return $this->laststatus;
  }

  // Nr Of Changes
  function setNrOfChanges($nrofchanges) {
    $this->nrofchanges = $nrofchanges;    
  }
    
  function getNrOfChanges() {
    return $this->nrofchanges;
  }

  // update end
  function setUpdateEnd($updateend) {

    if(empty($updateend)) {
      $this->updateend = "";    
    } 
    else {
      $newDate = substr($updateend, 0, 4);
      $newDate .= "-".substr($updateend, 4, 2);
      $newDate .= "-".substr($updateend, 6, 2);
      $newDate .= " ".substr($updateend, 8, 2);
      $newDate .= ":".substr($updateend, 10, 2);
      $newDate .= ":".substr($updateend, 12, 2);
      $this->updateend = $newDate;    
    }
  }
  function setUpdateEndRaw($updateend) {
    $this->updateend = $updateend;    
  }

  // Get End Time Diff will diff the following values
  // CSN (if present) OR Update End Time
  function getEndTimeDiff($sCurrentTime, $sMasterCSNTime) {
    $aReturnTime = Array();
    $replicaTime = "";
    // first verify replication start
    // if this value does not exist, verify CSN
    if(!empty($this->updatestart)) {
      $replicaTime = strtotime($this->updatestart);
    }
    else if(!empty($this->csn)) {
      $replicaTime = strtotime($this->csn);
    }
    // if replica time is empty return no replication made
    if(empty($replicaTime)) {
      $aReturnTime[0] = "----";
      $aReturnTime[1] = "--";
      $aReturnTime[2] = "--";
      return $aReturnTime;    
    }
    
    // replication time will be based on master server current time
    $currentTime = strtotime($sCurrentTime);
    //echo "replica time: $replicaTime Current time: $currentTime<br>\n";

    // diff time
    $diffTime = ($currentTime - $replicaTime);
    // to avoid - in replication
    if($diffTime < 0) {
      $diffHour = $diffMinute = $diffSeconds = 0;
    }
    else {
      // get hours and seconds
      $diffHour = intval($diffTime / 3600);
      $diffMinute = intval(($diffTime - ($diffHour * 3600))/60);
      $diffSeconds = intval($diffTime - (($diffHour * 3600) + ($diffMinute * 60)));
    }

    // set time array and return
    $aReturnTime[0] = $diffHour;
    $aReturnTime[1] = $diffMinute;
    $aReturnTime[2] = $diffSeconds;

    return $aReturnTime;
  }
 
  function getUpdateEnd() {
    return $this->updateend;
  }

  // update start
  function setUpdateStart($updatestart) {

    if(empty($updatestart)) {
      $this->updatestart = "";    
    } 
    else {
      $newDate = substr($updatestart, 0, 4);
      $newDate .= "-".substr($updatestart, 4, 2);
      $newDate .= "-".substr($updatestart, 6, 2);
      $newDate .= " ".substr($updatestart, 8, 2);
      $newDate .= ":".substr($updatestart, 10, 2);
      $newDate .= ":".substr($updatestart, 12, 2);

      $this->updatestart = $newDate;
    }
  }

  function setUpdateStartRaw($updatestart) {
    if(empty($updatestart)) {
      $this->updatestart = "";    
    }
    $this->updatestart = $updatestart;
  }
    
  function getUpdateStart() {
    return $this->updatestart;
  }

  // update schedule
  function setUpdateSchedule($in_updateschedule) {
    //sunds = * and rhds is empty if scheduled
    if($in_updateschedule != "*" && (!empty($in_updateschedule))) {
      $this->scheduledReplication = 1;
    }
    $this->updateschedule = $in_updateschedule;
  }
  
  // returns 1 if scheduled replication
  function isScheduledReplication() {
    return $this->scheduledReplication;
  }

  // if replication agreement is disabled
  function setDisabledReplication($in_disabled) {
    if($in_disabled == true) {
      return $this->disabledReplication = true;
    }
  }

  // if replication agreement errors exists
  function setReplicationError($in_error) {
    if($in_error == true) {
      return $this->replicationError = true;
    }
  }

  // if "known" replication error exists
  function getReplicationError() {
    return $this->replicationError;
  }

  // returns 1 if disabled replication
  function isDisabledReplication() {
    return $this->disabledReplication;
  }
  
  function getUpdateSchedule() {
    return $this->updateschedule;
  }

  // description
  function setDescription($description) {
    $this->description = $description;    
  }
    
  function getDescription() {
    return $this->description;
  }

  // Set formatted CSN in "date" format
  function setCSN($csn) {
    if(empty($csn)) {
      $this->csn = "";
      return;
    }
    $this->csn = $csn;
  }

  function getCSN() {
    if(!empty($this->csn)) {
      return $this->csn;
    }
    return "";
  }

  // replica root
  function setReplicaRoot($replicaroot) {
    $this->replicaroot = $replicaroot;    
  }
    
  function getReplicaRoot() {
    return $this->replicaroot;
  }

  // bind dn
  function setBindDn($binddn) {
    $this->binddn = $binddn;    
  }
    
  function getBindDn() {
    return $this->binddn;
  }

  // bind method
  function setBindMethod($bindmethod) {
    $this->bindmethod = $bindmethod;    
  }
    
  function getBindMethod() {
    return $this->bindmethod;
  }

  // port
  function setPort($port) {
    $this->port = $port;    
  }
    
  function getPort() {
    return $this->port;
  }

  // message  
  function setMessage($sMessage) {
    $this->message = $sMessage;
  }

  function getMessage() {
    return $this->message;
  }

  function getExitCode() {
/*
    if(strpos($this->laststatus, "requires administrator action") > 0) {
      return 1;
    }
    else if(strpos($this->laststatus, "initialize") > 0) {
      return 2;
    }
    else if(strpos($this->laststatus, "match the data in the changelog") > 0) {
      return 3;
    }
    else {
      return 0;
    }
*/
    return $this->exitcode;
  }
}

?>
