<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package cn=replica
* @author ADON Andreas Andersson
* @version 1.0
*
*  090627 - Andreas Andersson
*           Created
*/  
class ReplicaInfo {
  
  var $hostname;
  var $replicatype = "consumer";
  var $isiplanet = false;
  var $replicaid = Array();
  var $replicaroot = Array();
  var $nrofchanges = Array();
  var $forwardflag = Array();
  var $message;

  // Hostname
  function setHostName($hostname) {
    $this->hostname = $hostname;    
  }
    
  function getHostName() {
    return $this->hostname;
  }

  // Replica Forward Flag (HUB)
  function setReplicaForwardFlag($replicaflag, $backenddb) {
    $this->forwardflag[$backenddb] = $replicaflag;
  }

  // Replica type
  function setReplicaType($replicatype, $backenddb) {
    $type = "consumer";
    if($replicatype == 3) {
      $type = "master";
    }
    else if(($replicatype == 2)  && (!empty($this->forwardflag[$backenddb]))) {
      // type consumer and forwarding flag exists
      $type = "hub";
    }

   // override default consumer value if at least one of the agreements are master or hub
   if($type == "master") {
      $this->replicatype = $type;
    }
    else if(($this->replicatype == "consumer") && ($type == "hub")) {
      // to avoid reseting master value
      $this->replicatype = $type;
    }
  }
  
  // this function requires the name (master, hub or consumer)
  function setReplicaTypeByName($replicatTypeName) {
    $this->replicatype = $replicatTypeName;
  }
  
  function getReplicaType() {
    return $this->replicatype;
  }

  // Replica ID
  function setReplicaId($replicaid, $backenddb) {
    $this->replicaid[$backenddb] = $replicaid;    
  }
    
  function getReplicaId($backenddb) {
    if(empty($this->replicaid[$backenddb])) {
      return "-";
    }
    return $this->replicaid[$backenddb];
  }

  // replica root
  function setReplicaRoot($in_replicaroot) {
    if(!in_array($in_replicaroot, $this->replicaroot)) {
      $this->replicaroot[count($this->replicaroot)] = $in_replicaroot;
    }
  }
    
  function getReplicaRoot() {
    return $this->replicaroot;
  }

  // nr of changes
  function setNrOfChanges($nrofchanges, $backenddb) {
    if(empty($nrofchanges)) {
      $this->nrofchanges[$backenddb] = 0;
    }
    else {
      $this->nrofchanges[$backenddb] = $nrofchanges;    
    }
  }
    
  function getNrOfChanges($backenddb) {
    // can't return 0
    if(empty($this->nrofchanges[$backenddb])) {
      return 1;
    }
    else {
      return $this->nrofchanges[$backenddb];
    }
  }
  
  function setIsIplanet($isiplanet) {
    $this->isiplanet = $isiplanet;
  }
  
  function isIplanet() {
    return $this->isiplanet;
  }

  // Message
  function setMessage($in_message) {
    $this->message = $in_message;    
  }
    
  function getMessage() {
    return $this->message;
  }

}

?>
