<?php
  /*
    Copyright (C) 2009 - 2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package query
* @author Andreas Andersson
* @version 1.0
*
*  080922 - Andreas Andersson
*           Created
*  090614 - Andreas Andersson
*           Added multivalue support
*/  
class Query {
  
  var $hostname;
  var $message;
  var $value = array();
  var $attributes = array();
  var $dn;
  var $modifiersname;
  var $modifytimestamp;
  var $creatorsname;
  var $createtimestamp;

  function Query($hostname) {
    $this->hostname = $hostname;    
  }

  // Hostname
  function setHostName($hostname) {
    $this->hostname = $hostname;    
  }
    
  function getHostName() {
    return $this->hostname;
  }

  // values
  function setValue($attribute, $value) {
    $size = 0;
    if(!empty($this->value[$attribute])) {
      $size = count($this->value[$attribute]);
    }
    $this->value[$attribute][$size] = $value;    
  }
  
  // returns an array of values
  function getValue($attribute) {
    if(!empty($this->value[$attribute])) {
      return $this->value[$attribute];
    }
    else {
      return Array();
    }
  }

  // attributes
  function setAttributes($in_attribute) {
    $size = count($this->attributes);
    $this->attributes[$size] = $in_attribute;    
  }
  
  // returns an array of values
  function getAttributes() {
    return $this->attributes;
  }

  // DN
  function setDN($dn) {
    $this->dn = $dn;    
  }
    
  function getDN() {
    return $this->dn;
  }

  // ModifiersName
  function setModifiersName($value) {
    $this->modifiersname = $value;    
  }
    
  function getModifiersName() {
    return $this->modifiersname;
  }

  // ModifyTimeStamp
  function setModifyTimestamp($value) {
    $this->modifytimestamp = $value;    
  }
    
  function getModifyTimestamp() {
    return $this->modifytimestamp;
  }

  // Creators Name
  function setCreatorsName($value) {
    $this->creatorsname = $value;    
  }
    
  function getCreatorsName() {
    return $this->creatorsname;
  }

  // Create Time Stamp
  function setCreateTimeStamp($value) {
    $this->createtimestamp = $value;    
  }
    
  function getCreateTimeStamp() {
    return $this->createtimestamp;
  }


  // Message
  function setMessage($message) {
    $this->message = $message;    
  }
    
  function getMessage() {
    return $this->message;
  }

}

?>
