<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package cn=monitor
* @author Andreas Andersson
* @version 1.3
*
*  120211 - Andreas Andersson
*           Added seconds to start and current time
*  100612 - Andreas Andersson
*           Removed never used bind variables
*  080811 - Andreas Andersson
*           Created
*/
class Monitor {
  var $version = "";
  var $connectionPeak = 0;
  var $threads = 0;
  var $currentConnections = 0;
  var $totalConnections = 0;
  var $dtablesize;
  var $entriessent = 0;
  var $cacheavailbytes = 0;
  var $starttime;
  var $currenttime;
  var $errors = 0;
  var $connections = 0;
  var $connectionseq = 0;
  var $bytesrecv = 0;
  var $bytessent = 0;
  var $entriesreturned = 0;
  var $hostname = "";
  var $message = "";
  var $executiontime = "";
  var $uptimeday = "";
  var $uptimehour = "";
  var $uptimeminute = "";

  /**
  * Setters...
  */
  function setVersion($sVersion) {
    $this->version = $sVersion;
  }

  function setConnectionPeak($sConnectionPeak) {
    $this->connectionPeak = $sConnectionPeak;
  }

  function setThreads($sThreads) {
    $this->threads = $sThreads;
  }

  function setCurrentConnections($sCurrentConnections) {
    $this->currentConnections = $sCurrentConnections;
  }

  function setTotalConnections($sTotalConnections) {
    $this->totalConnections = $sTotalConnections;
  }

  function setEntriesSent($sEntriesSent) {
    $this->entriessent = $sEntriesSent;
  }

  function setBytesSent($sBytesSent) {
    $this->bytessent = $sBytesSent;
  }

  function setCacheAvailBytes($sCacheAvailBytes) {
    $this->cacheavailbytes = $sCacheAvailBytes;
  }

  function setExecutionTime($executiontime) {
    $this->executiontime = round(($executiontime * 1000), 2);
  }

  function setStartTime($sStartTime) {
    if(!empty($sStartTime)) {
      $newDate = substr($sStartTime, 0, 4);
      $newDate .= "-".substr($sStartTime, 4, 2);
      $newDate .= "-".substr($sStartTime, 6, 2);
      $newDate .= " ".substr($sStartTime, 8, 2);
      $newDate .= ":".substr($sStartTime, 10, 2);
      // not all directory servers specify seconds
      if(strlen($sStartTime) == 15) {
        $newDate .= ":".substr($sStartTime, 12, 2);
      }
      else {
        $newDate .= ":00";      
      }
    }
    $this->starttime = $newDate;
  }

  function setStartTimeFormated($sStartTime) {
    $this->starttime = $sStartTime;
  }

  function setCurrentTime($sCurrentTime) {
    if(!empty($sCurrentTime)) {
      $newDate = substr($sCurrentTime, 0, 4);
      $newDate .= "-".substr($sCurrentTime, 4, 2);
      $newDate .= "-".substr($sCurrentTime, 6, 2);
      $newDate .= " ".substr($sCurrentTime, 8, 2);
      $newDate .= ":".substr($sCurrentTime, 10, 2);
      if(strlen($sCurrentTime) == 15) {
        $newDate .= ":".substr($sCurrentTime, 12, 2);
      }
      else {
        $newDate .= ":00";      
      }
    }
    $this->currenttime = $newDate;
  }

  function setCurrentTimeFormated($sCurrentTime) {
    $this->currenttime = $sCurrentTime;
  }

  function setHostName($sHostName) {
    $this->hostname = $sHostName;
  }
  
  function setMessage($message) {
    $this->message = $message;
  }

  /**
  * Getters...
  */
  function getVersion() {
    return $this->version;
  }

  function getConnectionPeak() {
    return $this->connectionPeak;
  }

  function getThreads() {
    return $this->threads;
  }

  function getCurrentConnections() {
    if($this->currentConnections < 1) {
      return 0;
    }
    else {
      return $this->currentConnections;
    }
  }

  function getExecutionTime() {
    return $this->executiontime;
  }

  function getTotalConnections($nOffset = 0) {
    return returnValueOnOffset($this->totalConnections, $nOffset);
  }

  function getEntriesSent($nOffset = 0) {
    return returnValueOnOffset($this->entriessent, $nOffset);
  }

  function getBytesSent($nOffset = 0) {
    return returnValueOnOffset($this->bytessent, $nOffset);
  }

  function getMBytesSent() {
    return round(($this->bytessent/1024/1024), 2);
  }

  function getKBytesSent() {
    return round(($this->bytessent/1024), 2);
  }

  function getCacheAvailBytes() {
    return $this->cacheavailbytes;
  }

  function getStartTime() {
    return $this->starttime;
  }

  function getStartTimeSeconds($offset = 0) {
    if(empty($this->starttime)) {
      return "";
    }
    $unixtime = strtotime($this->starttime);
    if(!empty($offset)) {
      return ($offset - $unixtime);
    }
    else {
      return strtotime($this->starttime);
    }
  }

  function getCurrentTime() {
    return $this->currenttime;
  }

  function setUptime() {
    if(empty($this->starttime)) {
      return "";
    }
    // first, parse time:
    $startTime = strtotime($this->starttime);
    $currentTime = $this->currenttime;
    if(empty($currentTime)) {
      $currentTime = time();
    }
    else {
      $currentTime = strtotime($this->currenttime);
    }
    // diff time
    $diffTime = ($currentTime - $startTime);

    // get hours and seconds
    $diffDay = intval($diffTime / 86400);
    $diffHour = intval(($diffTime - ($diffDay * 86400))/3600);
    $diffMinute = intval(($diffTime - (($diffDay * 86400) + ($diffHour * 3600)))/60);
    $this->uptimeday = $diffDay;
    $this->uptimehour = $diffHour;
    $this->uptimeminute = $diffMinute;
    return;
  }

  function getHostName() {
    return $this->hostname;
  }

  function getMessage() {
    return $this->message;
  }

  function getEntriesPerSecond($nOffset = 0, $sStartTime = "") {
    $entriessent = $this->entriessent;

    if(empty($this->currenttime)) {
      return 0;
    }

    if(empty($sStartTime)) {
      $sStartTime = $this->starttime;
    }
    else if($sStartTime == $this->currenttime) {
      $sStartTime = $this->starttime;
    }

    if($nOffset > 0) {
      $entriessent = ($entriessent - $nOffset);
    }

    $now = strtotime($this->currenttime);
    $start = strtotime($sStartTime);
    $diffTime = ($now - $start);
    $nReturn = round(($entriessent / $diffTime), 1);

    if($nReturn < 0) {
      return 0;
    }
    return $nReturn;
  }

  function getConnectionsPerSecond($nOffset = 0, $sStartTime = "") {
    $connections = $this->totalConnections;

    if(empty($this->currenttime)) {
      return 0;
    }

    if(empty($sStartTime)) {
      $sStartTime = $this->starttime;
    }
    else if($sStartTime == $this->currenttime) {
      $sStartTime = $this->starttime;
    }

    if($nOffset > 0) {
      $connections = ($connections - $nOffset);
    }

    $now = strtotime($this->currenttime);
    $start = strtotime($sStartTime);
    $diffTime = ($now - $start);
    //echo "difftime: $diffTime - $connections<br>";
    $nReturn = round(($connections / $diffTime), 1);

    if($nReturn < 0) {
      return 0;
    }
    return $nReturn;
  }

  function getKBPerSecond($nOffset = 0, $sStartTime = "") {
    $bytessent = $this->bytessent;

    if(empty($this->currenttime)) {
      return 0;
    }

    if($nOffset > 0) {
      $bytessent = ($bytessent - $nOffset);
    }

    if(empty($sStartTime)) {
      $sStartTime = $this->starttime;
    }
    else if($sStartTime == $this->currenttime) {
      $sStartTime = $this->starttime;
    }

    $now = strtotime($this->currenttime);
    $start = strtotime($sStartTime);

    // get time in seconds
    $diffTime = ($now - $start);

    $return = round((($bytessent/1024) / $diffTime), 1);

    if($return < 0) {
      return 0;
    }
    return $return;

  }
}


?>
