<?php
  /*
    Copyright (C) 2010-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package monitoranalyse
* @author Andreas Andersson
* @version 1.0
*
*  100917 - Andreas Andersson
*           Created
*/  
class MonitorAnalyse {
  
  var $maxvalue = 0;
  var $minvalue = 0;
  var $averagevalue = 0;
  var $measuredvalues = 0;
  var $totalvalue = 0;
  var $valueparts = array();
  var $valuepartsnumbers = array();
  var $message = "";
  var $startdate = "-";
  var $enddate = "-";

  // Max Value
  function setMaxValue($maxvalue) {
    $this->maxvalue = $maxvalue;    
  }
    
  function getMaxValue() {
    return $this->maxvalue;
  }

  // Min Value
  function setMinValue($minvalue) {
    $this->minvalue = $minvalue;    
  }
    
  function getMinValue() {
    return $this->minvalue;
  }

  // Average Value
  function setAverageValue($averagevalue) {
    $this->averagevalue = $averagevalue;    
  }
    
  function getAverageValue() {
    return $this->averagevalue;
  }

  // Set Value Parts
  function setValueParts($valueParts) {
    $this->valueparts = $valueParts;    
  }
    
  function getValueParts() {
    return $this->valueparts;
  }

  function getValuePartsWithText() {
    $valueText = array();
    
    $valueText[0] = "00:00 - 01:59 : ".$this->valuepartsnumbers[0];
    $valueText[1] = "02:00 - 03:59 : ".$this->valuepartsnumbers[1];
    $valueText[2] = "04:00 - 05:59 : ".$this->valuepartsnumbers[2];
    $valueText[3] = "06:00 - 07:59 : ".$this->valuepartsnumbers[3];
    $valueText[4] = "08:00 - 09:59 : ".$this->valuepartsnumbers[4];
    $valueText[5] = "10:00 - 11:59 : ".$this->valuepartsnumbers[5];
    $valueText[6] = "12:00 - 13:59 : ".$this->valuepartsnumbers[6];
    $valueText[7] = "14:00 - 15:59 : ".$this->valuepartsnumbers[7];
    $valueText[8] = "16:00 - 19:59 : ".$this->valuepartsnumbers[8];
    $valueText[9] = "18:00 - 19:59 : ".$this->valuepartsnumbers[9];
    $valueText[10] = "20:00 - 21:59 : ".$this->valuepartsnumbers[10];
    $valueText[11] = "22:00 - 23:59 : ".$this->valuepartsnumbers[11];
    
    return $valueText;
  }

  // Set Value Parts Numbers
  function setValuePartsNumbers($valuePartsNumbers) {
    $this->valuepartsnumbers = $valuePartsNumbers;    
  }
    
  function getValuePartsNumbers() {
    return $this->valuepartsnumbers;
  }

  // Set Measured Values
  function setMeasuredValues($measuredvalues) {
    $this->measuredvalues = $measuredvalues;    
  }
    
  function getMeasuredValues() {
    return $this->measuredvalues;
  }

  // Set Total Value
  function setTotalValues($totalvalue) {
    $this->totalvalue = $totalvalue;    
  }
    
  function getTotalValues() {
    return $this->totalvalue;
  }

  // Message
  function setMessage($message) {
    $this->message = $message;
  }
    
  function getMessage() {
    return $this->message;
  }

  // Start Date
  function setStartDate($startdate) {
    $this->startdate = $startdate;
  }
    
  function getStartDate() {
    return $this->startdate;
  }

  // End Date
  function setEndDate($enddate) {
    $this->enddate = $enddate;
  }
    
  function getEndDate() {
    return $this->enddate;
  }
}

?>
