<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package loadbalancer
* @author Andreas Andersson
* @version 1.0
*
*  100814 - Andreas Andersson
*           Updated with execution time
*  090510 - Andreas Andersson
*           Created
*/  
class LoadBalancer {
  
  var $nrofqueries;
  // associative array for example $host["host1"] = 3
  var $host = Array();
  // associative array for example $port['host1'] = 3
  var $port = Array();
  // associative array for example $secondaryport['host1'] = 3
  var $secondaryport = Array();
  // multi array for response time $responsetime['host'][<port>] = Array(<exectime1>, <exectime2>)
  var $responsetime = Array();
  var $starttime = "";
  var $endtime = "";
  var $message = "";

  // Hostname
  function addHostMatch($host) {
    if(empty($this->host[$host])) {
      $this->host[$host] = 1;
    }
    else {
      $this->host[$host]++;
    }
    $this->nrofqueries++;
  }

  function setStartTime($startTime) {
    $this->starttime = $startTime;
  }

  function setEndTime($endTime) {
    $this->endtime = $endTime;
  }

  // Port
  function setPort($host) {
    if(empty($this->port[$host])) {
      $this->port[$host] = 1;
    }
    else {
      $this->port[$host]++;
    }
  }

  function setSecondaryPort($host) {
    if(empty($this->secondaryport[$host])) {
      $this->secondaryport[$host] = 1;
    }
    else {
      $this->secondaryport[$host]++;
    }
  }
  
  function setResponseTime($responseTime, $endtime, $host, $port) {
    if(empty($this->responsetime[$host][$port])) {
      $this->responsetime[$host][$port][0][0] = $responseTime;  
      $this->responsetime[$host][$port][0][1] = $endtime;  
    }
    else {
      $currIndex = count($this->responsetime[$host][$port]);
      $this->responsetime[$host][$port][$currIndex][0] = $responseTime;
      $this->responsetime[$host][$port][$currIndex][1] = $endtime;
    }
  }

  function getResponseTime($host, $port) {
    if(empty($this->responsetime[$host][$port])) {
      return array();
    }
    return $this->responsetime[$host][$port];
  }

  function getResponseTimeGrouped($host, $port) {
    $return = array(0, 0, 0, 0, 0);

    if(empty($this->responsetime[$host][$port])) {
      return $return;
    }
    $responsetime = $this->responsetime[$host][$port];
    
    // first lets decide if we want to use the small or the big scale
    $maxvalue = $this->getResponseTimeMax($host, $port);
    if($maxvalue > 100) {
      // over 100 ms, use big scale
      $scale = Array(25, 50, 100, 250, 250);
    }
    else {
      $scale = Array(5, 10, 15, 25, 25);
    }
    
    for($i = 0; $i < count($responsetime); $i++) {
      if($responsetime[$i] < $scale[0]) {
        $return[0]++;
      }
      else if($responsetime[$i] < $scale[1]) {
        $return[1]++;
      }
      else if($responsetime[$i] < $scale[2]) {
        $return[2]++;
      }
      else if($responsetime[$i] < $scale[3]) {
        $return[3]++;
      }
      else {
        $return[4]++;
      }
    }
    
    return $return;
  }

  function getResponseTimeMax($host, $port) {
    if(empty($this->responsetime[$host][$port])) {
      return "9999";
    }
    return max($this->responsetime[$host][$port]);
  }

  function getResponseTimeMin($host, $port) {
    if(empty($this->responsetime[$host][$port])) {
      return "9999";
    }
    return min($this->responsetime[$host][$port]);
  }

  function getResponseTimeAverage($host, $port) {
    if(empty($this->responsetime[$host][$port])) {
      return "9999";
    }
    return array_sum($this->responsetime[$host][$port]) / count(array_filter($this->responsetime[$host][$port])); 
  }

  

  // get host array    
  function getHosts() {
    return $this->host;
  }

  // get port array    
  function getPort() {
    return $this->port;
  }

  function getSecondaryPort() {
    return $this->secondaryport;
  }

  // get nr of queries in this object
  function getNrOfQueries() {
    return $this->nrofqueries;
  }

  // messages
  function setMessage($message) {
    $this->message = $message;
  }

  function getMessage() {
    return $this->message;
  }
  
  function getStartTime() {
    return $this->starttime;
  }

  function getEndTime() {
    return $this->endtime;
  }
}

?>
