<?php
  /*
    Copyright (C) 2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package indexes
* @author Andreas Andersson
* @version 1.0
*
*  110214 - Andreas Andersson
*           Created
*/  
class Index {
  
  var $hostnameList = array();
  var $indexType = array();
  // in format $indexTypeHost["<hostname>"] = array("index1, "index2"...);
  var $indexTypeHost = array();
  var $index = "";

  var $message = "";
  var $exitcode = 0;

  // Hostnames
  function setHostNames($in_hostnameList) {
    if(!in_array($in_hostnameList, $this->hostnameList)) {
      $this->hostnameList[count($this->hostnameList)] = $in_hostnameList;
    }
  }
    
  function getHostNames() {
    return $this->hostnameList;
  }

  // Index
  function setIndex($index) {
    $this->index = $index;    
  }
    
  function getIndex() {
    return $this->index;
  }

  // Index Type
  function setIndexType($in_indexType) {
    // global unique list for all servers
    if(!in_array($in_indexType, $this->indexType)) {
      $this->indexType[count($this->indexType)] = $in_indexType;
    }
  }

  function getIndexType() {
    return $this->indexType;
  }
  
  // Index Type By Host
  function setIndexTypeByHost($in_hostname, $in_indexType) {
    if(!empty($in_indexType) && !empty($in_hostname)) {
      if(empty($this->indexTypeHost[$in_hostname])) {
        $this->indexTypeHost[$in_hostname] = array($in_indexType);
      }
      else {
        $this->indexTypeHost[$in_hostname][count($this->indexTypeHost[$in_hostname])] = $in_indexType;
      }
    }
  }
  
  function getIndexTypeByHost($in_hostname) {
    if(!empty($in_hostname)) {
      if(!empty($this->indexTypeHost[$in_hostname])) {
        return $this->indexTypeHost[$in_hostname];
      }
    }
    return array();
  }

  function setExitCode($code) {
    $this->exitcode = $code;  
  }

  function getExitCode() {
    return $this->exitcode;
  }
}

?>
