<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package certifcate
* @author Andreas Andersson
* @version 1.2
*
*  090311 - Andreas Andersson
*           Created
*/  
class Certificate {
  
  var $hostname;
  var $issuer = "";
  var $subject = "";
  var $message = "";
  var $exitcode = 1;
  var $nPause = 1;
  var $commonName = "";
  var $company = "";
  var $organization = "";
  var $location = "";
  var $state = "";
  var $country = "";
  var $issuerCommonName = "";
  var $issuerCompany = "";
  var $issuerOrganization = "";
  var $issuerLocation = "";
  var $issuerState = "";
  var $issuerCountry = "";
  var $validFrom = "";
  var $validTo = "";
  var $alternativeName = "";
  var $certificate = "";

  // constructor
  function Certificate($hostname, $port, $useCache = true) {
    // if created for dummy purposes
    if(empty($hostname)) {
      $this->setMessage("Missing servername or server not responding on secure port: ".$port);
      return;
    }

    $this->hostname = $hostname;

    $File = new File();
    $sslFile = getTempFileName("ssl_file_".$hostname);
    $sslFile_error = getTempFileName("ssl_fileerror_".$hostname);

    if(!$useCache || !file_exists($sslFile)) {
      exec("openssl s_client -connect $hostname:$port 1> $sslFile 2> $sslFile_error"); //  2>&1 = a little bit harded to verify if connected
    }
    
    if(!file_exists($sslFile)) {
      $this->message = "$sFile_error";
      $this->exitcode = 2;
      return;
    }
    
    $aFile = $File->readToArray($sslFile);
    $sFile_error = $File->read($sslFile_error);

    if(count($aFile) == 0) {
      $this->message = "Unable to execute openssl command. OpenSSL installed?\n";
      $this->message .= "Temporary ssl output '".$sslFile."' not created!";
      $this->exitcode = 1;
      return;	
    }

    $certificate = "";
    $gettingCert = false;
    for($i = 0; $i < count($aFile); $i++) {
        
      if(strstr($aFile[$i], "BEGIN CERTIFICATE")) {
        $gettingCert = true;
      }
        
      if($gettingCert) {
        $certificate .= $aFile[$i];
      }

      if(strstr($aFile[$i], "END CERTIFICATE")) {
        $gettingCert = false;
      }
    }
    $parsedCert = openssl_x509_parse($certificate);
    $this->certificate = $parsedCert;  
    $this->exitcode = 0;
/*
      // subject
      if(!empty($parsedCert["subject"]["CN"])) {
        $this->commonName = $this->parseValue($parsedCert["subject"]["CN"]);
      }
      if(!empty($parsedCert["subject"]["OU"])) {
        $this->company = $this->parseValue($parsedCert["subject"]["OU"]);
      }
      if(!empty($parsedCert["subject"]["O"])) {
        $this->organization = $this->parseValue($parsedCert["subject"]["O"]);
      }
      if(!empty($parsedCert["subject"]["L"])) {
        $this->location = $this->parseValue($parsedCert["subject"]["L"]);
      }
      if(!empty($parsedCert["subject"]["ST"])) {
        $this->state = $this->parseValue($parsedCert["subject"]["ST"]);
      }
      if(!empty($parsedCert["subject"]["C"])) {
        $this->country = $this->parseValue($parsedCert["subject"]["C"]);
      }

      // issuer
      if(!empty($parsedCert["issuer"]["CN"])) {
        $this->issuerCommonName = $this->parseValue($parsedCert["issuer"]["CN"]);
      }
      if(!empty($parsedCert["issuer"]["OU"])) {
        $this->issuerCompany = $this->parseValue($parsedCert["issuer"]["OU"]);
      }
      if(!empty($parsedCert["issuer"]["O"])) {
        $this->issuerOrganization = $this->parseValue($parsedCert["issuer"]["O"]);
      }
      if(!empty($parsedCert["issuer"]["L"])) {
        $this->issuerLocation = $this->parseValue($parsedCert["issuer"]["L"]);
      }
      if(!empty($parsedCert["issuer"]["ST"])) {
        $this->issuerState = $this->parseValue($parsedCert["issuer"]["ST"]);
      }
      if(!empty($parsedCert["issuer"]["C"])) {
        $this->issuerCountry = $this->parseValue($parsedCert["issuer"]["C"]);
      }

      // Valid from and to
      $this->validFrom = date("r", convertLDAPDate($this->parseValue($parsedCert["validFrom"])));
      $this->validTo = date("r", convertLDAPDate($this->parseValue($parsedCert["validTo"])));

      // Alternative Name
      if(!empty($parsedCert["extensions"]["subjectAltName"])) {
        $this->alternativeName = $this->parseValue($parsedCert["extensions"]["subjectAltName"]);
      }
    }
    */      
  }
  
  // parse certificate value
  function parseValue($inValue) {
    if(empty($inValue)) {
      return "";
    }
    
    if(is_array($inValue)) {
      return implode("<br>", $inValue);      
    }
    else {
      return $inValue;
    }
  }

  // Hostname
  function getHostName() {
    return $this->hostname;
  }

  function getIssuerArray() {
    if(!empty($this->issuer)) {
      return explode("/", $this->issuer);
    }
    return Array();
  }

  function getArray($inString) {
    if(!empty($inString)) {
      return explode("/", $inString);
    }
    return Array();
  }

  // message
  function getMessage() {
    return $this->message;
  }

  function getCertificate() {
    return $this->certificate;
  }

  // get common name
  function getCommonName() {
    return $this->commonName;
  }

  // get company
  function getCompany() {
    return $this->company;
  }

  // get organization
  function getOrganization() {
    return $this->organization;
  }

  // get location
  function getLocation() {
    return $this->location;
  }

  // get state
  function getState() {
    return $this->state;
  }

  // get country
  function getCountry() {
    return $this->country;
  }

  // get common name
  function getIssuerCommonName() {
    return $this->issuerCommonName;
  }

  // get company
  function getIssuerCompany() {
    return $this->issuerCompany;
  }

  // get organization
  function getIssuerOrganization() {
    return $this->issuerOrganization;
  }

  // get location
  function getIssuerLocation() {
    return $this->issuerLocation;
  }

  // get state
  function getIssuerState() {
    return $this->issuerState;
  }

  // get country
  function getIssuerCountry() {
    return $this->issuerCountry;
  }

  // get valid from
  function getValidFrom() {
    return $this->validFrom;
  }

  // get valid to
  function getValidTo() {
    return $this->validTo;
  }

  // get alternative name
  function getAlternativeName() {
    return $this->alternativeName;
  }

  // returns 0 on success
  function cnMatchesHostname($hostname, $nIgnoreVerification = 0) {

    $cn = $this->getCommonName();
    if($cn != $hostname) {
      if($nIgnoreVerification == 1) {
        return 0;
      }
      else {
        return 1;
      }
    }
    return 0;
  }

  function issuerTranslate($str) {
    $aIssuer = explode("=", $str);
    if($aIssuer[0] == "C") {
      $aIssuer[0] = "Company";
    }
    else if($aIssuer[0] == "ST") {
      $aIssuer[0] = "State";
    }
    else if($aIssuer[0] == "L") {
      $aIssuer[0] = "Location";
    }
    else if($aIssuer[0] == "O") {
      $aIssuer[0] = "Organisation";
    }
    else if($aIssuer[0] == "OU") {
      $aIssuer[0] = "OU";
    }
    else if($aIssuer[0] == "CN") {
      $aIssuer[0] = "Common Name";
    }
    else if($aIssuer[0] == "emailAdress") {
      $aIssuer[0] = "Email Adress";
    }
    
    return $aIssuer;
  }

  function getExitCode() {
    return $this->exitcode;
  }

  function setMessage($message) {
    $this->message = $message;
  }

}

?>
