<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/**
* @package cache
* @author Andreas Andersson
* @version 1.2
*
*  080811 - Andreas Andersson
*           Created
*  120212 - Andreas Andersson
*           Updated for jquery and improved vendor support
*/  
class Cache {
  
  var $hostname;
  var $entriesindb = Array();

  var $maxentriescache = Array();
  var $maxentriescacheset = Array();

  var $entriesincaches = Array();
  var $entriesincacheset = Array();

  var $backenddb = Array();

  var $cachehits = Array();
  var $cachehitsset = Array();

  var $hitratio = Array();
  var $hitratioset = Array();

  var $currentcache = Array();
  var $currentcacheset = Array();

  var $maxcache = Array();
  var $maxcacheset = Array();

  var $dnmaxcache = Array();
  var $dncurrentcache = Array();

  var $indexmaxcache = Array();
  var $indexcurrentcache = Array();

  var $message = Array();
  var $exitcode = Array();
  var $exitcodemain = 0;

  // Hostname
  function setHostName($hostname) {
    $this->hostname = $hostname;    
  }
    
  function getHostName() {
    return $this->hostname;
  }

  // Message
  function setMessage($message, $in_backend) {
    $this->message[$in_backend] = $message;
  }
    
  function getMessage($in_backend) {
    if(!empty($this->message[$in_backend])) {
      return $this->message[$in_backend];
    }
  }

  // Backend
  function setBackendDb($in_backenddb) {
    $this->backenddb[count($this->backenddb)] = $in_backenddb;    
  }
    
  function getBackendDb() {
    return $this->backenddb;
  }

  // Entries in db
  function setEntriesInDb($entriesindb, $in_backend) {
      $this->entriesindb[$in_backend] = $entriesindb;
  }
    
  function getEntriesInDb($in_backend) {
    if(!isset($this->entriesindb[$in_backend])) {
      return 0;
    }
    return $this->entriesindb[$in_backend];
  }

  // DN Cache
  function setDNMaxCache($dncache, $in_backend) {
    $this->dnmaxcache[$in_backend] = $dncache;
  }

  function getDNMaxCache($in_backend) {
    if(!isset($this->dnmaxcache[$in_backend])) {
      return 0;
    }
    return $this->dnmaxcache[$in_backend];
  }

  function setDNCurrentCache($dncache, $in_backend) {
    $this->dncurrentcache[$in_backend] = $dncache;
  }

  function getDNCurrentCache($in_backend) {
    if(!isset($this->dncurrentcache[$in_backend])) {
      return 0;
    }
    return $this->dncurrentcache[$in_backend];
  }

  // Index Cache
  function setIndexMaxCache($indexcache, $in_backend) {
    $this->indexmaxcache[$in_backend] = $indexcache;
  }

  function getIndexMaxCache($in_backend) {
    if(!isset($this->indexmaxcache[$in_backend])) {
      return 0;
    }
    return $this->indexmaxcache[$in_backend];
  }

  function setIndexCurrentCache($indexcache, $in_backend) {
    $this->indexcurrentcache[$in_backend] = $indexcache;
  }

  function getIndexCurrentCache($in_backend) {
    if(!isset($this->indexcurrentcache[$in_backend])) {
      return 0;
    }
    return $this->indexcurrentcache[$in_backend];
  }

  // Entry cache
  // Number of entries allowed in cache
  function setMaxEntriesCache($maxentriescache, $in_backend) {
    $this->maxentriescache[$in_backend] = $maxentriescache;
    $this->maxentriescacheset[$in_backend] = true;
  }

  function getMaxEntriesCache($in_backend) {
    if(!isset($this->maxentriescache[$in_backend])) {
      return 0;
    }
    return $this->maxentriescache[$in_backend];
  }
    
  // Entries in cache
  function setEntriesInCache($entriesincache, $in_backend) {
    $this->entriesincache[$in_backend] = $entriesincache;
    $this->entriesincacheset[$in_backend] = true;
  }
    
  function getEntriesInCache($in_backend) {
    if(!isset($this->entriesincache[$in_backend])) {
      return 0;
    }
    return $this->entriesincache[$in_backend];
  }

  // cache hits
  function setCacheHits($cachehits, $in_backend) {
      $this->cachehits[$in_backend] = $cachehits;
      $this->cachehitsset[$in_backend] = true;
  }
    
  function getCacheHits($in_backend) {
    if(!isset($this->cachehits[$in_backend])) {
      return 0;
    }
    return $this->cachehits[$in_backend];
  }

  // Hit ratio
  function setHitRatio($hitratio, $in_backend) {
    $this->hitratio[$in_backend] = $hitratio;
    $this->hitratioset[$in_backend] = true;
  }
    
  function getHitRatio($in_backend) {
    if(!isset($this->hitratio[$in_backend])) {
      return 0;
    }
    return $this->hitratio[$in_backend];
  }

  // Current Cache
  function setCurrentCache($currentcache, $in_backend) {
    $this->currentcache[$in_backend] = round(($currentcache/1024/1024), 1);
    $this->currentcacheset[$in_backend] = true;
  }
    
  function getCurrentCache($in_backend) {
    if(!isset($this->currentcache[$in_backend])) {
      return 0;
    }
    return $this->currentcache[$in_backend];
  }

  // Max Cache
  function setMaxCache($maxcache, $in_backend) {
    $this->maxcache[$in_backend] = round(($maxcache/1024/1024), 1);
    if(empty($this->currentcache[$in_backend])) {
      $this->currentcache[$in_backend] = 0;
    }

    // if the current cache is bigger than max we have to increase the max.
    if($this->currentcache[$in_backend] > $this->maxcache[$in_backend]) {
      $this->maxcache[$in_backend] = ($this->currentcache[$in_backend] + 1);
      $this->setMessage("Invalid max cache value. Changed to currentvalue + 1", $in_backend);
      $this->setExitCode(1, $in_backend);
    }
    $this->maxcacheset[$in_backend] = true;
  }
  
  function getMaxCache($in_backend) {
    if(!isset($this->maxcache[$in_backend])) {
      return 0;
    }
    return $this->maxcache[$in_backend];
  }

  // Get used cache in percent
  function getUsedPercent($in_backend) {
    if(empty($this->maxcache[$in_backend])) {
      return 0;
    }

    if($this->maxcache[$in_backend] > 0) {
      return round((($this->currentcache[$in_backend] / $this->maxcache[$in_backend]) * 100), 1);
    }
  }

  // Get used cache in percent
  function getUsedEntriesPercent($in_backend) {
    if(empty($this->maxentriescache[$in_backend])) {
      return 0;
    }

    if($this->maxentriescache[$in_backend] > 0) {
      return round((($this->entriesincache[$in_backend] / $this->maxentriescache[$in_backend]) * 100), 1);
    }
  }

  function setMessageBasedOnUsedCache($in_backend) {
    if($this->getUsedPercent($in_backend) > 90) {
      $this->setMessage("Used cache is over 90%", $in_backend);
      $this->setExitCode(3, $in_backend);
    }
    else if($this->getUsedPercent($in_backend) > 70) {
      $this->setMessage("Used cache is over 70%", $in_backend);
      $this->setExitCode(4, $in_backend);
    }
    else {
      $this->setExitCode(0, $in_backend);
    }
  }

  function setExitCode($code, $in_backend) {
    $this->exitcode[$in_backend] = $code;  
  }

  function getExitCode($in_backend) {
    return $this->exitcode[$in_backend];
  }

  function setExitCodeMain($code) {
    $this->exitcodemain = $code;  
  }

  function getExitCodeMain() {
    return $this->exitcodemain;
  }
}

?>
