  /*
    Copyright (C) 2009 - 2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

  /********************************************************************
  * Global variables
  ********************************************************************/
  var preloadImageUp = new Image(32,32); 
  preloadImageUp.src = "icons/minus.png"; 

  var preloadImageUpWarning = new Image(32,32); 
  preloadImageUpWarning.src = "icons/minus_warning.png"; 

  var preloadImageUpError = new Image(32,32); 
  preloadImageUpError.src = "icons/minus_error.png"; 

  var preloadImageDown = new Image(32,32); 
  preloadImageDown.src = "icons/plus.png"; 

  var preloadImageDownOk = new Image(32,32); 
  preloadImageDownOk.src = "icons/alert_ok.png"; 

  var preloadImageDownWarning = new Image(32,32); 
  preloadImageDownWarning.src = "icons/alert_warning.png"; 

  var preloadImageDownError = new Image(32,32); 
  preloadImageDownError.src = "icons/alert_error.png"; 

  var preloadImageLoadingContent = new Image(32,32);
  preloadImageLoadingContent.src = "icons/loading_content.gif"; 

  var preloadImageHostOk = new Image(32,32); 
  preloadImageHostOk.src = "icons/computer_ok.png"; 

  var preloadImageServer = new Image(32,32); 
  preloadImageServer.src = "icons/server.png"; 

  var preloadImageServerHub = new Image(32,32); 
  preloadImageServerHub.src = "icons/server_hub.png"; 

  var preloadImageServerMaster = new Image(32,32); 
  preloadImageServerMaster.src = "icons/server_master.png"; 

  // Reload Timer / Monitoring Attributes
  var reloadTimer = -100;
  var reloadTimerActivated = false;
  var reloadTimerCounter = -1;
  var collectedMonitoringData = new Array();
  
  // if the browser used is IE
  function isIE() {
    if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)) {
      return true;
    }
    return false;
  }

  function openPage(pageName, environmentId, serverId) {
    openPage(pageName, environmentId, serverId, '');
  }

  /*************************************************
  * Basic services URL
  *************************************************/
  function getServiceURL() {
    return "services/serverservice.php?sid=" + usersessionid;
  }

  /*************************************************
  * Services error message
  *************************************************/
  function getServiceError(url) {
    // only show json service errors if loglevel set to 4.
    // this is also to avoid reloading messages if you exit a page.
    if(CNMONITOR_LOGLEVEL > 7) {
      alert("Unable to retrieve service(s) from server!\n" +
            "Please check for error messages in page:\n" + url + "\n\n" +
            "Contact CN=Monitor development for a bugfix.");
    }
  }

  /*************************************************
  * Activate or disable reload page
  * timeout = Set timeout for reload, nothing means disable
  * page = Page to reload, nothing means environments
  * url = URL Options for backward compat.
  *************************************************/
  function reloadPage(inTimer, inPage) {
    reloadTimerCounter = -1;
    $("#configurationDiv").hide();
    if(!inTimer) {
      reloadTimerActivated = false;
      $("#divPageReloadValue").text("");
      $("#imgPageReloadIcon").attr("src", "icons/wall_clock_gray.png");
      selectElementsInList("reloadpage", [ "" ]);
      return;
    }
    reloadTimer = inTimer;
    $("#divPageReloadValue").text(inTimer + "s");
    $("#imgPageReloadIcon").attr("src", "icons/wall_clock.png");
    selectElementsInList("reloadpage", [ inTimer ]);

    if(!reloadTimerActivated) {
      reloadTimerActivated = true;
      
      if(inPage) {
        if(CNMONITOR_ENVIRONMENTID == null) {
          CNMONITOR_ENVIRONMENTID = 0;
        }
        cnmonitorStartMonitoring(CNMONITOR_ENVIRONMENTID, CNMONITOR_ENVIRONMENTID, 
                                 environmentCount, CNMONITOR_SERVERID, inPage);
      }
    }
  }

  /*************************************************
  * buttonReloadPage - quick button function to enable monitoring
  * page = Page to reload, nothing means environments
  *************************************************/
  function buttonReloadPage(inPage) {
    var inTimer = reloadTimer;
    if(inTimer < 0) {
      inTimer = 60;
    }
    // if text is empty
    if($("#divPageReloadValue").text()) {
      reloadPage("", inPage);
      return;
    }
    reloadPage(inTimer, inPage);
  }
  
  /*************************************************
  * Init reload page (new page opened)
  * inEnvironment = Environment id to reload, null = all
  * inServer = Server id to reload, null = all
  * inPage = Page Name
  *************************************************/
  function initReloadPage(inEnvironment, inServer, inPage) {
    if(inEnvironment == null) {
      inEnvironment = 0;
    }
    else {
      environmentCount = inEnvironment;
    }
    if(inServer != null) {
      environmentCount = inEnvironment;
    }
    
    reloadTimerActivated = true;
    reloadTimerCounter = 1;
    cnmonitorStartMonitoring(inEnvironment, inEnvironment, 
                             environmentCount, inServer, inPage);      
  }
  
  /*************************************************
  * Get server status based on environment id
  * envid = Current Environment ID to process
  * startEnvironmentId = Start Environment ID
  * maxEnvironmentId = Max Environment ID
  * page = page to receive feedback
  *************************************************/
  function cnmonitorStartMonitoring(envid, startEnvironmentId, maxEnvironmentId, serverid, page) {
    if(!page) { return; }
    if(!reloadTimerActivated) { return; }
    if(envid > maxEnvironmentId) {
      // check if we have a reload counter
      if(reloadTimerCounter > 0) {
        reloadTimerCounter = (reloadTimerCounter - 1);
      }
      // if reached 0, exit
      if(reloadTimerCounter == 0) {
        reloadTimerCounter = -1;
        reloadTimerActivated = false;
      }
      else {
        // reload counter not used
        setTimeout(function() { cnmonitorStartMonitoring(startEnvironmentId, startEnvironmentId, maxEnvironmentId, serverid, page) }, (reloadTimer * 1000));
      }
      return; 
    }

    url = "";
    if(page == "environments.php") {
      url = getServiceURL() + "&service=serverstatus&environmentid=" + envid;
      $("#envIcon_" + envid).attr("src", preloadImageLoadingContent.src);
    }
    else if(page == "environment.php") {
      url = getServiceURL() + "&service=serverstatus&environmentid=" + envid;
      $("#envIcon_" + envid).attr("src", preloadImageLoadingContent.src);
      if(serverCount != null) {
        for(i = 0; i < serverCount; i++) {
          $("#serverIcon_" + i).attr("src", preloadImageLoadingContent.src);
        }
      }
    }
    else if(page == "server.php") {
      url = getServiceURL() + "&service=serverstatus&environmentid=" + envid + 
                              "&serverid=" + serverid;
      $("#serverIcon").attr("src", preloadImageLoadingContent.src);
    }

    if(url) {
      if(CNMONITOR_LOGLEVEL > 9) { alert(url); }
      $.getJSON(url, function(received) {
        if(page == "environments.php") {
          cnmonitorEnvironmentsStatus(envid, received);
        }
        else if(page == "environment.php") {
          cnmonitorEnvironmentStatus(envid, received);
        }
        else if(page == "server.php") {
          cnmonitorEnvironmentStatus(received);
        }
        cnmonitorStartMonitoring(envid + 1, startEnvironmentId, maxEnvironmentId, serverid, page);
      }).error(function() { 
        // Unable to retrieve JSON data
        if(page == "environments.php") {
          $("#envIcon_" + envid).attr("src", preloadImageDownError.src);
        }
        if(page == "environment.php") {
          $("#envIcon_" + envid).attr("src", preloadImageDownError.src);
          if(serverCount != null) {
            for(i = 0; i < serverCount; i++) {
              $("#serverIcon_" + i).attr("src", preloadImageDownWarning.src);
            }
          }
        }
        else if(page == "server.php") {
          $("#serverIcon").attr("src", preloadImageDownError.src);
        }
        getServiceError(url);
      });
    }
  }

  /*************************************************
  * Set collected monitoring information, supported pie and line graph
  * operation = Type of operation
  * labelid = Id in order 0,1,2...
  * label = Label matching ID
  * value = Value
  * return void
  *************************************************/
  function setCollectedMonitoringData(operation, labelid, label, value) {
    currentMSeconds = new Date().getTime();
    if(!collectedMonitoringData[operation]) {
      collectedMonitoringData[operation] = new Array();
    }
    if(!collectedMonitoringData[operation][labelid]) {
      collectedMonitoringData[operation][labelid] = new Array("data", "label");
      collectedMonitoringData[operation][labelid]["label"] = label;
      collectedMonitoringData[operation][labelid]["data"] = new Array();
    }
    collectIndex = collectedMonitoringData[operation][labelid]["data"].length;
    collectedMonitoringData[operation][labelid]["data"][collectIndex] = new Array(currentMSeconds, value);
    if(collectIndex > 10) {
      collectedMonitoringData[operation][labelid]["data"].shift();
    }
  }

  /*************************************************
  * Show tool tip for Flot graphs
  * x - mouse X position
  * y - mouse Y position
  * content - Information to be displayed
  * prevValue - if present we will compare the value
  *************************************************/
  var cnmonitorPreviousPoint = null;
  function showTooltip(x, y, content, value, prevValue) {
  
    // try to change the position of the tooltip if to far on the right side
    if((x + 220) > $(window).width()) {
      x = (x - 225);
    }

    if(prevValue > 0) {
      value = Math.round(value);
      var difference = (value - prevValue);
      var percentage = Math.round((difference / prevValue) * 100);
      var valueStatusImg = preloadImageMiddleRight.src;
      if(difference > 0) {
        valueStatusImg = preloadImageTopRight.src;    
      }
      else if(difference < 0) {
        valueStatusImg = preloadImageDownRight.src;    
      }
      var content = "<table cellpadding='5' border='0'><tr style='color:fff;'>" +
                    "<td><img src='"+  valueStatusImg + "' width='24'></td><td>" + difference + "</td>" +
                    "<td>" + percentage + "%</td></tr><tr style='color:fff;'>" +
                    "<td>&nbsp;</td><td colspan='2'>" + value + "</td>" +
                    "</tr></table>";
    }
    // CSS can not be referenced as a class in IE, has to be included
    $("<div id='cnmonitorTooltip' class='cnmonitorTooltip'>" + content +
      "</div>").css({
        position: 'absolute',
        display: 'none',
        border: '1px solid #CCC',
        padding: '5px',
        width: '200px',
        color: '#fff',
        'background-color': '#000',
        opacity: '0.80',
        '-moz-border-radius': '5px',
        '-webkit-border-radius': '5px',
        'border-radius': '5px 5px 5px 5px',
        top: y - 20,
        left: x + 5      
      }).appendTo("body").fadeIn(400);
  }

  /*************************************************
  * Flot Pie Graph Hover Function
  *************************************************/  
  function setFlotPieLineGraphHover(event, pos, obj) {
    if (!obj) {
      $("#cnmonitorTooltip").remove();
      cnmonitorPreviousPoint = null;
      return;
    }
    var setValue = "";
    var setPercent = "";
    // using JQuery to strip any labels with anchor refs
    if(obj.series.label.indexOf("<a") != -1) {
      var setText = "<b>" + $(obj.series.label).text() + "</b><br><br>";
    }
    else {
      var setText = "<b>" + obj.series.label + "</b><br><br>";
    }    
    if(obj.series.pie["show"]) {
      setValue = obj.series.data[0][1];
      setPercent = parseFloat(obj.series.percent).toFixed(2);
      setText = setText + "<b>" + setValue + "</b> (" + setPercent + "%)";
    }
    else {
      setValue = obj.datapoint[1];
      nTime = obj.datapoint[0];
      dateObj = new Date();
      dateObj.setTime(nTime);
      var setTime = createDateBasedOnObject(dateObj) + " " + getTimeUTC(dateObj, "hour") +
                                                       ":" + getTimeUTC(dateObj, "minute") +
                                                       ":" + getTimeUTC(dateObj, "second");      
      setText = setText + setTime + "<br><b>= " + setValue + "</b>";
    }
    
    if(cnmonitorPreviousPoint != setValue) {
      var removeAnchor = [];
      cnmonitorPreviousPoint = setValue;
      $("#cnmonitorTooltip").remove();
      showTooltip(pos.pageX, pos.pageY, setText, setValue, 0);
    }
  }

  /*************************************************
  * Get default monitoring options based on server
  * v = Vendor key
  * Will return exec_time as default value
  *************************************************/
  function cnmonitorDefaultMonitoring(v) {
    if((v == "openldap") || (v == "fedora") || (v == "redhat") || (v == "netscape") ||
       (v == "sun") || (v == "ibm") || (v == "opends")) {
      return ["ent_sent", "search", "tot_con"];
    }
    else if(v == "novell") {
      return ["search", "kbyte_sent"];
    }
    return ["exec_time"];
  }

  function displayEnvironment(oObject) {
    if(oObject.value != "") {
      top.location.href = "index.php?environmentid=" + oObject.value + "&settab=environment_availability";
    }
  }

  function onSubmitQueryConfig(oForm) {
    var url = "index.php?queryserver=" + oForm.queryconfigtext.value;
    top.location.href = url;
    return false;
  }
    
  function openPage(pageName, environmentId, serverId, urladdition) {
    window.top.location = "index.php?page=" + pageName + "&environmentid=" + environmentId + "&serverid=" + serverId + "&" + urladdition;
  }

  // open page by format <page>,<environmentid>,<serverid>
  function openPageBySelectMenu(selectObject) {
    if(selectObject.value == "") {
      return;
    }
    var elements = selectObject.value.split(",");
    if(elements.length == 2) {
      openPage(elements[0], elements[1], '', '');
    }
    else if(elements.length == 3) {
      openPage(elements[0], elements[1], elements[2], '');
    }
    else if(elements.length == 4) {
      openPage(elements[0], elements[1], elements[2], elements[3]);
    }
    return;
  }

  function showTab(tabId) {
    preloadtab = tabId;
    var currentObject = null;
    // hide tabs
    var tabs = availableTabs.split(";");
    for(var i = 0; i < tabs.length; i++) {
      // remove display of object
      currentObject = document.getElementById(tabs[i]);
      currentObject.style.display = "none";
      // remove selected class on all other elements
      currentObject = document.getElementById("tab_" + tabs[i]);
      currentObject.className = "";
    }

    // finally set the correct tab to visible
     currentObject = document.getElementById(tabId);
     currentObject.style.display = "inline";
     // set selected tab on element
     currentObject = document.getElementById("tab_" + tabId);
     currentObject.className = "selectedTab";

    if(typeof cnmonitorTabSwitch == 'function') {
      cnmonitorTabSwitch(tabId);
    }
    return;
  }
    

// show more info rows
function showHideRow(rowId, status) {
  var oImage = document.getElementById("moreinfo_image_" + rowId);

  var oElement = document.getElementById("moreinfo_" + rowId);
  if(oElement.style.visibility == "hidden") {
    oElement.style.visibility = "visible";
    // as IE isn't supporting table-row
    if(isIE()) {
      oElement.style.display = 'inline';
    }
    else {
      oElement.style.display = 'table-row';
    }
    if(status == "warning") {
      oImage.src = preloadImageUpWarning.src;
    }
    else if(status == "error") {
      oImage.src = preloadImageUpError.src;
    }
    else {
      oImage.src = preloadImageUp.src;
    }
  }
  else {
    oElement.style.visibility = "hidden";
    oElement.style.display = 'none';
    if(status == "warning") {
      oImage.src = preloadImageDownWarning.src;
    }
    else if(status == "error") {
      oImage.src = preloadImageDownError.src;
    }
    else {
      oImage.src = preloadImageDown.src;
    }
  }
}

// show more info rows
function showHideServerMenu(rowId, status) {
  var oImage = document.getElementById("moreinfo_image_" + rowId);

  var oElement = document.getElementById("moreinfo_" + rowId);
  if(oElement.style.visibility == "visible") {
    oElement.style.visibility = "hidden";
    if(status == "warning") {
      oImage.src = preloadImageDownWarning.src;
    }
    else if(status == "error") {
      oImage.src = preloadImageDownError.src;
    }
    else {
      oImage.src = preloadImageDown.src;
    }
  }
  else {
    oElement.style.visibility = "visible";

    oElement.style.left = (xMousePos + 10);
    oElement.style.top  = (yMousePos + 5);

    if(status == "warning") {
      oImage.src = preloadImageUpWarning.src;
    }
    else if(status == "error") {
      oImage.src = preloadImageUpError.src;
    }
    else {
      oImage.src = preloadImageUp.src;
    }
  }
}

/************************************
* Trigger Test Authentication Method
************************************/
  function testAuthentication(oForm, servername, authreset) {
  
    var options = "";
    var authdn = oForm.authdn.value;
    var authpassword = oForm.authpassword.value;
    var authlevel = getCheckOrRadioValue(oForm.authlevel);
    var authsecurity = getCheckOrRadioValue(oForm.authsecurity);

    setStyleProperty(oForm.authdn, "border-width", "2");
    setStyleProperty(oForm.authdn, "border-style", "solid");
    setStyleProperty(oForm.authdn, "border-color", "#CCCCCC");
    setStyleProperty(oForm.authpassword, "border-width", "2");
    setStyleProperty(oForm.authpassword, "border-style", "solid");
    setStyleProperty(oForm.authpassword, "border-color", "#CCCCCC");

    $("#authimagestatus").attr("src", preloadImageLoadingContent.src);

    options = authdn;
    options += ";" + authpassword;
    options += ";" + authlevel;
    options += ";" + authsecurity;
    options += ";" + authreset;
    $.post("services/serverservice.php", { 
      "service": "authenticate",
      "sid": usersessionid,
      "q": options,
      "servername": servername },
      function(data){
        if(data.success) {
          // reload page
          window.location.reload();
        }
        else {
          $("#authimagestatus").attr("src", preloadImageDownError.src);
          setStyleProperty(oForm.authdn, "border-width", "2");
          setStyleProperty(oForm.authdn, "border-style", "solid");
          setStyleProperty(oForm.authdn, "border-color", "red");
          setStyleProperty(oForm.authpassword, "border-width", "2");
          setStyleProperty(oForm.authpassword, "border-style", "solid");
          setStyleProperty(oForm.authpassword, "border-color", "red");
          oForm.authpassword.value = "";
          oForm.authpassword.focus();
        }
    }, "json");
  }

/************************************
* Get event source
************************************/
function eventTarget(event) {
  event = event || window.event;
  return (event.target || event.srcElement);
}

/************************************
* Get current event source
************************************/
function currentEventTarget(event) {
  event = event || window.event;
  return (event.currentTarget || event.srcElement);
}

function queryConfigSetStyle(oConfig, defaultValue) {
  oConfig.style.color = "#000000";
  if(oConfig.value == defaultValue) {
    oConfig.value = "";  
  }
}

/************************************
* Query configuration on enter
************************************/
function setStyleProperty(currObject, name, value) {
  if(isIE()) {
    currObject.style[name] = value;
  }
  else {
    // w3c compatible
    currObject.style.setProperty(name, value, null);
  }
}

/************************************
* Show hide element
************************************/
function showHideElement(sElementName) {
  var oElement = document.getElementById(sElementName);
  var visibility = oElement.style.visibility;
  if(!visibility) {
    oElement.style.visibility = "visible";
  }
  else if(visibility == "visible") {
    oElement.style.visibility = "hidden";
  }
  else {
    oElement.style.visibility = "visible";
  }
}

/************************************
* Trims value
************************************/
function trim(value) {
 return value.replace(/^\s+|\s+$/, '')
}

/************************************
* General get checked radio value
************************************/
  function getCheckOrRadioValue(oRadio) {
    var value = "";
    for(var i = 0; i < oRadio.length; i++) {
      if(oRadio[i].checked) {
        value = oRadio[i].value;
      }
    }
    return value;
  }

  // Capture Mouse Position
  function captureMousePosition(e) {
    if (document.all) {
      xMousePos = window.event.x+document.body.scrollLeft;
      yMousePos = window.event.y+document.body.scrollTop;
    } else if (document.getElementById) {
      xMousePos = e.pageX;
      yMousePos = e.pageY;
    }
  }
  xMousePos = 0;
  yMousePos = 0;
  if (document.all) { // Internet Explorer
    document.onmousemove = captureMousePosition;
  } else if (document.getElementById) { // Netcsape 6
    document.onmousemove = captureMousePosition;
  }

  // Monitoring step forward or backward the amount of time that is monitored
/*REMOVE
  function graphStepFwdOrBwd(direction) {
    // Get timestamp for date
    currentTimeFrom = getTimeStampByDateForm("backward");
    currentTimeTo = getTimeStampByDateForm("forward");

    timeDifference = (currentTimeTo - currentTimeFrom);
    if(direction == "backward") {
      newTimeFrom = (currentTimeFrom - timeDifference);
      newTimeTo = (currentTimeTo - timeDifference);
    }
    else {
      newTimeFrom = (currentTimeFrom + timeDifference);
      newTimeTo = (currentTimeTo + timeDifference);    
    }
    setDateBasedOnTimeStamp(newTimeFrom, newTimeTo);
  }
*/

/* REMOVE
  function getTimeStampByDateForm(direction) {
    var oForm = document.forms['servergraph'];
    if(direction == "backward") {
      var sDate = oForm.monitordatestart.value;
          sDate += " " + oForm.monitordatestarthour.value;
          sDate += ":" + oForm.monitordatestartminute.value;
          sDate += ":" + oForm.monitordatestartsecond.value;
    }
    else {
      var sDate = oForm.monitordateend.value;
          sDate += " " + oForm.monitordateendhour.value;
          sDate += ":" + oForm.monitordateendminute.value;
          sDate += ":" + oForm.monitordateendsecond.value;
    }
    timeStamp = getDateFromFormat(sDate, "yyyy-MM-dd HH:mm:ss");
    return timeStamp;
  }
*/

  function setDateBasedOnTimeStamp(timestampStart, timestampEnd, isUTC) {
    var dateObj = new Date();
    if(timestampStart) {
      dateObj = new Date();
      dateObj.setTime(timestampStart);
      document.forms['servergraph'].monitordatestart.value = createDateBasedOnObject(dateObj, isUTC);
      if(!isUTC) {
        document.forms['servergraph'].monitordatestarthour.value = getTime(dateObj, "hour");
        document.forms['servergraph'].monitordatestartminute.value = getTime(dateObj, "minute");
        document.forms['servergraph'].monitordatestartsecond.value = getTime(dateObj, "second");
      }
      else {
        document.forms['servergraph'].monitordatestarthour.value = getTimeUTC(dateObj, "hour");
        document.forms['servergraph'].monitordatestartminute.value = getTimeUTC(dateObj, "minute");
        document.forms['servergraph'].monitordatestartsecond.value = getTimeUTC(dateObj, "second");
      }
    }
    if(timestampEnd) {
      dateObj = new Date();
      dateObj.setTime(timestampEnd);
      document.forms['servergraph'].monitordateend.value   = createDateBasedOnObject(dateObj, isUTC);
      if(!isUTC) {
        document.forms['servergraph'].monitordateendhour.value = getTime(dateObj, "hour");
        document.forms['servergraph'].monitordateendminute.value = getTime(dateObj, "minute");
        document.forms['servergraph'].monitordateendsecond.value = getTime(dateObj, "second");
      }
      else {
        document.forms['servergraph'].monitordateendhour.value = getTimeUTC(dateObj, "hour");
        document.forms['servergraph'].monitordateendminute.value = getTimeUTC(dateObj, "minute");
        document.forms['servergraph'].monitordateendsecond.value = getTimeUTC(dateObj, "second");
      }
    }
  }

  // Adding zero for dates less than 10
  function getTime(dateObject, type) {
    var str = "";
    if(type == "hour") {
      if(dateObject.getHours() < 10) {
        str += "0";
      }
      str += parseInt(dateObject.getHours());
    }
    if(type == "minute") {
      if(dateObject.getMinutes() < 10) {
        str += "0";
      }
      str += parseInt(dateObject.getMinutes());
    }
    if(type == "second") {
      if(dateObject.getSeconds() < 10) {
        str += "0";
      }
      str += parseInt(dateObject.getSeconds());
    }
    return str;
  }

  // Adding zero for dates less than 10
  function getTimeUTC(dateObject, type) {
    var str = "";
    if(type == "hour") {
      if(dateObject.getUTCHours() < 10) {
        str += "0";
      }
      str += dateObject.getUTCHours();
    }
    if(type == "minute") {
      if(dateObject.getUTCMinutes() < 10) {
        str += "0";
      }
      str += dateObject.getUTCMinutes();
    }
    if(type == "second") {
      if(dateObject.getUTCSeconds() < 10) {
        str += "0";
      }
      str += dateObject.getUTCSeconds();
    }
    return str;
  }
  
  // Adding zero for dates less than 10
  function createDateBasedOnObject(dateObject, isUTC) {
    var str = "";
    if(!isUTC) {
      str = dateObject.getFullYear();
    }
    else {
      str = dateObject.getUTCFullYear();
    }
    str += "-";
    if(!isUTC) {
      if((dateObject.getMonth() + 1) < 10) {
        str += "0";
      }
      str += (dateObject.getMonth() + 1);
    }
    else {
      if((dateObject.getUTCMonth() + 1) < 10) {
        str += "0";
      }
      str += (dateObject.getUTCMonth() + 1);
    }
    str += "-";
    if(!isUTC) {
      if(dateObject.getDate() < 10) {
        str += "0";
      }
      str += dateObject.getDate();
    }
    else {
      if(dateObject.getUTCDate() < 10) {
        str += "0";
      }
      str += dateObject.getUTCDate();
    }
    return str;
  }

  jQuery.extend({
    compareArray: function (arrayA, arrayB) {
      if (arrayA.length != arrayB.length) { return false; }
      var a = jQuery.extend(true, [], arrayA);
      var b = jQuery.extend(true, [], arrayB);
      a.sort(); 
      b.sort();
      for (var i = 0, l = a.length; i < l; i++) {
        if (a[i] !== b[i]) { 
          return false;
        }
      }
      return true;
    }
  });
