  /*
    Copyright (C) 2009 - 2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/************************************
* Find offset location
************************************/
function findPos(oElement) {
  var curleft = curtop = 0;

  if (oElement.offsetParent) {
    do {
      curleft += oElement.offsetLeft;
      curtop += oElement.offsetTop;
    } while (oElement = oElement.offsetParent);
  }
  
  return [curleft,curtop];
}


/************************************
* Event on keydown to trigger list
************************************/
function eventKeydDownText(e) {

  var oText = eventTarget(e);
  var oSelect = document.getElementById(oText.getAttribute("custom_options"));

  var keyCode = e.keyCode;

  if(!oSelect) {
    return true;
  }

  if(keyCode == 13) {
    addValueToValueObject(oText, oText.value);
    return false;
  }
  else if(keyCode == 8) {
    // disable backspace key
    return true;
  }
  else if (keyCode == 40 || keyCode == 46) {
    showAndSetFocusSelect(oText.getAttribute("custom_options"));
  }
  else if (keyCode < 32 || (keyCode >= 33 && keyCode < 46) || (keyCode >= 112 && keyCode <= 123)) {
    return true;
  }
  else {
    // run service
    var runService = oText.getAttribute("custom_service");
    if(!runService) {
      return true;
    }

    var servername = oText.getAttribute("custom_hostname");
    if(!servername) {
      return true;
    }

    var select = oText.getAttribute("custom_options");
    if(!select) {
      return true;
    }

    setSelectPosition(oSelect, oText);
    
    currentSelectObject = document.getElementById(select);
    if(!currentSelectObject) {
      return true;
    }
    queryServices(runService, servername, oText.value);
  }
  
  return true;
}

/************************************
* Event on blur for list
************************************/
function eventBlurSelect(e) {
  var oSelect = eventTarget(e);
  oSelect.style.visibility = "hidden";
}

/************************************
* Event on keydown for list
************************************/
function eventKeyDownSelect(e) {
  var oSelect = eventTarget(e);
  var oText = document.getElementById(oSelect.getAttribute("custom_text"));

  var keyCode = e.keyCode;
  if(!oText) {
    return;
  }
  
  if(keyCode == 8) {
    // disable backspace key
    oText.focus();
    return false;
  }
  else if(keyCode == 38) {
    // quit on zero
    if(oSelect.selectedIndex == 0) {
      oText.focus();
    }
  }
  else if(keyCode == 13) {
    addValueToValueObject(oText, oSelect.value);
    oText.focus();
    return false;
  }  
}

/************************************
* Track events on value objects
************************************/
function eventKeyDownValue(e) {
  var oValue = eventTarget(e);
  var oText = document.getElementById(oValue.getAttribute("custom_text"));

  var keyCode = e.keyCode;

  if(!oText) {
    return;
  }
  
  if(keyCode == 8) {
    oText.focus();
    removeElementFromList(oValue);
    return false;
  }
}


/************************************
* Event on mousedown for list
************************************/
function eventMouseDownSelect(e) {

  var oSelect = currentEventTarget(e);

  if(!oSelect.getAttribute("custom_text")) {
    return false;
  }

  var oText = document.getElementById(oSelect.getAttribute("custom_text"));
  if(!oText) {
    return;
  }

  addValueToValueObject(oText, oSelect.value);
  oText.focus();
}

/************************************
* Sets focus, displays select box and sets correct location
************************************/
function setCorrectLocationOnSelect(sSelect, sText) {
  showAndSetFocusSelect(sSelect);
  var oSelect = document.getElementById(sSelect);
  var oText = document.getElementById(sText);
  setSelectPosition(oSelect, oText);
}

/************************************
* Add Value to Value Object if exists
* Params oText object
*        text value
* Return true on success
************************************/
function addValueToValueObject(oText, value) {

  // if empty return
  if(!value) {
    return;
  }

  // test if there is a value object present
  if(!oText.getAttribute("custom_value")) {
    oText.value = value;
    return false;
  }
  
  var oValue = document.getElementById(oText.getAttribute("custom_value"));
  if(oValue) {
    // value object exists. Now we need to know what kind
    if(oValue.value) {
      oValue.value = value;
    }
    else if(oValue.options) {
      addElementToList(oValue, value, value, "");
    }
  }
  else {
    return false;
  }
  return true;
}

/************************************
* Remove elements in list
************************************/
function removeElementFromList(oElement) {
  if(!oElement) {
    return;
  }

  if(!oElement.options) {
    return;
  }

  var lengthBeforeRemoval = oElement.options.length;
  for (var i = (lengthBeforeRemoval - 1); i >= 0; i--) {
    if (oElement.options[i].selected) {
      oElement.remove(i);
    }
  }
}

/************************************
* Remove all elements in list
************************************/
function removeAllElementsInList(oElement) {
  var lengthBeforeRemoval = oElement.options.length;
  for (var i = (lengthBeforeRemoval - 1); i >= 0; i--) {
    oElement.remove(i);
  }
}

/************************************
* Add element in list
* Option oList = List Object
*        listname = Displayed Value Text
*        Listvalue = Value
*        style = in format "attribute:value;attribute2:value;"
************************************/
function addElementToList(oList, listname, listvalue, style) {

  if(!oList) {
    return;
  }

  var optionSize = oList.options.length;
  oList.options[optionSize] = new Option(trim(listname), trim(listvalue), false, false);
  
  if(style) {
    var aStyleList = style.split(";");
    for(var i = 0; i < aStyleList.length; i++) {
      if(aStyleList[i]) {
        aStyle = aStyleList[i].split(":");
        setStyleProperty(oList.options[optionSize], aStyle[0], aStyle[1]);
      }
    }
  }
}

/************************************
* Add element in list
* listName = Listname ID String
* values = Array of values to select
************************************/
function selectElementsInList(listName, values) {
  for(var i = 0; i < values.length; i++) {
    $("#" + listName + " option[value=" + values[i] + "]").attr("selected",true);
  }
}

/************************************
* Get selected elements in list
* listName = Listname ID String
* return elements in list
************************************/
function getSelectedElementsInList(listName) {
  // returns array or string depending on multivalue settings
  return $("#" + listName).val();
}


/************************************
* Add single value to a list
* textField = ID of Text field
* listName = ID of List box
************************************/
function cnmonitorAddValueToList(textField, listName) {
  if($("#" + textField).val()) {
    var inVal = $("#" + textField).val();
    $("#" + listName).append($('<option>', { 
      value : inVal }).text(inVal)); 
  }
}

/************************************
* Set Listbox location on screen
************************************/
function setSelectPosition(oSelect, oText) {
  var aPosition = findPos(oText);
  oSelect.style.left = aPosition[0];
  if(isIE()) {
    var addHeight = 20;
  }
  else {
    var addHeight = 17;
  }
  oSelect.style.top = (aPosition[1] + addHeight);
  oSelect.style.width = oText.offsetWidth;
}

/************************************
* Sets focus and displays select box
************************************/
function showAndSetFocusSelect(sElementName) {
  var oSelect = document.getElementById(sElementName);
  var visibility = oSelect.style.visibility;
  oSelect.style.visibility = "visible";
  oSelect.focus();
}

