/**
 * jQuery Plugin for creating AJAX auto-suggest textfield
 * @requires jQuery 1.4 or later
 *
 * Copyright (c) 2011 Lucky
 * Licensed under the GPL license:
 *   http://www.gnu.org/licenses/gpl.html
 * Andreas - fixed me.idField, check for null, reported to author
 */

(function($) {
	function autosuggest(callBackUrl, textField){
		this.divId="suggestions_holder";
		this.hovered=false;
		this.arrData=null;
		
		this.textField=textField;
		this.callBackUrl=callBackUrl;
		
		var width=this.textField.width() + 3;
		var minChars=1;
		var currRow=0;
		var suggestRow="suggest_row";
		var suggestItem="suggest_item";
		
		this.idField=null;
		this.submitOnSelect=false;
		this.thumbnail=false;
		this.description=false;
		
		this.textField.after('<div class="suggestions" id="' + this.divId + '"></div>');
		this.textField.attr("autocomplete", "off");
		
		this.holder=this.textField.next("#" + this.divId);
		this.holder.hide();
		
		var me=this;
		this.textField.keyup(
			function(e){
				if(e.keyCode!=37 && e.keyCode!=38 && e.keyCode!=39 && e.keyCode!=40 && e.keyCode!=13){
					if($(this).val().length>=minChars){
						$.ajax({
							url:me.callBackUrl + $(this).val(),
							success:function(data){
								try{
									me.arrData=$.parseJSON(data);
									
									var arr=me.arrData;
									var html="";
									
									currRow=0;
									
									if(arr==null){
										me.hide();
									}
									else{
										if(arr.length>0){
											for(i=0;i<arr.length;i++){
												cssClass=suggestItem;
												
												if(i==0){
													cssClass+=" first";
												}
												if(i==(arr.length-1)){
													cssClass+=" last";
												}
												
												var id_field='';
												if(me.idField!=null){
													id_field=' id_field="' + arr[i].id + '"';
												}
												
												var thumb="";
												if(me.thumbnail==true){
													var style="";
													if(arr[i].thumbnail!=undefined){
														style=' style="background-image:url(' + arr[i].thumbnail + ');"';
													}
													thumb='<div class="thumbnail"' + style + '></div>';
												}
												
												var desc="";
												if(me.description==true){
													if(arr[i].description!=undefined){
														desc='<div class="description">' + arr[i].description + '</div>';
													}
												}
												
												html+='<div id="' + suggestRow + (i+1) + '" class="' + cssClass + '"' + id_field + '>' + thumb + '<div class="suggestion_title">' + arr[i].data.replace(new RegExp('(' + me.textField.val() + ')', 'gi'), "<b>$1</b>") + '</div>' + desc + '</div>';
											}
											
											me.holder.html(html);
											
											for(i=1;i<=arr.length;i++){
												var target=me.holder.find("#" + suggestRow + i);
												target.mouseover(function(e){
													me.hovered=true;
													me.unSelectAll(this);
													$(this).addClass("selected");
												});
												
												target.mouseout(function(e){
													me.hovered=false;
													$(this).removeClass("selected");
												});
												
												target.click(function(e){
													me.textField.val($(this).find(".suggestion_title").text());
													if(me.idField!=null){
														me.idField.val($(this).attr("id_field"));
													}
													
													if(me.submitOnSelect==true){
														$("form").has(me.textField).submit();
													}
													me.hide();
												});
											}
											
											me.show(me.holder.find("." + suggestItem).height() * arr.length);
										}
										else{
											me.hide();
										}
									}
								}
								catch(e){
									alert('Sorry, an error has occured!');
								}
							},
							error: function(xhr, status, ex){
								alert('Sorry, an error has occured!');
							}
						});
					}
					else{
						me.hide();
					}
				}
				else{
					if(me.holder.css("display")!="none"){
						checkKey(e);
					}
				}
			}
		);
		
		this.textField.bind(
			"blur",
			function(e){
				if(me.idField!=null){
					if(me.checkSelected(me.textField.val())==false){
						me.textField.val("");
						me.idField.val("");
					}
				}
				
				if(me.hovered==false){
					me.hide();
				}
				else{
					me.hovered=false;
				}
			}
		);
		
		this.show=function(height){
			this.holder.css({
				"position":"absolute",
				"left":this.textField.position().left + "px",
				"top":this.textField.position().top + this.textField.height() + 5 + "px",
				"height":height + "px"
			});
			
			this.holder.css({
				"width":width + "px"
			});
			
			this.holder.find("." + suggestItem).css({
				"width":width + "px",
				"overflow":"hidden"
			});
			
			this.holder.show();
		}
		
		this.hide=function(){
			this.holder.hide();
		}
		
		this.unSelectAll=function(div){
			var id=$(div).attr("id");
			var rows=this.holder.find("." + suggestItem).get().length;
			
			for(i=1;i<=rows;i++){
				this.holder.find("#" + suggestRow + i).removeClass("selected");
			}
			
			currRow=parseInt(id.replace(suggestRow, ""));
			var rgx=/^[0-9]+$/;
			if(!rgx.test(currRow)){
				currRow=0;
			}
		}
		
		this.setWidth=function(w){
			width=w;
		}
		
		this.setMinChars=function(c){
			minChars=c;
		}
		
		this.preventEnter=function(){
			this.textField.keypress(
				function(e){
					if(e.keyCode==13){
						return false;
					}
					
					return true;
				}
			);
		}
		
		this.checkSelected=function(data){
			if(this.arrData!=null){
				for(var i=0;i<this.arrData.length;i++){
					if(this.arrData[i].data==data){
						return true;
					}
				}
			}
			
			return false;
		}
		
		function checkKey(e){
			if(me.holder.css("display")!="none"){
				var rows=me.holder.find("." + suggestItem).get().length;
				if(e.keyCode==40){
					currRow++;
					if(currRow<=rows){
						if(currRow>0){
							me.holder.find("#" + suggestRow + (currRow-1)).removeClass("selected");
						}
						
						var target=me.holder.find("#" + suggestRow + currRow);
						
						target.addClass("selected");
						me.textField.val(target.find(".suggestion_title").text());
						if(me.idField != null) {
							me.idField.val(target.attr("id_field"));
						}
					}
					else{
						currRow=rows;
					}
				}
				else if(e.keyCode==38){
					currRow--;
					if(currRow>0){
						if(currRow<rows){
							me.holder.find("#" + suggestRow + (currRow+1)).removeClass("selected");
						}
						
						var target=me.holder.find("#" + suggestRow + currRow);
						
						target.addClass("selected");
						me.textField.val(target.find(".suggestion_title").text());
						if(me.idField != null) {
							me.idField.val(target.attr("id_field"));
						}
					}
					else{
						currRow=1;
					}
				}
				else if(e.keyCode==13){
					if(me.idField!=null){
						if(me.checkSelected(me.textField.val())==false){
							me.textField.val("");
							me.idField.val("");
						}
					}
					
					me.hide();
				}
			}
			
			return true;
		}
	}
	
	$.fn.coolautosuggest = function(options) {
		var settings = {
			width: null,
			minChars: null,
			idField: null,
			submitOnSelect: false,
			showThumbnail : false,
			showDescription : false
		};
		$.extend(settings, options);
		
		return this.each(function() {
			var obj = new autosuggest(settings.url, $(this));
			
			if(settings.width!=null){
				obj.setWidth(settings.width);
			}
			
			if(settings.minChars!=null){
				obj.setMinChars(settings.minChars);
			}
			
			if(settings.idField!=null){
				obj.idField=settings.idField;
				obj.preventEnter();
			}
			
			if(settings.submitOnSelect==true){
				obj.submitOnSelect=true;
			}
			else{
				obj.preventEnter();
			}
			
			if(settings.showThumbnail==true){
				obj.thumbnail=settings.showThumbnail;
			}
			
			if(settings.showDescription==true){
				obj.description=settings.showDescription;
			}
			
			if(obj.idField!=null){
				if(obj.checkSelected(obj.textField.val())==false){
					obj.textField.val("");
					obj.idField.val("");
				}
			}
		});
	}
})(jQuery);

 /*
 * TipTip
 * Copyright 2010 Drew Wilson
 * www.drewwilson.com
 * code.drewwilson.com/entry/tiptip-jquery-plugin
 *
 * Version 1.3   -   Updated: Mar. 23, 2010
 *
 * This Plug-In will create a custom tooltip to replace the default
 * browser tooltip. It is extremely lightweight and very smart in
 * that it detects the edges of the browser window and will make sure
 * the tooltip stays within the current window size. As a result the
 * tooltip will adjust itself to be displayed above, below, to the left 
 * or to the right depending on what is necessary to stay within the
 * browser window. It is completely customizable as well via CSS.
 *
 * This TipTip jQuery plug-in is dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 */
(function($){$.fn.tipTip=function(options){var defaults={activation:"hover",keepAlive:false,maxWidth:"200px",edgeOffset:3,defaultPosition:"bottom",delay:400,fadeIn:200,fadeOut:200,attribute:"title",content:false,enter:function(){},exit:function(){}};var opts=$.extend(defaults,options);if($("#tiptip_holder").length<=0){var tiptip_holder=$('<div id="tiptip_holder" style="max-width:'+opts.maxWidth+';"></div>');var tiptip_content=$('<div id="tiptip_content"></div>');var tiptip_arrow=$('<div id="tiptip_arrow"></div>');$("body").append(tiptip_holder.html(tiptip_content).prepend(tiptip_arrow.html('<div id="tiptip_arrow_inner"></div>')))}else{var tiptip_holder=$("#tiptip_holder");var tiptip_content=$("#tiptip_content");var tiptip_arrow=$("#tiptip_arrow")}return this.each(function(){var org_elem=$(this);if(opts.content){var org_title=opts.content}else{var org_title=org_elem.attr(opts.attribute)}if(org_title!=""){if(!opts.content){org_elem.removeAttr(opts.attribute)}var timeout=false;if(opts.activation=="hover"){org_elem.hover(function(){active_tiptip()},function(){if(!opts.keepAlive){deactive_tiptip()}});if(opts.keepAlive){tiptip_holder.hover(function(){},function(){deactive_tiptip()})}}else if(opts.activation=="focus"){org_elem.focus(function(){active_tiptip()}).blur(function(){deactive_tiptip()})}else if(opts.activation=="click"){org_elem.click(function(){active_tiptip();return false}).hover(function(){},function(){if(!opts.keepAlive){deactive_tiptip()}});if(opts.keepAlive){tiptip_holder.hover(function(){},function(){deactive_tiptip()})}}function active_tiptip(){opts.enter.call(this);tiptip_content.html(org_title);tiptip_holder.hide().removeAttr("class").css("margin","0");tiptip_arrow.removeAttr("style");var top=parseInt(org_elem.offset()['top']);var left=parseInt(org_elem.offset()['left']);var org_width=parseInt(org_elem.outerWidth());var org_height=parseInt(org_elem.outerHeight());var tip_w=tiptip_holder.outerWidth();var tip_h=tiptip_holder.outerHeight();var w_compare=Math.round((org_width-tip_w)/2);var h_compare=Math.round((org_height-tip_h)/2);var marg_left=Math.round(left+w_compare);var marg_top=Math.round(top+org_height+opts.edgeOffset);var t_class="";var arrow_top="";var arrow_left=Math.round(tip_w-12)/2;if(opts.defaultPosition=="bottom"){t_class="_bottom"}else if(opts.defaultPosition=="top"){t_class="_top"}else if(opts.defaultPosition=="left"){t_class="_left"}else if(opts.defaultPosition=="right"){t_class="_right"}var right_compare=(w_compare+left)<parseInt($(window).scrollLeft());var left_compare=(tip_w+left)>parseInt($(window).width());if((right_compare&&w_compare<0)||(t_class=="_right"&&!left_compare)||(t_class=="_left"&&left<(tip_w+opts.edgeOffset+5))){t_class="_right";arrow_top=Math.round(tip_h-13)/2;arrow_left=-12;marg_left=Math.round(left+org_width+opts.edgeOffset);marg_top=Math.round(top+h_compare)}else if((left_compare&&w_compare<0)||(t_class=="_left"&&!right_compare)){t_class="_left";arrow_top=Math.round(tip_h-13)/2;arrow_left=Math.round(tip_w);marg_left=Math.round(left-(tip_w+opts.edgeOffset+5));marg_top=Math.round(top+h_compare)}var top_compare=(top+org_height+opts.edgeOffset+tip_h+8)>parseInt($(window).height()+$(window).scrollTop());var bottom_compare=((top+org_height)-(opts.edgeOffset+tip_h+8))<0;if(top_compare||(t_class=="_bottom"&&top_compare)||(t_class=="_top"&&!bottom_compare)){if(t_class=="_top"||t_class=="_bottom"){t_class="_top"}else{t_class=t_class+"_top"}arrow_top=tip_h;marg_top=Math.round(top-(tip_h+5+opts.edgeOffset))}else if(bottom_compare|(t_class=="_top"&&bottom_compare)||(t_class=="_bottom"&&!top_compare)){if(t_class=="_top"||t_class=="_bottom"){t_class="_bottom"}else{t_class=t_class+"_bottom"}arrow_top=-12;marg_top=Math.round(top+org_height+opts.edgeOffset)}if(t_class=="_right_top"||t_class=="_left_top"){marg_top=marg_top+5}else if(t_class=="_right_bottom"||t_class=="_left_bottom"){marg_top=marg_top-5}if(t_class=="_left_top"||t_class=="_left_bottom"){marg_left=marg_left+5}tiptip_arrow.css({"margin-left":arrow_left+"px","margin-top":arrow_top+"px"});tiptip_holder.css({"margin-left":marg_left+"px","margin-top":marg_top+"px"}).attr("class","tip"+t_class);if(timeout){clearTimeout(timeout)}timeout=setTimeout(function(){tiptip_holder.stop(true,true).fadeIn(opts.fadeIn)},opts.delay)}function deactive_tiptip(){opts.exit.call(this);if(timeout){clearTimeout(timeout)}tiptip_holder.fadeOut(opts.fadeOut)}}})}})(jQuery);

var jstz=function(){var b=function(a){a=-a.getTimezoneOffset();return null!==a?a:0},c=function(){return b(new Date(2010,0,1,0,0,0,0))},f=function(){return b(new Date(2010,5,1,0,0,0,0))},e=function(){var a=c(),d=f(),b=c()-f();return new jstz.TimeZone(jstz.olson.timezones[0>b?a+",1":0<b?d+",1,s":a+",0"])};return{determine_timezone:function(){"undefined"!==typeof console&&console.log("jstz.determine_timezone() is deprecated and will be removed in an upcoming version. Please use jstz.determine() instead.");
return e()},determine:e,date_is_dst:function(a){var d=5<a.getMonth()?f():c(),a=b(a);return 0!==d-a}}}();jstz.TimeZone=function(b){var c=null,c=b;"undefined"!==typeof jstz.olson.ambiguity_list[c]&&function(){for(var b=jstz.olson.ambiguity_list[c],e=b.length,a=0,d=b[0];a<e;a+=1)if(d=b[a],jstz.date_is_dst(jstz.olson.dst_start_dates[d])){c=d;break}}();return{name:function(){return c}}};jstz.olson={};
jstz.olson.timezones={"-720,0":"Etc/GMT+12","-660,0":"Pacific/Pago_Pago","-600,1":"America/Adak","-600,0":"Pacific/Honolulu","-570,0":"Pacific/Marquesas","-540,0":"Pacific/Gambier","-540,1":"America/Anchorage","-480,1":"America/Los_Angeles","-480,0":"Pacific/Pitcairn","-420,0":"America/Phoenix","-420,1":"America/Denver","-360,0":"America/Guatemala","-360,1":"America/Chicago","-360,1,s":"Pacific/Easter","-300,0":"America/Bogota","-300,1":"America/New_York","-270,0":"America/Caracas","-240,1":"America/Halifax",
"-240,0":"America/Santo_Domingo","-240,1,s":"America/Asuncion","-210,1":"America/St_Johns","-180,1":"America/Godthab","-180,0":"America/Argentina/Buenos_Aires","-180,1,s":"America/Montevideo","-120,0":"America/Noronha","-120,1":"Etc/GMT+2","-60,1":"Atlantic/Azores","-60,0":"Atlantic/Cape_Verde","0,0":"Etc/UTC","0,1":"Europe/London","60,1":"Europe/Berlin","60,0":"Africa/Lagos","60,1,s":"Africa/Windhoek","120,1":"Asia/Beirut","120,0":"Africa/Johannesburg","180,1":"Europe/Moscow","180,0":"Asia/Baghdad",
"210,1":"Asia/Tehran","240,0":"Asia/Dubai","240,1":"Asia/Yerevan","270,0":"Asia/Kabul","300,1":"Asia/Yekaterinburg","300,0":"Asia/Karachi","330,0":"Asia/Kolkata","345,0":"Asia/Kathmandu","360,0":"Asia/Dhaka","360,1":"Asia/Omsk","390,0":"Asia/Rangoon","420,1":"Asia/Krasnoyarsk","420,0":"Asia/Jakarta","480,0":"Asia/Shanghai","480,1":"Asia/Irkutsk","525,0":"Australia/Eucla","525,1,s":"Australia/Eucla","540,1":"Asia/Yakutsk","540,0":"Asia/Tokyo","570,0":"Australia/Darwin","570,1,s":"Australia/Adelaide",
"600,0":"Australia/Brisbane","600,1":"Asia/Vladivostok","600,1,s":"Australia/Sydney","630,1,s":"Australia/Lord_Howe","660,1":"Asia/Kamchatka","660,0":"Pacific/Noumea","690,0":"Pacific/Norfolk","720,1,s":"Pacific/Auckland","720,0":"Pacific/Tarawa","765,1,s":"Pacific/Chatham","780,0":"Pacific/Tongatapu","780,1,s":"Pacific/Apia","840,0":"Pacific/Kiritimati"};
jstz.olson.dst_start_dates={"America/Denver":new Date(2011,2,13,3,0,0,0),"America/Mazatlan":new Date(2011,3,3,3,0,0,0),"America/Chicago":new Date(2011,2,13,3,0,0,0),"America/Mexico_City":new Date(2011,3,3,3,0,0,0),"Atlantic/Stanley":new Date(2011,8,4,7,0,0,0),"America/Asuncion":new Date(2011,9,2,3,0,0,0),"America/Santiago":new Date(2011,9,9,3,0,0,0),"America/Campo_Grande":new Date(2011,9,16,5,0,0,0),"America/Montevideo":new Date(2011,9,2,3,0,0,0),"America/Sao_Paulo":new Date(2011,9,16,5,0,0,0),"America/Los_Angeles":new Date(2011,
2,13,8,0,0,0),"America/Santa_Isabel":new Date(2011,3,5,8,0,0,0),"America/Havana":new Date(2011,2,13,2,0,0,0),"America/New_York":new Date(2011,2,13,7,0,0,0),"Asia/Gaza":new Date(2011,2,26,23,0,0,0),"Asia/Beirut":new Date(2011,2,27,1,0,0,0),"Europe/Minsk":new Date(2011,2,27,2,0,0,0),"Europe/Helsinki":new Date(2011,2,27,4,0,0,0),"Europe/Istanbul":new Date(2011,2,28,5,0,0,0),"Asia/Damascus":new Date(2011,3,1,2,0,0,0),"Asia/Jerusalem":new Date(2011,3,1,6,0,0,0),"Africa/Cairo":new Date(2010,3,30,4,0,0,
0),"Asia/Yerevan":new Date(2011,2,27,4,0,0,0),"Asia/Baku":new Date(2011,2,27,8,0,0,0),"Pacific/Auckland":new Date(2011,8,26,7,0,0,0),"Pacific/Fiji":new Date(2010,11,29,23,0,0,0),"America/Halifax":new Date(2011,2,13,6,0,0,0),"America/Goose_Bay":new Date(2011,2,13,2,1,0,0),"America/Miquelon":new Date(2011,2,13,5,0,0,0),"America/Godthab":new Date(2011,2,27,1,0,0,0)};
jstz.olson.ambiguity_list={"America/Denver":["America/Denver","America/Mazatlan"],"America/Chicago":["America/Chicago","America/Mexico_City"],"America/Asuncion":["Atlantic/Stanley","America/Asuncion","America/Santiago","America/Campo_Grande"],"America/Montevideo":["America/Montevideo","America/Sao_Paulo"],"Asia/Beirut":"Asia/Gaza Asia/Beirut Europe/Minsk Europe/Helsinki Europe/Istanbul Asia/Damascus Asia/Jerusalem Africa/Cairo".split(" "),"Asia/Yerevan":["Asia/Yerevan","Asia/Baku"],"Pacific/Auckland":["Pacific/Auckland",
"Pacific/Fiji"],"America/Los_Angeles":["America/Los_Angeles","America/Santa_Isabel"],"America/New_York":["America/Havana","America/New_York"],"America/Halifax":["America/Goose_Bay","America/Halifax"],"America/Godthab":["America/Miquelon","America/Godthab"]};
