<?php
  /*
    Copyright (C) 2009 - 2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

  session_start();
    
  /************************************
  * Exported File i.e. CSV output
  ************************************/
  function getExportFile($exportfile) {

    $filename = getTempFileName($exportfile);
    if(!file_exists($filename)) {
      echo "File Export Error! Can happen if your temporary directory has been removed!";
      // someone is looking for something that we can't give them
      exit(1);
    }

    header('Content-type: application/csv');

    header('Content-Disposition: attachment; filename="export.csv"');

    readfile($filename);
    exit(0);
  }
  
  $CONFDIR="../config";
  require $CONFDIR."/config.php";
  require "./functions/config_functions.php";
  require "./functions/ldap_functions.php";
  require "./functions/network_functions.php";
  require "./objects/querytimeobject.php";
  require "./objects/serverobject.php";
  require "./phpfile/file_class.php";
  require "./phpldap/ldap_class.php";


  // Do not view mobile page
  $viewMobilePage = getFormValue("setmobilestatus");
  if(!empty($viewMobilePage)) {
    if($viewMobilePage == "off") {
      setConfigValue("mobile", "off");
    }
    if($viewMobilePage == "on") {
      setConfigValue("mobile", "on");
    }
  }

  // if querying a server
  $queryserver = getFormValue("queryserver");
  if(!functionIsEnabled("queryconfig")) {
    $queryserver = "";
  }
  if(!empty($queryserver)) {
    $serverId = getEnvironmentId($queryserver);
    // no match found. Continue to query page
    if(empty($serverId)) {
      $url = "index.php?page=queryconfig.php&settab=default&querytext=".$queryserver;
    }
    else {
      // environment or server found
      $url = "index.php?page=environment.php&settab=environment_availability&environmentid=".$serverId[0];
      if(!empty($serverId[1])) {
        $url = "index.php?page=server.php&settab=server_availability&environmentid=".$serverId[0]."&serverid=".$serverId[1];
      }
    }
    header("location: $url");
  }

  // language options
  $config_Language = getFormValue("config_language");
  if(!empty($config_Language)) {
    setLanguage($config_Language);
  }
  $languageCode = getLanguage();
  require "language/".$languageCode.".php";

  $pageName = getFormValue("page");
  // if user is requesting a export file
  if($pageName == "exportfile.php") {
    getExportFile(getFormValue("exportfile"));
  }
  
  $page = getPage();
  if(empty($pageName)) {
    $pageName = $page;
  }
  
  $tabs = getTabs($pageName);
  $buttons = getButtons($pageName);

  $sRunningMobile = isRunningMobile();  
  //$sRunningMobile = true;
  // if we should display mobile top or normal webpage
  if($sRunningMobile == "on") {
    require "includes/mobiletop.php";
  }
  else {
    require "includes/top.php";
  }

  // if we should display mobile page or normal webpage
  if($sRunningMobile == "on") {
    require "pages/mobile".$page;
  }
  else {
    require "pages/".$page;
  }

  // if we should display mobile bottom or normal webpage
  if($sRunningMobile == "on") {
    require "includes/mobilebottom.php";
  }
  else {
    require "includes/bottom.php";
  }
?>
