﻿<?php
  $pagetimestart = microtimeFloat();

  // standard error message
  function showErrorMessage($errorSubject, $errorMessage = "") {
    echo "<div class='errorMessage'>\n";
    echo "<img src='icons/alert_error.png' width='16'>\n";
    echo "<big>".$errorSubject."</big><br>\n";
    if(!empty($errorMessage)) {
      echo "<br>\n";
      echo nl2br($errorMessage)."\n";
      echo "<br>\n";
    }
    echo "<br>";
    echo "<span class='gray'><i>".getLang("page.general.errortip")."</span>\n";
    echo "</div>\n";
  }

  // standard warning message
  function showWarningMessage($warningMessage, $moreInfo = "") {
    echo "<div class='warningMessage'>\n";
    echo "<img src='icons/alert_warning.png' width='16'>\n";
    echo nl2br($warningMessage)."<br>\n";
    if(!empty($moreInfo)) {
      echo "<br>".nl2br($moreInfo)."<br>\n";
    }
    echo "</div>\n";
  }

  // standard info message
  function showInfoMessage($infoMessage, $moreInfo = "") {
    echo "<div class='infoMessage'>\n";
    echo "<img src='icons/info.png' width='16'>\n";
    echo nl2br($infoMessage)."<br>\n";
    if(!empty($moreInfo)) {
      echo "<br>".nl2br($moreInfo)."<br>\n";
    }
    echo "</div>\n";
  }
?>
<html>

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<?php
  $stylesheet = "style/default.css";
  if(!empty($CONFIG["general"]["stylesheet"])) {
    $stylesheet = $CONFIG["general"]["stylesheet"];
  }
?>
  <link rel="stylesheet" href="<?php echo $stylesheet; ?>" />
  <link rel="stylesheet" href="style/jquery.plugins.css" />
  <link rel="stylesheet" href="style/calendar.css" />
  <meta name="keywords" content="ldap, iplanet, rhds, sunone ds, monitor, cn=monitor, cn=config" />
  <meta name="description" content="LDAP Monitoring iPlanet Directory Servers." />
  <title>CN=Monitor - LDAP Monitoring</title>
  <link rel="icon" type="image/png" href="icons/logo_icon.png">
  <script type="text/javascript" src="js/jquery.min.js"></script>
  <script type="text/javascript" src="js/jquery.plugins.js"></script>
  <script type="text/javascript" src="js/jquery.flot.min.js"></script>
  <script type="text/javascript" src="js/jquery.flot.plugins.js"></script>
  <!--[if lte IE 8]><script language="javascript" type="text/javascript" src="js/excanvas.min.js"></script><![endif]-->
  <script type="text/javascript" src="js/monitor.js"></script>
  <script type="text/javascript" src="js/listbox.js"></script>
  <script type="text/javascript" src="js/calendar.js"></script>
  <script type="text/javascript" src="js/xdate.js"></script>

<?php
  // Global Variables
  $env =  getEnvironments();
  $environmentId = getFormValue("environmentid");
  $environmentName = getEnvironmentName($environmentId);
  $serverId = getFormValue("serverid");  
  $authdn = getConfigValue("dn", $environmentId, $serverId);
  $CNMONITOR_VENDOR = setServer(getFirstRespondingServerInEnvironment($environmentId, $serverId))->getVendor();
  $CNMONITOR_PAGENAME = getPage();
  $CNMONITOR_ENVIRONMENTID = (!isset($environmentId) ? "null" : $environmentId);
  $CNMONITOR_SERVERID = (!isset($serverId) ? "null" : $serverId);
  if(empty($CNMONITOR_PAGENAME)) {
    $CNMONITOR_PAGENAME = "environments.php";
  }
  $loglevel = getConfigValue("loglevel", $environmentId, $serverId);
  $CNMONITOR_LOGLEVEL = ($loglevel) ? $loglevel : 0;
  $CNMONITOR_AUTORELOAD = (getConfigValue("autoreload", $environmentId, $serverId) == 1) ? 1 : 0;
  $CNMONITOR_RELOAD_ENABLED = 0;
  if($CNMONITOR_PAGENAME == "environments.php" ||
     $CNMONITOR_PAGENAME == "environment.php" ||
     $CNMONITOR_PAGENAME == "server.php") {
    $CNMONITOR_RELOAD_ENABLED = 1;
  }
?>

  <script language="javascript">
    // Global Variables
    var attributenotfound = "<?php echo getLang('page.query.nomatchfound'); ?>";
    var usersessionid = "<?php echo base64_encode(session_id()); ?>";
    var environmentCount = <?php echo (count($env) - 1); ?>;
    var environmentId = <?php echo !isset($environmentId) ? "null" : $environmentId; ?>;
    var serverId = <?php echo !isset($serverId) ? "null" : $serverId; ?>;
    var serverCount = <?php 
      if(isset($environmentId)) {
        echo "".count(getServers($environmentId))."";
      }
      else {
        echo "null";
      }
    ?>;
    var CNMONITOR_VENDOR = "<?php echo $CNMONITOR_VENDOR; ?>";
    var CNMONITOR_PAGENAME = "<?php echo $CNMONITOR_PAGENAME; ?>";
    var CNMONITOR_ENVIRONMENTID = <?php echo $CNMONITOR_ENVIRONMENTID; ?>;
    var CNMONITOR_SERVERID = <?php echo $CNMONITOR_SERVERID; ?>;
    var CNMONITOR_LOGLEVEL = <?php echo empty($CNMONITOR_LOGLEVEL) ? 0 : $CNMONITOR_LOGLEVEL; ?>;
    var CNMONITOR_AUTORELOAD = <?php echo $CNMONITOR_AUTORELOAD; ?>;
  </script>

</head>
<body onLoad="onPageLoad()">

<div id="loading" class="loading-invisible">
  <p>
    <?php echo getLang("page.general.loading"); ?><br>
    <img src="icons/loading.gif">
  </p>
</div>
<?php
  if($CNMONITOR_RELOAD_ENABLED) {
?>
  <div id="divPageReload" align="right">
    <span id="divPageReloadValue" style="font-weight:bold;"></span>
    &nbsp;
    <img id="imgPageReloadIcon" onClick="buttonReloadPage(CNMONITOR_PAGENAME)" src="icons/wall_clock_gray.png" width="32" height="32" border="0">
  </div>
<?php
  }
?>
<script type="text/javascript">
  document.getElementById("loading").className = "loading-visible";
  var hideDiv = function(){document.getElementById("loading").className = "loading-invisible";};
  var oldLoad = window.onload;
  var newLoad = oldLoad ? function(){hideDiv.call(this);oldLoad.call(this);} : hideDiv;
  window.onload = newLoad;
<?php
  // if auto reload enabled and reload is enabled on page
  if(($CNMONITOR_RELOAD_ENABLED == 1) && ($CNMONITOR_AUTORELOAD == 1)) {
    // add reload script
?>
    setTimeout(function() { buttonReloadPage(CNMONITOR_PAGENAME); }, (60 * 1000));
<?php
  }
?>
</script>

<div class="top">
  <div class="location">
    <table border="0" width="100%" cellpadding="3" cellspacing="3">
    <form name="queryconfig" onSubmit="onSubmitQueryConfig(this);return false;">
    <tr>
      <td width="150">
        <span id="locationName">
          <a href="index.php">
          <img src="icons/logo.png">
          </a>
        </span>
      </td>
      <td width="30">
         <small id="locationVersion">
            v.<?php require "./includes/version.php"; ?>
         </small>
      </td>
      <td align="right">
        <span id="locationOptions">
<?php
  if(functionIsEnabled("authenticate")) {
         echo "<a href='#' onClick=\"showHideElement('authenticationDiv')\">";
         if(empty($authdn)) {
           echo getLang("page.general.authenticate");
         }
         else {
           echo $authdn;
         }
         echo "</a>\n";
  }
?>
        </span>
      </td>
      <td width="24" align="right">
<?php
  if(functionIsEnabled("authenticate")) {
         echo "<a href='#' onClick=\"showHideElement('authenticationDiv')\">";
         if(empty($authdn)) {
           echo "<img src='icons/unsecure.png' width='24'>";
         }
         else {
           echo "<img src='icons/secure.png' width='24'>";
         }
         echo "</a>";
  }
?>
      </td>
      <td align="right" width="90">
        <span id="locationOptions">
<?php
  if(functionIsEnabled("preferences")) {
?>
          <a href="#" onClick="$('#configurationDiv').toggle();">
          <?php echo getLang('page.general.preferences'); ?>
          </a>
<?php
  }
?>
        </span>      
      </td>
      <td width="24" align="right">
<?php
  if(functionIsEnabled("preferences")) {
?>
        <a href="#" onClick="$('#configurationDiv').toggle();">
          <img src='icons/config.png' height='24'>
        </a>
<?php
  }
?>
      </td>
      <td align="right" width="160">
          <input value="<?php echo getLang("page.general.queryconfiguration"); ?>" onFocus="queryConfigSetStyle(this, '<?php echo getLang("page.general.queryconfiguration"); ?>')" type="text" name="queryconfigtext" autocomplete="off" id="queryconfigtext">
          <script language="javascript" type="text/javascript">
            $(function () {
              $("#queryconfigtext").coolautosuggest({
                url:getServiceURL() + "&service=configquery&q=",
                submitOnSelect:true,
                minChars:3
              });
            });
          </script>
        </span>
      </td>
      <td width="24" align="right">
        <a href="#" onclick="onSubmitQueryConfig(document.forms['queryconfig']);">
          <img src='icons/search.png' border='0' width='24'>
        </a>
      </td>
    </tr>
  </form>
    </table>
  </div>
  <div id="menu">
    <table width="100%" border="0" cellpadding="0" cellspacing="0">
    <tr>
      <td width="30" align="center">
        <a href="index.php"><img src="icons/home.png"></a>
      </td>
      <td valign="middle">
        <select onChange="displayEnvironment(this)">
          <option value=""><?php echo getLang('main.selectenvironment'); ?></option>
          <option value=""></option>
<?php
          for($i = 0; $i < count($env); $i++) {

            echo '<option value="'.$env[$i][0].'"';
            if($env[$i][0] == $environmentId) {
              echo ' selected';
            }
            echo '>'.$env[$i][1].'</option>\n';
          }
          
          if($serverId > 0) {
            $serverName = getServerName();
          }
?>
        </select>
        &nbsp;
<?php
  if(!empty($environmentName)) {
    echo "<span><a href='index.php?environmentid=".$environmentId."&settab=environment_availability'>".$environmentName."</a></span>";
  
  }

  if(!empty($serverName)) {
    echo " <b>&gt;</b> <span><a href='index.php?environmentid=$environmentId&serverid=".$serverId."&settab=server_availability'>".$serverName."</a></span>";
  }
?>

			</td>
			<td align="right" style="padding-right:4px;">
            <?php
              require "buttons/$buttons";
             ?>
			</td>
		</tr>
		</table>
	</div>
  </div>
	<br>

    <!--Tabs -->
	<div id="tab">
    <ul>
      <?php
        require "tabs/$tabs";
      ?>
    </ul>
	</div>

    <!-- Content -->
	<div id="content">
      <table width="100%" border="0" cellpadding="3" cellspacing="3">
      <tr>
        <td>
