<?php
  $pagetimestart = microtimeFloat();

  // standard error message
  function showErrorMessage($errorSubject, $errorMessage) {
    echo "<div class='errorMessage'>\n";
    echo "<big>".$errorSubject."</big>\n";
    echo "<br><br>\n";
    echo nl2br($errorMessage)."\n";
    echo "<br><br>\n";
    echo "<span class='gray'><i>".getLang("page.general.errortip")."</span>\n";
    echo "</div>\n";
  }

  // standard error message
  function showWarningMessage($warningMessage) {
    echo "<div class='warningMessage'>\n";
    echo nl2br($warningMessage)."\n";
    echo "<br>\n";
    echo "<span class='gray'><i>".getLang("page.general.errortip")."</span>\n";
    echo "</div>\n";
  }
?>
<html>

<head>
<?php
  $stylesheet = "style/mobiledefault.css";
?>
  <link rel="stylesheet" href="<?php echo $stylesheet; ?>" />
  <meta name="keywords" content="ldap, iplanet, rhds, sunone ds, monitor, cn=monitor, cn=config" />
  <meta name="description" content="LDAP Monitoring iPlanet Directory Servers." />
  <meta name="viewport" content="width = 320" />
  <link rel="icon" type="image/png" href="icons/server.png">
  <title>CN=Monitor - LDAP Monitoring</title>
</head>
<body>

<?php
  $env =  getEnvironments();
  $environmentId = getFormValue("environmentid");
  $environmentName = getEnvironmentName($environmentId);
  $serverId = getFormValue("serverid");
  
  $authdn = getConfigValue("dn", $environmentId, $serverId);
?>

<div class="top">
  <div class="location">
    <table border="0" width="100%" cellpadding="3" cellspacing="3">
    <tr>
      <td width="150">
        <span id="locationName">
          <a href="index.php">
            <img src='icons/logo.png' height="30">
          </a>
        </span>
      </td>
      <td>
        <span id="locationVersion">
            v.<?php require "./includes/version.php"; ?>
        </span>
      </td>
      <td width="40" align="right">
        <a href="index.php?page=<?php
          echo $pageName;
          if(isset($environmentId)) {
            echo "&environmentid=".$environmentId;
          }
          ?>"><img src="icons/refresh.png">
        &nbsp;
      </td>
    </tr>
    </table>
  </div>
</div>
