<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

  /**********************************************************************
  * Oracle Internet Directory Functions
  *
  * Specific LDAP functions for Directory Servers
  *
  * Available functionality:
  * (0) setMonitor
  * (0) setSnmp
  * (X) getHostNameOfServer
  * (0) setCache
  * (0) setBackEndDatabases
  * (0) setIndex
  * (0) setIndexesList
  * (0) getReplicationCSN
  * (0) convertCSNValue
  * (0) setReplicationAgreement
  * (0) setReplicaInfo
  * (X) setVendorInfo
  *
  **********************************************************************/

  function oid_getHostNameOfServer($ldap) {
    $sReturn = "";
    $hResult = @$ldap->get_entry("", array("orclreplicaid"));

    if(!$hResult) {
      return $sReturn;
    }

    $nRows = $ldap->num_rows($hResult);
    if($nRows == 1) {
      $aEntries = $ldap->get_result($hResult);
      if(!empty($aEntries[0]["orclreplicaid"][0])) {
        $sReturn = $aEntries[0]["orclreplicaid"][0];
      }
    }
    $ldap->free_result($hResult);

    return $sReturn;
  }

  /**
  * OID LDAP Returns Vendor and Version
  */
  function oid_setVendorInfo($ldap, $oVendorInfo) {
    $ldap->set_base_dn("");
    $hResult = @$ldap->get_entry("", array("orcldirectoryversion"));

    if($hResult) {
      $aEntries = $ldap->get_result($hResult);
      if(isset($aEntries[0]["orcldirectoryversion"][0])) {
        $oVendorInfo->setVersion($aEntries[0]["orcldirectoryversion"][0]);
      }
      $ldap->free_result($hResult);
    }  
    return $oVendorInfo;
  }

?>