<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

  /**********************************************************************
  * Novell eDirectory Functions
  *
  * Specific LDAP functions for Directory Servers
  *
  * Available functionality:
  * (X) setMonitor
  * (X) setSnmp
  * (0) getHostNameOfServer
  * (0) setCache
  * (0) setBackEndDatabases
  * (0) setIndex
  * (0) setIndexesList
  * (0) getReplicationCSN
  * (0) convertCSNValue
  * (0) setReplicationAgreement
  * (0) setReplicaInfo
  * (X) setPerformanceCounterList
  *
  **********************************************************************/

  /**
  * Returns a monitor object for eDirectory
  */
  function novell_setMonitor($ldap, $currentMonitor, $operation = Array()) {

      // cn monitor (@ to hide ev. error message)
      $hResult = @$ldap->get_entry("");
      if(!$hResult) {
        $sMessage = "Unable to query server";
        $endtime = microtimeFloat();
        $currentMonitor->setExecutionTime($endtime - $starttime);
        $ldap->close();
        $currentMonitor->setMessage($sMessage);
        return $currentMonitor;
      }
      $nRows = $ldap->num_rows($hResult);

      if($nRows > 0) {
        $aEntries = $ldap->get_result($hResult);
        if(!empty($aEntries[0]["vendorversion"][0])) {
          $currentMonitor->setVersion($aEntries[0]["vendorversion"][0]);
        }
        if(!empty($aEntries[0]["outbytes"][0])) {
          $currentMonitor->setBytesSent($aEntries[0]["outbytes"][0]);
        }
      }
      else {
        $currentMonitor->setMessage("Unable to fetch result");
      }
 
    $ldap->free_result($hResult);

    return $currentMonitor;
  }

  function novell_setSnmp($ldap, $currentSnmp, $operation = Array()) {

      // cn cnmp (@ to hide ev. error message)
      $hResult = @$ldap->get_entry(""); 

      if(!$hResult) {
        $currentSnmp->setMessage("Unable to open ldap connection");
        return $currentSnmp;
      }
      $nRows = $ldap->num_rows($hResult);

      if($nRows > 0) {
        $aEntries = $ldap->get_result($hResult);
        // we use unauthenticed binds on both anonymous and unauthenticated
        if(!empty($aEntries[0]["unauthbinds"])) {
          $currentSnmp->setAnonymousBinds($aEntries[0]["unauthbinds"][0]);
          $currentSnmp->setUnAuthenticatedBinds($aEntries[0]["unauthbinds"][0]);
        }
        if(!empty($aEntries[0]["simpleauthbinds"])) {
          $currentSnmp->setSimpleAuthBinds($aEntries[0]["simpleauthbinds"][0]);
        }
        if(!empty($aEntries[0]["strongauthbinds"])) {
          $currentSnmp->setStrongAuthBinds($aEntries[0]["strongauthbinds"][0]);
        }
        if(!empty($aEntries[0]["wholesubtreesearchops"])) {
          $currentSnmp->setWholeSubtreeSearchOps($aEntries[0]["wholesubtreesearchops"][0]);
        }
        if(!empty($aEntries[0]["bindsecurityerrors"])) {
          $currentSnmp->setBindSecurityErrors($aEntries[0]["bindsecurityerrors"][0]);
        }
        if(!empty($aEntries[0]["compareops"])) {
          $currentSnmp->setCompareOps($aEntries[0]["compareops"][0]);
        }
        if(!empty($aEntries[0]["errors"])) {
          $currentSnmp->setErrors($aEntries[0]["errors"][0]);
        }

        if(!empty($aEntries[0]["inops"])) {
          $currentSnmp->setInOps($aEntries[0]["inops"][0]);
        }
        if(!empty($aEntries[0]["addentryops"])) {
          $currentSnmp->setAddEntryOps($aEntries[0]["addentryops"][0]);
        }
        if(!empty($aEntries[0]["modifyentryops"])) {
          $currentSnmp->setModifyEntryOps($aEntries[0]["modifyentryops"][0]);
        }
        if(!empty($aEntries[0]["modifyrdnops"])) {
          $currentSnmp->setModifyRdnOps($aEntries[0]["modifyrdnops"][0]);
        }
        if(!empty($aEntries[0]["removeentryops"])) {
          $currentSnmp->setRemoveEntryOps($aEntries[0]["removeentryops"][0]);
        }

        if(!empty($aEntries[0]["searchops"])) {
          $currentSnmp->setSearchOps($aEntries[0]["searchops"][0]);
        }
        if(!empty($aEntries[0]["securityerrors"])) {
          $currentSnmp->setSecurityErrors($aEntries[0]["securityerrors"][0]);
        }
      }
 
    $ldap->free_result($hResult);

    return $currentSnmp;
  }

  /**
  * Novell Returns available operations
  */
  function novell_setPerformanceCounterList($byte_operation) {    
    return array($byte_operation, "exec_time", "search",
                 "add", "modify", "modifyrdn", "compare", "remove", "in",
                 "unauth_bind", "simple_bind", "strong_bind", "error");
  }
?>