<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

  /**********************************************************************
  * IBM Tivoli Functions
  *
  * Specific LDAP functions for Directory Servers
  *
  * Available functionality:
  * (X) setMonitor
  * (X) setSnmp
  * (X) getHostNameOfServer
  * (0) setCache
  * (0) setBackEndDatabases
  * (0) setIndex
  * (0) setIndexesList
  * (0) getReplicationCSN
  * (0) convertCSNValue
  * (0) setReplicationAgreement
  * (0) setReplicaInfo
  * (X) setPerformanceCounterList
  *
  **********************************************************************/

  /**
  * Returns a monitor object for IBM Tivoli
  */
  function ibm_setMonitor($ldap, $currentMonitor, $operation = Array()) {

      $ldap->set_base_dn("cn=monitor");

      // cn monitor (@ to hide ev. error message)
      $hResult = @$ldap->get_entry("cn=monitor");
      if(!$hResult) {
        $sMessage = "Unable to query server";
        $ldap->close();
        $currentMonitor->setMessage($sMessage);
        return $currentMonitor;
      }
      $nRows = $ldap->num_rows($hResult);

      if($nRows > 0) {
        $aEntries = $ldap->get_result($hResult);
        if(!empty($aEntries[0]["currenttime"][0])) {
          $currentMonitor->setCurrentTimeFormated($aEntries[0]["currenttime"][0]);        
        }

        if(!empty($aEntries[0]["starttime"][0])) {
          $currentMonitor->setStartTimeFormated($aEntries[0]["starttime"][0]);        
        }

        if(!empty($aEntries[0]["livethreads"][0])) {
          $currentMonitor->setThreads($aEntries[0]["livethreads"][0]);        
        }
        
        if(!empty($aEntries[0]["maxconnections"])) {
          $currentMonitor->setConnectionPeak($aEntries[0]["maxconnections"][0]);
        }

        if(!empty($aEntries[0]["totalconnections"])) {
          $currentMonitor->setTotalConnections($aEntries[0]["totalconnections"][0]);
        }

        if(!empty($aEntries[0]["currentconnections"])) {
          $currentMonitor->setCurrentConnections($aEntries[0]["currentconnections"][0]);
        }

        if(!empty($aEntries[0]["entriessent"])) {
          $currentMonitor->setEntriesSent($aEntries[0]["entriessent"][0]);
        }

        if(!empty($aEntries[0]["version"][0])) {
          $currentMonitor->setVersion($aEntries[0]["version"][0]);
        }
      }
      else {
        $currentMonitor->setMessage("Unable to fetch result");
      }
 
    $ldap->free_result($hResult);

    return $currentMonitor;
  }

  function ibm_setSnmp($ldap, $currentSnmp, $operation = Array()) {

      // cn cnmp (@ to hide ev. error message)
      $hResult = @$ldap->get_entry("cn=monitor"); 

      if(!$hResult) {
        $currentSnmp->setMessage("Unable to open ldap connection");
        return $currentSnmp;
      }
      $nRows = $ldap->num_rows($hResult);

      if($nRows > 0) {
        $aEntries = $ldap->get_result($hResult);

        if(!empty($aEntries[0]["bindscompleted"])) {
          $currentSnmp->setAnonymousBinds($aEntries[0]["bindscompleted"][0]);
        }

        if(!empty($aEntries[0]["searchescompleted"])) {
          $currentSnmp->setWholeSubtreeSearchOps($aEntries[0]["searchescompleted"][0]);
        }

        if(!empty($aEntries[0]["comparescompleted"])) {
          $currentSnmp->setCompareOps($aEntries[0]["comparescompleted"][0]);
        }

        if(!empty($aEntries[0]["addscompleted"])) {
          $currentSnmp->setAddEntryOps($aEntries[0]["addscompleted"][0]);
        }

        if(!empty($aEntries[0]["deletescompleted"])) {
          $currentSnmp->setRemoveEntryOps($aEntries[0]["deletescompleted"][0]);
        }

        if(!empty($aEntries[0]["modrdnscompleted"])) {
          $currentSnmp->setModifyRdnOps($aEntries[0]["modrdnscompleted"][0]);
        }

        if(!empty($aEntries[0]["modifiescompleted"])) {
          $currentSnmp->setModifyEntryOps($aEntries[0]["modifiescompleted"][0]);
        }

        if(!empty($aEntries[0]["slapderrorlog_messages"])) {
          $currentSnmp->setErrors($aEntries[0]["slapderrorlog_messages"][0]);
        }

        if(!empty($aEntries[0]["opscompleted"])) {
          $currentSnmp->setInOps($aEntries[0]["opscompleted"][0]);
        }

        if(!empty($aEntries[0]["searchescompleted"])) {
          $currentSnmp->setSearchOps($aEntries[0]["searchescompleted"][0]);
        }
      }
 
    $ldap->free_result($hResult);

    return $currentSnmp;
  }

  function ibm_getHostNameOfServer($ldap) {
    $sReturn = "";
    $hResult = @$ldap->get_entry("", array("ibm-sasldigestrealmname"));

    if(!$hResult) {
      return $sReturn;
    }

    $nRows = $ldap->num_rows($hResult);
    if($nRows == 1) {
      $aEntries = $ldap->get_result($hResult);
      if(!empty($aEntries[0]["ibm-sasldigestrealmname"][0])) {
        $sReturn = $aEntries[0]["ibm-sasldigestrealmname"][0];
      }
    }
    $ldap->free_result($hResult);

    return $sReturn;
  }

  /**
  * IBM Returns available operations
  */
  function ibm_setPerformanceCounterList($byte_operation) {    
    return array("ent_sent", $byte_operation, "tot_con", "exec_time", "search", "cur_con",
                 "add", "modify", "modifyrdn", "compare", "remove", "in",
                 "anon_bind", "error");
  }
?>