<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */


  /**********************************************************************
  * PostegreSQL Functions
  *
  * Specific PostegreSQL functions
  *
  * Available functionality:
  * (X) dbConnect
  * (X) dbClose
  * (X) dbQuery
  * (X) dbGetNumRows
  * (X) dbGetRow
  * (X) dbFreeResult
  *
  **********************************************************************/

  /**
  * Returns SQL Connect
  */
  function pgsql_dbConnect($host, $database, $port = "", $username, $password = "") {
    // connect to a postgre database
    if(empty($port)) {
      $port = 5432;
    }
    $connectionString = "host=".$host;
    $connectionString .=" port=".$port;
    $connectionString .= " dbname=".$database;
    $connectionString .= " user=".$username;
    $connectionString .= " password=".$password;
    // echo $connectionString;
    $dbh = pg_connect($connectionString);  
    return $dbh;
  }

  /**
  * Close database connection
  */
  function pgsql_dbClose($dbh) {
    @pg_close($dbh);
  }

  /**
  * Query database
  */
  function pgsql_dbQuery($dbh, $sql) {
    return @pg_query($dbh, $sql);
  }

  /**
  * Get number of rows
  */
  function pgsql_dbGetNumRows($result) {
    return @pg_num_rows($result);
  }

  /**
  * Get row
  */
  function pgsql_dbGetRow($result) {
    return @pg_fetch_row($result);
  }

  /**
  * Free Result
  */
  function pgsql_dbFreeResult($result) {
    @pg_free_result($result);
  }

?>