<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */


  /**********************************************************************
  * MySQLi Functions
  *
  * Specific MySQLi functions
  *
  * Available functionality:
  * (X) dbConnect
  * (X) dbClose
  * (X) dbQuery
  * (X) dbGetNumRows
  * (X) dbGetRow
  * (X) dbFreeResult
  *
  **********************************************************************/

  /**
  * Returns SQL Connect
  */
  function mysqli_dbConnect($host, $database, $port = "", $username, $password = "") {
    if(empty($port)) {
      $port = 3306;
    }

    $dbh = @mysqli_connect($host, 
                           $username, 
                           $password, 
                           $database, 
                           $port);
    return $dbh;
  }

  /**
  * Close database connection
  */
  function mysqli_dbClose($dbh) {
    @mysqli_close($dbh);
  }

  /**
  * Query database
  */
  function mysqli_dbQuery($dbh, $sql) {
    return @mysqli_query($dbh, $sql);
  }

  /**
  * Get number of rows
  */
  function mysqli_dbGetNumRows($result) {
    return @mysqli_num_rows($result);
  }

  /**
  * Get row
  */
  function mysqli_dbGetRow($result) {
    return @mysqli_fetch_row($result);
  }

  /**
  * Free Result
  */
  function mysqli_dbFreeResult($result) {
    @mysqli_free_result($result);  
  }

?>