<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

  /**************************
    NETWORK FUNCTIONS
  **************************/

  /****
    Ping LDAP Server
    @param $sServer ServerName
  */
  function pingLdapServer($sServer) {
    $shortOSName = strtoupper(substr(PHP_OS, 0, 3));

    $nResponse = 1;
    $nOutput = "";
    
    // as switches are different between OS
    if($shortOSName == "DAR") {
      // darwin = mac os x
      $switches = "-t 1 -c 1";
    }
    else {
      // fallback linux
      $switches = "-w 1 -c 1";
    }
    exec("ping $switches $sServer", $nOutput, $nResponse);

    return $nResponse;
  }

  /****
    This is to get around the LDAP Timeout issue (fixed in PHP 5.3)
    We will do a connect against the defined openport
    Return 1 on success, 0 on failure
  */
  function socketOpen($servername, $port) {
    global $CONFIG;
    
    if(empty($port)) {
      $port = 389;
    }

    if($fp = @fsockopen($servername, $port, $errno, $errstr, 5)) {
      fclose($fp);
      return 1;
    }
    return 0;
  }
  
  /****
    Returns server IP address
    @param $sServer ServerName
    @return ip address
  */
  function getServerIP($sServer) {
    return gethostbyname($sServer);
  }

  
  /****
    Returns server IP address
    @param $sIP Server IP Address
    @return dns name
  */
  function getServerDNS($sIP) {
    return gethostbyaddr($sIP);
  }
?>