<?php
  /*
    Copyright (C) 2009-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

/*********************************************
  Sends a notification in form of a mail
  or triggers an external script
*********************************************/
function sendNotification($inmessage, $oFile, $logFileName, $errorKey = "", $servername = "") {
  $debug = 0;

  // try to get options based on server and up
  if(!empty($servername)) {
    $configId = getEnvironmentId($servername);
    if(!empty($configId)) {
      $runscript = getConfigValue("collectscript", $configId[0], $configId[1]);
      $mailreportto = getConfigValue("mailto", $configId[0], $configId[1]);
      $mailreportfrom = getConfigValue("mailfrom", $configId[0], $configId[1]);
      $mailwwwaddress = getConfigValue("wwwaddress", $configId[0], $configId[1]);
    }  
  }
  
  if(empty($runscript)) {
    $runscript = getConfigValue("collectscript");
    echo $runscript;
  }
  if(empty($mailreportto)) {
    $mailreportto = getConfigValue("mailto");
  }
  if(empty($mailreportfrom)) {
    $mailreportfrom = getConfigValue("mailfrom");
  }
  if(empty($mailwwwaddress)) {
    $mailwwwaddress = getConfigValue("wwwaddress");
  }

  // if runscript is configured
  if(!empty($errorKey)) {
    if(!empty($runscript)) {
      if(file_exists($runscript)) {
        exec($runscript." \"".$errorKey."\" \"".$servername."\" \"'".$inmessage."'\"");
        if(function_exists("addToLogger")) {
          addToLogger("    Successfully Triggered Script!\n", $oFile, $logFileName);
        } // log exists
      } // run script file exists
      else {
        // runscript does not exist
        if(function_exists("addToLogger")) {
          addToLogger("    Script to trigger: $runscript does not exist!\n", $oFile, $logFileName);
        } // log exists      
      } // runscript file does not exist
    } // runscript defined
  } // error key present

  /* 
    this will give the order of:
     - servername
     - key
     - message text
     - inmessage text (value)
  */
  $message = "";
  if(!empty($errorKey)) {
    $message .= "Message : ".getTextByServerMessageKey($errorKey)."\n";
  }
  if(!empty($servername)) {
    $message .= "Host    : ".$servername."\n";
  }
  if(!empty($errorKey)) {
    $message .= "Key     : ".$errorKey."\n";
  }
  if(!empty($inmessage)) {
    $message .= "Info    : ".$inmessage."\n";
  }
  
  if($errorKey == "collectservermessage") {
    $oFile = new File();
    $collectservermessage_server_check = getTempFileName("collectservermessage_server");
    if(file_exists($collectservermessage_server_check)) {
      $message .= "Latest connect attempts:\n";
      $serverCheckInfo = $oFile->read($collectservermessage_server_check);
      $message .= $serverCheckInfo."\n";
    }
  }

  if(empty($mailreportto) ||
     empty($mailreportfrom) ||
     empty($mailwwwaddress)) {
     if(function_exists("addToLogger")) {
       addToLogger("    Mail report failed. To, From or WWW address not configured!\n\n", $oFile, $logFileName);
     }
     return false;
  }
  $message = $message."\nSent from CN=Monitor\n";
  $message = $message.$mailwwwaddress."\n\n";
  if($debug) { echo $message; }

  // Set servername as subject if available
  // If not available use CN=Monitor
  if(!empty($servername)) {
    $mailSubject = $servername;
  }
  else {
    $mailSubject = "CN=Monitor";
  }
  $headers = "From: ".$mailreportfrom."\r\n";
  if(!mail($mailreportto, $mailSubject, $message, $headers)) {
    if(function_exists("addToLogger")) {
      addToLogger("    Failed Sending Mail!\n", $oFile, $logFileName);
      return false;
    }
  }
  else {
    if(function_exists("addToLogger")) {
      addToLogger("    Successfully Sent Mail!\n", $oFile, $logFileName);
    }
  }
  return true;
}

/*********************************************
  Check if PID file exists.
  Remove it automaticly if more than 35 minutes old
  Returns true / false if file stille exists
*********************************************/
function pidFileExists($pidFile, $oFile, $logFileName, $errorKey) {
  if(!file_exists($pidFile)) {
    return false;
  }
  // pid file exists, check time
  $fileTimeCurrent = time();
  $fileTimeBeforeDelete = (filemtime($pidFile) + 2100);
  if($fileTimeCurrent > $fileTimeBeforeDelete) {
    if(unlink($pidFile)) {
      sendNotification("PID file removed", $oFile, $logFileName, $errorKey);
      return false;
    }
  }
  // file still exists
  return true;
}

?>