<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */


/********************************************
  Return text by operation name
  @param string operation Operation to get text for
  @return string Operation Text
********************************************/
  function getTextByOperation($operation) {
    if($operation == "ent_sent") {
      return getLang('page.servergraph.entriessent');
    }
    else if($operation == "byte_sent") {
      return getLang('page.servergraph.bytessent');
    }
    else if($operation == "kbyte_sent") {
      return getLang('page.servergraph.kbytessent');
    }
    else if($operation == "mbyte_sent") {
      return getLang('page.servergraph.mbytessent');
    }
    else if($operation == "tot_con") {
      return getLang('page.servergraph.totalconnections');
    }
    else if($operation == "exec_time") {
      return getLang('page.servergraph.responsetime');
    }
    else if($operation == "search") {
      return getLang('page.general.searchoperations');
    }
    else if($operation == "cur_con") {
      return getLang('page.servergraph.curconnections');
    }
    else if($operation == "add") {
      return getLang('page.servergraph.addoperations');
    }
    else if($operation == "modify") {
      return getLang('page.servergraph.modoperations');
    }
    else if($operation == "modifyrdn") {
      return getLang('page.servergraph.modrdnoperations');
    }
    else if($operation == "compare") {
      return getLang('page.servergraph.compareoperations');
    }
    else if($operation == "remove") {
      return getLang('page.servergraph.removeoperations');
    }
    else if($operation == "in") {
      return getLang('page.servergraph.inoperations');
    }
    else if($operation == "anon_bind") {
      return getLang('page.servergraph.anonymousbinds');
    }
    else if($operation == "unauth_bind") {
      return getLang('page.servergraph.unauthbinds');
    }
    else if($operation == "simple_bind") {
      return getLang('page.servergraph.simplebinds');
    }
    else if($operation == "strong_bind") {
      return getLang('page.servergraph.strongbinds');
    }
    else if($operation == "error") {
      return getLang('page.servergraph.returnederrors');
    }
  }

/****************************************************
* update live monitoring data
* @param environmentid
* @param serverid
* @param servername
* @param operation
* $return void
****************************************************/
function updateLiveGraphData($servername, $operation, $mergedata = false) {
  $default_history_queries = 50;
  error_reporting(E_ALL ^ E_NOTICE);

  $currentDate = date("H:i:s");

  $FILE = new File();
  if(empty($operation)) {
    $operation = "ent_sent";
  }

  $tmpFile = getTempFileName($operation);

  // read data contents
  if(file_exists($tmpFile)) {
    require($tmpFile);
  }

  /*
   // to understand file data 
   <?
     $graphdata[<0 = data>][<server id>][<data counter>]
     $graphdata[0][0][0] = 1095;
     $graphdata[<1 = tickdates>][<data counter>] = '20:16:43';
     $graphdata[1][0] = '20:16:43';
   ?>
  */

  $tickdates = $graphdata[1];
  $tickdates[count($tickdates)] = $currentDate;

  for($i = 0; $i < count($servername); $i++) {
    $currentValues = $graphdata[0][$i];

    $val = returnValue($servername[$i], $operation);
    $currentValues[count($currentValues)] = $val;
    $graphdata[0][$i] = $currentValues;

    // remove data if over max history
    if(count($graphdata[0][$i]) > $default_history_queries) {
      array_shift($graphdata[0][$i]);
    }
  }
  // remove dates if over max history
  if(count($tickdates) > $default_history_queries) {
    array_shift($tickdates);
  }
  
  // Add Dates
  $graphdata[1] = $tickdates;

  // Add Hosts
  for($i = 0; $i < count($servername); $i++) {
    $graphdata[2][$i] = $servername[$i];
  }
  
  // Add Combined result tag
  if($mergedata) {
    $graphdata[3] = 1;
  }
  else {
    $graphdata[3] = 0;
  }
  
  imageSaveData($graphdata, $tickdates, $servername, $operation);
  return $graphdata;
}

function setValueToGraphData($inarray = 0, $invalue) {
  $currentValues = $inarray;
  $currentValues[count($currentValues)] = $invalue;

  return $currentValues;
}

/****************************************************
* Get data from summary database
* @param serverlist list of servers
* @param operation
* @return void
****************************************************/
function updateSummaryDatabaseGraphData($serverlistsemicolon, $inoperation) {

  // to support kbyte and mbyte sent operations
  if($inoperation == "kbyte_sent") {
    $operation = "byte_sent";
  }
  else if($inoperation == "mbyte_sent") {
    $operation = "byte_sent";
  }
  else {
    $operation = $inoperation;
  }

  $serverlist = explode(";", $serverlistsemicolon);

  $tickdates = array("","Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
  $defaultvalues = array(0,0,0,0,0,0,0,0,0,0,0,0,0); 
  $yearlist = array();
  $graphdata[0][0] = array();
  
  for($i = 0; $i < count($serverlist); $i++) {
    $servername = $serverlist[$i];
    $sql = "SELECT col_sum_date, col_sum_value FROM summary";
    $sql .= " WHERE col_sum_host = '".$servername."' AND col_sum_key = '".$operation."'";
    $sql .= " ORDER BY col_sum_date ASC";
    $dbh = dbConnect();
    $result = dbQuery($sql, $dbh);

    $currentyearid = 0;
    while($row = dbGetRow($result)) {
      $aDate = explode("-", trim($row[0]));

      $currentData = $row[1];
      if($inoperation == "kbyte_sent") {
        $currentData = round(($currentData / 1024), 2);
      }
      else if($inoperation == "mbyte_sent") {
        $currentData = round(($currentData / 1024 / 1024), 2);
      }

      if(!in_array($aDate[0], $yearlist)) {
        // set new default values
        $currentyearid = count($yearlist);
        $graphdata[0][$currentyearid] = $defaultvalues;
        // add new year
        $yearlist[$currentyearid] = $aDate[0];
      }
      else {
        $currentyearid = array_search($aDate[0], $yearlist);
      }

      // graphdata[0][<year>][<month>] = <value>
//      echo "month: ".intval($aDate[1])."<br>";
      $graphdata[0][$currentyearid][intval($aDate[1])] += $currentData;
      
    } // while database
    $graphdata[1] = $tickdates;
        
    dbFreeResult($result);
    dbClose($dbh);
  } // for each server

  // re-write result for exec_time if more than one server. If so return average of all servers
  if($inoperation == "exec_time" && count($serverlist) > 1) {
    for($i = 0; $i < count($graphdata[0]); $i++) {
      for($j = 0; $j < count($graphdata[0][$i]); $j++) {
        if($graphdata[0][$i][$j] > 0 && count($serverlist) > 0) {
          $graphdata[0][$i][$j] = round($graphdata[0][$i][$j] / count($serverlist), 2);
        }
      }
    }
  }
//  $graphdata[0][$currentyearid][intval($aDate[1])]  

  $graphdata[2] = $yearlist;
//    print_r($graphdata);

  // graphdata[0] = Actual Data
  // graphdata[1] = tick dates
  // graphdata[2] = year list
  return $graphdata;
}

/****************************************************
* Get data from database
* @param servername
* @param operation
* @param datestart Start Date
* @param dateend End Date
* @return void
****************************************************/
function updateDatabaseGraphData($servername, $operation, $datestart, 
                                 $dateend, $mergedata = false, $collapsData = false) {
  // turn on notices as some php environments 
  // (especially CLI) are set to report them
  error_reporting(E_ALL ^ E_NOTICE);

  $debug = 0;
  $dividevalue = 0;
  $coloperation = "ent_sent";
  $dbtable = "monitor";
  $currtime = "";
  $currserver = "";
  $tickdates = Array();
  $graphdata = Array();
  $serversincluded = Array();
  
  // which table?
  if($operation == "ent_sent") {
    $dbtable = "monitor";
    $coloperation = "ent_sent";
  }
  else if($operation == "byte_sent") {
    $dbtable = "monitor";
    $coloperation = "byte_sent";
  }
  else if($operation == "kbyte_sent") {
    $dbtable = "monitor";
    $coloperation = "byte_sent";
    $dividevalue = 1024;
  }
  else if($operation == "mbyte_sent") {
    $dbtable = "monitor";
    $coloperation = "byte_sent";
    $dividevalue = 1048576;
  }
  else if($operation == "tot_con") {
    $dbtable = "monitor";
    $coloperation = "tot_con";
  }
  else if($operation == "thread") {
    $dbtable = "monitor";
    $coloperation = "thread";
  }
  else if($operation == "cur_con") {
    $dbtable = "monitor";
    $coloperation = "cur_con";
  }
  else if($operation == "exec_time") {
    $dbtable = "monitor";
    $coloperation = "exec_time";
  }
  else if($operation == "search") {
    $dbtable = "operation";
    $coloperation = "search";
  }
  else if($operation == "add") {
    $dbtable = "operation";
    $coloperation = "add";
  }
  else if($operation == "modify") {
    $dbtable = "operation";
    $coloperation = "modify";
  }
  else if($operation == "modifyrdn") {
    $dbtable = "operation";
    $coloperation = "modifyrdn";
  }
  else if($operation == "compare") {
    $dbtable = "operation";
    $coloperation = "compare";
  }
  else if($operation == "remove") {
    $dbtable = "operation";
    $coloperation = "remove";
  }
  else if($operation == "in") {
    $dbtable = "operation";
    $coloperation = "in";
  }
  else if($operation == "anon_bind") {
    $dbtable = "operation";
    $coloperation = "anon_bind";
  }
  else if($operation == "unauth_bind") {
    $dbtable = "operation";
    $coloperation = "unauth_bind";
  }
  else if($operation == "simple_bind") {
    $dbtable = "operation";
    $coloperation = "simple_bind";
  }
  else if($operation == "strong_bind") {
    $dbtable = "operation";
    $coloperation = "strong_bind";
  }
  else if($operation == "error") {
    $dbtable = "operation";
    $coloperation = "error";
  }
  
  $sql = "SELECT col_mon_host, col_mon_date, col_mon_".$coloperation." FROM ".$dbtable." ";
  $sql .= "WHERE (";
  for($i = 0; $i < count($servername); $i++) {
    if($i > 0) {
      $sql .= "OR ";
    }
    $sql .= "col_mon_host = '".$servername[$i]."' ";
  }
  $sql .= ") AND col_mon_date >= '".$datestart."' ";
  $sql .= "AND col_mon_date <= '".$dateend."' ";
  $sql .= "ORDER BY col_mon_date ASC, col_mon_host ASC";
  
  if($debug) { echo $sql."\n"; }

  $dbh = dbConnect();
  $result = dbQuery($sql, $dbh);

  // check if we are braking the limit of number of rows
  $monitoringlimit = intval(getConfigValue("monitoringlimit"));
  if(empty($monitoringlimit)) {
    $monitoringlimit = 20000;
  }
  // if the result set contain more than allowed limit, exit
  // this in order to avoid any web server related issues (out of memory etc..)
  $numReturnedRows = dbGetNumRows($result);
  if($numReturnedRows > $monitoringlimit) {
    $graphdata[4][0] = "Error: Result exceeds limit of ".$monitoringlimit." records";
    dbFreeResult($result);
    dbClose($dbh);
    return $graphdata;
  }
  
  while($row = dbGetRow($result)) {
    $aTime = explode(" ", $row[1]);
    $sTime = $row[1];
    $rowserver = trim($row[0]); 
    $rowvalue = $row[2]; 

    if($sTime != $currtime) {
    
      // before switching to the new time
      // make sure all servers has got a value
      // if not set value 0
      if((count($serversincluded) != count($servername)) && (count($serversincluded) > 0)) {
        if($debug) { echo "included c: ".count($serversincluded)." servername c: ".count($servername)."<br>\n"; }
        for($i = 0; $i < count($servername); $i++) {
          // if server still not in included
          if(!in_array($servername[$i], $serversincluded)) {
            $graphdata[0][$i] = setValueToGraphData($graphdata[0][$i], 0);
            if($debug) { echo $servername[$i]."-".$currtime."-0 (solved)<br>\n"; }
            $serversincluded[count($serversincluded)] = $servername[$i];
          }
        }
      }
    
      // we are now ready to start the new time
      //$currtime = $aTime[1];
      $currtime = $sTime;
      $tickdates[count($tickdates)] = $currtime;
      $serversincluded = Array();
      if($debug) { echo "NEW TIME: ".$currtime."<br>\n"; }
    }
    
    // if we should divide the value (cases like kbyte and mbyte
    if(($rowvalue > 0) && ($dividevalue > 0)) {
      $rowvalue = round(($rowvalue / $dividevalue), 2);
    }
    
    if($debug) { echo $rowserver."-".$row[1]."-".$rowvalue."<br>\n"; }

    //set matching value    
    for($i = 0; $i < count($servername); $i++) {
      if($servername[$i] == $rowserver) {
        $currserver = $rowserver;
          
        // value array for this server
        $graphdata[0][$i] = setValueToGraphData($graphdata[0][$i], $rowvalue);
        $serversincluded[count($serversincluded)] = $servername[$i];
        if($debug) { echo "VALUE: server: ".$rowserver." Value: ".$rowvalue." (ok)<br>\n"; }
      }
    } // for each server
  } // while result
  
  dbFreeResult($result);
  dbClose($dbh);
  
  // Add Dates
  $graphdata[1] = $tickdates;

  // Add Hosts
  for($i = 0; $i < count($servername); $i++) {
    $graphdata[2][$i] = $servername[$i];
  }

  // for summary we do not collaps data and can return data
  if(!$collapsData) {
    return $graphdata;
  }
  else {
    // if we should collaps data
    $returnData = databaseGraphDataCollaps($graphdata);
  }
  
  // Add Combined result tag
  if($mergedata) {
    $returnData[3] = 1;
  }
  else {
    $returnData[3] = 0;
  }
  return $returnData;
}

function databaseGraphDataCollaps($graphdata) {
  $debug = 0;  
  $graphSize = (count($graphdata[1]) - 1);
  $data = Array();
  if(empty($graphdata[0])) {
    return $graphdata;
  }

  $maxVal = intval(getConfigValue("monitoringcollaps"));
  if(empty($maxVal)) {
    $maxVal = 100;
  }

  // get index indicator
  $narrValue = round($graphSize/$maxVal,0);
  if($debug) { echo "array size: ".$graphSize."<br>\n"; }
  if($debug) { echo "divide by $maxVal : ".$narrValue."<br>\n"; }
  if($narrValue < 2) {
    if($debug) { echo "narr value below 2, exit function<br>\n"; }
    return $graphdata;  
  }
  
  // set warning information that we have divided the result
  $data[4][1] = str_replace("%s", $narrValue, getLang("page.general.zoomin"));
  
  // get range to use
  $indexRange = range(0, $graphSize, $narrValue);
  if($debug) { print_r($indexRange); }
  
  // loop range
  for($i = 0; $i < count($graphdata[0]); $i++) {
    for($j = 0; $j < count($indexRange); $j++) {
      if($debug) { echo "- index for ".$indexRange[$j]." - value: ".$graphdata[0][$i][$indexRange[$j]]."<br>\n"; }
      $data[0][$i][count($data[0][$i])] = $graphdata[0][$i][$indexRange[$j]];
    }
  }
  // ticks
  for($i = 0; $i < count($indexRange); $i++) {
    if($debug) { echo "set tick $i - ".$indexRange[$i].": ".$graphdata[1][$indexRange[$i]]."<br>\n"; }
    $data[1][count($data[1])] = $graphdata[1][$indexRange[$i]];
  }
  // set server names
  $data[2] = $graphdata[2];
  
  if($debug) { print_r($data); }
  return $data;  
}

/****************************************************
* store data to temporary file
* @param graphdata multi array of values
* @param tickdates dates in array
* @param servername
* @param operation
* @param mergdata default false
* @return void
****************************************************/
function imageSaveData($graphdata, $tickdates, $servername, $operation, $mergedata = false) {
  // turn on notices as some php environments 
  // (especially CLI) are set to report them
  error_reporting(E_ALL ^ E_NOTICE);

  $FILE = new File();

  $tmpFile = getTempFileName($operation);

  // write data contents
  $dataStr = "<?php\n";
  $dataStrHosts = "";
  for($i = 0; $i < count($servername); $i++) {
    // start from 1 as the first one always is empty
    for($j = 0; $j < count($graphdata[0][$i]); $j++) {
      $dataStr .= "\$graphdata[0][$i][$j] = ".$graphdata[0][$i][$j].";\n";
    }
    $dataStrHosts .= "\$graphdata[2][$i] = '".$servername[$i]."';\n";
  }
  
  // start from 1 as the first one always is empty
  $counter = 0;
  for($i = 0; $i < count($tickdates); $i++) {
    $dataStr .= "\$graphdata[1][$i] = '".$tickdates[$i]."';\n";
  }
  $dataStr .= $dataStrHosts;

  if($mergedata) {
    $dataStr .= "\$graphdata[3] = 1;\n";
  }

  $dataStr .= "?>\n";
//  echo "<!-- \n".$dataStr."--> \n";
  $FILE->write($tmpFile, $dataStr);

}

function returnSummaryValue($operation, $graphdata) {
  // turn on notices as some php environments 
  // (especially CLI) are set to report them
  error_reporting(E_ALL ^ E_NOTICE);

  // get number of changes
  $graphdata[0][0] = rewriteValues($operation, $graphdata[0][0], "", $graphdata[1]);
  // summarize all values and return
  $returnValue = 0;
  for($i = 0; $i < count($graphdata[0][0]); $i++) {
    $returnValue += $graphdata[0][0][$i];
  }
  return $returnValue;
}

/****************************************************
* returns average execution time based on graphdata
* @param graphdata
* @return int value
****************************************************/
function returnAverageValue($graphdata) {
  // turn on notices as some php environments 
  // (especially CLI) are set to report them
  error_reporting(E_ALL ^ E_NOTICE);

  $total = 0;
  for($i = 0; $i < count($graphdata[0]); $i++) {
    $total += array_sum($graphdata[0][$i]);
  }
  $items = count($graphdata[0][0]);
  if(empty($total)) {
    return 0;
  }
  return round(($total / ($items * count($graphdata[0]))), 2);
}

/****************************************************
* get value for live monitoring
* @param servername
* @param operation
* @return int value
****************************************************/
function returnValue($servername, $operation) {
  // type of value
  if($operation == "cur_con") {
    $currentMonitor = setMonitor($servername, array($operation));
    return $currentMonitor->getCurrentConnections();
  }
  else if($operation == "tot_con") {
    $currentMonitor = setMonitor($servername, array($operation));
    return $currentMonitor->getTotalConnections();
  }
  else if($operation == "cur_con") {
    $currentMonitor = setMonitor($servername, array($operation));
    return $currentMonitor->getCurrentConnections();
  }
  else if($operation == "thread") {
    $currentMonitor = setMonitor($servername, array($operation));
    return $currentMonitor->getThreads();
  }
  else if($operation == "ent_sent") {
    $currentMonitor = setMonitor($servername, array($operation));
    return $currentMonitor->getEntriesSent();
  }
  else if($operation == "byte_sent") {
    $currentMonitor = setMonitor($servername, array($operation));
    return $currentMonitor->geBytesSent();
  }
  else if($operation == "kbyte_sent") {
    $currentMonitor = setMonitor($servername, array($operation));
    return $currentMonitor->getKBytesSent();
  }
  else if($operation == "mbyte_sent") {
    $currentMonitor = setMonitor($servername, array($operation));
    return $currentMonitor->getMBytesSent();
  }
  else if($operation == "search") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getSearchOps();
  }
  else if($operation == "add") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getAddEntryOps();
  }
  else if($operation == "modify") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getModifyEntryOps();
  }
  else if($operation == "modifyrdn") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getModifyRdnOps();
  }
  else if($operation == "compare") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getCompareOps();
  }
  else if($operation == "remove") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getRemoveEntryOps();
  }
  else if($operation == "in") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getInOps();
  }
  else if($operation == "anon_bind") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getAnonymousBinds();
  }
  else if($operation == "unauth_bind") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getUnAuthenticatedBinds();
  }
  else if($operation == "simple_bind") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getSimpleAuthBinds();
  }
  else if($operation == "strong_bind") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getStrongAuthBinds();
  }
  else if($operation == "error") {
    $currentSnmp = setSnmp($servername, array($operation));
    return $currentSnmp->getErrors();
  }
  else if($operation == "exec_time") {
    return getExecutionTime($servername);
  }
  return 0;
}

/****************************************************
* rewrite values if server restarted or in seconds
* @param operation
* @param values
* @param changetype if in seconds
* @param tickdates
* @return int value
****************************************************/
function rewriteValues($operation, $values, $changetype, $tickdates) {
  $debug = 0;
  //error_reporting(E_ALL ^ E_NOTICE);

  $returnArray = Array();
  for($i = 0; $i < count($values); $i++) {
    $currentvalue = 0;
    
    $seconds = 0;
    if($operation == "ent_sent"  ||
       $operation == "tot_con"   ||
       $operation == "byte_sent"  ||
       $operation == "kbyte_sent"  ||
       $operation == "mbyte_sent"  ||
       $operation == "search" ||
       $operation == "add"    ||
       $operation == "modify"    ||
       $operation == "modifyrdn" ||
       $operation == "compare" ||
       $operation == "remove" ||
       $operation == "in" ||
       $operation == "anon_bind" || 
       $operation == "unauth_bind" || 
       $operation == "simple_bind" || 
       $operation == "strong_bind" ||
       $operation == "error") {
       $seconds = 1;
       
       if($changetype == "seconds") {
         // set seconds elapsed
         if(!empty($tickdates[$i - 1])) {
           $seconds = (strtotime($tickdates[$i]) - strtotime($tickdates[$i - 1]));
         }
         else {
           $seconds = 0;
         }
       }
       
       if($debug) { echo $i."-".$values[$i]."-".$values[$i - 1]."<br>\n"; }
       if(empty($values[$i - 1])) {
         if($debug) { echo $i."- first entry in array, set 0<br>\n"; }
         // first entry in array
         $currentvalue = 0;
       }
       else if($values[$i - 1] > $values[$i]) {
         // previous value higher than this one. Server restarted or down?
         $currentvalue = 0;
         if($debug) { echo $i."- value lower than previous, set 0<br>\n"; }
       }
       else {
       
         // current value - previous value, divided by number of seconds with max two decimal precission
         $currentvalue = round((($values[$i] - $values[$i - 1]) / $seconds), 2);
         if($debug) { echo $i."- value ok set ".round((($values[$i] - $values[$i - 1]) / $seconds), 2)."<br>\n"; }
         
         // will always save us. I don't know if this is the best solution
         if($currentvalue < 0) {
           $currentvalue = 0;
         }         
      }
    }
    else {
      $currentvalue = $values[$i];
    }
    $returnArray[count($returnArray)] = $currentvalue;
    if($i == 1) {
      // as first always is 0, we set second value as first value
      $returnArray[0] = $currentvalue;
    }
  }
  return $returnArray;
}

// creates one single result
function mergeResultSet($graphdata) {
  error_reporting(E_ALL ^ E_NOTICE);
  $returnData = array();

  for($i = 0; $i < count($graphdata[1]); $i++) {
    for($j = 0; $j < count($graphdata[0]); $j++) {
      $returnData[0][0][$i] += $graphdata[0][$j][$i];
    }
  }
  $returnData[1] = $graphdata[1];
  return $returnData;
}

?>
