-- Upgrade from 0.9 to 0.9.1

-- Connect to database
\connect cnmonitor

-- Create Table Server Message
CREATE TABLE servermessage
(
   col_srvmsg_date timestamp without time zone NOT NULL,
   col_srvmsg_host character(255) NOT NULL, 
   col_srvmsg_key character(25) NOT NULL, 
   col_srvmsg_value text DEFAULT '',
   CONSTRAINT "Unique Server Message Key" PRIMARY KEY (col_srvmsg_date, col_srvmsg_host)
) 
WITH (
  OIDS = FALSE
)
;
COMMENT ON TABLE servermessage IS 'Server Message Table';

-- Drop Old Table Summary
DROP TABLE summary;

-- Create Table Summary
CREATE TABLE summary
(
   col_sum_date date NOT NULL, 
   col_sum_host character(255) NOT NULL, 
   col_sum_key character(25) NOT NULL, 
   col_sum_value bigint DEFAULT '0', 
   col_sum_updated date NOT NULL, 
   CONSTRAINT "Unique Summary Key" PRIMARY KEY (col_sum_date, col_sum_host, col_sum_key)
) 
WITH (
  OIDS = FALSE
)
;
COMMENT ON TABLE summary IS 'Summary Table';
