-- Database: cnmonitor

-- DROP DATABASE cnmonitor;

-- Create Database cnmonitor
CREATE DATABASE cnmonitor;

-- Connect to database
\connect cnmonitor

-- Create Table Monitor
CREATE TABLE monitor
(
   col_mon_date timestamp without time zone NOT NULL, 
   col_mon_host character(255) NOT NULL, 
   col_mon_con_peak integer DEFAULT '0', 
   col_mon_thread integer DEFAULT '0', 
   col_mon_cur_con integer DEFAULT '0', 
   col_mon_ent_sent bigint DEFAULT '0',
   col_mon_tot_con bigint DEFAULT '0', 
   col_mon_byte_sent bigint DEFAULT '0', 
   col_mon_exec_time real DEFAULT '0', 
   col_mon_msg text DEFAULT '', 
   CONSTRAINT "Unique Monitor Key" PRIMARY KEY (col_mon_date, col_mon_host)
) 
WITH (
  OIDS = FALSE
)
;
COMMENT ON TABLE monitor IS 'Monitor Table';

-- Create Table Operation
CREATE TABLE operation
(
   col_mon_date timestamp without time zone NOT NULL, 
   col_mon_host character(255) NOT NULL, 
   col_mon_anon_bind bigint DEFAULT '0', 
   col_mon_unauth_bind bigint DEFAULT '0', 
   col_mon_simple_bind bigint DEFAULT '0', 
   col_mon_strong_bind bigint DEFAULT '0', 
   col_mon_error_bind bigint DEFAULT '0', 
   col_mon_whole_search bigint DEFAULT '0', 
   col_mon_search bigint DEFAULT '0', 
   col_mon_in bigint DEFAULT '0', 
   col_mon_compare bigint DEFAULT '0', 
   col_mon_add bigint DEFAULT '0', 
   col_mon_modify bigint DEFAULT '0', 
   col_mon_modifyrdn bigint DEFAULT '0', 
   col_mon_remove bigint DEFAULT '0', 
   col_mon_error bigint DEFAULT '0', 
   col_mon_sec_error bigint DEFAULT '0', 
   col_mon_msg text DEFAULT '',
   CONSTRAINT "Unique Operations Key" PRIMARY KEY (col_mon_date, col_mon_host)
) 
WITH (
  OIDS = FALSE
)
;
COMMENT ON TABLE operation IS 'Operation Table';

-- Create Table Summary
CREATE TABLE summary
(
   col_sum_date date NOT NULL, 
   col_sum_host character(255) NOT NULL, 
   col_sum_key character(25) NOT NULL, 
   col_sum_value bigint DEFAULT '0', 
   col_sum_updated date NOT NULL, 
   CONSTRAINT "Unique Summary Key" PRIMARY KEY (col_sum_date, col_sum_host, col_sum_key)
) 
WITH (
  OIDS = FALSE
)
;
COMMENT ON TABLE summary IS 'Summary Table';

-- Create Table Server Message
CREATE TABLE servermessage
(
   col_srvmsg_date timestamp without time zone NOT NULL,
   col_srvmsg_host character(255) NOT NULL, 
   col_srvmsg_key character(25) NOT NULL, 
   col_srvmsg_value text DEFAULT '',
   CONSTRAINT "Unique Server Message Key" PRIMARY KEY (col_srvmsg_date, col_srvmsg_host)
) 
WITH (
  OIDS = FALSE
)
;
COMMENT ON TABLE servermessage IS 'Server Message Table';
