-- Database: cnmonitor

-- DROP DATABASE cnmonitor;
CREATE DATABASE cnmonitor;

USE cnmonitor;

-- Create Table Monitor
CREATE TABLE monitor (
  col_mon_date timestamp NOT NULL default 0,
  col_mon_host varchar(255) NOT NULL default '',
  col_mon_con_peak int(11) default '0',
  col_mon_thread int(11) default '0',
  col_mon_cur_con int(11) default '0',
  col_mon_tot_con bigint(20) default '0',
  col_mon_ent_sent bigint(20) default '0',
  col_mon_byte_sent bigint(20) default '0',
  col_mon_exec_time float default '0',
  col_mon_msg text default '',
  PRIMARY KEY  (col_mon_date,col_mon_host)
);

-- Create Table Operation
CREATE TABLE operation (
  col_mon_date timestamp NOT NULL default 0,
  col_mon_host varchar(255) NOT NULL default '',
  col_mon_anon_bind bigint(20) default '0',
  col_mon_unauth_bind bigint(20) default '0',
  col_mon_simple_bind bigint(20) default '0',
  col_mon_strong_bind bigint(20) default '0',
  col_mon_error_bind bigint(20) default '0',
  col_mon_whole_search bigint(20) default '0',
  col_mon_search bigint(20) default '0',
  col_mon_in bigint(20) default '0',
  col_mon_compare bigint(20) default '0',
  col_mon_add bigint(20) default '0',
  col_mon_modify bigint(20) default '0',
  col_mon_modifyrdn bigint(20) default '0',
  col_mon_remove bigint(20) default '0',
  col_mon_error bigint(20) default '0',
  col_mon_sec_error bigint(20) default '0',
  col_mon_msg text default '',
  PRIMARY KEY  (col_mon_date, col_mon_host)
);

-- Create Summary Table
CREATE TABLE summary (
  col_sum_date date NOT NULL default 0,
  col_sum_host varchar(255) NOT NULL default '',
  col_sum_key varchar(25) NOT NULL default '',
  col_sum_value bigint(20) default '0',
  col_sum_updated date NOT NULL default 0,
  PRIMARY KEY  (col_sum_date, col_sum_host, col_sum_key)
);

-- Create Server Message Table
CREATE TABLE servermessage (
  col_srvmsg_date timestamp NOT NULL default 0,
  col_srvmsg_host varchar(255) NOT NULL default '',
  col_srvmsg_key varchar(25) NOT NULL default '',
  col_srvmsg_value text default '',
  PRIMARY KEY  (col_srvmsg_date, col_srvmsg_host)
);

