<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */
  
 /*************************************************************
 * Verify Configuration
 * Recommended for troubleshooting
 * Usage:
 *   php verifyconfiguration.php [dump]
 * [dump] = Will dump and expose the complete configuration
 *************************************************************/

$WWWDIR  = dirname(__FILE__)."/../www";
$CONFDIR = dirname(__FILE__)."/../config";

function checkFunction($functionName, $required = false) {
  echo "+ ".$functionName.": ";
  
  $statusText = "ERROR";
  if(!$required) {
    $statusText = "Warning";  
  }
  
  if(!function_exists($functionName)) {
    echo $statusText.". Function '".$functionName."' does not exist";
    // if required we will stop the script
    if($required) {
      echo "\n  Your PHP installation must support this function in order to work!\n";
    }
    else {
      echo "\n  This function is not required to have.";
    }
  }
  else {
    echo "OK";
  }
  echo "\n";
}

function checkDatabase($CONFIG) {
  if(empty($CONFIG)) {
    echo "  Configuration is empty. Unable to parse XML configuration file?\n";
  }
  else {
    echo "  Configuration exists...";
  }
  if(empty($CONFIG["general"]["db"]["type"])) {
    echo "  Database option 'type' MISSING. Have you configured a database connection?\n"; 
  }
  else {
    echo "type option exist...";  
  }
  if(empty($CONFIG["general"]["db"]["host"])) {
    echo "  Database option 'host' MISSING. Have you configured a database connection?\n"; 
  }
  else {
    echo "host option exist...";
  }
  if(empty($CONFIG["general"]["db"]["database"])) {
    echo "  Database option 'database' MISSING. Have you configured a database connection?\n"; 
  }
  else {
    echo "database option exist...";
  }
  echo "\n";
  echo "  Database settings:\n";
  echo "    Type: '".$CONFIG["general"]["db"]["type"]."'\n";
  echo "    Host: '".$CONFIG["general"]["db"]["host"]."'\n";
  if(empty($CONFIG["general"]["db"]["port"])) {
    echo "    Port: '<use default port>'\n";  
  }
  else {
    echo "    Port: '".$CONFIG["general"]["db"]["port"]."'\n";  
  }
  echo "    Database: '".$CONFIG["general"]["db"]["database"]."'\n";
  echo "    Username: '".$CONFIG["general"]["db"]["username"]."'\n";
  if(empty($CONFIG["general"]["db"]["password"])) {
    echo "    Password: '<empty value>'\n";
  }
  else {
    echo "    Password: '<value exist>'\n";  
  }
  
  if(empty($CONFIG["general"]["db"]["type"])) {
    echo " - ERROR. As database type is missing we won't try to connect against SQL database\n";
    return;
  }
  
  echo "  Check if we can manually connect using configured database settings.\n";
  // MySQL
  if($CONFIG["general"]["db"]["type"] == "mysql") {
    if(empty($CONFIG["general"]["db"]["port"])) {
      $dbPort = 3306;
    }
    else {
      $dbPort = $CONFIG["general"]["db"]["port"];
    }
    echo "  Connecting to database using mysql...\n";
    $dbh = mysql_connect($CONFIG["general"]["db"]["host"].":".$dbPort, 
                         $CONFIG["general"]["db"]["username"], $CONFIG["general"]["db"]["password"]);  
    if(empty($dbh)) {
      echo "  - Unable to connect to database\n";
    }
    else {
      echo "  + Connected to database\n";  
    }

    if(mysql_errno()) {
      echo "    MySQL ERROR ".mysql_errno().": ".mysql_error()."\n";
    }

    if(mysql_select_db($CONFIG["general"]["db"]["database"], $dbh)) {
      echo "  + Database available.\n";
    }
    else {
      if(mysql_errno()) {
        echo "    MySQL ERROR ".mysql_errno().": ".mysql_error()."\n";
      }
      echo "  - Database not available.\n";
    }
    echo "    Disconnecting\n";
    mysql_close($dbh);
  }
  // MySQLi
  else if($CONFIG["general"]["db"]["type"] == "mysqli") {
    if(empty($CONFIG["general"]["db"]["port"])) {
      $dbPort = 3306;
    }
    else {
      $dbPort = $CONFIG["general"]["db"]["port"];
    }
    echo "  Connecting to database using mysql...\n";
    $dbh = mysqli_connect($CONFIG["general"]["db"]["host"], 
                          $CONFIG["general"]["db"]["username"], 
                          $CONFIG["general"]["db"]["password"], 
                          $CONFIG["general"]["db"]["database"], 
                          $dbPort);
    if(empty($dbh)) {
      echo "  - Unable to connect to database\n";
    }
    else {
      echo "  + Connected to database\n";  
    }

    if(mysqli_errno($dbh)) {
      echo "    MySQL ERROR ".mysqli_errno().": ".mysqli_error()."\n";
      echo "  - Database not available.\n";
    }
    else {
      echo "  + Database available.\n";    
    }
    echo "    Disconnecting\n";
    mysqli_close($dbh);
  }
  // PostgreSQL
  else if($CONFIG["general"]["db"]["type"] == "pgsql") {

    if(empty($CONFIG["general"]["db"]["port"])) {
      $dbPort = 5432;
    }
    else {
      $dbPort = $CONFIG["general"]["db"]["port"];
    }

    $connectionString = "host=".$CONFIG["general"]["db"]["host"];
    $connectionString .=" port=".$dbPort;
    $connectionString .= " dbname=".$CONFIG["general"]["db"]["database"];
    $connectionString .= " user=".$CONFIG["general"]["db"]["username"];
    $connectionString .= " password=".$CONFIG["general"]["db"]["password"];
    // echo $connectionString;
    $dbh = pg_connect($connectionString);
    if(empty($dbh)) {
      echo "  - Unable to connect to database\n";
    }
    else {
      echo "  + Connected to database\n";  
    }
    echo "    Check if error exist: ".pg_last_error($dbh)."\n";
    echo "    Disconnecting\n";
    pg_close($dbh);
  
  }
  else {
    echo "  Support to validate database connection: ".$CONFIG["general"]["db"]["type"]." does not exist (yet?)\n";
  }
}

echo "\n";
echo "Verify that PHP has required functions\n";
echo "--------------------------------------\n";

// LDAP Support
checkFunction("ldap_connect", true);
// XML Support
checkFunction("simplexml_load_string", true);
// Database Support
checkFunction("mysql_connect", false);
checkFunction("mysqli_connect", false);
checkFunction("pg_connect", false);
// Encryption Support
checkFunction("openssl_encrypt", false);

echo "\n";
echo "Verify database connection.\n";
echo "--------------------------------------\n";
echo "+ Loading configuration\n";
require $CONFDIR."/config.php";

// verify that php settings exist
if(isset($CONFIG["general"]["xml"])) {
  echo "+ XML configuration set in config.php\n";
}
else {
  echo "- ERROR XML configuration not set in config.php\n";
}

if(!empty($CONFIG["general"]["xmlfile"])) {
  if(file_exists($CONFIG["general"]["xmlfile"])) {
    echo "+ XML file configured: ".$CONFIG["general"]["xmlfile"]."\n";
  }
  else {
    echo "- ERROR XML file configured but does not exist ".$CONFIG["general"]["xmlfile"]."\n";
  }
}

require $WWWDIR."/functions/config_functions.php";
require $WWWDIR."/functions/sql_functions.php";
if(dbConfigured()) {
  echo "+ Database configured\n";
}
else {
  echo "- Database not configured!\n";
}
checkDatabase($CONFIG);

// finally if argument exist we will dump the entire configuration
if(!empty($argv[1])) {
  print_r($CONFIG);
}

echo "--------------------------------------\n";
echo "Configuration verification completed. Check for errors.";
echo "\n\n";
?>