<?php
  /*
    Copyright (C) 2010-2011 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

 /*************************************************************
 * Encrypt a password
 *************************************************************/

$WWWDIR  = dirname(__FILE__)."/../www";
$CONFDIR = dirname(__FILE__)."/../config";
require $CONFDIR."/config.php";
require $WWWDIR."/functions/config_functions.php";
$notallowed_characters = array("<", ">", "&", "'", "\"");

echo "\nEncrypting password\n";
echo "---------------------------------------------------\n\n";

echo "Enter password to encrypt: ";
$password = chop(fgets(STDIN)); 
if(empty($password)) {
  echo "\n- Password is empty! Exiting...\n\n";
  exit(0);
}

echo "---------------------------------------------------\n\n";

echo "+ Available encryption methods:\n";
$availableMethods = getAvailableEncryptionMethods();
$availableMethodsCount = 0;
$availableMethodsMaxRow = 8;
echo " > ";
for($i = 0; $i < count($availableMethods); $i++) {
  echo $availableMethods[$i].",";
  $availableMethodsCount++;
  if($availableMethodsCount >= $availableMethodsMaxRow) {
    echo "\n > ";
    $availableMethodsCount = 0;
  }
}
echo "\n";
echo "+ Current configured method is: ".getConfiguredEncryptionMethod()."\n";
echo "  Change method by setting the general environment configuration:\n";
echo "  <encryption>".getConfiguredEncryptionMethod()."</encryption>\n";

echo "+ Password encrypted\n";
$encpassword = encryptPassword($password);
echo "+ Verifying that the encrypted password doesn't contain special characters\n";
for($i = 0; $i < count($notallowed_characters); $i++) {
  if(strpos($encpassword, $notallowed_characters[$i]) !== FALSE) {
    echo "\n";
    echo "- Encrypted password '".$encpassword."' contains special not allowed XML character(s)\n";
    echo "  Not allowed characters are: ".implode(",", $notallowed_characters)."\n";
    echo "- Use another encryption method and try again or / and file this as bug!\n\n";
    exit(0);
  }
}
echo "  Passed special characters verification\n";

echo "+ Verifying with a decrypt\n";
if($password != decryptPassword($encpassword)) {
  echo "\n";
  echo "- Unable to decrypt password!\n";
  echo "  Verify that you have openssl support added to your PHP configuration\n";
  echo "  Could also be that the encrypted password: '".$encpassword."' is containing space or end characters\n";
  echo "\n";
  exit(1);
}
echo "  Decrypt of password is possible\n\n\n";

echo "Password Encrypted!\n";
echo "---------------------------------------------------\n";
echo "+ Password encrypted to: $encpassword\n\n";
echo "  Insert into your configuration in environment or server section as: \n";
echo "  <encpassword>".$encpassword."</encpassword>\n\n\n";
exit(0);
?>
